local assets =
{
    Asset("ANIM", "anim/honeyspear.zip"),
    Asset("ANIM", "anim/swap_honeyspear.zip"),
    Asset("IMAGE", "images/inventoryimages/honeyspear.tex" ),
    Asset("ATLAS", "images/inventoryimages/honeyspear.xml" ),
}

local HONEYSPEAR_VAR =
{
    BEE_MAX = 8,
    ATTACK = 34,
    BEE_SPAWNTIME = 30,
    BEE_REGENTIME = 60,
    REGEN_VARIANCE = 100,
}

local function sethoneycolor(target, p)
    p = p / 2
    target.AnimState:SetAddColour(p*255/255, p*180/255, 0, 1)
end

local function AttackUpdate(inst)
    if inst.task == nil then
        inst.task = inst:DoPeriodicTask(1,function () 
            inst.components.weapon:SetDamage(HONEYSPEAR_VAR.ATTACK-((inst.components.childspawner.maxchildren-inst.components.childspawner.childreninside)*3))
            -- print("Attack"..inst.components.weapon.damage)
            if inst.components.weapon.damage == HONEYSPEAR_VAR.ATTACK then
                inst.task:Cancel()
                inst.task = nil
            end
        end)
    end
end

local function SpawnFunc(inst, owner, target)
    local tmp = ((inst.components.childspawner:CanSpawn() and math.random() < .6) and inst.components.childspawner:SpawnChild(target) or SpawnPrefab("honey"))
    if tmp.components.combat then
        AttackUpdate(inst)
    else
        local pos = Vector3(target.Transform:GetWorldPosition())
        local start_angle = math.random()*PI*2
        local rad = 0.5
        if target.Physics then
            rad = rad + target.Physics:GetRadius()
        end
        local offset = FindWalkableOffset(pos, start_angle, rad, 8, false)
        if offset ~= nil then
            pos = pos + offset
            tmp.Transform:SetPosition(pos:Get())
        end
        owner.components.sanity:DoDelta(2) 
    end
end

local function OnTimerEnd(inst, time)
    -- print("time end")
    if inst.components.childspawner and inst.components.childspawner.numchildrenoutside>0 then
        for k,v in pairs(inst.components.childspawner.childrenoutside) do
            -- print(tostring(k)..tostring(v)..";"..inst.components.childspawner:CountChildrenOutside())
            if v.components.combat.target == nil then
                v:AddTag("goinghome")
                -- v:AddTag("_goinghome")
                -- print("AAA"..tostring(v:HasTag("gionghome"))..tostring(v:HasTag("_goinghome")))
            else
                -- print("target:"..tostring(v.components.combat.target))
                inst.components.timer_h:SetTime(5)
                inst.components.timer_h:StartTimer()
            end
        end
    end
end

local function onequip(inst, owner)
    owner.AnimState:OverrideSymbol("swap_object", "swap_honeyspear", "swap_honeyspear")
    owner.AnimState:Show("ARM_carry")
    owner.AnimState:Hide("ARM_normal")
end

local function onunequip(inst, owner)
    owner.AnimState:Hide("ARM_carry")
    owner.AnimState:Show("ARM_normal")
end

local function onattack(inst, owner, target)
    inst.components.timer_h:SetTime(10)
    if not target:HasTag("EnemyOfBear") then 
        target:AddTag("EnemyOfBear") 
        Debug("add this to your enemy")
    end
    if target.chasetime == nil then
        target.chasetime={
            task = target:DoPeriodicTask(.5,function ()
                if target.chasetime.time > 0 then
                target.chasetime.time = target.chasetime.time - .5
                else
                    target:RemoveTag("EnemyOfBear")
                    Debug("Remove Tag")
                    target.chasetime.task:Cancel()
                    target.chasetime.task = nil
                    target.chasetime.time = nil
                    target.chasetime = nil
                end
            end),
            time = 5
        }
    else
        target.chasetime.time = 5
    end
    if not inst.components.timer_h:IsRuning() then inst.components.timer_h:StartTimer() end
    if math.random() < .15 then
        SpawnFunc(inst, owner, target)
        if math.random() < .1 then--彩蛋
            local n = 0
            for n = 0, (math.random()*5+2), 1 do
                SpawnFunc(inst, owner, target)
            end
        end
    end
    if target.components.locomotor ~= nil then
        if target.components.locomotor.oldspeed == nil then target.components.locomotor.oldspeed = target.components.locomotor.runspeed end--初次攻击记录速度
        local s = target.components.locomotor.runspeed - ((target.components.locomotor.runspeed * .4) + (.1* math.random()))
        local p = s / target.components.locomotor.oldspeed
        if p < 0.3 then s = target.components.locomotor.oldspeed * 0.3 end
        target.components.locomotor.runspeed = s
        -- target.components.locomotor.runspeed = target.components.locomotor.runspeed - ((target.components.locomotor.oldspeed * .4 * math.random()) + .2)--攻击削减速度
        sethoneycolor(target,0.8-(target.components.locomotor.runspeed/target.components.locomotor.oldspeed))
        -- if target.components.locomotor.runspeed < 0 then target.components.locomotor.runspeed = 0 end--最低为零
        if target.components.locomotor.speedrec == nil then--速度恢复
            target.components.locomotor.speedrec = target:DoPeriodicTask(.5,function ()
                if target.components.locomotor.runspeed < target.components.locomotor.oldspeed then--不到原始速度继续恢复
                    target.components.locomotor.runspeed = target.components.locomotor.runspeed + (target.components.locomotor.oldspeed * .05)
                    Debug({"target:", tostring(target), "; speed:", target.components.locomotor.runspeed})
                else--到了关闭事件
                    if target.components.locomotor.runspeed > target.components.locomotor.oldspeed then 
                        target.components.locomotor.runspeed = target.components.locomotor.oldspeed 
                    end
                    target.components.locomotor.speedrec:Cancel()
                    target.components.locomotor.speedrec = nil
                end
                sethoneycolor(target,1-(target.components.locomotor.runspeed/target.components.locomotor.oldspeed))--给攻击对象设置颜色
            end)
        end
    end
    owner.components.sanity:DoDelta((math.random() < .1) and 1 or 0)--恢复脑残
end

local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()

    if compatible.isdst then
        inst.entity:AddNetwork()
    end

    MakeInventoryPhysics(inst)
    if compatible.isSW then
        MakeInventoryFloatable(inst, "idle_water", "idle")
    end

    inst.AnimState:SetBank("honeyspear")
    inst.AnimState:SetBuild("honeyspear")
    inst.AnimState:PlayAnimation("idle")

    inst:AddTag("sharp")
    inst:AddTag("flower")
    inst:AddTag("show_spoilage")
    inst:AddTag("icebox_valid")
    inst:AddTag("honeyspear")

    if compatible.isdst then
        inst.entity:SetPristine()
    end

    if not compatible.ismastersim() then
        return inst
    end

    inst:AddComponent("childspawner")
    inst.components.childspawner.childname = "bee_h"
    inst.components.childspawner:SetRegenPeriod(25)
    inst.components.childspawner:SetSpawnPeriod(60)
    inst.components.childspawner:SetMaxChildren(8)

    inst:AddComponent("timer_h")
    inst.components.timer_h:SetTime(10)
    inst.components.timer_h.timerendfn = OnTimerEnd

    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(TUNING.SPEAR_DAMAGE)
    inst.components.weapon.onattack = onattack

    inst:AddComponent("perishable")
    inst.components.perishable:SetPerishTime(TUNING.PERISH_MED)
    inst.components.perishable:StartPerishing()
    inst.components.perishable.onperishreplacement = "honey"

    inst:AddComponent("inspectable")

    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "honeyspear"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/honeyspear.xml"

    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip(onequip)
    inst.components.equippable:SetOnUnequip(onunequip)

    if compatible.isdst then
        MakeHauntableLaunch(inst)
    end
    
    AttackUpdate(inst)

    return inst
end

return Prefab("common/inventory/honeyspear", fn, assets)