local Badge = require("widgets/badge")
local UIAnim = require("widgets/uianim")


local FatBadge = Class(Badge, function(self, owner)
    Badge._ctor(self, "butter_meter", owner)--定义对象，使用“butter_meter”动画

    -- self.rate = 0
    self.ratescale = RATE_SCALE.NEUTRAL

    self.anim:GetAnimState():SetBank("beaver_meter")
    self.fatarrow = self.underNumber:AddChild(UIAnim())
    self.fatarrow:GetAnimState():SetBank("sanity_arrow")
    self.fatarrow:GetAnimState():SetBuild("sanity_arrow")
    self.fatarrow:GetAnimState():PlayAnimation("neutral")
    self.fatarrow:SetClickable(false)
    self:StartUpdating()
end)

local RATE_SCALE_ANIM =
{
    [RATE_SCALE.INCREASE_HIGH] = "arrow_loop_increase_most",
    [RATE_SCALE.INCREASE_MED] = "arrow_loop_increase_more",
    [RATE_SCALE.INCREASE_LOW] = "arrow_loop_increase",
    [RATE_SCALE.NEUTRAL] = "neutral",
    [RATE_SCALE.DECREASE_HIGH] = "arrow_loop_decrease_most",
    [RATE_SCALE.DECREASE_MED] = "arrow_loop_decrease_more",
    [RATE_SCALE.DECREASE_LOW] = "arrow_loop_decrease",
}

-- function FatBadge:RateUpdate(ra)
--     self.rate = ra
-- end

function FatBadge:SetPercent(val, max)
    Debug({"SetPercent: ", val})
    val = val or self.percent
    max = max or self.owner:GetFatMax() or 100

    self.anim:GetAnimState():SetPercent("anim", 1 - val)
    -- print(val, max, val * max)
    self.num:SetString(tostring(math.ceil(val * max)))

    self.percent = val
end

function FatBadge:OnUpdate(dt)
    self.ratescale = self.owner:GetFatRateScale()
    local anim = "neutral"
    if self.ratescale then
        anim = RATE_SCALE_ANIM[self.ratescale]
    end
    if self.percent > 0 and self.ratescale == RATE_SCALE.DECREASE_HIGH then 
        self:StartWarning()
    else
        self:StopWarning()
    end

    if self.arrowdir ~= anim then
        self.arrowdir = anim
        self.fatarrow:GetAnimState():PlayAnimation(anim, true)
    end
end

return FatBadge