﻿/*

"loc_langs" - the object holding all items that need localizations

In order for translations to work, the string in HTML source
should be encapsulated in a <span> with a class set to "l_"
PLUS the unique name of the sub-object containing its
translations.

For example, to translate "Install all" in HTML source, find
(or add) that sub-item in the langs object.  It already
exists with a name of "installAll".  Therefore the <span>
surrounding the text in the HTML source should be assigned a
class of "l_installAll". Example:

    <span class="l_installAll">Install all</span>

It's easy enough to add new translated strings.  Simply copy
one of the existing below, give it a unique name, and enter
the translated strings.  Then add the "l_" + unique name
class to a <span> around the original string in the HTML
source.
*/

loc_supportedLangs = [
"en", // English
"ptb", // Portuguese (Brazilian)
"de", // German
"fr", // French
"es", // Spanish
"it", // Italian
"ko", // Korean
"jp", // Japanese
"ch", // Chinese (Simplified)
];

loc_langs = {


  dropFirstFile: {
    en: 'Drop first file here.',
    ptb: 'Solte o primeiro arquivo aqui.',
    de: 'Ziehe die erste Datei hierher.',
    fr: 'Déposez le premier fichier ici.',
    es: 'Suelta el primer archivo aquí.',
    it: 'Rilascia il primo file qui.',
    ko: '여기에 첫 번째 파일을 놓습니다.',
    jp: '最初のファイルをここにドロップします。',
    ch: '删除第一个文件。',
  },

  dropSecondFile: {
    en: 'Drop second file here.',
    ptb: 'Solte o segundo arquivo aqui.',
    de: 'Ziehe die zweite Datei hierher.',
    fr: 'Déposer le deuxième fichier ici.',
    es: 'Suelta el segundo archivo aquí.',
    it: 'Rilascia il secondo file qui.',
    ko: '두 번째 파일을 여기에 놓습니다.',
    jp: 'ここに2番目のファイルをドロップします。',
    ch: '删除第二个文件。',
  },

  dropThirdFile: {
    en: 'Drop third file here.',
    ptb: 'Solte o terceiro arquivo aqui.',
    de: 'Ziehe die dritte Datei hierher.',
    fr: 'Déposez le troisième fichier ici.',
    es: 'Suelta el tercer archivo aquí.',
    it: 'Rilascia il terzo file qui.',
    ko: '세 번째 파일을 여기에 놓습니다.',
    jp: '3番目のファイルをここにドロップします。',
    ch: '删除第三个文件。',
  },

  dropFirstFolder: {
    en: 'Drop first folder here.',
    ptb: 'Solte a primeira pasta aqui.',
    de: 'Ziehe den ersten Ordner hierher.',
    fr: 'Déposez le premier dossier ici.',
    es: 'Suelta la primera carpeta aquí.',
    it: 'Rilascia la prima cartella qui.',
    ko: '첫 번째 폴더를 여기에 놓습니다.',
    jp: '最初のフォルダをここにドロップします。',
    ch: '删除第一个文件夹。',
  },

  dropSecondFolder: {
    en: 'Drop second folder here.',
    ptb: 'Solte a segunda pasta aqui.',
    de: 'Ziehe den zweiten Ordner hierher.',
    fr: 'Déposez le deuxième dossier ici.',
    es: 'Suelta la segunda carpeta aquí.',
    it: 'Rilascia la seconda cartella qui.',
    ko: '두 번째 폴더를 여기에 놓습니다.',
    jp: 'ここに第2のフォルダをドロップします。',
    ch: '删除第二个文件夹。',
  },

  dropThirdFolder: {
    en: 'Drop third folder here.',
    ptb: 'Solte a terceira pasta aqui.',
    de: 'Ziehe den dritten Ordner hierher.',
    fr: 'Déposez le troisième dossier ici.',
    es: 'Suelta la tercera carpeta aquí.',
    it: 'Rilascia la terza cartella qui.',
    ko: '세 번째 폴더를 여기에 놓습니다.',
    jp: '3番目のフォルダをここにドロップします。',
    ch: '删除第三个文件夹。',
  },

  dropGitConflictFile: {
    en: 'Drop file with conflicts here.',
    ptb: '',
    de: 'Ziehe die Datei mit den Konflikten hierher.',
    fr: '',
    es: '',
    it: '',
    ko: '',
    jp: '',
    ch: '',
  },


};