﻿/*

"loc_langs" - the object holding all items that need localizations

In order for translations to work, the string in HTML source
should be encapsulated in a <span> with a class set to "l_"
PLUS the unique name of the sub-object containing its
translations.

For example, to translate "Install all" in HTML source, find
(or add) that sub-item in the langs object.  It already
exists with a name of "installAll".  Therefore the <span>
surrounding the text in the HTML source should be assigned a
class of "l_installAll". Example:

    <span class="l_installAll">Install all</span>

It's easy enough to add new translated strings.  Simply copy
one of the existing below, give it a unique name, and enter
the translated strings.  Then add the "l_" + unique name
class to a <span> around the original string in the HTML
source.
*/

loc_supportedLangs = [
"en", // English
"ptb", // Portuguese (Brazilian)
"de", // German
"fr", // French
"es", // Spanish
"it", // Italian
"ko", // Korean
"jp", // Japanese
"ch", // Chinese (Simplified)
];

loc_langs = {


  thanks: {
    en: 'Thanks for choosing UltraCompare.',
    ptb: 'Obrigado por escolher o UltraCompare',
    de: 'Vielen Dank, dass Sie sich f&uuml;r UltraCompare entschieden haben!',
    fr: 'Merci d\'avoir choisi UltraCompare',
    es: 'Gracias por elegir UltraCompare',
    it: 'Grazie per aver scelto UltraCompare',
    ko: 'UltraCompare를 선택해 주셔서 감사합니다',
    jp: 'UltraCompareを選択していただき、ありがとうございます',
    ch: '感谢您选择 UltraCompare。',
  },

  getStarted: {
    en: 'To get started, select a new compare below:',
    ptb: 'Para começar, selecione uma nova comparação abaixo:',
    de: 'Wählen Sie einen neuen Vergleich unten, um zu beginnen:',
    fr: 'Pour commencer, sélectionnez une nouvelle comparaison ci-dessous :',
    es: 'Para comenzar, seleccione una nueva comparación a continuación:',
    it: 'Per iniziare, seleziona un nuovo confronto di seguito:',
    ko: '시작하려면 아래에서 새 비교를 선택하십시오:',
    jp: '開始するには、以下の新規比較セッションを選択してください。',
    ch: '开始时请在下面选择一个新比较：',
  },

  compareText: {
    en: 'Text',
    ptb: 'Texto',
    de: 'Text',
    fr: 'Texte',
    es: 'Texto',
    it: 'Testo',
    ko: '텍스트',
    jp: 'テキスト',
    ch: '文本',
  },

  compare3text: {
    en: '3-way text',
    ptb: 'Texto de 3 vias',
    de: '3-fach-Text',
    fr: '3 fichiers texte',
    es: 'Texto de 3 vías',
    it: 'Testo 3-Way',
    ko: '3개 텍스트 모드',
    jp: '<span style="font-size: 90%;">3-Wayテキストモード</span>',
    ch: '三方文本模式',
  },

  compareDoc: {
    en: 'Doc',
    ptb: 'Doc',
    de: 'Dokument',
    fr: 'Doc',
    es: 'Doc',
    it: 'Doc',
    ko: '문서',
    jp: 'ドキュメント',
    ch: '文件',
  },

  comparePdf: {
    en: 'PDF',
    ptb: 'PDF',
    de: 'PDF',
    fr: 'PDF',
    es: 'PDF',
    it: 'PDF',
    ko: 'PDF',
    jp: 'PDF',
    ch: 'PDF',
  },

  compareFolder: {
    en: 'Folder',
    ptb: 'Pasta',
    de: 'Ordner',
    fr: 'Dossier',
    es: 'Carpeta',
    it: 'Cartella',
    ko: '폴더',
    jp: 'フォルダモード',
    ch: '文件夹',
  },

  compare3folder: {
    en: '3-way folder',
    ptb: 'Pasta de 3 vias',
    de: '3-fach-Ordner',
    fr: '3 dossiers',
    es: '<span style="font-size: 85%;">Carpetas de 3-Vías</span>',
    it: 'Cartelle 3-Way',
    ko: '3개 폴더 모드',
    jp: '<span style="font-size: 85%;">3-Way フォルダモード</span>',
    ch: '三方文本模式',
  },

  compareTable: {
    en: 'Table',
    ptb: 'Tabela',
    de: 'Tabelle',
    fr: 'Table',
    es: 'Tabla',
    it: 'Tabella',
    ko: '문자표',
    jp: 'テーブル',
    ch: '字符表',
  },

  compareBinary: {
    en: 'Binary (smart)',
    ptb: '<span style="font-size: 85%;">Binário (inteligente)</span>',
    de: 'Binär (intelligent)',
    fr: '<span style="font-size: 90%;">Binaire (intelligent)</span>',
    es: '<span style="font-size: 87%;">Binario (inteligente)</span>',
    it: '<span style="font-size: 85%;">Binaria (intelligente)</span>',
    ko: '바이너리 (스마트)',
    jp: '<span style="font-size: 90%;">バイナリ（スマート)</span>',
    ch: '二进制(智能)',
  },

  compareBinaryFast: {
    en: 'Binary (fast)',
    ptb: 'Binário (rápido)',
    de: 'Binär (schnell)',
    fr: '<span style="font-size: 90%;">Binaire (rapide)</span>',
    es: '<span style="font-size: 87%;">Binario (rápido)</span>',
    it: '<span style="font-size: 90%;">Binaria (veloce)</span>',
    ko: '바이너리 (빠른)',
    jp: 'バイナリ(高速)',
    ch: '二进制(快速)',
  },

  compareArchive: {
    en: 'Zip/Rar/Jar',
    ptb: 'Zip/Rar/Jar',
    de: 'Zip/Rar/Jar',
    fr: 'Zip/Rar/Jar',
    es: 'Zip/Rar/Jar',
    it: 'Zip/Rar/Jar',
    ko: 'Zip/Rar/Jar',
    jp: 'Zip/Rar/Jar',
    ch: 'Zip/Rar/Jar',
  },

  compareGitMerge: {
    en: 'Resolve conflicts',
    ptb: 'Resolver conflitos',
    de: 'Konflikte auflösen',
    fr: '<span style="font-size: 87%;">Résoudre des conflits</span>',
    es: 'Resolver conflictos',
    it: 'Risolvi conflitti',
    ko: '충돌 해결',
    jp: '衝突を解決',
    ch: '解决冲突',
  },

  compareGitVersion: {
    en: 'Diff versions',
    ptb: 'Versões diferentes',
    de: '<span style="font-size: 75%;">Versionen vergleichen</span>',
    fr: '<span style="font-size: 70%;">Versions de différenciation</span>',
    es: '<span style="font-size: 75%;">Diferencias de versiones</span>', // Original: 'Comparar diferencias de versiones',
    it: '<span style="font-size: 75%;">Confronta (diff) versioni</span>',  
    ko: '다른 버전',
    jp: '相違バージョン',
    ch: '比较版本',
  },

};