require "brains/beeguardbrain"
require "stategraphs/SGbeeguard"

local assets=
{
	Asset("ANIM", "anim/bee_guard.zip"),
    Asset("ANIM", "anim/bee_guard_build.zip"),
    Asset("ANIM", "anim/bee_guard_puffy_build.zip"),
	Asset("SOUND", "sound/bee.fsb"),
}
    
    
local prefabs =
{
	"stinger",
	"honey",
}

local killersounds = 
{
	takeoff = "dontstarve/bee/bee_takeoff",
	attack = "dontstarve/bee/bee_attack",
	buzz = "dontstarve/bee/bee_fly_LP",
	hit = "dontstarve/bee/bee_hurt",
	death = "dontstarve/bee/bee_death",
}

local function OnWorked(inst, worker)
    local owner = inst.components.homeseeker and inst.components.homeseeker.home
    if owner and owner.components.childspawner then
        owner.components.childspawner:OnChildKilled(inst)
    end
    if worker.components.inventory then
        
        if METRICS_ENABLED then
			FightStat_Caught(inst)
		end
		
        worker.components.inventory:GiveItem(inst, nil, Vector3(TheSim:GetScreenPos(inst.Transform:GetWorldPosition())))
    end
end

local function OnPickedUp(inst)
    inst.sg:GoToState("idle")
    inst.SoundEmitter:KillAllSounds()
end

local function KillerRetarget(inst)
    return FindEntity(inst, 8, function(guy)
        return (guy:HasTag("character") or guy:HasTag("animal") or guy:HasTag("monster") )
            and not guy:HasTag("insect")
            and inst.components.combat:CanTarget(guy)
    end)
end

local function OnAttacked(inst, data)
    inst.components.combat:SetTarget(data.attacker)
    inst.components.combat:ShareTarget(data.attacker, 30, function(dude)
        return dude:HasTag("bee")
               and not dude.components.health:IsDead()
    end, 10)
end

local function commonfn()
	local inst = CreateEntity()
	
    inst.entity:AddTransform()
	inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter()
	inst.entity:AddLightWatcher()
	inst.entity:AddDynamicShadow()
	inst.DynamicShadow:SetSize(.8, .5)
    inst.Transform:SetSixFaced()
	inst.Transform:SetScale(1.4, 1.4, 1.4) 
    
    inst:AddTag("bee")
	inst:AddTag("beeguard")
    inst:AddTag("insect")
    inst:AddTag("smallcreature")
	inst:AddTag("animal")
   
    MakeCharacterPhysics(inst, 1, .5)
    inst.Physics:SetCollisionGroup(COLLISION.FLYERS)
    inst.Physics:ClearCollisionMask()
    inst.Physics:CollidesWith(COLLISION.WORLD)
    inst.Physics:CollidesWith(COLLISION.FLYERS)
    
    inst.AnimState:SetBank("bee_guard")
    inst.AnimState:PlayAnimation("idle")
    
    inst:AddComponent("locomotor")
    inst.components.locomotor:EnableGroundSpeedMultiplier(false)
	inst.components.locomotor:SetTriggersCreep(false)
	inst.components.locomotor.walkspeed = 3
	
    inst:SetStateGraph("SGbeeguard")
	
	inst:AddComponent("lootdropper")
	inst.components.lootdropper:AddRandomLoot("honey", 1)
	inst.components.lootdropper:AddRandomLoot("stinger", 1)   
	inst.components.lootdropper.numrandomloot = 1
   
    MakeSmallBurnableCharacter(inst, "body", Vector3(0, -1, 1))
    MakeTinyFreezableCharacter(inst, "body", Vector3(0, -1, 1))
    
    inst:AddComponent("health")
    
    inst:AddComponent("combat")
    inst.components.combat.hiteffectsymbol = "body"
    
    inst:AddComponent("sleeper")
    
    inst:AddComponent("knownlocations")
	
	inst:AddComponent("follower")
    
    inst:AddComponent("inspectable")
    
    inst:ListenForEvent("attacked", OnAttacked)
    return inst
end

local function OnWake(inst)
	inst.SoundEmitter:PlaySound(inst.sounds.buzz, "buzz")
end

local function OnSleep(inst)
    inst.SoundEmitter:KillSound("buzz")
end

local function beeguard()
    local inst = commonfn()
    inst:AddTag("killer")
    inst:AddTag("scarytoprey")
    inst.AnimState:SetBuild("bee_guard_build")
    inst.components.health:SetMaxHealth(100)
    inst.components.combat:SetDefaultDamage(10)
    inst.components.combat:SetAttackPeriod(TUNING.BEE_ATTACK_PERIOD)
    inst.components.combat:SetRetargetFunction(2, KillerRetarget)
	local brain = require "brains/beeguardbrain"
    inst:SetBrain(brain)
    inst.sounds = killersounds

    inst.OnEntityWake = OnWake
    inst.OnEntitySleep = OnSleep
    return inst
end 

return Prefab( "forest/monsters/beeguard", beeguard, assets, prefabs)