local prefabs = 
{
	"beequeen",
    "honey",
    "honeycomb",
}

local assets =
{
	Asset("ANIM", "anim/bee_queen_hive.zip"),
	Asset("SOUND", "sound/bee.fsb"),
}


local function OnEntityWake(inst)
    inst.SoundEmitter:PlaySound("dontstarve/bee/bee_hive_LP", "loop")
end

local function OnEntitySleep(inst)
	inst.SoundEmitter:KillSound("loop")
end

local function onhit(inst, worker)
	local pt = Point(inst.Transform:GetWorldPosition())
	local honeychance = math.random(1,3)
	if honeychance == 1 then
		inst.components.lootdropper:SpawnLootPrefab("honey")
	end
	local honeycombchance = math.random(1,10)
	if honeycombchance == 1 then
		inst.components.lootdropper:SpawnLootPrefab("honeycomb")
	end
	inst.SoundEmitter:PlaySound("dontstarve/bee/beehive_hit")
    inst.AnimState:PlayAnimation("hit")
end

local function onhammered(inst, worker)
	local x, y, z = inst.Transform:GetWorldPosition()
    inst:Remove()
    local queen = SpawnPrefab("beequeen")
    queen.Transform:SetPosition(x,y,z)
    if worker:IsValid() and worker.components.health ~= nil and not worker.components.health:IsDead() then
        queen.components.combat:SetTarget(worker)
    end
    queen.sg:GoToState("emerge")
end

local function fn(Sim)
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()	
    MakeObstaclePhysics(inst, 1.0)
	inst.Transform:SetScale(1.4,1.4,1.4)
	local minimap = inst.entity:AddMiniMapEntity()
	minimap:SetIcon( "giantbeehive.tex" )
	anim:SetBank("bee_queen_hive")
	anim:SetBuild("bee_queen_hive")
	anim:PlayAnimation("idle")
    inst:AddTag("structure")
	inst:AddTag("hive")
	inst:AddTag("beehive") 
	
    inst:AddComponent("lootdropper") 
	
	inst:AddComponent("childspawner") 

	inst:AddComponent("workable")
	inst.components.workable:SetWorkAction(ACTIONS.HAMMER)
	inst.components.workable:SetWorkLeft(5)
	inst.components.workable:SetOnFinishCallback(onhammered)
	inst.components.workable:SetOnWorkCallback(onhit) 
       
    MakeSnowCovered(inst)
    
    inst:AddComponent("inspectable")
	inst.OnEntitySleep = OnEntitySleep
	inst.OnEntityWake = OnEntityWake

	return inst
end

return Prefab( "forest/monsters/giantbeehive", fn, assets, prefabs ) 

