local assets =
{
	Asset("ANIM", "anim/hat_hive.zip"),
	Asset("IMAGE", "images/inventoryimages/hivehat.tex"),
	Asset("ATLAS", "images/inventoryimages/hivehat.xml")
}

local workersounds = 
{
	takeoff = "dontstarve/bee/bee_takeoff",
	attack = "dontstarve/bee/bee_attack",
	buzz = "dontstarve/bee/bee_fly_LP",
	hit = "dontstarve/bee/bee_hurt",
	death = "dontstarve/bee/bee_death",
}

local killersounds = 
{
	takeoff = "dontstarve/bee/killerbee_takeoff",
	attack = "dontstarve/bee/killerbee_attack",
	buzz = "dontstarve/bee/killerbee_fly_LP",
	hit = "dontstarve/bee/killerbee_hurt",
	death = "dontstarve/bee/killerbee_death",
}

function GetBeeGuards(inst)
	local x,y,z = inst.Transform:GetWorldPosition()
	local ents = TheSim:FindEntities(x,y,z,45, {"beeguard"}, {"FX", "NOCLICK", "DECOR","INLIMBO"})
    return ents
end

local function GuardSpeedBuff(inst)
	inst.AnimState:SetBuild("bee_guard_puffy_build")
	inst.components.locomotor.walkspeed = 8
	inst.sounds = killersounds
	if inst.SoundEmitter:PlayingSound("buzz") then
		inst.SoundEmitter:KillSound("buzz")
		inst.SoundEmitter:PlaySound(inst.sounds.buzz, "buzz")
	end
    inst:DoTaskInTime(14, function(inst)
		inst.AnimState:SetBuild("bee_guard_build")
		inst.components.locomotor.walkspeed = 3
		inst.sounds = workersounds
		if inst.SoundEmitter:PlayingSound("buzz") then
			inst.SoundEmitter:KillSound("buzz")
			inst.SoundEmitter:PlaySound(inst.sounds.buzz, "buzz")
		end
	end)
end

local function procfn(inst, data)
	local angerchance = math.random(1,2)
	if angerchance == 1 then
		local beeguards = GetBeeGuards(inst)
		for k,v in pairs(beeguards) do
			if v.components.combat and v.components.follower.leader == inst then
				if v.components.locomotor and v.components.locomotor.walkspeed < 8 then
					GuardSpeedBuff(v)
				end
			end
		end
	end
end

local function bee_disable(inst)
	if inst.updatetask then
		inst.updatetask:Cancel()
		inst.updatetask = nil
	end
	local owner = inst.components.inventoryitem and inst.components.inventoryitem.owner
	
	if owner and owner.components.leader then
		owner:RemoveTag("insect")
		for k,v in pairs(owner.components.leader.followers) do
			if k:HasTag("beeguard") and k.components.combat then
				k.components.combat:SuggestTarget(owner)
			end
		end
		owner.components.leader:RemoveFollowersByTag("beeguard")
	end
end
	
local function bee_update(inst)
	local owner = inst.components.inventoryitem and inst.components.inventoryitem.owner
	local guards = 0
	local beeguards = GetBeeGuards(inst)
	for k,v in pairs(beeguards) do
		if v.components.follower.leader == owner then
			guards = guards + 1
		end
	end
	--local x,y,z = owner.Transform:GetWorldPosition()
	---local ents = TheSim:FindEntities(x,y,z, TUNING.SPIDERHAT_RANGE, {"beeguard"})
	--for k,v in pairs(ents) do
	--	if v.components.follower and not v.components.follower.leader and not owner.components.leader:IsFollower(v) and guards < 6 then
	--		owner.components.leader:AddFollower(v)
	--	end
	--end
	if owner and owner.components.leader and guards < 6 then
		if IsDLCEnabled(CAPY_DLC) then
			local pt = Vector3(owner.Transform:GetWorldPosition())
			local theta = math.random() * 2 * PI
			local radius = math.random(20,30)
			local offset = FindWalkableOffset(pt, theta, radius, 12, true)
			if offset then
				local pos = pt + offset
				local ground = GetWorld()
				local tile = GROUND.GRASS
				if ground and ground.Map then
					tile = inst:GetCurrentTileType(pos:Get())
				end
				local onWater = ground.Map:IsWater(tile)
				if not onWater then 
					local guard = SpawnPrefab("beeguard")
					if guard then
						guard.Physics:Teleport(pos:Get())
						owner.components.leader:AddFollower(guard)
					end
				end 
			end
		else
			local pt = Vector3(owner.Transform:GetWorldPosition())
			local theta = math.random() * 2 * PI
			local radius = math.random(20,30)
			local offset = FindWalkableOffset(pt, theta, radius, 12, true)
			if offset then
				local pos = pt + offset
				local ground = GetWorld()
				local tile = GROUND.GRASS
				if ground and ground.Map then
					tile = inst:GetCurrentTileType(pos:Get())
				end
				local guard = SpawnPrefab("beeguard")
				if guard then
					guard.Physics:Teleport(pos:Get())
					owner.components.leader:AddFollower(guard)
				end
			end
		end	
	end
end
	
local function bee_enable(inst)
	local owner = inst.components.inventoryitem and inst.components.inventoryitem.owner
	if owner and owner.components.leader then
		owner.components.leader:RemoveFollowersByTag("pig")
		owner:AddTag("insect")
	end
	inst.updatetask = inst:DoPeriodicTask(2.0,bee_update,1)
end

local function onequip(inst, owner)
	owner.AnimState:OverrideSymbol("swap_hat", "hat_hive", "swap_hat")
	owner.AnimState:Show("HAT")
	owner.AnimState:Show("HAT_HAIR")
	owner.AnimState:Hide("HAIR_NOHAT")
	owner.AnimState:Hide("HAIR")
	if inst.components.fueled then
		inst.components.fueled:StartConsuming()        
	end
	bee_enable(inst)
	inst.tryproc = function(inst, data) procfn(inst,data) end 
    owner:ListenForEvent("attacked", inst.tryproc)
end

local function onunequip(inst, owner)
	owner.AnimState:Hide("HAT")
	owner.AnimState:Hide("HAT_HAIR")
	owner.AnimState:Show("HAIR_NOHAT")
	owner.AnimState:Show("HAIR")
	if owner:HasTag("player") then
		owner.AnimState:Show("HEAD")
		owner.AnimState:Hide("HEAD_HAIR")
	end
	if inst.components.fueled then
		inst.components.fueled:StopConsuming()        
	end	
	bee_disable(inst)
	owner:RemoveEventCallback("attacked", inst.tryproc)
end

local function onfinished(inst)
    inst:Remove()
end

local function fn(Sim)
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
	MakeInventoryPhysics(inst)
	
    inst:AddTag("hat")

    anim:SetBank("hivehat")
    anim:SetBuild("hat_hive")
	anim:PlayAnimation("anim")   
	
	inst:AddComponent("fueled")
	inst.components.fueled:InitializeFuelLevel(480)
	inst.components.fueled:SetDepletedFn(onfinished)
	
	inst:AddTag("bee")
        
    inst:AddComponent("inspectable")
	
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.atlasname = "images/inventoryimages/hivehat.xml"
    
    inst:AddComponent("equippable")
    inst.components.equippable.equipslot = EQUIPSLOTS.HEAD
	
	inst:AddComponent("waterproofer")
    inst.components.waterproofer:SetEffectiveness(TUNING.WATERPROOFNESS_SMALL)

    inst.components.equippable:SetOnEquip(onequip)
    inst.components.equippable:SetOnUnequip(onunequip)	
    return inst
end

STRINGS.NAMES.HIVEHAT = "Bee Queen Crown"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.HIVEHAT = "I fell like ... a queen!"

return Prefab("common/inventory/hivehat", fn, assets) 