local assets=
{
	Asset("ANIM", "anim/bee_queen_hive.zip"),
	Asset("IMAGE", "minimap/giantbeehive.tex"),
	Asset("ATLAS", "minimap/giantbeehive.xml"),	
	Asset("SOUND", "sound/bee.fsb"),
}

local function onfinished(inst)
    inst:Remove()
end

local function MiniBeeHiveWorking(inst)
	if inst.components.health then
		inst.components.health:DoDelta(4)
	end
	if inst.components.sanity then
		inst.components.sanity:DoDelta(3)
	end
	if inst.components.hunger then
		inst.components.hunger:DoDelta(5)
	end
end	

local function MiniBeeHiveActivated(inst)
	local owner = GetPlayer()
	if not owner.minibeehiveworking then
		inst.components.finiteuses:Use(1)
		owner.minibeehiveworking = true
		owner.SoundEmitter:PlaySound("dontstarve/bee/bee_hive_LP", "beehive")
		owner:DoTaskInTime(1, function(owner) MiniBeeHiveWorking(owner) end)
		owner:DoTaskInTime(2, function(owner) MiniBeeHiveWorking(owner) end)
		owner:DoTaskInTime(3, function(owner) MiniBeeHiveWorking(owner) end)
		owner:DoTaskInTime(4, function(owner) MiniBeeHiveWorking(owner) end)
		owner:DoTaskInTime(5, function(owner) MiniBeeHiveWorking(owner) end)
		owner:DoTaskInTime(6, function(owner) MiniBeeHiveWorking(owner) end)
		owner:DoTaskInTime(7, function(owner) MiniBeeHiveWorking(owner) end)
		owner:DoTaskInTime(8, function(owner) MiniBeeHiveWorking(owner) end)
		owner:DoTaskInTime(9, function(owner) MiniBeeHiveWorking(owner) end)
		owner:DoTaskInTime(10, function(owner) 
			MiniBeeHiveWorking(owner) 
			owner.SoundEmitter:KillSound("beehive")
			owner.minibeehiveworking = false
		end)
	else
		owner.components.talker:Say("It's already working for me.")
	end
end

local function fn(Sim)
	-- Create a new entity
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	MakeInventoryPhysics(inst)
	
	inst.Transform:SetScale(0.3,0.3,0.3)
	inst.AnimState:SetBuild("bee_queen_hive")
	inst.AnimState:SetBank("bee_queen_hive")
	inst.AnimState:PlayAnimation("idle")
	
	--inst:AddComponent("inspectable")
	
	inst:AddComponent("minibeehive")
	inst.components.minibeehive.onWorking = MiniBeeHiveActivated
	
	inst:AddComponent("finiteuses")
	inst.components.finiteuses:SetMaxUses(5)
	inst.components.finiteuses:SetUses(5)
	inst.components.finiteuses:SetOnFinished(onfinished)
	
	inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "giantbeehive"
    inst.components.inventoryitem.atlasname = "minimap/giantbeehive.xml"
	return inst
end

STRINGS.NAMES.MINIBEEHIVE = "Mini Beehive"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.MINIBEEHIVE = "I'm their new queen."

return Prefab( "common/inventory/minibeehive", fn, assets)