PrefabFiles = {
	"lulu",
}

Assets = {
    Asset( "IMAGE", "images/saveslot_portraits/lulu.tex" ),
    Asset( "ATLAS", "images/saveslot_portraits/lulu.xml" ),

    Asset( "IMAGE", "images/selectscreen_portraits/lulu.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/lulu.xml" ),
	
    Asset( "IMAGE", "images/selectscreen_portraits/lulu_silho.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/lulu_silho.xml" ),

    Asset( "IMAGE", "bigportraits/lulu.tex" ),
    Asset( "ATLAS", "bigportraits/lulu.xml" ),
	
	Asset( "IMAGE", "images/map_icons/lulu.tex" ),
	Asset( "ATLAS", "images/map_icons/lulu.xml" ),

}

TUNING.LULU_HP = GetModConfigData("lulu_hp") --180
TUNING.LULU_HUN = GetModConfigData("lulu_hunger")-- 120
TUNING.LULU_SANITY = GetModConfigData("lulu_sanity") --110
TUNING.LULU_PLANTLEVEL = GetModConfigData("get_fru")
TUNING.LULU_DIET = GetModConfigData("lulu_diet")
TUNING.LULU_MUSH = GetModConfigData("mash_open")
TUNING.LULU_EYE = GetModConfigData("eye_lulu")
TUNING.LULU_FLOWER_DEAD = GetModConfigData("lulu_flower_dead")
TUNING.LULU_CRAFT = GetModConfigData("lulu_craft")

local require = GLOBAL.require
local STRINGS = GLOBAL.STRINGS

-- The character select screen lines
STRINGS.CHARACTER_TITLES.lulu = "The plantress"
STRINGS.CHARACTER_NAMES.lulu = "Lulu"
STRINGS.CHARACTER_DESCRIPTIONS.lulu = "*Starts the game with a fleshy bulb.\n*Get two random fruit per day.\n*Don`t eat meat."
STRINGS.CHARACTER_QUOTES.lulu = "\"My power in plants!\""

-- Custom speech strings
STRINGS.CHARACTERS.LULU = require "speech_lulu"

-- Let the game know character is male, female, or robot
table.insert(GLOBAL.CHARACTER_GENDERS.FEMALE, "lulu")

AddMinimapAtlas("images/map_icons/lulu.xml")
AddModCharacter("lulu")

local ROG = GLOBAL.IsDLCEnabled(GLOBAL.REIGN_OF_GIANTS)
local CSW = GLOBAL.rawget(GLOBAL, "CAPY_DLC") and GLOBAL.IsDLCEnabled(GLOBAL.CAPY_DLC)

if ROG or CSW then
    TUNING.LULU_DIET_TYPE = "DLC"
else
    TUNING.LULU_DIET_TYPE = "VANILA"
end

AddPrefabPostInit("plantmeat", function(inst)
    inst.components.edible.foodtype = "VEGGIE"
end)

AddPrefabPostInit("plantmeat_cooked", function(inst)
    inst.components.edible.foodtype = "VEGGIE"
end)

local function open_any(inst)
    if GLOBAL.GetPlayer().prefab == "lulu" and not inst.AnimState:IsCurrentAnimation("picked") and TUNING.LULU_MUSH == 1 then
        if inst.components.pickable ~= nil and inst.components.pickable:CanBePicked() then
            inst.components.pickable.caninteractwith = true
			inst.AnimState:PlayAnimation(inst.color)
        end
	end
end

AddPrefabPostInit("red_mushroom", function(inst)
    inst.color = "red"
	inst:DoPeriodicTask(1, open_any)
end)

AddPrefabPostInit("green_mushroom", function(inst)
    inst.color = "green"
	inst:DoPeriodicTask(1, open_any)
end)

AddPrefabPostInit("blue_mushroom", function(inst)
    inst.color = "blue"
	inst:DoPeriodicTask(1, open_any)
end)



