
local MakePlayerCharacter = require "prefabs/player_common"


local assets = {

        Asset( "ANIM", "anim/player_basic.zip" ),
        Asset( "ANIM", "anim/player_idles_shiver.zip" ),
        Asset( "ANIM", "anim/player_actions.zip" ),
        Asset( "ANIM", "anim/player_actions_axe.zip" ),
        Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
        Asset( "ANIM", "anim/player_actions_shovel.zip" ),
        Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
        Asset( "ANIM", "anim/player_actions_eat.zip" ),
        Asset( "ANIM", "anim/player_actions_item.zip" ),
        Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
        Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
        Asset( "ANIM", "anim/player_actions_fishing.zip" ),
        Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
        Asset( "ANIM", "anim/player_bush_hat.zip" ),
        Asset( "ANIM", "anim/player_attacks.zip" ),
        Asset( "ANIM", "anim/player_idles.zip" ),
        Asset( "ANIM", "anim/player_rebirth.zip" ),
        Asset( "ANIM", "anim/player_jump.zip" ),
        Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
        Asset( "ANIM", "anim/player_teleport.zip" ),
        Asset( "ANIM", "anim/wilson_fx.zip" ),
        Asset( "ANIM", "anim/player_one_man_band.zip" ),
        Asset( "ANIM", "anim/shadow_hands.zip" ),
        Asset( "SOUND", "sound/sfx.fsb" ),
        Asset( "SOUND", "sound/wilson.fsb" ),
        Asset( "ANIM", "anim/beard.zip" ),

        Asset( "ANIM", "anim/lulu.zip" ),
}
local prefabs = {
}

-- Custom starting items
local start_inv = {
    "lureplantbulb",
}

local fruit_list =
{
    "pomegranate",
    "dragonfruit",
    "durian",
    "watermelon",
    "cave_banana",
    "carrot",
	"pumpkin",
	"corn",
	"eggplant",
	--"mandrake",
	"berries",
	"red_cap",
	"green_cap",
	"blue_cap",
	"wormlight",
	"cactus_meat",
}

local function GetFruit(inst)
	inst.components.inventory:GiveItem(SpawnPrefab(fruit_list[math.random(#fruit_list)]))
	inst.components.inventory:GiveItem(SpawnPrefab(fruit_list[math.random(#fruit_list)]))
	inst.components.talker:Say("New crop of vegetables!")
end

local fn = function(inst)

	inst.soundsname = "wendy"
	
	inst.plant_level = 0

	inst.MiniMapEntity:SetIcon( "lulu.tex" )
	inst:AddTag("Lulu")
	inst:AddTag("Lulu_eye")
	
	
	inst.components.health:SetMaxHealth(TUNING.LULU_HP)
	inst.components.hunger:SetMax(TUNING.LULU_HUN)
	inst.components.sanity:SetMax(TUNING.LULU_SANITY)
	
    --if TUNING.LULU_DIET == 0 then
	--    inst.components.eater:SetVegetarian(true)
	--end
	
	if TUNING.LULU_DIET == 0 and TUNING.LULU_DIET_TYPE == "DLC" then
		inst.components.eater.ablefoods = { "VEGGIE", "GOODIES", "INSECT", "SEEDS", "GENERIC"}
	end
	
	if TUNING.LULU_DIET == 0 and TUNING.LULU_DIET_TYPE == "VANILA" then
		inst.components.eater.foodprefs = { "VEGGIE", "GOODIES", "INSECT", "SEEDS", "GENERIC"}
	end
	
	-- inst.components.eater:SetDiet({ FOODGROUP.OMNI }, { FOODTYPE.VEGGIE, FOODTYPE.GOODIES, FOODTYPE.INSECT, FOODTYPE.SEEDS, FOODTYPE.GENERIC })
    inst.components.combat.damagemultiplier = 1
	
	inst.components.hunger.hungerrate = 1 * TUNING.WILSON_HUNGER_RATE
	
	inst.components.locomotor.walkspeed = 4
	inst.components.locomotor.runspeed = 6
	
    inst:ListenForEvent( "daycomplete", function(inst) 
	    if TUNING.LULU_PLANTLEVEL ~= 0 then
            if inst.plant_level <TUNING.LULU_PLANTLEVEL then
                inst.plant_level=inst.plant_level+1
			end
	        if inst.plant_level == TUNING.LULU_PLANTLEVEL then
                inst.plant_level = 0
		        GetFruit(inst)
			end
	    end
	end)


	if TUNING.LULU_EYE == 1 then
	    inst:RemoveTag("Lulu_eye")
	end
	
	if TUNING.LULU_CRAFT == 1 then
	    local lulu_recipe = Recipe("lureplantbulb", {Ingredient("dug_berrybush", 2), Ingredient("nightmarefuel", 7)}, RECIPETABS.TOWN, TECH.NONE, RECIPE_GAME_TYPE.COMMON)
	    lulu_recipe.sortkey = 1
	end
end

return MakePlayerCharacter("lulu", prefabs, assets, fn, start_inv)
