Scriptname towRandomIdle_Alias extends ReferenceAlias  

Import towRandomIdle

Perk Property ActivatePerk Auto

ObjectReference SelfRef
int ShoutKey
bool bRunIdle
bool IsBeast = false

Event OnInit()
	Init()
EndEvent

Event OnPlayerLoadGame()
	Init()
endEvent

Function Init()
	SelfRef = Self.GetReference()
	if (SelfRef == Game.GetPlayer())
		ShoutKey = Input.GetMappedKey("Shout")
		RegisterForKey(ShoutKey)

		if (!(SelfRef as Actor).HasPerk(ActivatePerk))
			(SelfRef as Actor).AddPerk(ActivatePerk)
		endif
	endif
		
	RegisterForAnimationEvent(SelfRef,  "tailMTIdle")
	RegisterForAnimEvent(SelfRef,  "moveStart")
	RegisterForAnimEvent(SelfRef,  "SneakStart")
	RegisterForBypassEvent(SelfRef,  "Magic_Equip")
	RegisterForBypassEvent(SelfRef,  "WeapEquip")
endFunction

State BlockState
	Event OnBeginState()
		RegisterForAnimEvent(SelfRef,  "HorseExit")
		SwitchBypassEvent(False)
	endEvent
	
	Event OnBypassEvent(ObjectReference akSource, string asEventName)
	endEvent

	Event OnAnimationEvent(ObjectReference akSource, string asEventName)
	endEvent

	Event OnAnimationEventEX(ObjectReference akSource, string asEventName)
		if (akSource == SelfRef)
			if (asEventName == "HorseExit")
				gotoState("")
			endif
		endif
	endEvent

	Event OnEndState()
		UnregisterForAnimEvent(SelfRef,  "HorseExit")
		bRunIdle = false
	endEvent
endState

Event OnBypassEvent(ObjectReference akSource, string asEventName)
	if (bRunIdle)
		Debug.SendAnimationEvent(akSource, "JumpLandEnd")
	endif
	SwitchBypassEvent(False)
	Debug.SendAnimationEvent(akSource, asEventName)
	SwitchBypassEvent(True)
endEvent

Event OnKeyDown(Int KeyCode)
	if (KeyCode == ShoutKey)
		OnAnimationEventEX(SelfRef, "KeydownEvent")
	endif
EndEvent

Event OnAnimationEvent(ObjectReference akSource, string asEventName)
	if (akSource == SelfRef)
		if (asEventName == "tailMTIdle")
			OnAnimationEventEX(akSource, asEventName)
		endif
	endif
endEvent

Event OnAnimationEventEX(ObjectReference akSource, string asEventName)
	if (akSource == SelfRef)

		if (bRunIdle)
			if (asEventName == "moveStart")
				Debug.SendAnimationEvent(akSource, "JumpLandEnd")
				SwitchBypassEvent(false)
				bRunIdle = false
			elseif (asEventName == "SneakStart")
				Debug.SendAnimationEvent(akSource, "JumpLandEnd")
				SwitchBypassEvent(false)
				bRunIdle = false
			elseif (asEventName == "KeydownEvent")
				Debug.SendAnimationEvent(akSource, "JumpLandEnd")
				SwitchBypassEvent(false)
				bRunIdle = false
			endif
		else
			if (IsRandomIdleEvent(asEventName))
				SwitchBypassEvent(True)
				bRunIdle = true
			elseif (asEventName == "tailMTIdle")
				string str = GetRandomIdleName(akSource)
				if (str != "")
					Debug.SendAnimationEvent(akSource, str)
				endif
			endif
		endif
	endif
endEvent


String Function GetRandomIdleName(ObjectReference ref)
	if (ref)
		GlobalVariable gvMaxIdle = Game.GetFormFromFile(0x0D63, "towRandomIdle.esp") as GlobalVariable
		if (gvMaxIdle)
			int index = Utility.RandomInt(1, (gvMaxIdle.GetValue() as int))
			if (index)
				string str
				if (index < 10)
					str = "RandomIdle0" + index
				else
					str = "RandomIdle" + index
				endif
				return str
			endif
		endif
	endif
	return ""
endFunction

Event OnRaceSwitchComplete()
	if (IsBeast)
		Init()
	endif
	if (SelfRef.HasKeywordString("ImmuneParalysis"))
		IsBeast = true
	else
		IsBeast = false
	endif
EndEvent
