scriptname NPCInfoQuestScript2 extends Quest

referencealias property NPCInfoSubjectAlias auto
message property NPCInfoMessage_MainMale auto
message property NPCInfoMessage_MainMaleEssential auto
message property NPCInfoMessage_MainMaleCommanded auto
message property NPCInfoMessage_MainFemale auto
message property NPCInfoMessage_MainFemaleEssential auto
message property NPCInfoMessage_MainFemaleCommanded auto
message property NPCInfoMessage_Combat auto
message property NPCInfoMessage_Magic auto
message property NPCInfoMessage_Stealth auto
spell property NPCInfoSpell auto

actor property NPCInfoSubject auto
float property NPCInfoLevel auto
race property NPCInfoRace auto
int property NPCInfoGender auto
bool property NPCInfoEssential auto
bool property NPCInfoCommanded auto
float property NPCInfoHealth auto
float property NPCInfoMagicka auto
float property NPCInfoStamina auto
float property NPCInfoHealthBase auto
float property NPCInfoMagickaBase auto
float property NPCInfoStaminaBase auto

float property NPCInfoArchery auto
float property NPCInfoBlock auto
float property NPCInfoHeavyArmour auto
float property NPCInfoOneHanded auto
float property NPCInfoTwoHanded auto
float property NPCInfoSmithing auto

float property NPCInfoAlteration auto
float property NPCInfoConjuration auto
float property NPCInfoDestruction auto
float property NPCInfoIllusion auto
float property NPCInfoRestoration auto
float property NPCInfoEnchanting auto

float property NPCInfoAlchemy auto
float property NPCInfoLightArmour auto
float property NPCInfoLockpicking auto
float property NPCInfoPickpocket auto
float property NPCInfoSneak auto
float property NPCInfoSpeech auto

int menuvalue

; ======

Event OnInit()
;	Debug.Notification("NPCInfoQuest started")
	Game.GetPlayer().AddSpell(NPCInfoSpell)
EndEvent

Function NPCInfoQuestFunction(actor Target)
	NPCInfoSubjectAlias.ForceRefTo(Target)
	NPCInfoSubject = NPCInfoSubjectAlias.GetActorRef()
	NPCInfoLevel = NPCInfoSubject.GetLevel() as float
	NPCInfoRace = NPCInfoSubject.GetRace()
	NPCInfoGender = (NPCInfoSubject.GetActorBase()).GetSex()
	NPCInfoEssential = NPCInfoSubject.IsEssential()
	NPCInfoCommanded = NPCInfoSubject.IsCommandedActor()
	NPCInfoHealth = NPCInfoSubject.GetAV("Health")
	NPCInfoMagicka = NPCInfoSubject.GetAV("Magicka")
	NPCInfoStamina = NPCInfoSubject.GetAV("Stamina")
	NPCInfoHealthBase = NPCInfoSubject.GetBaseAV("Health")
	NPCInfoMagickaBase = NPCInfoSubject.GetBaseAV("Magicka")
	NPCInfoStaminaBase = NPCInfoSubject.GetBaseAV("Stamina")
	NPCInfoArchery = NPCInfoSubject.GetAV("Marksman")
	NPCInfoBlock = NPCInfoSubject.GetAV("Block")
	NPCInfoHeavyArmour = NPCInfoSubject.GetAV("HeavyArmor")
	NPCInfoOneHanded = NPCInfoSubject.GetAV("OneHanded")
	NPCInfoTwoHanded = NPCInfoSubject.GetAV("TwoHanded")
	NPCInfoSmithing = NPCInfoSubject.GetAV("Smithing")
	NPCInfoAlteration = NPCInfoSubject.GetAV("Alteration")
	NPCInfoConjuration = NPCInfoSubject.GetAV("Conjuration")
	NPCInfoDestruction = NPCInfoSubject.GetAV("Destruction")
	NPCInfoIllusion = NPCInfoSubject.GetAV("Illusion")
	NPCInfoRestoration = NPCInfoSubject.GetAV("Restoration")
	NPCInfoEnchanting = NPCInfoSubject.GetAV("Enchanting")
	NPCInfoAlchemy = NPCInfoSubject.GetAV("Alchemy")
	NPCInfoLightArmour = NPCInfoSubject.GetAV("LightArmor")
	NPCInfoLockpicking = NPCInfoSubject.GetAV("Lockpicking")
	NPCInfoPickpocket = NPCInfoSubject.GetAV("Pickpocket")
	NPCInfoSneak = NPCInfoSubject.GetAV("Sneak")
	NPCInfoSpeech = NPCInfoSubject.GetAV("Speechcraft")
		
	NPCInfoMainMessage()
	
EndFunction


Function NPCInfoMainMessage()
	if NPCInfoGender == 0 ; Male
		if NPCInfoEssential
			menuvalue = NPCInfoMessage_MainMaleEssential.show(NPCInfoLevel, NPCInfoHealth, NPCInfoHealthBase, NPCInfoMagicka, NPCInfoMagickaBase, NPCInfoStamina, NPCInfoStaminaBase)
		elseif NPCInfoCommanded
			menuvalue = NPCInfoMessage_MainMaleCommanded.show(NPCInfoLevel, NPCInfoHealth, NPCInfoHealthBase, NPCInfoMagicka, NPCInfoMagickaBase, NPCInfoStamina, NPCInfoStaminaBase)
		else
			menuvalue = NPCInfoMessage_MainMale.show(NPCInfoLevel, NPCInfoHealth, NPCInfoHealthBase, NPCInfoMagicka, NPCInfoMagickaBase, NPCInfoStamina, NPCInfoStaminaBase)
		endif
	else ; Female
		if NPCInfoEssential
			menuvalue = NPCInfoMessage_MainFemaleEssential.show(NPCInfoLevel, NPCInfoHealth, NPCInfoHealthBase, NPCInfoMagicka, NPCInfoMagickaBase, NPCInfoStamina, NPCInfoStaminaBase)
		elseif NPCInfoCommanded
			menuvalue = NPCInfoMessage_MainFemaleCommanded.show(NPCInfoLevel, NPCInfoHealth, NPCInfoHealthBase, NPCInfoMagicka, NPCInfoMagickaBase, NPCInfoStamina, NPCInfoStaminaBase)
		else
			menuvalue = NPCInfoMessage_MainFemale.show(NPCInfoLevel, NPCInfoHealth, NPCInfoHealthBase, NPCInfoMagicka, NPCInfoMagickaBase, NPCInfoStamina, NPCInfoStaminaBase)
		endif
	endif
	
	if menuvalue == 0
		NPCInfoCombatSkillsMessage()
	elseif menuvalue == 1
		NPCInfoMagicSkillsMessage()
	elseif menuvalue == 2
		NPCInfoStealthSkillsMessage()
	endif
	
EndFunction

Function NPCInfoCombatSkillsMessage()
	int combatmenuvalue = NPCInfoMessage_Combat.show(NPCInfoArchery, NPCInfoBlock, NPCInfoHeavyArmour, NPCInfoOneHanded, NPCInfoTwoHanded, NPCInfoSmithing)
	
	if combatmenuvalue == 0
		NPCInfoMainMessage()
	elseif combatmenuvalue == 1
		NPCInfoMagicSkillsMessage()
	elseif combatmenuvalue == 2
		NPCInfoStealthSkillsMessage()
	endif

EndFunction

Function NPCInfoMagicSkillsMessage()
	int magicmenuvalue = NPCInfoMessage_Magic.show(NPCInfoAlteration, NPCInfoConjuration, NPCInfoDestruction, NPCInfoIllusion, NPCInfoRestoration, NPCInfoEnchanting)
	
	if magicmenuvalue == 0
		NPCInfoMainMessage()
	elseif magicmenuvalue == 1
		NPCInfoCombatSkillsMessage()
	elseif magicmenuvalue == 2
		NPCInfoStealthSkillsMessage()
	endif

EndFunction

Function NPCInfoStealthSkillsMessage()
	int stealthmenuvalue = NPCInfoMessage_Stealth.show(NPCInfoAlchemy, NPCInfoLightArmour, NPCInfoLockpicking, NPCInfoPickpocket, NPCInfoSneak, NPCInfoSpeech)
	
	if stealthmenuvalue == 0
		NPCInfoMainMessage()
	elseif stealthmenuvalue == 1
		NPCInfoCombatSkillsMessage()
	elseif stealthmenuvalue == 2
		NPCInfoMagicSkillsMessage()
	endif

EndFunction


