
local MakePlayerCharacter = require "prefabs/player_common"


local assets = {

        Asset( "ANIM", "anim/player_basic.zip" ),
        Asset( "ANIM", "anim/player_idles_shiver.zip" ),
        Asset( "ANIM", "anim/player_actions.zip" ),
        Asset( "ANIM", "anim/player_actions_axe.zip" ),
        Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
        Asset( "ANIM", "anim/player_actions_shovel.zip" ),
        Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
        Asset( "ANIM", "anim/player_actions_eat.zip" ),
        Asset( "ANIM", "anim/player_actions_item.zip" ),
        Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
        Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
        Asset( "ANIM", "anim/player_actions_fishing.zip" ),
        Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
        Asset( "ANIM", "anim/player_bush_hat.zip" ),
        Asset( "ANIM", "anim/player_attacks.zip" ),
        Asset( "ANIM", "anim/player_idles.zip" ),
        Asset( "ANIM", "anim/player_rebirth.zip" ),
        Asset( "ANIM", "anim/player_jump.zip" ),
        Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
        Asset( "ANIM", "anim/player_teleport.zip" ),
        Asset( "ANIM", "anim/wilson_fx.zip" ),
        Asset( "ANIM", "anim/player_one_man_band.zip" ),
        Asset( "ANIM", "anim/shadow_hands.zip" ),
        Asset( "SOUND", "sound/sfx.fsb" ),
        Asset( "SOUND", "sound/wilson.fsb" ),
        Asset( "ANIM", "anim/beard.zip" ),

		-- Don't forget to include your character's custom assets!
        Asset( "ANIM", "anim/luffy.zip" ),
}
local prefabs = {}
local start_inv = 
{
"strawhat",
"meat",
"meat",
"meat",
"meat",
"meat",
"meat",
"meat",
"meat",
"meat",
"meat",
"meat",
"meat",
"meat",
"meat",
"meat",
"meat",
"meat",
"meat",
"meat",
"meat",
} 



local fn = function(inst)
	inst.soundsname = "wolfgang"
	inst.MiniMapEntity:SetIcon( "wilson.png" )		
	inst.components.sanity:SetMax(160)
	inst.components.health:SetMaxHealth(350)
	inst.components.locomotor.runspeed = TUNING.WILSON_RUN_SPEED * 1.3
	inst.components.hunger:SetMax(280)
	inst.components.eater.ignoresspoilage = true
	inst.components.health.fire_damage_scale = 2
	inst.components.sanity.neg_aura_mult = 0
	inst.components.combat.damagemultiplier = 1.5
	inst.components.combat:SetDefaultDamage(40) 
	inst.components.hunger:SetKillRate(TUNING.WILSON_HEALTH/TUNING.STARVE_KILL_TIME*1.2) 
	inst.components.inventory:GuaranteeItems(start_inv)
	inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE*1.5)
	inst.components.eater.foodprefs = { "MEAT","INSECT","HORRIBLE"} 
end





STRINGS.CHARACTER_TITLES.luffy = "ҪΪ!"
STRINGS.CHARACTER_NAMES.luffy = "Luffy"
STRINGS.CHARACTER_DESCRIPTIONS.luffy = "*Ƥ,ʵ,ȻҲ.\n*ֻʳ,ܱʵʳ.\n*Ƥ!·ɵĿֹһ˸."
STRINGS.CHARACTER_QUOTES.luffy = "\"ҪΪ!\""

STRINGS.CHARACTERS.LUFFY = {}
STRINGS.CHARACTERS.LUFFY.DESCRIBE = {}
STRINGS.CHARACTERS.LUFFY.DESCRIBE.EVERGREEN = {",!¡һһ~"}
STRINGS.CHARACTERS.LUFFY.DESCRIBE.BEEBOX = {"ʵҲϲԷ~Ű"}
STRINGS.CHARACTERS.LUFFY.DESCRIBE.PIGHOUSE = {"!!!!Ҫ!!!~"}
STRINGS.CHARACTERS.LUFFY.DESCRIBE.RAIN = {"(  o  )ѽ~ѽ?"}
STRINGS.CHARACTERS.LUFFY.DESCRIBE.GRAVESTONE = {"ҳ˺һ"}
STRINGS.CHARACTERS.LUFFY.DESCRIBE.FIREPIT = {".~"}
STRINGS.CHARACTERS.LUFFY.DESCRIBE.PIGKING = {".......ɽ..."}
STRINGS.CHARACTERS.LUFFY.DESCRIBE.PIGMAN = {"ɭ..żܳô..."}
STRINGS.CHARACTERS.LUFFY.DESCRIBE.BEEFALO = {"ţɭ..ż...."}
STRINGS.CHARACTERS.LUFFY.DESCRIBE.MOUND = {"ҳ˺һ"}
STRINGS.CHARACTERS.LUFFY.DESCRIBE.BEEHIVE = {"ʵҲϲԷ~Ű"}
STRINGS.CHARACTERS.LUFFY.DESCRIBE.WALRUS_CAMP = {"..Ϳ.."}
STRINGS.CHARACTERS.LUFFY.DESCRIBE.HOMESIGN = {",֪˼·.."}
STRINGS.CHARACTERS.LUFFY.DESCRIBE.POND = {"Ƭ!!Ƭ!!Ƭ!!!."}
STRINGS.CHARACTERS.LUFFY.DESCRIBE.CAMPFIRE = {".~"}
STRINGS.CHARACTERS.LUFFY.DESCRIBE.RABBITHOLE = {"СӹԹ,Ŷ..."}




return MakePlayerCharacter("luffy", prefabs, assets, fn, start_inv)
