/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.character;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.gdstash.character.GDCharBio;
import org.gdstash.character.GDCharCrucible;
import org.gdstash.character.GDCharEquippedContainer;
import org.gdstash.character.GDCharFactionList;
import org.gdstash.character.GDCharHeader;
import org.gdstash.character.GDCharInfo;
import org.gdstash.character.GDCharInventory;
import org.gdstash.character.GDCharInventorySack;
import org.gdstash.character.GDCharMarkerList;
import org.gdstash.character.GDCharNoteList;
import org.gdstash.character.GDCharRespawnList;
import org.gdstash.character.GDCharShrineList;
import org.gdstash.character.GDCharSkill;
import org.gdstash.character.GDCharSkillList;
import org.gdstash.character.GDCharStash;
import org.gdstash.character.GDCharStats;
import org.gdstash.character.GDCharSummary;
import org.gdstash.character.GDCharTeleportList;
import org.gdstash.character.GDCharTutorialList;
import org.gdstash.character.GDCharUID;
import org.gdstash.character.GDCharUISettings;
import org.gdstash.db.DBSkill;
import org.gdstash.file.GDFileSize;
import org.gdstash.file.GDReader;
import org.gdstash.file.GDWriter;
import org.gdstash.item.GDItem;
import org.gdstash.util.GDConstants;
import org.gdstash.util.GDMsgFormatter;
import org.gdstash.util.GDMsgLogger;

public class GDChar
implements GDFileSize {
    public static final byte BYTE_FALSE = 0;
    public static final byte BYTE_TRUE = 1;
    public static final byte SEX_FEMALE = 0;
    public static final byte SEX_MALE = 1;
    public static final byte SOFTCORE = 0;
    public static final byte HARDCORE = 1;
    public static final byte DIFFICULTY_NORMAL = 0;
    public static final byte DIFFICULTY_ELITE = 1;
    public static final byte DIFFICULTY_ULTIMATE = 2;
    public static final byte CRUCIBLE_ASPIRANT = 0;
    public static final byte CRUCIBLE_GLADIATOR = 1;
    public static final byte CRUCIBLE_CHALLENGER = 2;
    public static final int EQUIP_SLOT_HEAD = 0;
    public static final int EQUIP_SLOT_AMULET = 1;
    public static final int EQUIP_SLOT_CHEST = 2;
    public static final int EQUIP_SLOT_LEGS = 3;
    public static final int EQUIP_SLOT_FEET = 4;
    public static final int EQUIP_SLOT_HANDS = 5;
    public static final int EQUIP_SLOT_RING_RIGHT = 6;
    public static final int EQUIP_SLOT_RING_LEFT = 7;
    public static final int EQUIP_SLOT_BELT = 8;
    public static final int EQUIP_SLOT_SHOULDERS = 9;
    public static final int EQUIP_SLOT_MEDAL = 10;
    public static final int EQUIP_SLOT_RELIC = 11;
    public static final int EQUIP_SLOT_WEAPON_1_RIGHT = 12;
    public static final int EQUIP_SLOT_WEAPON_1_LEFT = 13;
    public static final int EQUIP_SLOT_WEAPON_2_RIGHT = 14;
    public static final int EQUIP_SLOT_WEAPON_2_LEFT = 15;
    public static final int EQUIP_SLOT_HAND_RIGHT = 0;
    public static final int EQUIP_SLOT_HAND_LEFT = 1;
    private static final int VERSION_6 = 6;
    private static final int VERSION_7 = 7;
    private File file;
    private int key;
    private int version;
    private boolean charError;
    private GDCharHeader header;
    private GDCharUID uid;
    private GDCharInfo info;
    private GDCharBio bio;
    private GDCharInventory inventory;
    private GDCharStash stash;
    private GDCharRespawnList respawns;
    private GDCharTeleportList teleports;
    private GDCharMarkerList markers;
    private GDCharShrineList shrines;
    private GDCharSkillList skills;
    private GDCharNoteList notes;
    private GDCharFactionList factions;
    private GDCharUISettings ui;
    private GDCharTutorialList tutorials;
    private GDCharStats stats;
    private GDCharCrucible crucible;

    public GDChar(File file) {
        this.file = file;
        this.charError = false;
        this.header = new GDCharHeader();
        this.uid = new GDCharUID();
        this.info = new GDCharInfo();
        this.bio = new GDCharBio();
        this.inventory = new GDCharInventory(this);
        this.stash = new GDCharStash(this);
        this.respawns = new GDCharRespawnList();
        this.teleports = new GDCharTeleportList();
        this.markers = new GDCharMarkerList();
        this.shrines = new GDCharShrineList();
        this.skills = new GDCharSkillList();
        this.notes = new GDCharNoteList();
        this.factions = new GDCharFactionList();
        this.ui = new GDCharUISettings();
        this.tutorials = new GDCharTutorialList();
        this.stats = new GDCharStats();
        this.crucible = new GDCharCrucible();
    }

    public String getCharName() {
        if (this.header == null) {
            return null;
        }
        return this.header.getCharName();
    }

    public byte getSex() {
        if (this.header == null) {
            return 1;
        }
        return this.header.getSex();
    }

    public boolean isHardcore() {
        if (this.header == null) {
            return false;
        }
        return this.header.isHardcore();
    }

    public boolean isInMainQuest() {
        if (this.info == null) {
            return false;
        }
        return this.info.isInMainQuest();
    }

    public byte getGreatestDifficulty() {
        if (this.info == null) {
            return 0;
        }
        return this.info.getGreatestCampaignDifficulty();
    }

    public int getMoney() {
        if (this.info == null) {
            return 0;
        }
        return this.info.getMoney();
    }

    public int getLevel() {
        if (this.bio == null) {
            return 1;
        }
        return this.bio.getLevel();
    }

    public int getExperience() {
        if (this.bio == null) {
            return 0;
        }
        return this.bio.getExperience();
    }

    public int getStatPoints() {
        if (this.bio == null) {
            return 0;
        }
        return this.bio.getStatPoints();
    }

    public int getSkillPoints() {
        if (this.bio == null) {
            return 0;
        }
        return this.bio.getSkillPoints();
    }

    public int getDevotionPoints() {
        if (this.bio == null) {
            return 0;
        }
        return this.bio.getDevotionPoints();
    }

    public float getPhysique() {
        if (this.bio == null) {
            return 0.0f;
        }
        return this.bio.getPhysique();
    }

    public float getCunning() {
        if (this.bio == null) {
            return 0.0f;
        }
        return this.bio.getCunning();
    }

    public float getSpirit() {
        if (this.bio == null) {
            return 0.0f;
        }
        return this.bio.getSpirit();
    }

    public float getHealth() {
        if (this.bio == null) {
            return 0.0f;
        }
        return this.bio.getHealth();
    }

    public float getEnergy() {
        if (this.bio == null) {
            return 0.0f;
        }
        return this.bio.getEnergy();
    }

    public int getStashHeight() {
        if (this.stash == null) {
            return 18;
        }
        return this.stash.getHeight();
    }

    public int getStashWidth() {
        if (this.stash == null) {
            return 10;
        }
        return this.stash.getWidth();
    }

    public GDCharUID getRespawnPoint(int difficulty) {
        if (this.respawns == null) {
            return null;
        }
        return this.respawns.getRespawnPoint(difficulty);
    }

    public List<GDCharUID> getRiftList(int difficulty) {
        LinkedList<GDCharUID> list = new LinkedList<GDCharUID>();
        if (this.teleports == null) {
            return list;
        }
        return this.teleports.getRiftList(difficulty);
    }

    public List<GDCharUID> getDiscoveredShrinesList(int difficulty) {
        LinkedList<GDCharUID> list = new LinkedList<GDCharUID>();
        if (this.shrines == null) {
            return list;
        }
        return this.shrines.getDiscoveredShrinesList(difficulty);
    }

    public List<GDCharUID> getRestoredShrinesList(int difficulty) {
        LinkedList<GDCharUID> list = new LinkedList<GDCharUID>();
        if (this.shrines == null) {
            return list;
        }
        return this.shrines.getRestoredShrinesList(difficulty);
    }

    public int getSkillReclaimPoints() {
        if (this.skills == null) {
            return 0;
        }
        return this.skills.getSkillReclaimPoints();
    }

    public int getDevotionReclaimPoints() {
        if (this.skills == null) {
            return 0;
        }
        return this.skills.getDevotionReclaimPoints();
    }

    public int[] getFactionReputations() {
        int[] reputations = null;
        if (this.factions == null) {
            reputations = new int[GDCharFactionList.FACTIONS.length];
            for (int i = 0; i < reputations.length; ++i) {
                reputations[i] = 0;
            }
        } else {
            reputations = this.factions.getFactionReputations();
        }
        return reputations;
    }

    public int getDeaths() {
        if (this.stats == null) {
            return 0;
        }
        return this.stats.getDeaths();
    }

    public boolean hasErrors() {
        return this.charError;
    }

    public boolean hasChanged() {
        boolean hasChanged = false;
        hasChanged = hasChanged || this.header.hasChanged();
        hasChanged = hasChanged || this.info.hasChanged();
        hasChanged = hasChanged || this.bio.hasChanged();
        hasChanged = hasChanged || this.inventory.hasChanged();
        hasChanged = hasChanged || this.stash.hasChanged();
        hasChanged = hasChanged || this.respawns.hasChanged();
        hasChanged = hasChanged || this.teleports.hasChanged();
        hasChanged = hasChanged || this.shrines.hasChanged();
        hasChanged = hasChanged || this.skills.hasChanged();
        hasChanged = hasChanged || this.factions.hasChanged();
        hasChanged = hasChanged || this.stats.hasChanged();
        return hasChanged;
    }

    public GDCharEquippedContainer getEquipment() {
        GDCharEquippedContainer equipment = null;
        if (this.inventory != null) {
            equipment = this.inventory.getEquipment();
        }
        return equipment;
    }

    public GDCharInventorySack getInventory() {
        GDCharInventorySack sack = null;
        if (this.inventory != null) {
            sack = this.inventory.getInventory();
        }
        return sack;
    }

    public List<GDCharInventorySack> getBags() {
        List<GDCharInventorySack> list = new LinkedList<GDCharInventorySack>();
        if (this.inventory != null) {
            list = this.inventory.getBags();
        }
        return list;
    }

    public GDCharStash getStash() {
        return this.stash;
    }

    public List<GDItem> getItems() {
        LinkedList<GDItem> list = new LinkedList<GDItem>();
        list.addAll(this.inventory.getItems());
        list.addAll(this.stash.getItemList());
        return list;
    }

    private List<GDCharSkill> getMasteries() {
        List<Object> masteries = null;
        masteries = this.skills == null ? new LinkedList() : this.skills.getMasteries();
        return masteries;
    }

    public MasteryInfo[] getMasteryInfo() {
        List<GDCharSkill> masteries = this.getMasteries();
        if (masteries.size() == 0) {
            return null;
        }
        MasteryInfo[] infos = new MasteryInfo[masteries.size()];
        int i = 0;
        for (GDCharSkill skill : masteries) {
            MasteryInfo info;
            infos[i] = info = new MasteryInfo(skill);
            ++i;
        }
        return infos;
    }

    private GDCharHeader getCharHeader() {
        return this.header;
    }

    private GDCharInfo getCharInfo() {
        return this.info;
    }

    public void setFileDir(File fDir) {
        try {
            File f;
            String name = this.file.getName();
            String dir = fDir.getCanonicalPath();
            dir = dir + GDConstants.FILE_SEPARATOR + name;
            this.file = f = new File(dir);
        }
        catch (IOException ex) {
            GDMsgLogger.addError(ex);
        }
    }

    public void setCharName(String charName) {
        this.header.setCharName(charName);
    }

    public void setSex(byte sex) {
        this.header.setSex(sex);
    }

    public void setHardcore(boolean hardcore) {
        this.header.setHardcore(hardcore);
    }

    public void setInMainQuest(boolean isInMainQuest) {
        this.info.setInMainQuest(isInMainQuest);
    }

    public void setGreatestDifficulty(byte greatestDifficulty) {
        this.info.setGreatestCampaignDifficulty(greatestDifficulty);
    }

    public void setMoney(int money) {
        this.info.setMoney(money);
    }

    public void setLevel(int level) {
        this.bio.setLevel(level);
    }

    public void setExperience(int experience) {
        this.bio.setExperience(experience);
    }

    public void setStatPoints(int modifierPoints) {
        this.bio.setStatPoints(modifierPoints);
    }

    public void setSkillPoints(int skillPoints) {
        this.bio.setSkillPoints(skillPoints);
    }

    public void setDevotionPoints(int devotionPoints) {
        this.bio.setDevotionPoints(devotionPoints);
    }

    public void setPhysique(float physique) {
        this.bio.setPhysique(physique);
    }

    public void setCunning(float cunning) {
        this.bio.setCunning(cunning);
    }

    public void setSpirit(int spirit) {
        this.bio.setSpirit(spirit);
    }

    public void setHealth(float health) {
        this.bio.setHealth(health);
    }

    public void setEnergy(float energy) {
        this.bio.setEnergy(energy);
    }

    public void setRespawnPoint(int difficulty, GDCharUID spawn) {
        this.respawns.setRespawnPoint(difficulty, spawn);
    }

    public void setRiftList(int difficulty, List<GDCharUID> list) {
        this.teleports.setRiftList(difficulty, list);
    }

    public void setDiscoveredShrinesList(int difficulty, List<GDCharUID> list) {
        this.shrines.setDiscoveredShrinesList(difficulty, list);
    }

    public void setRestoredShrinesList(int difficulty, List<GDCharUID> list) {
        this.shrines.setRestoredShrinesList(difficulty, list);
        int shrinesRestored = 0;
        shrinesRestored += this.shrines.getDiscoveredShrinesList(0).size();
        shrinesRestored += this.shrines.getDiscoveredShrinesList(1).size();
        this.stats.setShrinesRestored(shrinesRestored += this.shrines.getDiscoveredShrinesList(2).size());
    }

    public void setSkillReclaimPoints(int skillReclamationPointsUsed) {
        this.skills.setSkillReclaimPoints(skillReclamationPointsUsed);
    }

    public void setDevotionReclaimPoints(int devotionReclamationPointsUsed) {
        this.skills.setDevotionReclaimPoints(devotionReclamationPointsUsed);
    }

    public void setFactionReputations(int[] reputations) {
        this.factions.setFactionReputations(reputations);
    }

    public void setDeaths(int deaths) {
        this.stats.setDeaths(deaths);
    }

    public void setMasteryInfo(MasteryInfo[] infos) {
        this.skills.setMasteryInfo(infos);
    }

    public static GDCharSummary readCharSummary(File file) {
        String path = null;
        try {
            path = file.getCanonicalPath();
        }
        catch (IOException ex) {
            return null;
        }
        GDChar gdc = new GDChar(file);
        gdc.readSummary(path);
        if (gdc.hasErrors()) {
            return null;
        }
        return new GDCharSummary(gdc.getCharHeader(), gdc.getCharInfo());
    }

    public static void readUIDList(List<GDCharUID> uidList) throws IOException {
        int len = GDReader.readEncInt(true);
        uidList.clear();
        for (int i = 0; i < len; ++i) {
            GDCharUID uid = new GDCharUID();
            uid.read();
            uidList.add(uid);
        }
    }

    public static void writeUIDList(List<GDCharUID> uidList) throws IOException {
        int len = 0;
        if (uidList != null) {
            len = uidList.size();
        }
        GDWriter.writeInt(len);
        if (uidList == null) {
            return;
        }
        for (GDCharUID uid : uidList) {
            uid.write();
        }
    }

    private void readSummary(String path) {
        int val = 0;
        try {
            GDReader.readEncFileToBuffer(this.file);
            this.key = GDReader.readKey();
            val = GDReader.readEncInt(true);
            if (val != 1480803399) {
                throw new IOException(GDMsgFormatter.getString(GDMsgFormatter.rbMsg, "ERR_UNSUPPORTED_VERSION"));
            }
            val = GDReader.readEncInt(true);
            if (val != 1) {
                throw new IOException(GDMsgFormatter.getString(GDMsgFormatter.rbMsg, "ERR_UNSUPPORTED_VERSION"));
            }
            this.header.read();
            val = GDReader.readEncInt(false);
            if (val != 0) {
                throw new IOException(GDMsgFormatter.getString(GDMsgFormatter.rbMsg, "ERR_UNSUPPORTED_VERSION"));
            }
            this.version = GDReader.readEncInt(true);
            if (this.version != 6 && this.version != 7) {
                throw new IOException(GDMsgFormatter.getString(GDMsgFormatter.rbMsg, "ERR_UNSUPPORTED_VERSION"));
            }
            this.uid.read();
            this.info.read();
        }
        catch (FileNotFoundException ex) {
            if (path != null) {
                Object[] args = new Object[]{path};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_FILE_NOT_FOUND", args);
                GDMsgLogger.addError(msg);
            }
            GDMsgLogger.addError(ex);
            this.charError = true;
        }
        catch (Exception ex) {
            if (path != null) {
                Object[] args = new Object[]{path};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_FILE_READ", args);
                GDMsgLogger.addError(msg);
            }
            GDMsgLogger.addError(ex);
            this.charError = true;
        }
    }

    public void read() {
        String path = null;
        boolean val = false;
        try {
            path = this.file.getCanonicalPath();
            this.readSummary(path);
            if (this.charError) {
                return;
            }
            this.bio.read();
            this.inventory.read();
            this.stash.read();
            this.respawns.read();
            this.teleports.read();
            this.markers.read();
            this.shrines.read();
            this.skills.read();
            this.notes.read();
            this.factions.read();
            this.ui.read();
            this.tutorials.read();
            this.stats.read();
            if (this.version == 7) {
                this.crucible.read();
            }
        }
        catch (FileNotFoundException ex) {
            if (path != null) {
                Object[] args = new Object[]{path};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_FILE_NOT_FOUND", args);
                GDMsgLogger.addError(msg);
            }
            GDMsgLogger.addError(ex);
            this.charError = true;
        }
        catch (Exception ex) {
            if (path != null) {
                Object[] args = new Object[]{path};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_FILE_READ", args);
                GDMsgLogger.addError(msg);
            }
            GDMsgLogger.addError(ex);
            this.charError = true;
        }
    }

    @Override
    public int getByteSize() {
        int size = 0;
        size += 4;
        size += 4;
        size += 4;
        size += this.header.getByteSize();
        size += 4;
        size += 4;
        GDChar gDChar = this;
        size += gDChar.uid.getByteSize();
        size += this.info.getByteSize();
        size += this.bio.getByteSize();
        size += this.inventory.getByteSize();
        size += this.stash.getByteSize();
        size += this.respawns.getByteSize();
        size += this.teleports.getByteSize();
        size += this.markers.getByteSize();
        size += this.shrines.getByteSize();
        size += this.skills.getByteSize();
        size += this.notes.getByteSize();
        size += this.factions.getByteSize();
        size += this.ui.getByteSize();
        size += this.tutorials.getByteSize();
        size += this.stats.getByteSize();
        if (this.version == 7) {
            size += this.crucible.getByteSize();
        }
        return size;
    }

    public void createBuffer() throws IOException {
        GDWriter.reserveBuffer(this);
        GDWriter.writeInt(0x55555555);
        GDWriter.writeInt(1480803399);
        GDWriter.writeInt(1);
        this.header.write();
        GDWriter.writeInt(0);
        GDWriter.writeInt(this.version);
        this.uid.write();
        this.info.write();
        this.bio.write();
        this.inventory.write();
        this.stash.write();
        this.respawns.write();
        this.teleports.write();
        this.markers.write();
        this.shrines.write();
        this.skills.write();
        this.notes.write();
        this.factions.write();
        this.ui.write();
        this.tutorials.write();
        this.stats.write();
        if (this.version == 7) {
            this.crucible.write();
        }
    }

    public void write() throws IOException {
        this.createBuffer();
        String separator = System.getProperty("file.separator");
        String path = this.file.getCanonicalPath();
        int pos = path.lastIndexOf(separator);
        if (pos != -1) {
            path = path.substring(0, pos + 1);
        }
        String tname = "player.g";
        File temp = new File(path + "temp_tmp.tmp");
        temp.createNewFile();
        GDWriter.writeBuffer(temp);
        File fCurr = new File(path + tname + String.format("%02d", 0));
        File fNew = null;
        for (int i = 9; i >= 0; --i) {
            fCurr = new File(path + tname + String.format("%02d", i));
            fNew = new File(path + tname + String.format("%02d", i + 1));
            if (!fCurr.exists()) continue;
            if (i == 9) {
                fCurr.delete();
                continue;
            }
            fCurr.renameTo(fNew);
        }
        this.file.renameTo(fCurr);
        temp.renameTo(this.file);
    }

    public static class MasteryInfo {
        public String id;
        public String name;
        public int points;

        public MasteryInfo(GDCharSkill skill) {
            if (skill == null) {
                return;
            }
            this.id = skill.getID();
            DBSkill dbSkill = DBSkill.get(this.id);
            this.name = dbSkill.getName();
            this.points = skill.getLevel();
        }
    }
}

