/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.character;

import java.io.IOException;
import org.gdstash.file.GDReader;
import org.gdstash.file.GDWriter;
import org.gdstash.util.GDMsgFormatter;

public class GDCharBio {
    private static final int VERSION = 8;
    private static final int BLOCK = 2;
    private int version;
    private int level;
    private int experience;
    private int modifierPoints;
    private int skillPoints;
    private int devotionPoints;
    private int totalDevotion;
    private float physique;
    private float cunning;
    private float spirit;
    private float health;
    private float energy;
    private boolean changed;

    public int getLevel() {
        return this.level;
    }

    public int getExperience() {
        return this.experience;
    }

    public int getStatPoints() {
        return this.modifierPoints;
    }

    public int getSkillPoints() {
        return this.skillPoints;
    }

    public int getDevotionPoints() {
        return this.devotionPoints;
    }

    public float getPhysique() {
        return this.physique;
    }

    public float getCunning() {
        return this.cunning;
    }

    public float getSpirit() {
        return this.spirit;
    }

    public float getHealth() {
        return this.health;
    }

    public float getEnergy() {
        return this.energy;
    }

    public boolean hasChanged() {
        return this.changed;
    }

    public void setLevel(int level) {
        this.level = level;
        this.changed = true;
    }

    public void setExperience(int experience) {
        this.experience = experience;
        this.changed = true;
    }

    public void setStatPoints(int modifierPoints) {
        this.modifierPoints = modifierPoints;
        this.changed = true;
    }

    public void setSkillPoints(int skillPoints) {
        this.skillPoints = skillPoints;
        this.changed = true;
    }

    public void setDevotionPoints(int devotionPoints) {
        this.devotionPoints = devotionPoints;
        this.changed = true;
    }

    public void setPhysique(float physique) {
        this.physique = physique;
        this.changed = true;
    }

    public void setCunning(float cunning) {
        this.cunning = cunning;
        this.changed = true;
    }

    public void setSpirit(float spirit) {
        this.spirit = spirit;
        this.changed = true;
    }

    public void setHealth(float health) {
        this.health = health;
        this.changed = true;
    }

    public void setEnergy(float energy) {
        this.energy = energy;
        this.changed = true;
    }

    public void read() throws IOException {
        int val = 0;
        GDReader.Block block = new GDReader.Block();
        val = GDReader.readBlockStart(block);
        if (val != 2) {
            throw new IOException(GDMsgFormatter.getString(GDMsgFormatter.rbMsg, "ERR_UNSUPPORTED_VERSION"));
        }
        this.version = GDReader.readEncInt(true);
        if (this.version != 8) {
            throw new IOException(GDMsgFormatter.getString(GDMsgFormatter.rbMsg, "ERR_UNSUPPORTED_VERSION"));
        }
        this.level = GDReader.readEncInt(true);
        this.experience = GDReader.readEncInt(true);
        this.modifierPoints = GDReader.readEncInt(true);
        this.skillPoints = GDReader.readEncInt(true);
        this.devotionPoints = GDReader.readEncInt(true);
        this.totalDevotion = GDReader.readEncInt(true);
        this.physique = GDReader.readEncFloat(true);
        this.cunning = GDReader.readEncFloat(true);
        this.spirit = GDReader.readEncFloat(true);
        this.health = GDReader.readEncFloat(true);
        this.energy = GDReader.readEncFloat(true);
        GDReader.readBlockEnd(block);
        this.changed = false;
    }

    public void write() throws IOException {
        GDReader.Block block = new GDReader.Block();
        GDWriter.writeBlockStart(block, 2);
        GDWriter.writeInt(8);
        GDWriter.writeInt(this.level);
        GDWriter.writeInt(this.experience);
        GDWriter.writeInt(this.modifierPoints);
        GDWriter.writeInt(this.skillPoints);
        GDWriter.writeInt(this.devotionPoints);
        GDWriter.writeInt(this.totalDevotion);
        GDWriter.writeFloat(this.physique);
        GDWriter.writeFloat(this.cunning);
        GDWriter.writeFloat(this.spirit);
        GDWriter.writeFloat(this.health);
        GDWriter.writeFloat(this.energy);
        GDWriter.writeBlockEnd(block);
        this.changed = false;
    }

    public int getByteSize() {
        int size = 0;
        size += 4;
        size += 4;
        size += 4;
        size += 4;
        size += 4;
        size += 4;
        size += 4;
        size += 4;
        size += 4;
        size += 4;
        size += 4;
        size += 4;
        size += 4;
        size += 4;
        return size += 4;
    }
}

