/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.character;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.gdstash.character.GDChar;
import org.gdstash.file.GDReader;
import org.gdstash.file.GDWriter;
import org.gdstash.item.GDAbstractContainer;
import org.gdstash.item.GDItem;

public class GDCharEquippedContainer
extends GDAbstractContainer {
    private GDItem[] equipment = new GDItem[12];
    private GDItem[] weapon1 = new GDItem[2];
    private GDItem[] weapon2 = new GDItem[2];
    private GDItem[] removedEquipment = new GDItem[this.equipment.length];
    private GDItem[] removedWeapon1 = new GDItem[this.weapon1.length];
    private GDItem[] removedWeapon2 = new GDItem[this.weapon2.length];
    private byte useAlternate;
    private byte alternate1;
    private byte alternate2;
    private GDChar gdc;

    public GDCharEquippedContainer(GDChar gdc) {
        super(5);
        this.gdc = gdc;
    }

    @Override
    public List<GDItem> getItemList() {
        GDItem item;
        int i;
        LinkedList<GDItem> list = new LinkedList<GDItem>();
        for (i = 0; i < this.equipment.length; ++i) {
            if (this.equipment[i] == null || (item = this.equipment[i]).getItemID() == null) continue;
            item.setX(0);
            item.setY(i);
            list.add(item);
        }
        for (i = 0; i < this.weapon1.length; ++i) {
            if (this.weapon1[i] == null || (item = this.weapon1[i]).getItemID() == null) continue;
            item.setX(1);
            item.setY(i);
            list.add(item);
        }
        for (i = 0; i < this.weapon2.length; ++i) {
            if (this.weapon2[i] == null || (item = this.weapon2[i]).getItemID() == null) continue;
            item.setX(2);
            item.setY(i);
            list.add(item);
        }
        return list;
    }

    @Override
    public boolean addItem(GDItem item) {
        if (!this.canAddItem(item)) {
            return false;
        }
        int x = item.getX();
        int y = item.getY();
        switch (x) {
            case 0: {
                this.equipment[y] = item;
                break;
            }
            case 1: {
                this.weapon1[y] = item;
                break;
            }
            case 2: {
                this.weapon2[y] = item;
            }
        }
        this.changed = true;
        return true;
    }

    @Override
    public boolean removeItem(GDItem item) {
        boolean found = false;
        int x = item.getX();
        int y = item.getY();
        switch (x) {
            case 0: {
                if (this.equipment.length <= y || this.equipment[y] != item) break;
                this.equipment[y] = new GDItem(this.gdc.getCharName(), this.gdc.isHardcore(), 5);
                this.equipment[y].setX(x);
                this.equipment[y].setY(y);
                found = true;
                break;
            }
            case 1: {
                if (this.weapon1.length <= y || this.weapon1[y] != item) break;
                this.weapon1[y] = new GDItem(this.gdc.getCharName(), this.gdc.isHardcore(), 5);
                this.weapon1[y].setX(x);
                this.weapon1[y].setY(y);
                found = true;
                break;
            }
            case 2: {
                if (this.weapon2.length <= y || this.weapon2[y] != item) break;
                this.weapon2[y] = new GDItem(this.gdc.getCharName(), this.gdc.isHardcore(), 5);
                this.weapon2[y].setX(x);
                this.weapon2[y].setY(y);
                found = true;
            }
        }
        if (found) {
            this.changed = true;
        }
        return found;
    }

    private boolean canAddItem(GDItem item) {
        GDItem gdi;
        int x = item.getX();
        int y = item.getY();
        boolean possible = false;
        if (x == 0) {
            switch (y) {
                case 0: {
                    if (this.equipment[0].getItemID() != null || !item.getItemClass().equals("ArmorProtective_Head")) break;
                    possible = true;
                    break;
                }
                case 1: {
                    if (this.equipment[1].getItemID() != null || !item.getItemClass().equals("ArmorJewelry_Amulet")) break;
                    possible = true;
                    break;
                }
                case 2: {
                    if (this.equipment[2].getItemID() != null || !item.getItemClass().equals("ArmorProtective_Chest")) break;
                    possible = true;
                    break;
                }
                case 3: {
                    if (this.equipment[3].getItemID() != null || !item.getItemClass().equals("ArmorProtective_Legs")) break;
                    possible = true;
                    break;
                }
                case 4: {
                    if (this.equipment[4].getItemID() != null || !item.getItemClass().equals("ArmorProtective_Feet")) break;
                    possible = true;
                    break;
                }
                case 5: {
                    if (this.equipment[5].getItemID() != null || !item.getItemClass().equals("ArmorProtective_Hands")) break;
                    possible = true;
                    break;
                }
                case 6: {
                    if (this.equipment[6].getItemID() != null || !item.getItemClass().equals("ArmorJewelry_Ring")) break;
                    possible = true;
                    break;
                }
                case 7: {
                    if (this.equipment[7].getItemID() != null || !item.getItemClass().equals("ArmorJewelry_Ring")) break;
                    possible = true;
                    break;
                }
                case 8: {
                    if (this.equipment[8].getItemID() != null || !item.getItemClass().equals("ArmorProtective_Waist")) break;
                    possible = true;
                    break;
                }
                case 9: {
                    if (this.equipment[9].getItemID() != null || !item.getItemClass().equals("ArmorProtective_Shoulders")) break;
                    possible = true;
                    break;
                }
                case 10: {
                    if (this.equipment[10].getItemID() != null || !item.getItemClass().equals("ArmorJewelry_Medal")) break;
                    possible = true;
                    break;
                }
                case 11: {
                    if (this.equipment[11].getItemID() != null || !item.getItemClass().equals("ItemArtifact")) break;
                    possible = true;
                }
            }
        }
        if (x == 1) {
            switch (y) {
                case 0: {
                    if (this.weapon1[0].getItemID() != null) break;
                    if (item.is1HWeapon()) {
                        possible = true;
                    }
                    if (!item.is2HWeapon() || (gdi = this.weapon1[1]) != null && gdi.getItemID() != null) break;
                    possible = true;
                    break;
                }
                case 1: {
                    if (this.weapon1[1].getItemID() != null || !item.is1HWeapon() && !item.isOffhand()) break;
                    gdi = this.weapon1[0];
                    if (gdi == null || gdi.getItemID() == null) {
                        possible = true;
                        break;
                    }
                    if (!gdi.is1HWeapon()) break;
                    possible = true;
                }
            }
        }
        if (x == 2) {
            switch (y) {
                case 0: {
                    if (this.weapon2[0].getItemID() != null) break;
                    if (item.is1HWeapon()) {
                        possible = true;
                    }
                    if (!item.is2HWeapon() || (gdi = this.weapon2[1]) != null && gdi.getItemID() != null) break;
                    possible = true;
                    break;
                }
                case 1: {
                    if (this.weapon2[1].getItemID() != null || !item.is1HWeapon() && !item.isOffhand()) break;
                    gdi = this.weapon2[0];
                    if (gdi == null || gdi.getItemID() == null) {
                        possible = true;
                        break;
                    }
                    if (!gdi.is1HWeapon()) break;
                    possible = true;
                }
            }
        }
        return possible;
    }

    public void read() throws IOException {
        GDItem item;
        int i;
        this.useAlternate = GDReader.readEncByte();
        for (i = 0; i < this.equipment.length; ++i) {
            item = new GDItem(this.gdc.getCharName(), this.gdc.isHardcore(), 5);
            item.read();
            if (item.hasErrors()) {
                this.removedEquipment[i] = item;
                item = new GDItem(this.gdc.getCharName(), this.gdc.isHardcore(), 5);
            } else {
                this.removedEquipment[i] = null;
            }
            this.equipment[i] = item;
        }
        this.alternate1 = GDReader.readEncByte();
        for (i = 0; i < this.weapon1.length; ++i) {
            item = new GDItem(this.gdc.getCharName(), this.gdc.isHardcore(), 5);
            item.read();
            if (item.hasErrors()) {
                this.removedWeapon1[i] = item;
                item = new GDItem(this.gdc.getCharName(), this.gdc.isHardcore(), 5);
            } else {
                this.removedWeapon1[i] = null;
            }
            this.weapon1[i] = item;
        }
        this.alternate2 = GDReader.readEncByte();
        for (i = 0; i < this.weapon2.length; ++i) {
            item = new GDItem(this.gdc.getCharName(), this.gdc.isHardcore(), 5);
            item.read();
            if (item.hasErrors()) {
                this.removedWeapon2[i] = item;
                item = new GDItem(this.gdc.getCharName(), this.gdc.isHardcore(), 5);
            } else {
                this.removedWeapon2[i] = null;
            }
            this.weapon2[i] = item;
        }
        this.changed = false;
    }

    private void mergeRemovedItems() {
        int i;
        for (i = 0; i < this.removedEquipment.length; ++i) {
            if (this.removedEquipment[i] == null) continue;
            this.equipment[i] = this.removedEquipment[i];
        }
        for (i = 0; i < this.removedWeapon1.length; ++i) {
            if (this.removedWeapon1[i] == null) continue;
            this.weapon1[i] = this.removedWeapon1[i];
        }
        for (i = 0; i < this.removedWeapon2.length; ++i) {
            if (this.removedWeapon2[i] == null) continue;
            this.weapon2[i] = this.removedWeapon2[i];
        }
    }

    public void write() throws IOException {
        int i;
        this.mergeRemovedItems();
        GDWriter.writeByte(this.useAlternate);
        for (i = 0; i < this.equipment.length; ++i) {
            this.equipment[i].write();
        }
        GDWriter.writeByte(this.alternate1);
        for (i = 0; i < this.weapon1.length; ++i) {
            this.weapon1[i].write();
        }
        GDWriter.writeByte(this.alternate2);
        for (i = 0; i < this.weapon2.length; ++i) {
            this.weapon2[i].write();
        }
        this.changed = false;
    }

    public int getByteSize() {
        int i;
        this.mergeRemovedItems();
        int size = 0;
        ++size;
        for (i = 0; i < this.equipment.length; ++i) {
            size += this.equipment[i].getByteSize();
        }
        ++size;
        for (i = 0; i < this.weapon1.length; ++i) {
            size += this.weapon1[i].getByteSize();
        }
        ++size;
        for (i = 0; i < this.weapon2.length; ++i) {
            size += this.weapon2[i].getByteSize();
        }
        return size;
    }
}

