/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.character;

import java.io.IOException;
import org.gdstash.file.GDReader;
import org.gdstash.file.GDWriter;

public class GDCharHeader {
    private String charName;
    private byte sex;
    private String classID;
    private int level;
    private byte hardcore;
    private boolean changed;

    public String getCharName() {
        return this.charName;
    }

    public byte getSex() {
        return this.sex;
    }

    public int getLevel() {
        return this.level;
    }

    public boolean isHardcore() {
        return this.hardcore == 1;
    }

    public boolean hasChanged() {
        return this.changed;
    }

    public void setCharName(String charName) {
        this.charName = charName;
        this.changed = true;
    }

    public void setSex(byte sex) {
        this.sex = sex == 0 ? (byte)0 : 1;
        this.changed = true;
    }

    public void setLevel(int level) {
        this.level = level;
        this.changed = true;
    }

    public void setHardcore(boolean hardcore) {
        this.hardcore = hardcore ? (byte)1 : 0;
        this.changed = true;
    }

    public void read() throws IOException {
        this.charName = GDReader.readEncWideString();
        this.sex = GDReader.readEncByte();
        this.classID = GDReader.readEncString();
        this.level = GDReader.readEncInt(true);
        this.hardcore = GDReader.readEncByte();
        this.changed = false;
    }

    public void write() throws IOException {
        GDWriter.writeWideString(this.charName);
        GDWriter.writeByte(this.sex);
        GDWriter.writeString(this.classID);
        GDWriter.writeInt(this.level);
        GDWriter.writeByte(this.hardcore);
        this.changed = false;
    }

    public int getByteSize() {
        int size = 0;
        size += 4;
        if (this.charName != null) {
            size += this.charName.length() * 2;
        }
        ++size;
        size += 4;
        if (this.classID != null) {
            size += this.classID.length();
        }
        size += 4;
        return ++size;
    }
}

