/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.character;

import java.io.IOException;
import org.gdstash.file.GDReader;
import org.gdstash.file.GDWriter;
import org.gdstash.util.GDMsgFormatter;

public class GDCharInfo {
    private static final int VERSION_3 = 3;
    private static final int VERSION_4 = 4;
    private static final int BLOCK = 1;
    private int version;
    private byte isInMainQuest;
    private byte hasBeenInGame;
    private byte difficulty;
    private byte greatestCampaignDifficulty;
    private int money;
    private byte greatestCrucibleDifficulty;
    private int tributes;
    private byte compassState;
    private int lootMode;
    private byte skillWindowHelp;
    private byte alternateConfig;
    private byte alternateConfigEnabled;
    private String texture;
    private boolean changed;

    public boolean isInMainQuest() {
        return this.isInMainQuest == 1;
    }

    public byte getGreatestCampaignDifficulty() {
        return this.greatestCampaignDifficulty;
    }

    public int getMoney() {
        return this.money;
    }

    public boolean hasChanged() {
        return this.changed;
    }

    public void setInMainQuest(boolean isInMainQuest) {
        this.isInMainQuest = isInMainQuest ? (byte)1 : 0;
    }

    public void setGreatestCampaignDifficulty(byte greatestCampaignDifficulty) {
        this.greatestCampaignDifficulty = greatestCampaignDifficulty;
        if (greatestCampaignDifficulty < 0) {
            this.greatestCampaignDifficulty = 0;
        }
        if (greatestCampaignDifficulty > 2) {
            this.greatestCampaignDifficulty = (byte)2;
        }
        this.changed = true;
    }

    public void setMoney(int money) {
        this.money = money;
        this.changed = true;
    }

    public void read() throws IOException {
        int val = 0;
        GDReader.Block block = new GDReader.Block();
        val = GDReader.readBlockStart(block);
        if (val != 1) {
            throw new IOException(GDMsgFormatter.getString(GDMsgFormatter.rbMsg, "ERR_UNSUPPORTED_VERSION"));
        }
        this.version = GDReader.readEncInt(true);
        if (this.version != 3 && this.version != 4) {
            throw new IOException(GDMsgFormatter.getString(GDMsgFormatter.rbMsg, "ERR_UNSUPPORTED_VERSION"));
        }
        this.isInMainQuest = GDReader.readEncByte();
        this.hasBeenInGame = GDReader.readEncByte();
        this.difficulty = GDReader.readEncByte();
        this.greatestCampaignDifficulty = GDReader.readEncByte();
        this.money = GDReader.readEncInt(true);
        if (this.version == 4) {
            this.greatestCrucibleDifficulty = GDReader.readEncByte();
            this.tributes = GDReader.readEncInt(true);
        }
        this.compassState = GDReader.readEncByte();
        this.lootMode = GDReader.readEncInt(true);
        this.skillWindowHelp = GDReader.readEncByte();
        this.alternateConfig = GDReader.readEncByte();
        this.alternateConfigEnabled = GDReader.readEncByte();
        this.texture = GDReader.readEncString();
        GDReader.readBlockEnd(block);
        this.changed = false;
    }

    public void write() throws IOException {
        GDReader.Block block = new GDReader.Block();
        GDWriter.writeBlockStart(block, 1);
        GDWriter.writeInt(this.version);
        GDWriter.writeByte(this.isInMainQuest);
        GDWriter.writeByte(this.hasBeenInGame);
        GDWriter.writeByte(this.difficulty);
        GDWriter.writeByte(this.greatestCampaignDifficulty);
        GDWriter.writeInt(this.money);
        if (this.version == 4) {
            GDWriter.writeByte(this.greatestCrucibleDifficulty);
            GDWriter.writeInt(this.tributes);
        }
        GDWriter.writeByte(this.compassState);
        GDWriter.writeInt(this.lootMode);
        GDWriter.writeByte(this.skillWindowHelp);
        GDWriter.writeByte(this.alternateConfig);
        GDWriter.writeByte(this.alternateConfigEnabled);
        GDWriter.writeString(this.texture);
        GDWriter.writeBlockEnd(block);
        this.changed = false;
    }

    public int getByteSize() {
        int size = 0;
        size += 4;
        size += 4;
        size += 4;
        ++size;
        ++size;
        ++size;
        ++size;
        size += 4;
        if (this.version == 4) {
            ++size;
            size += 4;
        }
        ++size;
        size += 4;
        ++size;
        ++size;
        ++size;
        size += 4;
        if (this.texture != null) {
            size += this.texture.length();
        }
        return size += 4;
    }
}

