/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.character;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.gdstash.character.GDChar;
import org.gdstash.character.GDCharEquippedContainer;
import org.gdstash.character.GDCharInventorySack;
import org.gdstash.file.GDReader;
import org.gdstash.file.GDWriter;
import org.gdstash.item.GDItem;
import org.gdstash.util.GDMsgFormatter;

public class GDCharInventory {
    public static final int EQUIPPOS_HEAD = 0;
    public static final int EQUIPPOS_AMULET = 1;
    public static final int EQUIPPOS_CHEST = 2;
    public static final int EQUIPPOS_LEGS = 3;
    public static final int EQUIPPOS_FEET = 4;
    public static final int EQUIPPOS_HANDS = 5;
    public static final int EQUIPPOS_RING_LEFT = 6;
    public static final int EQUIPPOS_RING_RIGHT = 7;
    public static final int EQUIPPOS_BELT = 8;
    public static final int EQUIPPOS_SHOULDERS = 9;
    public static final int EQUIPPOS_MEDAL = 10;
    public static final int EQUIPPOS_ARTIFACT = 11;
    public static final int EQUIPPOS_MAINHAND = 0;
    public static final int EQUIPPOS_OFFHAND = 1;
    private static final int VERSION = 4;
    private static final int BLOCK = 3;
    private int version;
    private List<GDCharInventorySack> sacks = new LinkedList<GDCharInventorySack>();
    private GDCharEquippedContainer equipment;
    private int focused;
    private int selected;
    private byte flag;
    private GDChar gdc;

    public GDCharInventory(GDChar gdc) {
        this.equipment = new GDCharEquippedContainer(gdc);
        this.gdc = gdc;
    }

    public GDCharInventorySack getInventory() {
        Iterator<GDCharInventorySack> iter;
        GDCharInventorySack sack = null;
        if (this.sacks != null && (iter = this.sacks.iterator()).hasNext()) {
            sack = iter.next();
        }
        return sack;
    }

    public List<GDCharInventorySack> getBags() {
        LinkedList<GDCharInventorySack> list = new LinkedList<GDCharInventorySack>();
        if (this.sacks != null) {
            int i = 0;
            for (GDCharInventorySack sack : this.sacks) {
                if (i > 0) {
                    list.add(sack);
                }
                ++i;
            }
        }
        return list;
    }

    public GDCharEquippedContainer getEquipment() {
        return this.equipment;
    }

    public List<GDItem> getItems() {
        LinkedList<GDItem> list = new LinkedList<GDItem>();
        for (GDCharInventorySack sack : this.sacks) {
            list.addAll(sack.getItemList());
        }
        list.addAll(this.equipment.getItemList());
        return list;
    }

    public boolean hasChanged() {
        boolean hasChanged = false;
        if (this.sacks != null) {
            for (GDCharInventorySack sack : this.sacks) {
                hasChanged = hasChanged || sack.hasChanged();
            }
        }
        hasChanged = hasChanged || this.equipment.hasChanged();
        return hasChanged;
    }

    public void read() throws IOException {
        int val = 0;
        GDReader.Block block = new GDReader.Block();
        val = GDReader.readBlockStart(block);
        if (val != 3) {
            throw new IOException(GDMsgFormatter.getString(GDMsgFormatter.rbMsg, "ERR_UNSUPPORTED_VERSION"));
        }
        this.version = GDReader.readEncInt(true);
        if (this.version != 4) {
            throw new IOException(GDMsgFormatter.getString(GDMsgFormatter.rbMsg, "ERR_UNSUPPORTED_VERSION"));
        }
        this.flag = GDReader.readEncByte();
        if (this.flag != 0) {
            int numSacks = GDReader.readEncInt(true);
            this.focused = GDReader.readEncInt(true);
            this.selected = GDReader.readEncInt(true);
            this.sacks.clear();
            for (int i = 0; i < numSacks; ++i) {
                GDCharInventorySack sack = new GDCharInventorySack(this.gdc, i);
                sack.read();
                this.sacks.add(sack);
            }
            this.equipment.read();
        }
        GDReader.readBlockEnd(block);
    }

    public void write() throws IOException {
        GDReader.Block block = new GDReader.Block();
        GDWriter.writeBlockStart(block, 3);
        GDWriter.writeInt(4);
        GDWriter.writeByte(this.flag);
        if (this.flag != 0) {
            int numSacks = this.sacks.size();
            GDWriter.writeInt(numSacks);
            GDWriter.writeInt(this.focused);
            GDWriter.writeInt(this.selected);
            for (GDCharInventorySack sack : this.sacks) {
                sack.write();
            }
            this.equipment.write();
        }
        GDWriter.writeBlockEnd(block);
    }

    public int getByteSize() {
        int size = 0;
        size += 4;
        size += 4;
        size += 4;
        ++size;
        if (this.flag != 0) {
            size += 4;
            size += 4;
            size += 4;
            for (GDCharInventorySack sack : this.sacks) {
                size += sack.getByteSize();
            }
            size += this.equipment.getByteSize();
        }
        return size += 4;
    }
}

