/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.character;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.gdstash.character.GDChar;
import org.gdstash.character.GDCharUID;
import org.gdstash.file.GDReader;
import org.gdstash.file.GDWriter;
import org.gdstash.util.GDMsgFormatter;

public class GDCharMarkerList {
    private static final int VERSION = 1;
    private static final int BLOCK = 7;
    private int version;
    private List<GDCharUID>[] uidLists = new List[3];

    public void read() throws IOException {
        int val = 0;
        GDReader.Block block = new GDReader.Block();
        val = GDReader.readBlockStart(block);
        if (val != 7) {
            throw new IOException(GDMsgFormatter.getString(GDMsgFormatter.rbMsg, "ERR_UNSUPPORTED_VERSION"));
        }
        this.version = GDReader.readEncInt(true);
        if (this.version != 1) {
            throw new IOException(GDMsgFormatter.getString(GDMsgFormatter.rbMsg, "ERR_UNSUPPORTED_VERSION"));
        }
        for (int i = 0; i < this.uidLists.length; ++i) {
            this.uidLists[i] = new LinkedList<GDCharUID>();
            GDChar.readUIDList(this.uidLists[i]);
        }
        GDReader.readBlockEnd(block);
    }

    public void write() throws IOException {
        GDReader.Block block = new GDReader.Block();
        GDWriter.writeBlockStart(block, 7);
        GDWriter.writeInt(1);
        for (int i = 0; i < this.uidLists.length; ++i) {
            GDChar.writeUIDList(this.uidLists[i]);
        }
        GDWriter.writeBlockEnd(block);
    }

    public int getByteSize() {
        int size = 0;
        size += 4;
        size += 4;
        size += 4;
        for (int i = 0; i < this.uidLists.length; ++i) {
            size += 4;
            size += this.uidLists[i].size() * GDCharUID.getByteSize();
        }
        return size += 4;
    }

    public void print() {
        for (int i = 0; i < this.uidLists.length; ++i) {
            System.out.println("Index : " + Integer.toString(i));
            for (GDCharUID uid : this.uidLists[i]) {
                uid.println();
            }
            System.out.println();
        }
    }
}

