/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.character;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.gdstash.file.GDReader;
import org.gdstash.file.GDWriter;
import org.gdstash.util.GDMsgFormatter;

public class GDCharNoteList {
    private static final int VERSION = 1;
    private static final int BLOCK = 12;
    private int version;
    private List<String> notes = new LinkedList<String>();

    public void read() throws IOException {
        int val = 0;
        GDReader.Block block = new GDReader.Block();
        val = GDReader.readBlockStart(block);
        if (val != 12) {
            throw new IOException(GDMsgFormatter.getString(GDMsgFormatter.rbMsg, "ERR_UNSUPPORTED_VERSION"));
        }
        this.version = GDReader.readEncInt(true);
        if (this.version != 1) {
            throw new IOException(GDMsgFormatter.getString(GDMsgFormatter.rbMsg, "ERR_UNSUPPORTED_VERSION"));
        }
        this.notes.clear();
        val = GDReader.readEncInt(true);
        for (int i = 0; i < val; ++i) {
            String note = GDReader.readEncString();
            this.notes.add(note);
        }
        GDReader.readBlockEnd(block);
    }

    public void write() throws IOException {
        GDReader.Block block = new GDReader.Block();
        GDWriter.writeBlockStart(block, 12);
        GDWriter.writeInt(this.version);
        int val = this.notes.size();
        GDWriter.writeInt(val);
        for (String note : this.notes) {
            GDWriter.writeString(note);
        }
        GDWriter.writeBlockEnd(block);
    }

    public int getByteSize() {
        int size = 0;
        size += 4;
        size += 4;
        size += 4;
        size += 4;
        for (String note : this.notes) {
            size += 4;
            if (note == null) continue;
            size += note.length();
        }
        return size += 4;
    }
}

