/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.character;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.gdstash.character.GDChar;
import org.gdstash.character.GDCharUID;
import org.gdstash.file.GDReader;
import org.gdstash.file.GDWriter;
import org.gdstash.util.GDMsgFormatter;

public class GDCharRespawnList {
    private static final byte[] RESPAWN_DEVILS_CROSSING = new byte[]{110, -113, 45, 112, -107, 79, 56, 103, 93, 21, 75, -98, 88, 4, 108, 6};
    private static final byte[] RESPAWN_HOMESTEAD = new byte[]{-121, 64, 3, 63, -43, 76, -62, 58, -20, 76, -104, -69, 28, -65, -111, -115};
    private static final byte[] RESPAWN_FORT_IKON = new byte[]{-128, 79, -90, 79, 36, 79, 46, -40, -91, -68, 58, -87, 124, 114, 33, -26};
    public static final GDCharUID UID_SPAWN_DEVILS_CROSSING = new GDCharUID(RESPAWN_DEVILS_CROSSING);
    public static final GDCharUID UID_SPAWN_HOMESTEAD = new GDCharUID(RESPAWN_HOMESTEAD);
    public static final GDCharUID UID_SPAWN_FORT_IKON = new GDCharUID(RESPAWN_FORT_IKON);
    private static final int VERSION = 1;
    private static final int BLOCK = 5;
    private int version;
    private List<GDCharUID>[] uidLists = new List[3];
    private GDCharUID[] spawns = new GDCharUID[3];
    private boolean changed;

    public GDCharUID getRespawnPoint(int difficulty) {
        GDCharUID spawn = null;
        if (difficulty < 0 || difficulty > 2) {
            return spawn;
        }
        return this.spawns[difficulty];
    }

    public boolean hasChanged() {
        return this.changed;
    }

    public void setRespawnPoint(int difficulty, GDCharUID spawn) {
        if (difficulty < 0 || difficulty > 2) {
            return;
        }
        this.spawns[difficulty] = spawn;
        this.changed = true;
    }

    public void read() throws IOException {
        int i;
        int val = 0;
        GDReader.Block block = new GDReader.Block();
        val = GDReader.readBlockStart(block);
        if (val != 5) {
            throw new IOException(GDMsgFormatter.getString(GDMsgFormatter.rbMsg, "ERR_UNSUPPORTED_VERSION"));
        }
        this.version = GDReader.readEncInt(true);
        if (this.version != 1) {
            throw new IOException(GDMsgFormatter.getString(GDMsgFormatter.rbMsg, "ERR_UNSUPPORTED_VERSION"));
        }
        for (i = 0; i < this.uidLists.length; ++i) {
            this.uidLists[i] = new LinkedList<GDCharUID>();
            GDChar.readUIDList(this.uidLists[i]);
        }
        for (i = 0; i < this.spawns.length; ++i) {
            GDCharUID uid = new GDCharUID();
            uid.read();
            this.spawns[i] = uid;
        }
        GDReader.readBlockEnd(block);
        this.changed = false;
    }

    public void write() throws IOException {
        int i;
        GDReader.Block block = new GDReader.Block();
        GDWriter.writeBlockStart(block, 5);
        GDWriter.writeInt(this.version);
        for (i = 0; i < this.uidLists.length; ++i) {
            GDChar.writeUIDList(this.uidLists[i]);
        }
        for (i = 0; i < this.spawns.length; ++i) {
            this.spawns[i].write();
        }
        GDWriter.writeBlockEnd(block);
        this.changed = false;
    }

    public int getByteSize() {
        int size = 0;
        size += 4;
        size += 4;
        size += 4;
        for (int i = 0; i < this.uidLists.length; ++i) {
            size += 4;
            size += this.uidLists[i].size() * GDCharUID.getByteSize();
        }
        size += this.spawns.length * GDCharUID.getByteSize();
        return size += 4;
    }

    public void print() {
        int i;
        for (i = 0; i < this.uidLists.length; ++i) {
            System.out.println("Index : " + Integer.toString(i));
            String s = "";
            for (GDCharUID uid : this.uidLists[i]) {
                uid.println();
            }
            System.out.println();
        }
        for (i = 0; i < this.spawns.length; ++i) {
            System.out.println("Spawn : " + Integer.toString(i));
            this.spawns[i].println();
        }
    }
}

