/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.character;

import java.io.IOException;
import org.gdstash.character.GDChar;
import org.gdstash.file.GDReader;
import org.gdstash.file.GDWriter;
import org.gdstash.item.GDAbstractContainer;
import org.gdstash.item.GDItem;
import org.gdstash.util.GDMsgFormatter;

public class GDCharStash
extends GDAbstractContainer {
    private static final int VERSION = 5;
    private static final int BLOCK = 4;
    private int version;
    protected boolean changed;
    private GDChar gdc;

    public GDCharStash(GDChar gdc) {
        super(2);
        this.gdc = gdc;
        this.changed = false;
    }

    public int getHeight() {
        int h = this.height;
        for (GDItem item : this.items) {
            int y = item.getY() + item.getImage().getHeight() / 32;
            if (h >= y) continue;
            h = y;
        }
        return h;
    }

    public int getWidth() {
        int w = this.width;
        for (GDItem item : this.items) {
            int x = item.getX() + item.getImage().getWidth() / 32;
            if (w >= x) continue;
            w = x;
        }
        return w;
    }

    public void read() throws IOException {
        int val = 0;
        GDReader.Block block = new GDReader.Block();
        val = GDReader.readBlockStart(block);
        if (val != 4) {
            throw new IOException(GDMsgFormatter.getString(GDMsgFormatter.rbMsg, "ERR_UNSUPPORTED_VERSION"));
        }
        this.version = GDReader.readEncInt(true);
        if (this.version != 5) {
            throw new IOException(GDMsgFormatter.getString(GDMsgFormatter.rbMsg, "ERR_UNSUPPORTED_VERSION"));
        }
        this.width = GDReader.readEncInt(true);
        this.height = GDReader.readEncInt(true);
        this.items.clear();
        this.removedItems.clear();
        val = GDReader.readEncInt(true);
        for (int i = 0; i < val; ++i) {
            GDItem item = new GDItem(this.gdc.getCharName(), this.gdc.isHardcore(), 2);
            item.read();
            if (!item.hasErrors()) {
                this.items.add(item);
                continue;
            }
            this.removedItems.add(item);
        }
        GDReader.readBlockEnd(block);
        this.changed = false;
    }

    public void write() throws IOException {
        GDReader.Block block = new GDReader.Block();
        GDWriter.writeBlockStart(block, 4);
        GDWriter.writeInt(this.version);
        GDWriter.writeInt(this.width);
        GDWriter.writeInt(this.height);
        int val = this.items.size() + this.removedItems.size();
        GDWriter.writeInt(val);
        for (GDItem item : this.items) {
            item.write();
        }
        for (GDItem item : this.removedItems) {
            item.write();
        }
        GDWriter.writeBlockEnd(block);
        this.changed = false;
    }

    public int getByteSize() {
        int size = 0;
        size += 4;
        size += 4;
        size += 4;
        size += 4;
        size += 4;
        size += 4;
        for (GDItem item : this.items) {
            size += item.getByteSize();
        }
        for (GDItem item : this.removedItems) {
            size += item.getByteSize();
        }
        return size += 4;
    }
}

