/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.character;

import java.io.IOException;
import org.gdstash.file.GDReader;
import org.gdstash.file.GDWriter;
import org.gdstash.util.GDMsgFormatter;

public class GDCharStats {
    private static final int VERSION_7 = 7;
    private static final int VERSION_9 = 9;
    private static final int BLOCK = 16;
    private int version;
    private int playTime = 0;
    private int deaths = 0;
    private int kills = 0;
    private int experienceFromKills = 0;
    private int healthPotionsUsed = 0;
    private int manaPotionsUsed = 0;
    private int maxLevel = 0;
    private int hitsReceived = 0;
    private int hitsInflicted = 0;
    private int criticalHitsInflicted = 0;
    private int criticalHitsReceived = 0;
    private float greatestDamageInflicted = 0.0f;
    private StatsPerDifficulty[] statsDifficulty = new StatsPerDifficulty[3];
    private int championKills;
    private float lastHit;
    private float lastHitBy;
    private float greatestDamageReceived;
    private int heroKills;
    private int itemsCrafted;
    private int relicsCrafted;
    private int transcendentRelicsCrafted;
    private int mythicalRelicsCrafted;
    private int shrinesRestored;
    private int oneShotChestsOpened;
    private int loreNotesCollected;
    private int survivalGreatestWave;
    private int survivalGreatestScore;
    private int survivalDefensesBuilt;
    private int survivalPowerUpsActivated;
    private int unknown1;
    private int unknown2;
    private boolean changed;

    public GDCharStats() {
        for (int i = 0; i < this.statsDifficulty.length; ++i) {
            this.statsDifficulty[i] = new StatsPerDifficulty();
        }
        this.championKills = 0;
        this.lastHit = 0.0f;
        this.lastHitBy = 0.0f;
        this.greatestDamageReceived = 0.0f;
        this.heroKills = 0;
        this.itemsCrafted = 0;
        this.relicsCrafted = 0;
        this.transcendentRelicsCrafted = 0;
        this.mythicalRelicsCrafted = 0;
        this.shrinesRestored = 0;
        this.oneShotChestsOpened = 0;
        this.loreNotesCollected = 0;
        this.survivalGreatestWave = 0;
        this.survivalGreatestScore = 0;
        this.survivalDefensesBuilt = 0;
        this.survivalPowerUpsActivated = 0;
        this.unknown1 = 0;
        this.unknown2 = 0;
    }

    public int getDeaths() {
        return this.deaths;
    }

    public boolean hasChanged() {
        return this.changed;
    }

    public void setDeaths(int deaths) {
        this.deaths = deaths;
        this.changed = true;
    }

    public void setShrinesRestored(int shrinesRestored) {
        this.shrinesRestored = shrinesRestored;
        this.changed = true;
    }

    public void read() throws IOException {
        int i;
        int val = 0;
        GDReader.Block block = new GDReader.Block();
        val = GDReader.readBlockStart(block);
        if (val != 16) {
            throw new IOException(GDMsgFormatter.getString(GDMsgFormatter.rbMsg, "ERR_UNSUPPORTED_VERSION"));
        }
        this.version = GDReader.readEncInt(true);
        if (this.version != 7 && this.version != 9) {
            throw new IOException(GDMsgFormatter.getString(GDMsgFormatter.rbMsg, "ERR_UNSUPPORTED_VERSION"));
        }
        this.playTime = GDReader.readEncInt(true);
        this.deaths = GDReader.readEncInt(true);
        this.kills = GDReader.readEncInt(true);
        this.experienceFromKills = GDReader.readEncInt(true);
        this.healthPotionsUsed = GDReader.readEncInt(true);
        this.manaPotionsUsed = GDReader.readEncInt(true);
        this.maxLevel = GDReader.readEncInt(true);
        this.hitsReceived = GDReader.readEncInt(true);
        this.hitsInflicted = GDReader.readEncInt(true);
        this.criticalHitsInflicted = GDReader.readEncInt(true);
        this.criticalHitsReceived = GDReader.readEncInt(true);
        this.greatestDamageInflicted = GDReader.readEncFloat(true);
        for (i = 0; i < this.statsDifficulty.length; ++i) {
            this.statsDifficulty[i].greatestMonsterKilledName = GDReader.readEncString();
            this.statsDifficulty[i].greatestMonsterKilledLevel = GDReader.readEncInt(true);
            this.statsDifficulty[i].greatestMonsterKilledLifeAndMana = GDReader.readEncInt(true);
            this.statsDifficulty[i].lastMonsterHit = GDReader.readEncString();
            this.statsDifficulty[i].lastMonsterHitBy = GDReader.readEncString();
        }
        this.championKills = GDReader.readEncInt(true);
        this.lastHit = GDReader.readEncFloat(true);
        this.lastHitBy = GDReader.readEncFloat(true);
        this.greatestDamageReceived = GDReader.readEncFloat(true);
        this.heroKills = GDReader.readEncInt(true);
        this.itemsCrafted = GDReader.readEncInt(true);
        this.relicsCrafted = GDReader.readEncInt(true);
        this.transcendentRelicsCrafted = GDReader.readEncInt(true);
        this.mythicalRelicsCrafted = GDReader.readEncInt(true);
        this.shrinesRestored = GDReader.readEncInt(true);
        this.oneShotChestsOpened = GDReader.readEncInt(true);
        this.loreNotesCollected = GDReader.readEncInt(true);
        for (i = 0; i < this.statsDifficulty.length; ++i) {
            this.statsDifficulty[i].nemesisKills = GDReader.readEncInt(true);
        }
        if (this.version == 9) {
            this.survivalGreatestWave = GDReader.readEncInt(true);
            this.survivalGreatestScore = GDReader.readEncInt(true);
            this.survivalDefensesBuilt = GDReader.readEncInt(true);
            this.survivalPowerUpsActivated = GDReader.readEncInt(true);
        }
        this.unknown1 = GDReader.readEncInt(true);
        this.unknown2 = GDReader.readEncInt(true);
        GDReader.readBlockEnd(block);
        this.changed = false;
    }

    public void write() throws IOException {
        int i;
        GDReader.Block block = new GDReader.Block();
        GDWriter.writeBlockStart(block, 16);
        GDWriter.writeInt(this.version);
        GDWriter.writeInt(this.playTime);
        GDWriter.writeInt(this.deaths);
        GDWriter.writeInt(this.kills);
        GDWriter.writeInt(this.experienceFromKills);
        GDWriter.writeInt(this.healthPotionsUsed);
        GDWriter.writeInt(this.manaPotionsUsed);
        GDWriter.writeInt(this.maxLevel);
        GDWriter.writeInt(this.hitsReceived);
        GDWriter.writeInt(this.hitsInflicted);
        GDWriter.writeInt(this.criticalHitsInflicted);
        GDWriter.writeInt(this.criticalHitsReceived);
        GDWriter.writeFloat(this.greatestDamageInflicted);
        for (i = 0; i < this.statsDifficulty.length; ++i) {
            GDWriter.writeString(this.statsDifficulty[i].greatestMonsterKilledName);
            GDWriter.writeInt(this.statsDifficulty[i].greatestMonsterKilledLevel);
            GDWriter.writeInt(this.statsDifficulty[i].greatestMonsterKilledLifeAndMana);
            GDWriter.writeString(this.statsDifficulty[i].lastMonsterHit);
            GDWriter.writeString(this.statsDifficulty[i].lastMonsterHitBy);
        }
        GDWriter.writeInt(this.championKills);
        GDWriter.writeFloat(this.lastHit);
        GDWriter.writeFloat(this.lastHitBy);
        GDWriter.writeFloat(this.greatestDamageReceived);
        GDWriter.writeInt(this.heroKills);
        GDWriter.writeInt(this.itemsCrafted);
        GDWriter.writeInt(this.relicsCrafted);
        GDWriter.writeInt(this.transcendentRelicsCrafted);
        GDWriter.writeInt(this.mythicalRelicsCrafted);
        GDWriter.writeInt(this.shrinesRestored);
        GDWriter.writeInt(this.oneShotChestsOpened);
        GDWriter.writeInt(this.loreNotesCollected);
        for (i = 0; i < this.statsDifficulty.length; ++i) {
            GDWriter.writeInt(this.statsDifficulty[i].nemesisKills);
        }
        if (this.version == 9) {
            GDWriter.writeInt(this.survivalGreatestWave);
            GDWriter.writeInt(this.survivalGreatestScore);
            GDWriter.writeInt(this.survivalDefensesBuilt);
            GDWriter.writeInt(this.survivalPowerUpsActivated);
        }
        GDWriter.writeInt(this.unknown1);
        GDWriter.writeInt(this.unknown2);
        GDWriter.writeBlockEnd(block);
        this.changed = false;
    }

    public int getByteSize() {
        int size = 0;
        boolean val = false;
        size += 4;
        size += 4;
        size += 4;
        size += 4;
        size += 4;
        size += 4;
        size += 4;
        size += 4;
        size += 4;
        size += 4;
        size += 4;
        size += 4;
        size += 4;
        size += 4;
        size += 4;
        for (int i = 0; i < this.statsDifficulty.length; ++i) {
            size += 4;
            if (this.statsDifficulty[i].greatestMonsterKilledName != null) {
                size += this.statsDifficulty[i].greatestMonsterKilledName.length();
            }
            size += 4;
            size += 4;
            size += 4;
            if (this.statsDifficulty[i].lastMonsterHit != null) {
                size += this.statsDifficulty[i].lastMonsterHit.length();
            }
            size += 4;
            if (this.statsDifficulty[i].lastMonsterHitBy == null) continue;
            size += this.statsDifficulty[i].lastMonsterHitBy.length();
        }
        size += 4;
        size += 4;
        size += 4;
        size += 4;
        size += 4;
        size += 4;
        size += 4;
        size += 4;
        size += 4;
        size += 4;
        size += 4;
        size += 4;
        size += 4 * this.statsDifficulty.length;
        if (this.version == 9) {
            size += 4;
            size += 4;
            size += 4;
            size += 4;
        }
        size += 4;
        size += 4;
        return size += 4;
    }

    private static class StatsPerDifficulty {
        private String greatestMonsterKilledName;
        private int greatestMonsterKilledLevel;
        private int greatestMonsterKilledLifeAndMana;
        private String lastMonsterHit;
        private String lastMonsterHitBy;
        private int nemesisKills;

        private StatsPerDifficulty() {
        }
    }
}

