/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.character;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.gdstash.character.GDChar;
import org.gdstash.character.GDCharUID;
import org.gdstash.file.GDReader;
import org.gdstash.file.GDWriter;
import org.gdstash.util.GDMsgFormatter;

public class GDCharTeleportList {
    private static final byte[] RIFTGATE_01_DEVILS_CROSSING = new byte[]{-73, 127, 11, -128, 41, 79, -108, -10, 80, 105, -9, -73, -41, 108, -25, 83};
    private static final byte[] RIFTGATE_01_LOWER_CROSSING = new byte[]{37, 51, -100, -49, -33, 66, -113, 56, -86, -2, -24, -100, 16, -26, -111, 63};
    private static final byte[] RIFTGATE_01_WIGHTMIRE = new byte[]{-13, -19, 78, 35, -40, 79, -103, 113, 65, -93, -125, -123, -102, 38, -62, 82};
    private static final byte[] RIFTGATE_01_FOGGY_BANK = new byte[]{88, 48, 20, -29, 54, 68, -5, -14, 105, 2, -65, -102, -63, -117, -123, -18};
    private static final byte[] RIFTGATE_01_FLOODED_PASSAGE = new byte[]{46, 69, -87, -24, 60, 70, -125, 6, 23, 43, 40, -121, -94, 4, -19, -67};
    private static final byte[] RIFTGATE_01_BURRWITCH_OUTSKIRTS = new byte[]{59, 104, 21, -5, 28, 73, -91, -126, -93, -38, 35, -66, 72, -57, 105, -128};
    private static final byte[] RIFTGATE_01_BURRWITCH_VILLAGE = new byte[]{-36, -37, 64, 110, 94, 68, -66, -54, 71, 90, -92, -103, 5, 28, -42, -91};
    private static final byte[] RIFTGATE_01_WARDENS_CELLAR = new byte[]{-99, 46, -79, -109, 90, 74, -74, 58, -8, 43, -56, -83, -81, 81, -120, 46};
    private static final byte[] RIFTGATE_01_UNDERGROUND_TRANSIT = new byte[]{-127, -73, 112, -94, -17, 65, 124, -81, -52, 60, -91, -89, 73, -3, 71, 31};
    private static final byte[] RIFTGATE_01_WARDENS_LABORATORY = new byte[]{-62, -125, 9, -98, -104, 73, 121, -2, 10, 49, -75, -119, 107, -24, 2, 12};
    private static final byte[] RIFTGATE_02_ARKOVIAN_FOOTHILLS = new byte[]{10, -22, -72, 54, 51, 77, 80, 120, -70, 12, -124, -94, -28, -95, 7, 64};
    private static final byte[] RIFTGATE_02_OLD_ARKOVIA = new byte[]{-64, -6, -112, -77, 45, 67, 94, 114, 39, -65, -76, -125, 58, 73, 109, 32};
    private static final byte[] RIFTGATE_02_CRONLEYS_HIDEOUT = new byte[]{110, 114, -67, -69, -102, 72, 44, -84, 94, 49, 62, -80, 94, 85, -83, 16};
    private static final byte[] RIFTGATE_02_TWIN_FALLS = new byte[]{107, -71, -120, -46, -92, 78, 37, 120, 97, -44, 29, -128, -107, 69, 34, 6};
    private static final byte[] RIFTGATE_02_BROKEN_HILLS = new byte[]{-97, -79, 6, 41, -106, 68, 99, -31, 4, 72, -67, -99, 71, 115, -62, 100};
    private static final byte[] RIFTGATE_02_SMUGGLERS_PASS = new byte[]{32, 53, 77, -34, 50, 72, 44, 121, -22, -85, -78, -73, -81, 96, -74, -16};
    private static final byte[] RIFTGATE_03_DEADMANS_GULCH = new byte[]{-14, -31, -39, -62, -23, 68, -63, 114, 113, -101, -110, -108, 11, 95, -120, -110};
    private static final byte[] RIFTGATE_03_PROSPECTORS_TRAIL = new byte[]{19, 3, 65, 61, -24, 78, -85, -111, 52, -46, -59, -127, -55, 71, -30, 26};
    private static final byte[] RIFTGATE_03_PINE_BARRENS = new byte[]{86, -88, 102, 123, 48, 77, 127, 84, -46, -66, 110, -95, 114, 51, -29, -42};
    private static final byte[] RIFTGATE_03_HOMESTEAD = new byte[]{-9, 24, -59, -22, 107, 76, -34, 41, 77, -59, -110, -122, -52, 64, 40, -28};
    private static final byte[] RIFTGATE_03_ROTTING_CROPLANDS = new byte[]{100, 101, -27, 60, -68, 75, 37, -54, -111, 79, 86, -100, 47, 49, -85, 116};
    private static final byte[] RIFTGATE_03_SORROWS_BASTION = new byte[]{-36, 28, 70, 46, -14, 74, 121, -117, -19, -83, -35, -68, -63, -64, -3, 9};
    private static final byte[] RIFTGATE_03_BLOOD_GROVE = new byte[]{-93, 35, 13, -126, 15, 75, -109, 15, -92, -72, 66, -102, -53, -20, 103, -86};
    private static final byte[] RIFTGATE_03_DARKVALE_GATE = new byte[]{-58, -25, -106, 71, 91, 79, -20, -96, -37, 42, -1, -105, 112, 60, 91, -47};
    private static final byte[] RIFTGATE_04_ASTERKARN_MOUNTAINS = new byte[]{-37, 49, -54, -17, 99, 76, 93, -123, 46, -116, 123, -70, 119, -24, 0, 42};
    private static final byte[] RIFTGATE_04_ASTERKARN_ROAD = new byte[]{104, -114, 40, -115, 125, 64, -5, 90, 43, 90, -28, -88, 126, -3, -71, -110};
    private static final byte[] RIFTGATE_04_ASTERKARN_VALLEY = new byte[]{-69, -46, -124, -43, 31, 69, 28, -108, 61, -31, -13, -123, -46, 60, -46, 5};
    private static final byte[] RIFTGATE_04_FORT_IKON = new byte[]{-61, 63, 25, 71, -116, 76, 39, 56, -74, -20, 15, -108, 101, 21, 100, -2};
    private static final byte[] RIFTGATE_04_GATES_OF_NECROPOLIS = new byte[]{100, -58, -44, -52, 21, 64, 93, 9, 27, -64, 5, -127, 10, 13, 30, -30};
    private static final byte[] RIFTGATE_04_NECROPOLIS_INTERIOR = new byte[]{-42, -11, -58, 19, 58, 70, -107, -89, -95, 85, 103, -82, -32, -1, -37, -61};
    public static final GDCharUID UID_RIFT_01_DEVILS_CROSSING = new GDCharUID(RIFTGATE_01_DEVILS_CROSSING);
    public static final GDCharUID UID_RIFT_01_LOWER_CROSSING = new GDCharUID(RIFTGATE_01_LOWER_CROSSING);
    public static final GDCharUID UID_RIFT_01_WIGHTMIRE = new GDCharUID(RIFTGATE_01_WIGHTMIRE);
    public static final GDCharUID UID_RIFT_01_FOGGY_BANK = new GDCharUID(RIFTGATE_01_FOGGY_BANK);
    public static final GDCharUID UID_RIFT_01_FLOODED_PASSAGE = new GDCharUID(RIFTGATE_01_FLOODED_PASSAGE);
    public static final GDCharUID UID_RIFT_01_BURRWITCH_OUTSKIRTS = new GDCharUID(RIFTGATE_01_BURRWITCH_OUTSKIRTS);
    public static final GDCharUID UID_RIFT_01_BURRWITCH_VILLAGE = new GDCharUID(RIFTGATE_01_BURRWITCH_VILLAGE);
    public static final GDCharUID UID_RIFT_01_WARDENS_CELLAR = new GDCharUID(RIFTGATE_01_WARDENS_CELLAR);
    public static final GDCharUID UID_RIFT_01_UNDERGROUND_TRANSIT = new GDCharUID(RIFTGATE_01_UNDERGROUND_TRANSIT);
    public static final GDCharUID UID_RIFT_01_WARDENS_LABORATORY = new GDCharUID(RIFTGATE_01_WARDENS_LABORATORY);
    public static final GDCharUID UID_RIFT_02_ARKOVIAN_FOOTHILLS = new GDCharUID(RIFTGATE_02_ARKOVIAN_FOOTHILLS);
    public static final GDCharUID UID_RIFT_02_OLD_ARKOVIA = new GDCharUID(RIFTGATE_02_OLD_ARKOVIA);
    public static final GDCharUID UID_RIFT_02_CRONLEYS_HIDEOUT = new GDCharUID(RIFTGATE_02_CRONLEYS_HIDEOUT);
    public static final GDCharUID UID_RIFT_02_TWIN_FALLS = new GDCharUID(RIFTGATE_02_TWIN_FALLS);
    public static final GDCharUID UID_RIFT_02_BROKEN_HILLS = new GDCharUID(RIFTGATE_02_BROKEN_HILLS);
    public static final GDCharUID UID_RIFT_02_SMUGGLERS_PASS = new GDCharUID(RIFTGATE_02_SMUGGLERS_PASS);
    public static final GDCharUID UID_RIFT_03_DEADMANS_GULCH = new GDCharUID(RIFTGATE_03_DEADMANS_GULCH);
    public static final GDCharUID UID_RIFT_03_PROSPECTORS_TRAIL = new GDCharUID(RIFTGATE_03_PROSPECTORS_TRAIL);
    public static final GDCharUID UID_RIFT_03_PINE_BARRENS = new GDCharUID(RIFTGATE_03_PINE_BARRENS);
    public static final GDCharUID UID_RIFT_03_HOMESTEAD = new GDCharUID(RIFTGATE_03_HOMESTEAD);
    public static final GDCharUID UID_RIFT_03_ROTTING_CROPLANDS = new GDCharUID(RIFTGATE_03_ROTTING_CROPLANDS);
    public static final GDCharUID UID_RIFT_03_SORROWS_BASTION = new GDCharUID(RIFTGATE_03_SORROWS_BASTION);
    public static final GDCharUID UID_RIFT_03_BLOOD_GROVE = new GDCharUID(RIFTGATE_03_BLOOD_GROVE);
    public static final GDCharUID UID_RIFT_03_DARKVALE_GATE = new GDCharUID(RIFTGATE_03_DARKVALE_GATE);
    public static final GDCharUID UID_RIFT_04_ASTERKARN_MOUNTAINS = new GDCharUID(RIFTGATE_04_ASTERKARN_MOUNTAINS);
    public static final GDCharUID UID_RIFT_04_ASTERKARN_ROAD = new GDCharUID(RIFTGATE_04_ASTERKARN_ROAD);
    public static final GDCharUID UID_RIFT_04_ASTERKARN_VALLEY = new GDCharUID(RIFTGATE_04_ASTERKARN_VALLEY);
    public static final GDCharUID UID_RIFT_04_FORT_IKON = new GDCharUID(RIFTGATE_04_FORT_IKON);
    public static final GDCharUID UID_RIFT_04_GATES_OF_NECROPOLIS = new GDCharUID(RIFTGATE_04_GATES_OF_NECROPOLIS);
    public static final GDCharUID UID_RIFT_04_NECROPOLIS_INTERIOR = new GDCharUID(RIFTGATE_04_NECROPOLIS_INTERIOR);
    private static final int VERSION = 1;
    private static final int BLOCK = 6;
    private int version;
    private List<GDCharUID>[] uidLists = new List[3];
    private boolean changed;

    public List<GDCharUID> getRiftList(int difficulty) {
        LinkedList<GDCharUID> list = new LinkedList<GDCharUID>();
        if (difficulty < 0 || difficulty > 2) {
            return list;
        }
        return this.uidLists[difficulty];
    }

    public boolean hasChanged() {
        return this.changed;
    }

    public void setRiftList(int difficulty, List<GDCharUID> list) {
        if (difficulty < 0 || difficulty > 2) {
            return;
        }
        this.uidLists[difficulty] = list;
        this.changed = true;
    }

    public void read() throws IOException {
        int val = 0;
        GDReader.Block block = new GDReader.Block();
        val = GDReader.readBlockStart(block);
        if (val != 6) {
            throw new IOException(GDMsgFormatter.getString(GDMsgFormatter.rbMsg, "ERR_UNSUPPORTED_VERSION"));
        }
        this.version = GDReader.readEncInt(true);
        if (this.version != 1) {
            throw new IOException(GDMsgFormatter.getString(GDMsgFormatter.rbMsg, "ERR_UNSUPPORTED_VERSION"));
        }
        for (int i = 0; i < this.uidLists.length; ++i) {
            this.uidLists[i] = new LinkedList<GDCharUID>();
            GDChar.readUIDList(this.uidLists[i]);
        }
        GDReader.readBlockEnd(block);
        this.changed = false;
    }

    public void write() throws IOException {
        GDReader.Block block = new GDReader.Block();
        GDWriter.writeBlockStart(block, 6);
        GDWriter.writeInt(this.version);
        for (int i = 0; i < this.uidLists.length; ++i) {
            GDChar.writeUIDList(this.uidLists[i]);
        }
        GDWriter.writeBlockEnd(block);
        this.changed = false;
    }

    public int getByteSize() {
        int size = 0;
        size += 4;
        size += 4;
        size += 4;
        for (int i = 0; i < this.uidLists.length; ++i) {
            size += 4;
            size += this.uidLists[i].size() * GDCharUID.getByteSize();
        }
        return size += 4;
    }
}

