/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;
import org.gdstash.db.DBCharBonusRace;
import org.gdstash.db.DBStashItem;
import org.gdstash.db.GDDBData;
import org.gdstash.db.GDDBUtil;
import org.gdstash.db.SelectionCriteria;
import org.gdstash.description.BonusDetail;
import org.gdstash.description.BonusInfo;
import org.gdstash.util.GDMsgFormatter;
import org.gdstash.util.GDMsgLogger;

public class DBCharBonus {
    public static final int ROW_ITEM_ID = 1;
    public static final int ROW_LIGHT_RADIUS = 2;
    public static final int ROW_DEFENSE = 3;
    public static final int ROW_DEFENSE_PERC = 4;
    public static final int ROW_OFFENSE = 5;
    public static final int ROW_OFFENSE_PERC = 6;
    public static final int ROW_MANA = 7;
    public static final int ROW_MANA_PERC = 8;
    public static final int ROW_MANALIMIT = 9;
    public static final int ROW_MANALIMIT_PERC = 10;
    public static final int ROW_MANAREDUCTION = 11;
    public static final int ROW_MANAREDUCTION_PERC = 12;
    public static final int ROW_MANAREGEN = 13;
    public static final int ROW_MANAREGEN_PERC = 14;
    public static final int ROW_HEALTH = 15;
    public static final int ROW_HEALTH_PERC = 16;
    public static final int ROW_HEALTHREGEN = 17;
    public static final int ROW_HEALTHREGEN_PERC = 18;
    public static final int ROW_CUNNING = 19;
    public static final int ROW_CUNNING_PERC = 20;
    public static final int ROW_PHYSIQUE = 21;
    public static final int ROW_PHYSIQUE_PERC = 22;
    public static final int ROW_SPIRIT = 23;
    public static final int ROW_SPIRIT_PERC = 24;
    public static final int ROW_BASE_ATTACKSPEED = 25;
    public static final int ROW_ATTACKSPEED = 26;
    public static final int ROW_ATTACKSPEED_PERC = 27;
    public static final int ROW_CASTSPEED_PERC = 28;
    public static final int ROW_RUNSPEED_PERC = 29;
    public static final int ROW_TOTALSPEED_PERC = 30;
    public static final int ROW_SHIELD_REC_RED_PERC = 31;
    public static final int ROW_REQ_REDUCT_PERC = 32;
    public static final int ROW_MANA_ABSORB_PERC = 33;
    public static final int ROW_XP_INCREASE_PERC = 34;
    public static final int ROW_COOLDOWN_RED = 35;
    public static final int ROW_COOLDOWN_RED_PERC = 36;
    public static final int ROW_MANACOST_RED = 37;
    public static final int ROW_MANACOST_RED_PERC = 38;
    public static final int ROW_RACE_DAMAGE_PERC = 39;
    public static final int ROW_CONSTITUTION_PERC = 40;
    public static final int ROW_AVOID_PROJECTILE_PERC = 41;
    public static final int ROW_AVOID_MELEE_PERC = 42;
    public static final int ROW_RED_ARMOR_STR_PERC = 43;
    public static final int ROW_RED_RANGED_DEX_PERC = 44;
    public static final int ROW_RED_MELEE_DEX_PERC = 45;
    public static final int ROW_RED_MELEE_STR_PERC = 46;
    public static final int ROW_RED_WEAPON_STR_PERC = 47;
    public static final String STAT_SPEED_TOTAL = "STAT_SPEED_TOTAL";
    public static final String STAT_COOLDOWN_REDUCTION = "STAT_COOLDOWN_REDUCTION";
    public static final String STAT_BASE_ATTACKSPEED = "STAT_BASE_ATTACKSPEED";
    public static final String STAT_SPEED_ATTACK = "STAT_SPEED_ATTACK";
    public static final String STAT_SPEED_CAST = "STAT_SPEED_CAST";
    public static final String STAT_SPEED_RUN = "STAT_SPEED_RUN";
    public static final String STAT_SHIELD_RECOVERY_RED = "STAT_SHIELD_RECOVERY_RED";
    public static final String STAT_XP_INCREASE = "STAT_XP_INCREASE";
    public static final String STAT_REQ_REDUCTION = "STAT_REQ_REDUCTION";
    public static final String STAT_CUNNING = "STAT_CUNNING";
    public static final String STAT_PHYSIQUE = "STAT_PHYSIQUE";
    public static final String STAT_SPIRIT = "STAT_SPIRIT";
    public static final String STAT_OFF_ABIL_SHORT = "STAT_OFF_ABIL_SHORT";
    public static final String STAT_DEF_ABIL_SHORT = "STAT_DEF_ABIL_SHORT";
    public static final String STAT_REGEN_HEALTH = "STAT_REGEN_HEALTH";
    public static final String STAT_HEALTH = "STAT_HEALTH";
    public static final String STAT_REGEN_ENERGY = "STAT_REGEN_ENERGY";
    public static final String STAT_MANACOST_REDUCTION = "STAT_MANACOST_REDUCTION";
    public static final String STAT_ENERGY_ABSORB = "STAT_ENERGY_ABSORB";
    public static final String STAT_ENERGY = "STAT_ENERGY";
    public static final String STAT_ENERGY_LIMIT = "STAT_ENERGY_LIMIT";
    public static final String STAT_ENERGY_RESERVE = "STAT_ENERGY_RESERVE";
    public static final String STAT_LIGHT_RADIUS = "STAT_LIGHT_RADIUS";
    public static final String STAT_RACE_DAMAGE = "TXT_UNI_RACE_DAMAGE";
    public static final String STAT_CONSTITUTION = "STAT_CONSTITUTION";
    public static final String STAT_AVOID_PROJECTILE = "STAT_AVOID_PROJECTILE";
    public static final String STAT_AVOID_MELEE = "STAT_AVOID_MELEE";
    public static final String STAT_RED_ARMOR_STR = "STAT_RED_ARMOR_STR";
    public static final String STAT_RED_RANGED_DEX = "STAT_RED_RANGED_DEX";
    public static final String STAT_RED_MELEE_DEX = "STAT_RED_MELEE_DEX";
    public static final String STAT_RED_MELEE_STR = "STAT_RED_MELEE_STR";
    public static final String STAT_RED_WEAPON_STR = "STAT_RED_WEAPON_STR";
    private String itemID;
    private int lightRadius = 0;
    private int defense = 0;
    private int defensePerc = 0;
    private int offense = 0;
    private int offensePerc = 0;
    private int mana = 0;
    private int manaPerc = 0;
    private int manaLimit = 0;
    private int manaLimitPerc = 0;
    private int manaReserve = 0;
    private int manaReservePerc = 0;
    private int manaRegen = 0;
    private int manaRegenPerc = 0;
    private int health = 0;
    private int healthPerc = 0;
    private int healthRegen = 0;
    private int healthRegenPerc = 0;
    private int cunning = 0;
    private int cunningPerc = 0;
    private int physique = 0;
    private int physiquePerc = 0;
    private int spirit = 0;
    private int spiritPerc = 0;
    private float baseAttackSpeed = 0.0f;
    private int attackSpeed = 0;
    private int attackSpeedPerc = 0;
    private int castSpeedPerc = 0;
    private int runSpeedPerc = 0;
    private int totalSpeedPerc = 0;
    private int shieldRecoveryRedPerc = 0;
    private int requirementRedPerc = 0;
    private int energyAbsorbPerc = 0;
    private int experienceIncPerc = 0;
    private int cooldownRed = 0;
    private int cooldownRedPerc = 0;
    private int manaCostRed = 0;
    private int manaCostRedPerc = 0;
    private int raceDamagePerc = 0;
    private int constitutionPerc = 0;
    private int avoidProjectilesPerc = 0;
    private int avoidMeleeAttackPerc = 0;
    private int redArmorStrPerc = 0;
    private int redRangedDexPerc = 0;
    private int redMeleeDexPerc = 0;
    private int redMeleeStrPerc = 0;
    private int redWeaponStrPerc = 0;
    private List<DBCharBonusRace> races = new LinkedList<DBCharBonusRace>();
    private List<RaceBonus> raceBonuses = new LinkedList<RaceBonus>();

    public boolean isInitial() {
        if (this.lightRadius != 0) {
            return false;
        }
        if (this.defense != 0) {
            return false;
        }
        if (this.defensePerc != 0) {
            return false;
        }
        if (this.offense != 0) {
            return false;
        }
        if (this.offensePerc != 0) {
            return false;
        }
        if (this.mana != 0) {
            return false;
        }
        if (this.manaPerc != 0) {
            return false;
        }
        if (this.manaLimit != 0) {
            return false;
        }
        if (this.manaLimitPerc != 0) {
            return false;
        }
        if (this.manaReserve != 0) {
            return false;
        }
        if (this.manaReservePerc != 0) {
            return false;
        }
        if (this.manaRegen != 0) {
            return false;
        }
        if (this.manaRegenPerc != 0) {
            return false;
        }
        if (this.health != 0) {
            return false;
        }
        if (this.healthPerc != 0) {
            return false;
        }
        if (this.healthRegen != 0) {
            return false;
        }
        if (this.healthRegenPerc != 0) {
            return false;
        }
        if (this.cunning != 0) {
            return false;
        }
        if (this.cunningPerc != 0) {
            return false;
        }
        if (this.physique != 0) {
            return false;
        }
        if (this.physiquePerc != 0) {
            return false;
        }
        if (this.spirit != 0) {
            return false;
        }
        if (this.spiritPerc != 0) {
            return false;
        }
        if (this.baseAttackSpeed != 0.0f) {
            return false;
        }
        if (this.attackSpeed != 0) {
            return false;
        }
        if (this.attackSpeedPerc != 0) {
            return false;
        }
        if (this.castSpeedPerc != 0) {
            return false;
        }
        if (this.runSpeedPerc != 0) {
            return false;
        }
        if (this.totalSpeedPerc != 0) {
            return false;
        }
        if (this.shieldRecoveryRedPerc != 0) {
            return false;
        }
        if (this.requirementRedPerc != 0) {
            return false;
        }
        if (this.energyAbsorbPerc != 0) {
            return false;
        }
        if (this.experienceIncPerc != 0) {
            return false;
        }
        if (this.cooldownRed != 0) {
            return false;
        }
        if (this.cooldownRedPerc != 0) {
            return false;
        }
        if (this.manaCostRed != 0) {
            return false;
        }
        if (this.manaCostRedPerc != 0) {
            return false;
        }
        if (this.raceDamagePerc != 0) {
            return false;
        }
        if (this.constitutionPerc != 0) {
            return false;
        }
        if (this.avoidProjectilesPerc != 0) {
            return false;
        }
        if (this.avoidMeleeAttackPerc != 0) {
            return false;
        }
        if (this.redArmorStrPerc != 0) {
            return false;
        }
        if (this.redRangedDexPerc != 0) {
            return false;
        }
        if (this.redMeleeDexPerc != 0) {
            return false;
        }
        if (this.redMeleeStrPerc != 0) {
            return false;
        }
        if (this.redWeaponStrPerc != 0) {
            return false;
        }
        return this.raceBonuses == null || this.raceBonuses.isEmpty();
    }

    public void add(DBCharBonus bonus) {
        if (bonus == null) {
            return;
        }
        this.lightRadius += bonus.lightRadius;
        this.defense += bonus.defense;
        this.defensePerc += bonus.defensePerc;
        this.offense += bonus.offense;
        this.offensePerc += bonus.offensePerc;
        this.mana += bonus.mana;
        this.manaPerc += bonus.manaPerc;
        this.manaLimit += bonus.manaLimit;
        this.manaLimitPerc += bonus.manaLimitPerc;
        this.manaReserve += bonus.manaReserve;
        this.manaReservePerc += bonus.manaReservePerc;
        this.manaRegen += bonus.manaRegen;
        this.manaRegenPerc += bonus.manaRegenPerc;
        this.health += bonus.health;
        this.healthPerc += bonus.healthPerc;
        this.healthRegen += bonus.healthRegen;
        this.healthRegenPerc += bonus.healthRegenPerc;
        this.cunning += bonus.cunning;
        this.cunningPerc += bonus.cunningPerc;
        this.physique += bonus.physique;
        this.physiquePerc += bonus.physiquePerc;
        this.spirit += bonus.spirit;
        this.spiritPerc += bonus.spiritPerc;
        this.attackSpeed += bonus.attackSpeed;
        this.attackSpeedPerc += bonus.attackSpeedPerc;
        this.castSpeedPerc += bonus.castSpeedPerc;
        this.runSpeedPerc += bonus.runSpeedPerc;
        this.totalSpeedPerc += bonus.totalSpeedPerc;
        this.shieldRecoveryRedPerc += bonus.shieldRecoveryRedPerc;
        this.requirementRedPerc += bonus.requirementRedPerc;
        this.energyAbsorbPerc += bonus.energyAbsorbPerc;
        this.experienceIncPerc += bonus.experienceIncPerc;
        this.cooldownRed += bonus.cooldownRed;
        this.cooldownRedPerc += bonus.cooldownRedPerc;
        this.manaCostRed += bonus.manaCostRed;
        this.manaCostRedPerc += bonus.manaCostRedPerc;
        this.constitutionPerc += bonus.constitutionPerc;
        this.avoidProjectilesPerc += bonus.avoidProjectilesPerc;
        this.avoidMeleeAttackPerc += bonus.avoidMeleeAttackPerc;
        this.redArmorStrPerc += bonus.redArmorStrPerc;
        this.redRangedDexPerc += bonus.redRangedDexPerc;
        this.redMeleeDexPerc += bonus.redMeleeDexPerc;
        this.redMeleeStrPerc += bonus.redMeleeStrPerc;
        this.redWeaponStrPerc += bonus.redWeaponStrPerc;
        if (!bonus.raceBonuses.isEmpty()) {
            if (this.raceBonuses.isEmpty()) {
                this.raceBonuses = bonus.raceBonuses;
            } else {
                for (RaceBonus rb1 : bonus.raceBonuses) {
                    boolean found = false;
                    for (RaceBonus rb2 : this.raceBonuses) {
                        if (!rb2.race.equals(rb1.race)) continue;
                        found = true;
                        rb2.perc += rb1.perc;
                        break;
                    }
                    if (found) continue;
                    this.raceBonuses.add(rb1);
                }
            }
        }
    }

    public String getID() {
        return this.itemID;
    }

    public int getLightRadius() {
        return this.lightRadius;
    }

    public int getDefense() {
        return this.defense;
    }

    public int getDefensePerc() {
        return this.defensePerc;
    }

    public int getOffense() {
        return this.offense;
    }

    public int getOffensePerc() {
        return this.offensePerc;
    }

    public int getMana() {
        return this.mana;
    }

    public int getManaPerc() {
        return this.manaPerc;
    }

    public int getManaLimit() {
        return this.manaLimit;
    }

    public int getManaLimitPerc() {
        return this.manaLimitPerc;
    }

    public int getManaReserve() {
        return this.manaReserve;
    }

    public int getManaReservePerc() {
        return this.manaReservePerc;
    }

    public int getManaRegen() {
        return this.manaRegen;
    }

    public int getManaRegenPerc() {
        return this.manaRegenPerc;
    }

    public int getHealth() {
        return this.health;
    }

    public int getHealthPerc() {
        return this.healthPerc;
    }

    public int getHealthRegen() {
        return this.healthRegen;
    }

    public int getHealthRegenPerc() {
        return this.healthRegenPerc;
    }

    public int getCunning() {
        return this.cunning;
    }

    public int getCunningPerc() {
        return this.cunningPerc;
    }

    public int getPhysique() {
        return this.physique;
    }

    public int getPhysiquePerc() {
        return this.physiquePerc;
    }

    public int getSpirit() {
        return this.spirit;
    }

    public int getSpiritPerc() {
        return this.spiritPerc;
    }

    public float getBaseAttackSpeed() {
        return this.baseAttackSpeed;
    }

    public int getAttackSpeed() {
        return this.attackSpeed;
    }

    public int getAttackSpeedPerc() {
        return this.attackSpeedPerc;
    }

    public int getCastSpeedPerc() {
        return this.castSpeedPerc;
    }

    public int getRunSpeedPerc() {
        return this.runSpeedPerc;
    }

    public int getTotalSpeedPerc() {
        return this.totalSpeedPerc;
    }

    public int getShieldRecoveryRedPerc() {
        return this.shieldRecoveryRedPerc;
    }

    public int getRequirementRedPerc() {
        return this.requirementRedPerc;
    }

    public int getEnergyAbsorbPerc() {
        return this.energyAbsorbPerc;
    }

    public int getExperienceIncPerc() {
        return this.experienceIncPerc;
    }

    public int getCooldownRed() {
        return this.cooldownRed;
    }

    public int getCooldownRedPerc() {
        return this.cooldownRedPerc;
    }

    public int getManaCostRed() {
        return this.manaCostRed;
    }

    public int getManaCostRedPerc() {
        return this.manaCostRedPerc;
    }

    public int getConstitutionPerc() {
        return this.constitutionPerc;
    }

    public int getAvoidProjectilesPerc() {
        return this.avoidProjectilesPerc;
    }

    public int getAvoidMeleeAttackPerc() {
        return this.avoidMeleeAttackPerc;
    }

    public int getReducedArmorStrPerc() {
        return this.redArmorStrPerc;
    }

    public int getReducedRangedDexPerc() {
        return this.redRangedDexPerc;
    }

    public int getReducedMeleeDexPerc() {
        return this.redMeleeDexPerc;
    }

    public int getReducedMeleeStrPerc() {
        return this.redMeleeStrPerc;
    }

    public int getReducedWeaponStrPerc() {
        return this.redWeaponStrPerc;
    }

    public int getRaceDamagePerc() {
        return this.raceDamagePerc;
    }

    public List<DBCharBonusRace> getRaceList() {
        return this.races;
    }

    public List<RaceBonus> getRaceBonusList() {
        return this.raceBonuses;
    }

    public int getTotalAttCount() {
        int total = 0;
        if (this.lightRadius != 0) {
            ++total;
        }
        if (this.defense != 0) {
            ++total;
        }
        if (this.defensePerc != 0) {
            ++total;
        }
        if (this.offense != 0) {
            ++total;
        }
        if (this.offensePerc != 0) {
            ++total;
        }
        if (this.mana != 0) {
            ++total;
        }
        if (this.manaPerc != 0) {
            ++total;
        }
        if (this.manaLimit != 0) {
            ++total;
        }
        if (this.manaLimitPerc != 0) {
            ++total;
        }
        if (this.manaReserve != 0) {
            ++total;
        }
        if (this.manaReservePerc != 0) {
            ++total;
        }
        if (this.manaRegen != 0) {
            ++total;
        }
        if (this.manaRegenPerc != 0) {
            ++total;
        }
        if (this.health != 0) {
            ++total;
        }
        if (this.healthPerc != 0) {
            ++total;
        }
        if (this.healthRegen != 0) {
            ++total;
        }
        if (this.healthRegenPerc != 0) {
            ++total;
        }
        if (this.cunning != 0) {
            ++total;
        }
        if (this.cunningPerc != 0) {
            ++total;
        }
        if (this.physique != 0) {
            ++total;
        }
        if (this.physiquePerc != 0) {
            ++total;
        }
        if (this.spirit != 0) {
            ++total;
        }
        if (this.spiritPerc != 0) {
            ++total;
        }
        if (this.attackSpeed != 0) {
            ++total;
        }
        if (this.attackSpeedPerc != 0) {
            ++total;
        }
        if (this.castSpeedPerc != 0) {
            ++total;
        }
        if (this.runSpeedPerc != 0) {
            ++total;
        }
        if (this.totalSpeedPerc != 0) {
            ++total;
        }
        if (this.shieldRecoveryRedPerc != 0) {
            ++total;
        }
        if (this.requirementRedPerc != 0) {
            ++total;
        }
        if (this.energyAbsorbPerc != 0) {
            ++total;
        }
        if (this.experienceIncPerc != 0) {
            ++total;
        }
        if (this.cooldownRed != 0) {
            ++total;
        }
        if (this.cooldownRedPerc != 0) {
            ++total;
        }
        if (this.manaCostRed != 0) {
            ++total;
        }
        if (this.manaCostRedPerc != 0) {
            ++total;
        }
        if (this.constitutionPerc != 0) {
            ++total;
        }
        if (this.avoidProjectilesPerc != 0) {
            ++total;
        }
        if (this.avoidMeleeAttackPerc != 0) {
            ++total;
        }
        if (this.redArmorStrPerc != 0) {
            ++total;
        }
        if (this.redRangedDexPerc != 0) {
            ++total;
        }
        if (this.redMeleeDexPerc != 0) {
            ++total;
        }
        if (this.redMeleeStrPerc != 0) {
            ++total;
        }
        if (this.redWeaponStrPerc != 0) {
            ++total;
        }
        if (this.raceBonuses != null && !this.raceBonuses.isEmpty()) {
            total += this.raceBonuses.size();
        }
        return total;
    }

    public boolean matchesCriteria(SelectionCriteria criteria) {
        if (!criteria.statFlat.isUsed() && !criteria.statPerc.isUsed()) {
            return true;
        }
        if (criteria.statFlat.cunning && this.cunning > 0) {
            return true;
        }
        if (criteria.statPerc.cunning && this.cunningPerc > 0) {
            return true;
        }
        if (criteria.statFlat.physique && this.physique > 0) {
            return true;
        }
        if (criteria.statPerc.physique && this.physiquePerc > 0) {
            return true;
        }
        if (criteria.statFlat.spirit && this.spirit > 0) {
            return true;
        }
        if (criteria.statPerc.spirit && this.spiritPerc > 0) {
            return true;
        }
        if (criteria.statFlat.defense && this.defense > 0) {
            return true;
        }
        if (criteria.statPerc.defense && this.defensePerc > 0) {
            return true;
        }
        if (criteria.statFlat.offense && this.offense > 0) {
            return true;
        }
        if (criteria.statPerc.offense && this.offensePerc > 0) {
            return true;
        }
        if (criteria.statFlat.health && this.health > 0) {
            return true;
        }
        if (criteria.statPerc.health && this.healthPerc > 0) {
            return true;
        }
        if (criteria.statFlat.healthRegen && this.healthRegen > 0) {
            return true;
        }
        if (criteria.statPerc.healthRegen && this.healthRegenPerc > 0) {
            return true;
        }
        if (criteria.statPerc.attackSpeed) {
            if (this.attackSpeed > 0) {
                return true;
            }
            if (this.attackSpeedPerc > 0) {
                return true;
            }
        }
        if (criteria.statPerc.castSpeed && this.castSpeedPerc > 0) {
            return true;
        }
        if (criteria.statPerc.runSpeed && this.runSpeedPerc > 0) {
            return true;
        }
        if (criteria.statPerc.totalSpeed && this.totalSpeedPerc > 0) {
            return true;
        }
        if (criteria.statPerc.cooldown) {
            if (this.cooldownRed > 0) {
                return true;
            }
            if (this.cooldownRedPerc > 0) {
                return true;
            }
        }
        return criteria.statPerc.shieldRecovery && this.shieldRecoveryRedPerc > 0;
    }

    public void setID(String itemID) {
        this.itemID = itemID;
    }

    public void setLightRadius(int lightRadius) {
        this.lightRadius = lightRadius;
    }

    public void setDefense(int defense) {
        this.defense = defense;
    }

    public void setDefensePerc(int defensePerc) {
        this.defensePerc = defensePerc;
    }

    public void setOffense(int offense) {
        this.offense = offense;
    }

    public void setOffensePerc(int offensePerc) {
        this.offensePerc = offensePerc;
    }

    public void setMana(int mana) {
        this.mana = mana;
    }

    public void setManaPerc(int manaPerc) {
        this.manaPerc = manaPerc;
    }

    public void setManaLimit(int manaLimit) {
        this.manaLimit = manaLimit;
    }

    public void setManaLimitPerc(int manaLimitPerc) {
        this.manaLimitPerc = manaLimitPerc;
    }

    public void setManaReserve(int manaReserve) {
        this.manaReserve = manaReserve;
    }

    public void setManaReservePerc(int manaReservePerc) {
        this.manaReservePerc = manaReservePerc;
    }

    public void setManaRegen(int manaRegen) {
        this.manaRegen = manaRegen;
    }

    public void setManaRegenPerc(int manaRegenPerc) {
        this.manaRegenPerc = manaRegenPerc;
    }

    public void setHealth(int health) {
        this.health = health;
    }

    public void setHealthPerc(int healthPerc) {
        this.healthPerc = healthPerc;
    }

    public void setHealthRegen(int healthRegen) {
        this.healthRegen = healthRegen;
    }

    public void setHealthRegenPerc(int healthRegenPerc) {
        this.healthRegenPerc = healthRegenPerc;
    }

    public void setCunning(int cunning) {
        this.cunning = cunning;
    }

    public void setCunningPerc(int cunningPerc) {
        this.cunningPerc = cunningPerc;
    }

    public void setPhysique(int physique) {
        this.physique = physique;
    }

    public void setPhysiquePerc(int physiquePerc) {
        this.physiquePerc = physiquePerc;
    }

    public void setSpirit(int spirit) {
        this.spirit = spirit;
    }

    public void setSpiritPerc(int spiritPerc) {
        this.spiritPerc = spiritPerc;
    }

    public void setBaseAttackSpeed(float baseAttackSpeed) {
        this.baseAttackSpeed = baseAttackSpeed;
    }

    public void setAttackSpeed(int attackSpeed) {
        this.attackSpeed = attackSpeed;
    }

    public void setAttackSpeedPerc(int attackSpeedPerc) {
        this.attackSpeedPerc = attackSpeedPerc;
    }

    public void setCastSpeedPerc(int castSpeedPerc) {
        this.castSpeedPerc = castSpeedPerc;
    }

    public void setRunSpeedPerc(int runSpeedPerc) {
        this.runSpeedPerc = runSpeedPerc;
    }

    public void setTotalSpeedPerc(int totalSpeedPerc) {
        this.totalSpeedPerc = totalSpeedPerc;
    }

    public void setShieldRecoveryRedPerc(int shieldRecoveryRedPerc) {
        this.shieldRecoveryRedPerc = shieldRecoveryRedPerc;
    }

    public void setRequirementRedPerc(int requirementRedPerc) {
        this.requirementRedPerc = requirementRedPerc;
    }

    public void setEnergyAbsorbPerc(int energyAbsorbPerc) {
        this.energyAbsorbPerc = energyAbsorbPerc;
    }

    public void setExperienceIncPerc(int experienceIncPerc) {
        this.experienceIncPerc = experienceIncPerc;
    }

    public void setCooldownRed(int cooldownRed) {
        this.cooldownRed = cooldownRed;
    }

    public void setCooldownRedPerc(int cooldownRedPerc) {
        this.cooldownRedPerc = cooldownRedPerc;
    }

    public void setManaCostRed(int manaCostRed) {
        this.manaCostRed = manaCostRed;
    }

    public void setManaCostRedPerc(int manaCostRedPerc) {
        this.manaCostRedPerc = manaCostRedPerc;
    }

    public void setConstitutionPerc(int constitutionPerc) {
        this.constitutionPerc = constitutionPerc;
    }

    public void setAvoidProjectilesPerc(int avoidProjectilesPerc) {
        this.avoidProjectilesPerc = avoidProjectilesPerc;
    }

    public void setAvoidMeleeAttackPerc(int avoidMeleeAttackPerc) {
        this.avoidMeleeAttackPerc = avoidMeleeAttackPerc;
    }

    public void setReducedArmorStrPerc(int redArmorStrPerc) {
        this.redArmorStrPerc = redArmorStrPerc;
    }

    public void setReducedRangedDexPerc(int redRangedDexPerc) {
        this.redRangedDexPerc = redRangedDexPerc;
    }

    public void setReducedMeleeDexPerc(int redMeleeDexPerc) {
        this.redMeleeDexPerc = redMeleeDexPerc;
    }

    public void setReducedMeleeStrPerc(int redMeleeStrPerc) {
        this.redMeleeStrPerc = redMeleeStrPerc;
    }

    public void setReducedWeaponStrPerc(int redWeaponStrPerc) {
        this.redWeaponStrPerc = redWeaponStrPerc;
    }

    public void setRaceDamagePerc(int raceDamagePerc) {
        this.raceDamagePerc = raceDamagePerc;
    }

    public void addRace(String tag, String name) {
        boolean found = false;
        for (DBCharBonusRace race : this.races) {
            if (!race.getRaceTag().equals(tag)) continue;
            found = true;
            break;
        }
        if (!found) {
            DBCharBonusRace race;
            race = new DBCharBonusRace();
            race.setID(this.itemID);
            race.setRaceTag(tag);
            race.setRaceName(name);
            this.races.add(race);
        }
    }

    public static void createTable(Connection conn, String tabName, String tabRace, String idName) throws SQLException {
        String dropTable = "DROP TABLE " + tabName;
        String createTable = "CREATE TABLE " + tabName + " (" + idName + " VARCHAR(256) NOT NULL, " + "LIGHT_RADIUS        INTEGER, " + "DEFENSE             INTEGER, " + "DEFENSE_PERC        INTEGER, " + "OFFENSE             INTEGER, " + "OFFENSE_PERC        INTEGER, " + "MANA                INTEGER, " + "MANA_PERC           INTEGER, " + "MANALIMIT           INTEGER, " + "MANALIMIT_PERC      INTEGER, " + "MANAREDUCTION       INTEGER, " + "MANAREDUCTION_PERC  INTEGER, " + "MANAREGEN           INTEGER, " + "MANAREGEN_PERC      INTEGER, " + "HEALTH              INTEGER, " + "HEALTH_PERC         INTEGER, " + "HEALTHREGEN         INTEGER, " + "HEALTHREGEN_PERC    INTEGER, " + "CUNNING             INTEGER, " + "CUNNING_PERC        INTEGER, " + "PHYSIQUE            INTEGER, " + "PHYSIQUE_PERC       INTEGER, " + "SPIRIT              INTEGER, " + "SPIRIT_PERC         INTEGER, " + "BASE_ATTACKSPEED    FLOAT, " + "ATTACKSPEED         INTEGER, " + "ATTACKSPEED_PERC    INTEGER, " + "CASTSPEED_PERC      INTEGER, " + "RUNSPEED_PERC       INTEGER, " + "TOTALSPEED_PERC     INTEGER, " + "SHIELD_REC_RED_PERC INTEGER, " + "REQ_REDUCT_PERC     INTEGER, " + "MANA_ABSORB_PERC    INTEGER, " + "XP_INCREASE_PERC    INTEGER, " + "COOLDOWN_RED        INTEGER, " + "COOLDOWN_RED_PERC   INTEGER, " + "MANACOST_RED        INTEGER, " + "MANACOST_RED_PERC   INTEGER, " + "RACE_DAMAGE_PERC    INTEGER, " + "CONSTITUTION_PERC   INTEGER, " + "AVOID_PROJECTILE_PERC INTEGER, " + "AVOID_MELEE_PERC    INTEGER, " + "RED_ARMOR_STR_PERC  INTEGER, " + "RED_RANGED_DEX_PERC INTEGER, " + "RED_MELEE_DEX_PERC  INTEGER, " + "RED_MELEE_STR_PERC  INTEGER, " + "RED_WEAPON_STR_PERC INTEGER, " + "PRIMARY KEY (" + idName + "))";
        try (Statement st = conn.createStatement();){
            if (GDDBUtil.tableExists(conn, tabName)) {
                st.execute(dropTable);
            }
            st.execute(createTable);
            st.close();
            conn.commit();
            DBCharBonusRace.createTable(conn, tabRace, idName);
        }
        catch (SQLException ex) {
            Object[] args = new Object[]{tabName};
            String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_CREATE_TABLE", args);
            GDMsgLogger.addError(msg);
            throw ex;
        }
    }

    public static void delete(Connection conn, String tabName, String tabRace, String idName, String itemID) throws SQLException {
        String deleteEntry = "DELETE FROM " + tabName + " WHERE " + idName + " = ?";
        try (PreparedStatement ps = conn.prepareStatement(deleteEntry);){
            ps.setString(1, itemID);
            ps.executeUpdate();
            ps.close();
            DBCharBonusRace.delete(conn, tabRace, idName, itemID);
        }
    }

    public static void insert(Connection conn, String tabName, String tabRace, String id, DBCharBonus bonus) throws SQLException {
        String insert = "INSERT INTO " + tabName + " VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        if (bonus == null) {
            return;
        }
        if (bonus.isInitial()) {
            return;
        }
        try (PreparedStatement ps = conn.prepareStatement(insert);){
            ps.setString(1, id);
            ps.setInt(2, bonus.lightRadius);
            ps.setInt(3, bonus.defense);
            ps.setInt(4, bonus.defensePerc);
            ps.setInt(5, bonus.offense);
            ps.setInt(6, bonus.offensePerc);
            ps.setInt(7, bonus.mana);
            ps.setInt(8, bonus.manaPerc);
            ps.setInt(9, bonus.manaLimit);
            ps.setInt(10, bonus.manaLimitPerc);
            ps.setInt(11, bonus.manaReserve);
            ps.setInt(12, bonus.manaReservePerc);
            ps.setInt(13, bonus.manaRegen);
            ps.setInt(14, bonus.manaRegenPerc);
            ps.setInt(15, bonus.health);
            ps.setInt(16, bonus.healthPerc);
            ps.setInt(17, bonus.healthRegen);
            ps.setInt(18, bonus.healthRegenPerc);
            ps.setInt(19, bonus.cunning);
            ps.setInt(20, bonus.cunningPerc);
            ps.setInt(21, bonus.physique);
            ps.setInt(22, bonus.physiquePerc);
            ps.setInt(23, bonus.spirit);
            ps.setInt(24, bonus.spiritPerc);
            ps.setFloat(25, bonus.baseAttackSpeed);
            ps.setInt(26, bonus.attackSpeed);
            ps.setInt(27, bonus.attackSpeedPerc);
            ps.setInt(28, bonus.castSpeedPerc);
            ps.setInt(29, bonus.runSpeedPerc);
            ps.setInt(30, bonus.totalSpeedPerc);
            ps.setInt(31, bonus.shieldRecoveryRedPerc);
            ps.setInt(32, bonus.requirementRedPerc);
            ps.setInt(33, bonus.energyAbsorbPerc);
            ps.setInt(34, bonus.experienceIncPerc);
            ps.setInt(35, bonus.cooldownRed);
            ps.setInt(36, bonus.cooldownRedPerc);
            ps.setInt(37, bonus.manaCostRed);
            ps.setInt(38, bonus.manaCostRedPerc);
            ps.setInt(39, bonus.raceDamagePerc);
            ps.setInt(40, bonus.constitutionPerc);
            ps.setInt(41, bonus.avoidProjectilesPerc);
            ps.setInt(42, bonus.avoidMeleeAttackPerc);
            ps.setInt(43, bonus.redArmorStrPerc);
            ps.setInt(44, bonus.redRangedDexPerc);
            ps.setInt(45, bonus.redMeleeDexPerc);
            ps.setInt(46, bonus.redMeleeStrPerc);
            ps.setInt(47, bonus.redWeaponStrPerc);
            ps.executeUpdate();
            ps.clearParameters();
            ps.close();
            conn.commit();
            DBCharBonusRace.insert(conn, tabRace, id, bonus.races);
        }
    }

    private static DBCharBonus getByID(String tableName, String tableRace, String fieldName, String itemID) {
        DBCharBonus bonus = null;
        String command = "SELECT * FROM " + tableName + " WHERE " + fieldName + " = ?";
        try (Connection conn = GDDBData.getConnection();
             PreparedStatement ps = conn.prepareStatement(command);){
            ps.setString(1, itemID);
            try (ResultSet rs = ps.executeQuery();){
                List<DBCharBonus> list = DBCharBonus.wrap(tableRace, fieldName, rs);
                bonus = list.isEmpty() ? null : list.get(0);
                conn.commit();
            }
        }
        catch (SQLException ex) {
            Object[] args = new Object[]{itemID, tableName};
            String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_READ_TABLE_BY_ID", args);
            GDMsgLogger.addError(msg);
            GDMsgLogger.addError(ex);
        }
        return bonus;
    }

    public static DBCharBonus getByItemID(String itemID) {
        return DBCharBonus.getByID("GD_ITEM_CHAR", "GD_ITEM_CHARRACES", "ITEM_ID", itemID);
    }

    public static DBCharBonus getByAffixID(String affixID) {
        return DBCharBonus.getByID("GD_AFFIX_CHAR", "GD_AFFIX_CHARRACES", "AFFIX_ID", affixID);
    }

    public static DBCharBonus getBySkillID(String skillID) {
        return DBCharBonus.getByID("GD_SKILL_CHAR", "GD_SKILL_CHARRACES", "SKILL_ID", skillID);
    }

    private static List<DBCharBonus> wrap(String tableName, String fieldName, ResultSet rs) throws SQLException {
        LinkedList<DBCharBonus> list = new LinkedList<DBCharBonus>();
        while (rs.next()) {
            DBCharBonus bonus = new DBCharBonus();
            bonus.itemID = rs.getString(1);
            bonus.lightRadius = rs.getInt(2);
            bonus.defense = rs.getInt(3);
            bonus.defensePerc = rs.getInt(4);
            bonus.offense = rs.getInt(5);
            bonus.offensePerc = rs.getInt(6);
            bonus.mana = rs.getInt(7);
            bonus.manaPerc = rs.getInt(8);
            bonus.manaLimit = rs.getInt(9);
            bonus.manaLimitPerc = rs.getInt(10);
            bonus.manaReserve = rs.getInt(11);
            bonus.manaReservePerc = rs.getInt(12);
            bonus.manaRegen = rs.getInt(13);
            bonus.manaRegenPerc = rs.getInt(14);
            bonus.health = rs.getInt(15);
            bonus.healthPerc = rs.getInt(16);
            bonus.healthRegen = rs.getInt(17);
            bonus.healthRegenPerc = rs.getInt(18);
            bonus.cunning = rs.getInt(19);
            bonus.cunningPerc = rs.getInt(20);
            bonus.physique = rs.getInt(21);
            bonus.physiquePerc = rs.getInt(22);
            bonus.spirit = rs.getInt(23);
            bonus.spiritPerc = rs.getInt(24);
            bonus.baseAttackSpeed = rs.getFloat(25);
            bonus.attackSpeed = rs.getInt(26);
            bonus.attackSpeedPerc = rs.getInt(27);
            bonus.castSpeedPerc = rs.getInt(28);
            bonus.runSpeedPerc = rs.getInt(29);
            bonus.totalSpeedPerc = rs.getInt(30);
            bonus.shieldRecoveryRedPerc = rs.getInt(31);
            bonus.requirementRedPerc = rs.getInt(32);
            bonus.energyAbsorbPerc = rs.getInt(33);
            bonus.experienceIncPerc = rs.getInt(34);
            bonus.cooldownRed = rs.getInt(35);
            bonus.cooldownRedPerc = rs.getInt(36);
            bonus.manaCostRed = rs.getInt(37);
            bonus.manaCostRedPerc = rs.getInt(38);
            bonus.raceDamagePerc = rs.getInt(39);
            bonus.constitutionPerc = rs.getInt(40);
            bonus.avoidProjectilesPerc = rs.getInt(41);
            bonus.avoidMeleeAttackPerc = rs.getInt(42);
            bonus.redArmorStrPerc = rs.getInt(43);
            bonus.redRangedDexPerc = rs.getInt(44);
            bonus.redMeleeDexPerc = rs.getInt(45);
            bonus.redMeleeStrPerc = rs.getInt(46);
            bonus.redWeaponStrPerc = rs.getInt(47);
            if (bonus.raceDamagePerc > 0) {
                bonus.races = DBCharBonusRace.getByID(tableName, fieldName, bonus.itemID);
                if (bonus.races != null) {
                    for (DBCharBonusRace race : bonus.races) {
                        RaceBonus rb = new RaceBonus();
                        rb.race = race.getRaceName();
                        rb.perc = bonus.raceDamagePerc;
                        bonus.raceBonuses.add(rb);
                    }
                }
            }
            list.add(bonus);
        }
        return list;
    }

    public BonusDetail getBonusDetail(DBStashItem item, int detailType, String prefix) {
        BonusDetail bonus = new BonusDetail(item, detailType, this, prefix);
        return bonus;
    }

    public List<BonusInfo> getBonusInfos(DBStashItem item, int detailType) {
        return BonusDetail.createStatInfos(item, detailType, this, null);
    }

    public static class RaceBonus {
        public String race;
        public int perc;
    }
}

