/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;
import org.gdstash.db.GDDBData;
import org.gdstash.db.GDDBUtil;
import org.gdstash.util.GDMsgFormatter;
import org.gdstash.util.GDMsgLogger;

public class DBCharBonusRace {
    public static final int ROW_ITEM_ID = 1;
    public static final int ROW_RACE_TAG = 2;
    public static final int ROW_RACE_NAME = 3;
    private String itemID = null;
    private String raceTag = null;
    private String raceName = null;

    public String getID() {
        return this.itemID;
    }

    public String getRaceTag() {
        if (this.raceTag == null) {
            return null;
        }
        if (this.raceTag.startsWith("tag")) {
            return this.raceTag;
        }
        return "tag" + this.raceTag;
    }

    public String getRaceName() {
        return this.raceName;
    }

    public void setID(String itemID) {
        this.itemID = itemID;
    }

    public void setRaceTag(String raceTag) {
        this.raceTag = raceTag;
    }

    public void setRaceName(String raceName) {
        this.raceName = raceName;
    }

    public static void createTable(Connection conn, String tabName, String idName) throws SQLException {
        String dropTable = "DROP TABLE " + tabName;
        String createTable = "CREATE TABLE " + tabName + " (" + idName + " VARCHAR(256) NOT NULL, " + "RACE_TAG           VARCHAR(64), " + "RACE_NAME          VARCHAR(64), " + "PRIMARY KEY (" + idName + ", RACE_TAG))";
        try (Statement st = conn.createStatement();){
            if (GDDBUtil.tableExists(conn, tabName)) {
                st.execute(dropTable);
            }
            st.execute(createTable);
            st.close();
            conn.commit();
        }
        catch (SQLException ex) {
            Object[] args = new Object[]{tabName};
            String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_CREATE_TABLE", args);
            GDMsgLogger.addError(msg);
            throw ex;
        }
    }

    public static void delete(Connection conn, String tabName, String idName, String itemID) throws SQLException {
        String deleteEntry = "DELETE FROM " + tabName + " WHERE " + idName + " = ?";
        try (PreparedStatement ps = conn.prepareStatement(deleteEntry);){
            ps.setString(1, itemID);
            ps.executeUpdate();
            ps.close();
        }
    }

    public static void insert(Connection conn, String tabName, String id, List<DBCharBonusRace> races) throws SQLException {
        String insert = "INSERT INTO " + tabName + " VALUES (?,?,?)";
        if (races == null) {
            return;
        }
        if (races.isEmpty()) {
            return;
        }
        try (PreparedStatement ps = conn.prepareStatement(insert);){
            for (DBCharBonusRace race : races) {
                ps.setString(1, id);
                ps.setString(2, race.raceTag);
                ps.setString(3, race.raceName);
                ps.executeUpdate();
                ps.clearParameters();
            }
            ps.close();
            conn.commit();
        }
    }

    public static List<DBCharBonusRace> getByID(String tableName, String fieldName, String itemID) {
        List<DBCharBonusRace> list = new LinkedList<DBCharBonusRace>();
        String command = "SELECT * FROM " + tableName + " WHERE " + fieldName + " = ?";
        try (Connection conn = GDDBData.getConnection();
             PreparedStatement ps = conn.prepareStatement(command);){
            ps.setString(1, itemID);
            try (ResultSet rs = ps.executeQuery();){
                list = DBCharBonusRace.wrap(rs);
                conn.commit();
            }
        }
        catch (SQLException ex) {
            Object[] args = new Object[]{itemID, tableName};
            String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_READ_TABLE_BY_ID", args);
            GDMsgLogger.addError(msg);
            GDMsgLogger.addError(ex);
        }
        return list;
    }

    private static List<DBCharBonusRace> wrap(ResultSet rs) throws SQLException {
        LinkedList<DBCharBonusRace> list = new LinkedList<DBCharBonusRace>();
        while (rs.next()) {
            DBCharBonusRace race = new DBCharBonusRace();
            race.itemID = rs.getString(1);
            race.raceTag = rs.getString(2);
            race.raceName = rs.getString(3);
            list.add(race);
        }
        return list;
    }
}

