/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;
import org.gdstash.db.DBAffix;
import org.gdstash.db.DBItem;
import org.gdstash.db.DBStashItem;
import org.gdstash.db.GDDBData;
import org.gdstash.db.GDDBUtil;
import org.gdstash.description.BonusDetail;
import org.gdstash.util.GDMsgFormatter;
import org.gdstash.util.GDMsgLogger;

public class DBDamage
implements Cloneable {
    public static final int ROW_ITEM_ID = 1;
    public static final int ROW_DAMAGE_TYPE = 2;
    public static final int ROW_FLAG_GLOBAL = 3;
    public static final int ROW_FLAG_XOR = 4;
    public static final int ROW_DAMAGE_MIN = 5;
    public static final int ROW_DAMAGE_MAX = 6;
    public static final int ROW_DAMAGE_CHANCE = 7;
    public static final int ROW_MODIFIER = 8;
    public static final int ROW_MODIFIER_CHANCE = 9;
    public static final int ROW_DURATION_MIN = 10;
    public static final int ROW_DURATION_MAX = 11;
    public static final int ROW_DURATION_CHANCE = 12;
    public static final int ROW_DURATION_MODIFIER = 13;
    public static final int ROW_DURATION_MODIFIER_CHANCE = 14;
    public static final int ROW_MAX_RESIST = 15;
    public static final int GLOBAL_NONE = 0;
    public static final int GLOBAL_ITEM = 1;
    public static final int GLOBAL_COMPONENT = 2;
    public static final int GLOBAL_PREFIX = 3;
    public static final int GLOBAL_PREFIX_PET = 4;
    public static final int GLOBAL_SUFFIX = 5;
    public static final int GLOBAL_SUFFIX_PET = 6;
    public static final int GLOBAL_MODIFIER = 7;
    public static final int GLOBAL_COMPLETION = 8;
    public static final int GLOBAL_ENCHANTMENT = 9;
    public static final String TYPE_DEF_ABSORTPION = "defensiveAbsorption";
    public static final String TYPE_DEF_AETHER = "defensiveAether";
    public static final String TYPE_DEF_ALL = "defensiveAll";
    public static final String TYPE_DEF_BLEED = "defensiveBleeding";
    public static final String TYPE_DEF_BLOCK_CHANCE = "defensiveBlock";
    public static final String TYPE_DEF_BLOCK_AMOUNT = "defensiveBlockAmount";
    public static final String TYPE_DEF_BONUS_PROTECT = "defensiveBonusProtection";
    public static final String TYPE_DEF_CHAOS = "defensiveChaos";
    public static final String TYPE_DEF_COLD = "defensiveCold";
    public static final String TYPE_DEF_CONFUSION = "defensiveConfusion";
    public static final String TYPE_DEF_CONVERT = "defensiveConvert";
    public static final String TYPE_DEF_DISRUPTION = "defensiveDisruption";
    public static final String TYPE_DEF_ELEMENTAL = "defensiveElemental";
    public static final String TYPE_DEF_ELEMENTAL_RES = "defensiveElementalResistance";
    public static final String TYPE_DEF_FEAR = "defensiveFear";
    public static final String TYPE_DEF_FIRE = "defensiveFire";
    public static final String TYPE_DEF_FREEZE = "defensiveFreeze";
    public static final String TYPE_DEF_KNOCKDOWN = "defensiveKnockdown";
    public static final String TYPE_DEF_LIFE = "defensiveLife";
    public static final String TYPE_DEF_LIGHTNING = "defensiveLightning";
    public static final String TYPE_DEF_LIFE_PERC = "defensivePercentCurrentLife";
    public static final String TYPE_DEF_MANA_BURN = "defensiveManaBurnRatio";
    public static final String TYPE_DEF_PETRIFY = "defensivePetrify";
    public static final String TYPE_DEF_PHYSICAL = "defensivePhysical";
    public static final String TYPE_DEF_PIERCE = "defensivePierce";
    public static final String TYPE_DEF_POISON = "defensivePoison";
    public static final String TYPE_DEF_PROTECTION = "defensiveProtection";
    public static final String TYPE_DEF_REFLECT = "defensiveReflect";
    public static final String TYPE_DEF_SLEEP = "defensiveSleep";
    public static final String TYPE_DEF_SLOW_LIFE_LEECH = "defensiveSlowLifeLeach";
    public static final String TYPE_DEF_SLOW_MANA_LEECH = "defensiveSlowManaLeach";
    public static final String TYPE_DEF_STUN = "defensiveStun";
    public static final String TYPE_DEF_TAUNT = "defensiveTaunt";
    public static final String TYPE_DEF_TOTALSPEED_RES = "defensiveTotalSpeedResistance";
    public static final String TYPE_DEF_TRAP = "defensiveTrap";
    public static final String TYPE_OFF_AETHER = "offensiveAether";
    public static final String TYPE_OFF_BASE_AETHER = "offensiveBaseAether";
    public static final String TYPE_OFF_BASE_CHAOS = "offensiveBaseChaos";
    public static final String TYPE_OFF_BASE_COLD = "offensiveBaseCold";
    public static final String TYPE_OFF_BASE_FIRE = "offensiveBaseFire";
    public static final String TYPE_OFF_BASE_LIFE = "offensiveBaseLife";
    public static final String TYPE_OFF_BASE_LIGHTNING = "offensiveBaseLightning";
    public static final String TYPE_OFF_BASE_POISON = "offensiveBasePoison";
    public static final String TYPE_OFF_BONUS_PHYSICAL = "offensiveBonusPhysical";
    public static final String TYPE_OFF_CHAOS = "offensiveChaos";
    public static final String TYPE_OFF_COLD = "offensiveCold";
    public static final String TYPE_OFF_CONFUSION = "offensiveConfusion";
    public static final String TYPE_OFF_CONVERT = "offensiveConvert";
    public static final String TYPE_OFF_CRITICAL = "offensiveCritDamage";
    public static final String TYPE_OFF_DMGMULT = "offensiveDamageMult";
    public static final String TYPE_OFF_DISRUPTION = "offensiveDisruption";
    public static final String TYPE_OFF_ELEMENTAL = "offensiveElemental";
    public static final String TYPE_OFF_ELEM_RED_PERC = "offensiveElementalReductionPercent";
    public static final String TYPE_OFF_ELEM_RES_RED_ABS = "offensiveElementalResistanceReductionAbsolute";
    public static final String TYPE_OFF_FEAR = "offensiveFear";
    public static final String TYPE_OFF_FIRE = "offensiveFire";
    public static final String TYPE_OFF_FREEZE = "offensiveFreeze";
    public static final String TYPE_OFF_FUMBLE = "offensiveFumble";
    public static final String TYPE_OFF_KNOCKDOWN = "offensiveKnockdown";
    public static final String TYPE_OFF_LIFE = "offensiveLife";
    public static final String TYPE_OFF_LIFE_LEECH = "offensiveLifeLeech";
    public static final String TYPE_OFF_LIGHTNING = "offensiveLightning";
    public static final String TYPE_OFF_MANA_BURN_RATIO = "offensiveManaBurnDamageRatio";
    public static final String TYPE_OFF_MANA_BURN_DRAIN = "offensiveManaBurnDrain";
    public static final String TYPE_OFF_LIFE_PERC = "offensivePercentCurrentLife";
    public static final String TYPE_OFF_PETRIFY = "offensivePetrify";
    public static final String TYPE_OFF_PHYSICAL = "offensivePhysical";
    public static final String TYPE_OFF_PHYS_DMG_RED_PERC = "offensivePhysicalReductionPercent";
    public static final String TYPE_OFF_PHYS_RES_RED_ABS = "offensivePhysicalResistanceReductionAbsolute";
    public static final String TYPE_OFF_PIERCE = "offensivePierce";
    public static final String TYPE_OFF_PIERCE_RATIO = "offensivePierceRatio";
    public static final String TYPE_OFF_POISON = "offensivePoison";
    public static final String TYPE_OFF_PROJECTILE_FUMBLE = "offensiveProjectileFumble";
    public static final String TYPE_OFF_SLEEP = "offensiveSleep";
    public static final String TYPE_OFF_SLOW_ATTACK = "offensiveSlowAttackSpeed";
    public static final String TYPE_OFF_SLOW_BLEED = "offensiveSlowBleeding";
    public static final String TYPE_OFF_SLOW_COLD = "offensiveSlowCold";
    public static final String TYPE_OFF_SLOW_DEFENSE = "offensiveSlowDefensiveAbility";
    public static final String TYPE_OFF_SLOW_DEF_RED = "offensiveSlowDefensiveReduction";
    public static final String TYPE_OFF_SLOW_FIRE = "offensiveSlowFire";
    public static final String TYPE_OFF_SLOW_LIFE = "offensiveSlowLife";
    public static final String TYPE_OFF_SLOW_LIFE_LEECH = "offensiveSlowLifeLeach";
    public static final String TYPE_OFF_SLOW_LIGHTNING = "offensiveSlowLightning";
    public static final String TYPE_OFF_SLOW_MANA_LEECH = "offensiveSlowManaLeach";
    public static final String TYPE_OFF_SLOW_OFFENSE = "offensiveSlowOffensiveAbility";
    public static final String TYPE_OFF_SLOW_OFF_RED = "offensiveSlowOffensiveReduction";
    public static final String TYPE_OFF_SLOW_PHYSICAL = "offensiveSlowPhysical";
    public static final String TYPE_OFF_SLOW_POISON = "offensiveSlowPoison";
    public static final String TYPE_OFF_SLOW_RUNSPEED = "offensiveSlowRunSpeed";
    public static final String TYPE_OFF_SLOW_TOTALSPEED = "offensiveSlowTotalSpeed";
    public static final String TYPE_OFF_STUN = "offensiveStun";
    public static final String TYPE_OFF_TAUNT = "offensiveTaunt";
    public static final String TYPE_OFF_TOTALDAMAGE = "offensiveTotalDamage";
    public static final String TYPE_OFF_TOTALDMGRED_PERC = "offensiveTotalDamageReductionPercent";
    public static final String TYPE_OFF_TOTALRESRED_ABS = "offensiveTotalResistanceReductionAbsolute";
    public static final String TYPE_OFF_TOTALRESRED_PERC = "offensiveTotalResistanceReductionPercent";
    public static final String TYPE_OFF_TRAP = "offensiveTrap";
    public static final String TYPE_RET_AETHER = "retaliationAether";
    public static final String TYPE_RET_CHAOS = "retaliationChaos";
    public static final String TYPE_RET_COLD = "retaliationCold";
    public static final String TYPE_RET_CONFUSION = "retaliationConfusion";
    public static final String TYPE_RET_CONVERT = "retaliationConvert";
    public static final String TYPE_RET_ELEMENTAL = "retaliationElemental";
    public static final String TYPE_RET_FEAR = "retaliationFear";
    public static final String TYPE_RET_FIRE = "retaliationFire";
    public static final String TYPE_RET_FREEZE = "retaliationFreeze";
    public static final String TYPE_RET_LIFE = "retaliationLife";
    public static final String TYPE_RET_LIGHTNING = "retaliationLightning";
    public static final String TYPE_RET_LIFE_PERC = "retaliationPercentCurrentLife";
    public static final String TYPE_RET_PETRIFY = "retaliationPetrify";
    public static final String TYPE_RET_PHYSICAL = "retaliationPhysical";
    public static final String TYPE_RET_PIERCE = "retaliationPierce";
    public static final String TYPE_RET_PIERCE_RATIO = "retaliationPierceRatio";
    public static final String TYPE_RET_POISON = "retaliationPoison";
    public static final String TYPE_RET_SLEEP = "retaliationSleep";
    public static final String TYPE_RET_SLOW_ATTACK = "retaliationSlowAttackSpeed";
    public static final String TYPE_RET_SLOW_BLEED = "retaliationSlowBleeding";
    public static final String TYPE_RET_SLOW_COLD = "retaliationSlowCold";
    public static final String TYPE_RET_SLOW_DEFENSE = "retaliationSlowDefensiveAbility";
    public static final String TYPE_RET_SLOW_FIRE = "retaliationSlowFire";
    public static final String TYPE_RET_SLOW_LIFE = "retaliationSlowLife";
    public static final String TYPE_RET_SLOW_LIFE_LEECH = "retaliationSlowLifeLeach";
    public static final String TYPE_RET_SLOW_LIGHTNING = "retaliationSlowLightning";
    public static final String TYPE_RET_SLOW_MANA_LEECH = "retaliationSlowManaLeach";
    public static final String TYPE_RET_SLOW_OFFENSE = "retaliationSlowOffensiveAbility";
    public static final String TYPE_RET_SLOW_OFF_RED = "retaliationSlowOffensiveReduction";
    public static final String TYPE_RET_SLOW_PHYSICAL = "retaliationSlowPhysical";
    public static final String TYPE_RET_SLOW_POISON = "retaliationSlowPoison";
    public static final String TYPE_RET_SLOW_RUNSPEED = "retaliationSlowRunSpeed";
    public static final String TYPE_RET_STUN = "retaliationStun";
    public static final String TYPE_RET_TOTALDAMAGE = "retaliationTotalDamage";
    public static final String TYPE_RET_TRAP = "retaliationTrap";
    public static final int DMG_CLASS_DEFENSE = 1;
    public static final int DMG_CLASS_OFFENSE = 2;
    public static final int DMG_CLASS_RETALIATION = 3;
    public static final int DMG_TYPE_FLAT_POISON = 101;
    public static final int DMG_TYPE_FLAT_AETHER = 102;
    public static final int DMG_TYPE_FLAT_CHAOS = 103;
    public static final int DMG_TYPE_FLAT_COLD = 104;
    public static final int DMG_TYPE_FLAT_ELEMENTAL = 105;
    public static final int DMG_TYPE_FLAT_FIRE = 106;
    public static final int DMG_TYPE_FLAT_LIFE = 107;
    public static final int DMG_TYPE_FLAT_LIGHTNING = 108;
    public static final int DMG_TYPE_FLAT_PHYSICAL = 109;
    public static final int DMG_TYPE_FLAT_PIERCE = 110;
    public static final int DMG_TYPE_DOT_POISON = 201;
    public static final int DMG_TYPE_DOT_COLD = 204;
    public static final int DMG_TYPE_DOT_FIRE = 206;
    public static final int DMG_TYPE_DOT_LIFE = 207;
    public static final int DMG_TYPE_DOT_LIGHTNING = 208;
    public static final int DMG_TYPE_DOT_PHYSICAL = 209;
    public static final int DMG_TYPE_DOT_PIERCE = 210;
    public static final int DMG_TYPE_SPEC_TOTAL = 301;
    public static final int DMG_TYPE_SPEC_CRITICAL = 302;
    public static final int DMG_TYPE_SPEC_LIFELEECH = 303;
    public static final int DMG_TYPE_SPEC_REFLECTION = 304;
    public static final int DMG_TYPE_SPEC_SLOW_ATTACK = 305;
    public static final int DMG_TYPE_SPEC_SLOW_TOTAL = 306;
    public static final int DMG_TYPE_SPEC_SLOW_DA = 307;
    public static final int DMG_TYPE_SPEC_SLOW_OA = 308;
    private String itemID;
    private String type;
    private boolean global;
    private boolean xor;
    private int damageMin;
    private int damageMax;
    private int damageChance;
    private int damageModifier;
    private int damageModifierChance;
    private int durationMin;
    private int durationMax;
    private int durationChance;
    private int durationModifier;
    private int durationModifierChance;
    private int maxResist;
    private DBItem itemGlobal;
    private DBAffix affixGlobal;
    private int globalType;

    public DBDamage() {
        this.itemID = null;
        this.type = null;
        this.global = false;
        this.xor = false;
        this.damageMin = 0;
        this.damageMax = 0;
        this.damageChance = 0;
        this.damageModifier = 0;
        this.damageModifierChance = 0;
        this.durationMin = 0;
        this.durationMax = 0;
        this.durationChance = 0;
        this.durationModifier = 0;
        this.durationModifierChance = 0;
        this.maxResist = 0;
        this.itemGlobal = null;
        this.affixGlobal = null;
        this.globalType = 0;
    }

    private DBDamage(DBDamage damage) {
        this.itemID = damage.itemID;
        this.type = damage.type;
        this.global = damage.global;
        this.xor = damage.xor;
        this.damageMin = damage.damageMin;
        this.damageMax = damage.damageMax;
        this.damageChance = damage.damageChance;
        this.damageModifier = damage.damageModifier;
        this.damageModifierChance = damage.damageModifierChance;
        this.durationMin = damage.durationMin;
        this.durationMax = damage.durationMax;
        this.durationChance = damage.durationChance;
        this.durationModifier = damage.durationModifier;
        this.durationModifierChance = damage.durationModifierChance;
        this.maxResist = damage.maxResist;
        this.itemGlobal = damage.itemGlobal;
        this.affixGlobal = damage.affixGlobal;
        this.globalType = damage.globalType;
    }

    public Object clome() {
        return new DBDamage(this);
    }

    public boolean isInitial() {
        if (this.global) {
            return false;
        }
        if (this.xor) {
            return false;
        }
        if (this.damageMin != 0) {
            return false;
        }
        if (this.damageMax != 0) {
            return false;
        }
        if (this.damageChance != 0) {
            return false;
        }
        if (this.damageModifier != 0) {
            return false;
        }
        if (this.damageModifierChance != 0) {
            return false;
        }
        if (this.durationMin != 0) {
            return false;
        }
        if (this.durationMax != 0) {
            return false;
        }
        if (this.durationChance != 0) {
            return false;
        }
        if (this.durationModifier != 0) {
            return false;
        }
        if (this.durationModifierChance != 0) {
            return false;
        }
        return this.maxResist == 0;
    }

    public String getItemID() {
        return this.itemID;
    }

    public String getDamageType() {
        return this.type;
    }

    public boolean isGlobal() {
        return this.global;
    }

    public boolean isXOR() {
        return this.xor;
    }

    public int getMinDamage() {
        return this.damageMin;
    }

    public int getMaxDamage() {
        return this.damageMax;
    }

    public int getDamageChance() {
        return this.damageChance;
    }

    public int getDamageModifier() {
        return this.damageModifier;
    }

    public int getDamageModifierChance() {
        return this.damageModifierChance;
    }

    public int getMinDuration() {
        return this.durationMin;
    }

    public int getMaxDuration() {
        return this.durationMax;
    }

    public int getDurationChance() {
        return this.durationChance;
    }

    public int getDurationModifier() {
        return this.durationModifier;
    }

    public int getDurationModifierChance() {
        return this.durationModifierChance;
    }

    public int getMaxResist() {
        return this.maxResist;
    }

    public int getGlobalOffensePerc() {
        if (this.itemGlobal != null) {
            return this.itemGlobal.getOffensiveChance();
        }
        if (this.affixGlobal != null) {
            return this.affixGlobal.getOffensiveChance();
        }
        return -1;
    }

    public int getGlobalRetaliationPerc() {
        if (this.itemGlobal != null) {
            return this.itemGlobal.getRetaliationChance();
        }
        if (this.affixGlobal != null) {
            return this.affixGlobal.getRetaliationChance();
        }
        return -1;
    }

    public int getGlobalCategory() {
        return this.globalType;
    }

    public void setItemID(String itemID) {
        this.itemID = itemID;
    }

    public void setDamageType(String type) {
        this.type = type;
    }

    public void setGlobal(boolean global) {
        this.global = global;
    }

    public void setXOR(boolean xor) {
        this.xor = xor;
    }

    public void setMinDamage(int damageMin) {
        this.damageMin = damageMin;
    }

    public void setMaxDamage(int damageMax) {
        this.damageMax = damageMax;
    }

    public void setDamageChance(int damageChance) {
        this.damageChance = damageChance;
    }

    public void setDamageModifier(int damageModifier) {
        this.damageModifier = damageModifier;
    }

    public void setDamageModifierChance(int damageModifierChance) {
        this.damageModifierChance = damageModifierChance;
    }

    public void setMinDuration(int durationMin) {
        this.durationMin = durationMin;
    }

    public void setMaxDuration(int durationMax) {
        this.durationMax = durationMax;
    }

    public void setDurationChance(int durationChance) {
        this.durationChance = durationChance;
    }

    public void setDurationModifier(int durationModifier) {
        this.durationModifier = durationModifier;
    }

    public void setDurationModifierChance(int durationModifierChance) {
        this.durationModifierChance = durationModifierChance;
    }

    public void setMaxResist(int maxResist) {
        this.maxResist = maxResist;
    }

    public static void createTable(Connection conn, String tabName, String idName) throws SQLException {
        String dropTable = "DROP TABLE " + tabName;
        String createTable = "CREATE TABLE " + tabName + " (" + idName + "    VARCHAR(256) NOT NULL, " + "DAMAGE_TYPE  VARCHAR(64) NOT NULL, " + "FLAG_GLOBAL  BOOLEAN, " + "FLAG_XOR     BOOLEAN, " + "DAMAGE_MIN    INTEGER, " + "DAMAGE_MAX    INTEGER, " + "DAMAGE_CHANCE INTEGER, " + "MODIFIER        INTEGER, " + "MODIFIER_CHANCE INTEGER, " + "DURATION_MIN    INTEGER, " + "DURATION_MAX    INTEGER, " + "DURATION_CHANCE INTEGER, " + "DURATION_MODIFIER        INTEGER, " + "DURATION_MODIFIER_CHANCE INTEGER, " + "MAX_RESIST   INTEGER, " + "PRIMARY KEY (" + idName + ", DAMAGE_TYPE))";
        try (Statement st = conn.createStatement();){
            if (GDDBUtil.tableExists(conn, tabName)) {
                st.execute(dropTable);
            }
            st.execute(createTable);
            st.close();
            conn.commit();
        }
        catch (SQLException ex) {
            Object[] args = new Object[]{tabName};
            String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_CREATE_TABLE", args);
            GDMsgLogger.addError(msg);
            throw ex;
        }
    }

    public static void delete(Connection conn, String tabName, String idName, String itemID) throws SQLException {
        String deleteEntry = "DELETE FROM " + tabName + " WHERE " + idName + " = ?";
        try (PreparedStatement ps = conn.prepareStatement(deleteEntry);){
            ps.setString(1, itemID);
            ps.executeUpdate();
            ps.close();
        }
    }

    public static void insert(Connection conn, String tabName, String id, List<DBDamage> damages) throws SQLException {
        String insert = "INSERT INTO " + tabName + " VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        if (damages == null) {
            return;
        }
        if (damages.isEmpty()) {
            return;
        }
        try (PreparedStatement ps = conn.prepareStatement(insert);){
            for (DBDamage damage : damages) {
                if (damage.isInitial()) continue;
                ps.setString(1, id);
                ps.setString(2, damage.type);
                ps.setBoolean(3, damage.global);
                ps.setBoolean(4, damage.xor);
                ps.setInt(5, damage.damageMin);
                ps.setInt(6, damage.damageMax);
                ps.setInt(7, damage.damageChance);
                ps.setInt(8, damage.damageModifier);
                ps.setInt(9, damage.damageModifierChance);
                ps.setInt(10, damage.durationMin);
                ps.setInt(11, damage.durationMax);
                ps.setInt(12, damage.durationChance);
                ps.setInt(13, damage.durationModifier);
                ps.setInt(14, damage.durationModifierChance);
                ps.setInt(15, damage.maxResist);
                ps.executeUpdate();
                ps.clearParameters();
            }
            ps.close();
            conn.commit();
        }
    }

    public static List<DBDamage> getByItemID(String itemID) {
        List<DBDamage> list = new LinkedList<DBDamage>();
        String command = "SELECT * FROM GD_ITEM_DAMAGE WHERE ITEM_ID = ?";
        try (Connection conn = GDDBData.getConnection();
             PreparedStatement ps = conn.prepareStatement(command);){
            ps.setString(1, itemID);
            try (ResultSet rs = ps.executeQuery();){
                list = DBDamage.wrap(rs);
                conn.commit();
            }
        }
        catch (SQLException ex) {
            Object[] args = new Object[]{itemID, "GD_ITEM_DAMAGE"};
            String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_READ_TABLE_BY_ID", args);
            GDMsgLogger.addError(msg);
            GDMsgLogger.addError(ex);
        }
        return list;
    }

    public static List<DBDamage> getByAffixID(String affixID) {
        List<DBDamage> list = new LinkedList<DBDamage>();
        String command = "SELECT * FROM GD_AFFIX_DAMAGE WHERE AFFIX_ID = ?";
        try (Connection conn = GDDBData.getConnection();
             PreparedStatement ps = conn.prepareStatement(command);){
            ps.setString(1, affixID);
            try (ResultSet rs = ps.executeQuery();){
                list = DBDamage.wrap(rs);
                conn.commit();
            }
        }
        catch (SQLException ex) {
            Object[] args = new Object[]{affixID, "GD_AFFIX_DAMAGE"};
            String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_READ_TABLE_BY_ID", args);
            GDMsgLogger.addError(msg);
            GDMsgLogger.addError(ex);
        }
        return list;
    }

    public static List<DBDamage> getBySkillID(String skillID) {
        List<DBDamage> list = new LinkedList<DBDamage>();
        String command = "SELECT * FROM GD_SKILL_DAMAGE WHERE SKILL_ID = ?";
        try (Connection conn = GDDBData.getConnection();
             PreparedStatement ps = conn.prepareStatement(command);){
            ps.setString(1, skillID);
            try (ResultSet rs = ps.executeQuery();){
                list = DBDamage.wrap(rs);
                conn.commit();
            }
        }
        catch (SQLException ex) {
            Object[] args = new Object[]{skillID, "GD_SKILL_DAMAGE"};
            String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_READ_TABLE_BY_ID", args);
            GDMsgLogger.addError(msg);
            GDMsgLogger.addError(ex);
        }
        return list;
    }

    private static List<DBDamage> wrap(ResultSet rs) throws SQLException {
        LinkedList<DBDamage> list = new LinkedList<DBDamage>();
        while (rs.next()) {
            DBDamage damage = new DBDamage();
            damage.itemID = rs.getString(1);
            damage.type = rs.getString(2);
            damage.global = rs.getBoolean(3);
            damage.xor = rs.getBoolean(4);
            damage.damageMin = rs.getInt(5);
            damage.damageMax = rs.getInt(6);
            damage.damageChance = rs.getInt(7);
            damage.damageModifier = rs.getInt(8);
            damage.damageModifierChance = rs.getInt(9);
            damage.durationMin = rs.getInt(10);
            damage.durationMax = rs.getInt(11);
            damage.durationChance = rs.getInt(12);
            damage.durationModifier = rs.getInt(13);
            damage.durationModifierChance = rs.getInt(14);
            damage.maxResist = rs.getInt(15);
            list.add(damage);
        }
        return list;
    }

    public static void add(List<DBDamage> list, DBItem item, int globalType, List<DBDamage> addList) {
        DBDamage.add(list, item, null, globalType, addList);
    }

    public static void add(List<DBDamage> list, DBAffix affix, int globalType, List<DBDamage> addList) {
        DBDamage.add(list, null, affix, globalType, addList);
    }

    private static void add(List<DBDamage> list, DBItem item, DBAffix affix, int globalType, List<DBDamage> addList) {
        if (addList == null) {
            return;
        }
        for (DBDamage dmgAdd : addList) {
            try {
                dmgAdd = (DBDamage)dmgAdd.clone();
            }
            catch (CloneNotSupportedException ex) {
                // empty catch block
            }
            if (dmgAdd.global) {
                if (item != null) {
                    dmgAdd.itemGlobal = item;
                }
                if (affix != null) {
                    dmgAdd.affixGlobal = affix;
                }
                dmgAdd.globalType = globalType;
                list.add(dmgAdd);
                continue;
            }
            for (DBDamage damage : list) {
                boolean match;
                if (damage.global || !dmgAdd.type.equals(damage.type)) continue;
                if (dmgAdd.damageMin > 0) {
                    if (damage.damageMin == 0) {
                        damage.damageMin = dmgAdd.damageMin;
                        damage.damageMax = dmgAdd.damageMax;
                        damage.damageChance = dmgAdd.damageChance;
                        damage.durationMin = dmgAdd.durationMin;
                        dmgAdd.damageMin = 0;
                        dmgAdd.damageMax = 0;
                        dmgAdd.damageChance = 0;
                        dmgAdd.durationMin = 0;
                    } else {
                        match = true;
                        if (dmgAdd.durationMin != damage.durationMin) {
                            match = false;
                        }
                        if (dmgAdd.damageChance != damage.damageChance) {
                            match = false;
                        }
                        if (match) {
                            damage.damageMin += dmgAdd.damageMin;
                            if (damage.damageMax > 0) {
                                damage.damageMax = dmgAdd.damageMax > 0 ? (damage.damageMax += dmgAdd.damageMax) : (damage.damageMax += dmgAdd.damageMin);
                            } else if (dmgAdd.damageMax > 0) {
                                damage.damageMax = damage.damageMin + dmgAdd.damageMax;
                            }
                            dmgAdd.damageMin = 0;
                            dmgAdd.damageMax = 0;
                            dmgAdd.damageChance = 0;
                            dmgAdd.durationMin = 0;
                        }
                    }
                }
                if (dmgAdd.damageModifier > 0) {
                    if (damage.damageModifier == 0) {
                        damage.damageModifier = dmgAdd.damageModifier;
                        damage.damageModifierChance = dmgAdd.damageModifierChance;
                        dmgAdd.damageModifier = 0;
                        dmgAdd.damageModifierChance = 0;
                    } else {
                        match = true;
                        if (dmgAdd.damageModifierChance != damage.damageModifierChance) {
                            match = false;
                        }
                        if (match) {
                            damage.damageModifier += dmgAdd.damageModifier;
                            dmgAdd.damageModifier = 0;
                            dmgAdd.damageModifierChance = 0;
                        }
                    }
                }
                if (dmgAdd.maxResist <= 0) continue;
                damage.maxResist += dmgAdd.maxResist;
                dmgAdd.maxResist = 0;
            }
            if (dmgAdd.isInitial() || dmgAdd.global) continue;
            list.add(dmgAdd);
        }
    }

    public BonusDetail getBonusDetail(DBStashItem item, int detailType, String prefix) {
        BonusDetail bonus = null;
        if (this.type == null) {
            return bonus;
        }
        bonus = new BonusDetail(item, detailType, this, prefix);
        return bonus;
    }
}

