/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;
import net.objecthunter.exp4j.Expression;
import net.objecthunter.exp4j.ExpressionBuilder;
import org.gdstash.db.GDDBData;
import org.gdstash.db.GDDBUtil;
import org.gdstash.file.ARZRecord;
import org.gdstash.file.GDParseException;
import org.gdstash.util.GDConstants;
import org.gdstash.util.GDMsgFormatter;
import org.gdstash.util.GDMsgLogger;

public class DBEnginePlayer {
    public static final String TABLE_NAME = "GDC_PLAYER";
    public static final int ROW_ID = 1;
    public static final int ROW_INCREMENT_DEX = 2;
    public static final int ROW_INCREMENT_INT = 3;
    public static final int ROW_INCREMENT_STR = 4;
    public static final int ROW_INCREMENT_LIFE = 5;
    public static final int ROW_INCREMENT_MANA = 6;
    public static final int ROW_MAX_LEVEL = 7;
    public static final int ROW_XP_FORMULA = 8;
    private int incDex;
    private int incInt;
    private int incStr;
    private int incLife;
    private int incMana;
    private int maxLevel;
    private String xpFormula;
    private Expression expression;

    public DBEnginePlayer() {
        this.incDex = 8;
        this.incInt = 8;
        this.incStr = 8;
        this.incLife = 20;
        this.incMana = 16;
        this.expression = null;
    }

    private DBEnginePlayer(ARZRecord record) {
        this.incDex = record.getPlayerIncDex();
        this.incInt = record.getPlayerIncInt();
        this.incStr = record.getPlayerIncStr();
        this.incLife = record.getPlayerIncLife();
        this.incMana = record.getPlayerIncMana();
        this.maxLevel = record.getPlayerMaxLevel();
        try {
            this.setXPFormula(record.getXPFormula());
        }
        catch (GDParseException ex) {
            GDMsgLogger.addError(ex);
            this.expression = null;
        }
    }

    public int getIncDex() {
        return this.incDex;
    }

    public int getIncInt() {
        return this.incInt;
    }

    public int getIncStr() {
        return this.incStr;
    }

    public int getIncLife() {
        return this.incLife;
    }

    public int getIncMana() {
        return this.incMana;
    }

    public int getMaxLevel() {
        return this.maxLevel;
    }

    public String getXPFormula() {
        return this.xpFormula;
    }

    private void setXPFormula(String xpFormula) throws GDParseException {
        this.xpFormula = xpFormula;
        if (xpFormula != null) {
            ExpressionBuilder builder = new ExpressionBuilder(xpFormula);
            builder = builder.variables("playerLevel");
            builder = builder.variables("PLAYERLEVEL");
            try {
                this.expression = builder.build();
            }
            catch (Throwable ex) {
                throw new GDParseException(ex.getMessage());
            }
        }
    }

    public void setPlayerLevel(int level) {
        if (this.expression == null) {
            return;
        }
        this.expression.setVariable("playerLevel", level);
        this.expression.setVariable("PLAYERLEVEL", level);
    }

    public double getValue() {
        if (this.expression == null) {
            return 0.0;
        }
        double value = this.expression.evaluate();
        return value;
    }

    public static void createTable() throws SQLException {
        String dropTable = "DROP TABLE GDC_PLAYER";
        String createTable = "CREATE TABLE GDC_PLAYER (ID          VARCHAR(8) NOT NULL, INC_DEX     INTEGER, INC_INT     INTEGER, INC_STR     INTEGER, INC_LIFE    INTEGER, INC_MANA    INTEGER, MAX_LEVEL   INTEGER, XP_FORMULA  VARCHAR(256), PRIMARY KEY (ID))";
        try (Connection conn = GDDBData.getConnection();){
            boolean auto = conn.getAutoCommit();
            conn.setAutoCommit(false);
            try (Statement st = conn.createStatement();){
                if (GDDBUtil.tableExists(conn, TABLE_NAME)) {
                    st.execute(dropTable);
                }
                st.execute(createTable);
                st.close();
                conn.commit();
            }
            catch (SQLException ex) {
                conn.rollback();
                Object[] args = new Object[]{"DBEnginePlayer"};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_CREATE_TABLE", args);
                GDMsgLogger.addError(msg);
                throw ex;
            }
            finally {
                conn.setAutoCommit(auto);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void delete() throws SQLException {
        String deleteEntry = "DELETE FROM GDC_PLAYER WHERE ID = ?";
        try (Connection conn = GDDBData.getConnection();){
            boolean auto = conn.getAutoCommit();
            conn.setAutoCommit(false);
            try (PreparedStatement ps = conn.prepareStatement(deleteEntry);){
                ps.setString(1, "DEFAULT");
                ps.executeUpdate();
                ps.close();
                conn.commit();
            }
            catch (SQLException ex) {
                conn.rollback();
            }
            finally {
                conn.setAutoCommit(auto);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static void insert(ARZRecord record) throws SQLException {
        DBEnginePlayer player = new DBEnginePlayer(record);
        String insert = "INSERT INTO GDC_PLAYER VALUES (?,?,?,?,?,?,?,?)";
        try (Connection conn = GDDBData.getConnection();){
            boolean auto = conn.getAutoCommit();
            conn.setAutoCommit(false);
            try (PreparedStatement ps = conn.prepareStatement(insert);){
                ps.setString(1, "DEFAULT");
                ps.setInt(2, player.getIncDex());
                ps.setInt(3, player.getIncInt());
                ps.setInt(4, player.getIncStr());
                ps.setInt(5, player.getIncLife());
                ps.setInt(6, player.getIncMana());
                ps.setInt(7, player.getMaxLevel());
                ps.setString(8, player.getXPFormula());
                ps.executeUpdate();
                ps.close();
                conn.commit();
            }
            catch (SQLException ex) {
                conn.rollback();
                GDMsgLogger.addError(GDMsgFormatter.getString(GDMsgFormatter.rbMsg, "ERR_IN_PLAYER_CONFIG"));
                throw ex;
            }
            finally {
                conn.setAutoCommit(auto);
            }
        }
    }

    public static void insertMod(ARZRecord record) throws SQLException {
        DBEnginePlayer entry = DBEnginePlayer.get();
        if (entry != null) {
            DBEnginePlayer.delete();
        }
        DBEnginePlayer.insert(record);
    }

    public static DBEnginePlayer get() {
        DBEnginePlayer player = new DBEnginePlayer();
        String command = "SELECT * FROM GDC_PLAYER WHERE ID = ?";
        try (Connection conn = GDDBData.getConnection();
             PreparedStatement ps = conn.prepareStatement(command);){
            ps.setString(1, "DEFAULT");
            try (ResultSet rs = ps.executeQuery();){
                List<DBEnginePlayer> list = DBEnginePlayer.wrap(rs);
                player = list.isEmpty() ? null : list.get(0);
                conn.commit();
            }
        }
        catch (SQLException ex) {
            GDMsgLogger.addError(GDMsgFormatter.getString(GDMsgFormatter.rbMsg, "ERR_READ_CONFIG_PLAYER"));
            GDMsgLogger.addError(ex);
            player = null;
        }
        return player;
    }

    private static List<DBEnginePlayer> wrap(ResultSet rs) throws SQLException {
        LinkedList<DBEnginePlayer> list = new LinkedList<DBEnginePlayer>();
        while (rs.next()) {
            DBEnginePlayer player = new DBEnginePlayer();
            player.incDex = rs.getInt(2);
            player.incInt = rs.getInt(3);
            player.incStr = rs.getInt(4);
            player.incLife = rs.getInt(5);
            player.incMana = rs.getInt(6);
            player.maxLevel = rs.getInt(7);
            player.xpFormula = rs.getString(8);
            if (player.xpFormula != null) {
                player.xpFormula = player.xpFormula.toUpperCase(GDConstants.LOCALE_US);
            }
            try {
                player.setXPFormula(player.xpFormula);
            }
            catch (GDParseException gDParseException) {
                // empty catch block
            }
            list.add(player);
        }
        return list;
    }
}

