/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;
import org.gdstash.db.GDDBData;
import org.gdstash.db.GDDBUtil;
import org.gdstash.file.ARZRecord;
import org.gdstash.ui.GDStashFrame;
import org.gdstash.util.GDMsgFormatter;
import org.gdstash.util.GDMsgLogger;

public class DBFactionReputation {
    public static final String TABLE_NAME = "GDC_FACTION_REPUTATION";
    public static final int ROW_INDEX = 1;
    public static final int ROW_VALUE = 2;
    public static final int ROW_STATE_TAG = 3;
    public static final int ROW_STATE = 4;
    private int index;
    private int value;
    private String stateTag;
    private String stateText;

    public int getIndex() {
        return this.index;
    }

    public int getValue() {
        return this.value;
    }

    public String getStateTag() {
        return this.stateTag;
    }

    public String getStateText() {
        return this.stateText;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public void setValue(int value) {
        this.value = value;
    }

    public void setStateTag(String stateTag) {
        this.stateTag = stateTag;
        this.stateText = stateTag == null ? null : GDStashFrame.arcList.getTag("tags_ui.txt", stateTag);
    }

    public static void createTable(Connection conn) throws SQLException {
        String dropTable = "DROP TABLE GDC_FACTION_REPUTATION";
        String createTable = "CREATE TABLE GDC_FACTION_REPUTATION (INDEX       INTEGER NOT NULL, VALUE       INTEGER, STATE_TAG   VARCHAR(64), STATE_TEXT  VARCHAR(64), PRIMARY KEY (INDEX))";
        try (Statement st = conn.createStatement();){
            if (GDDBUtil.tableExists(conn, TABLE_NAME)) {
                st.execute(dropTable);
            }
            st.execute(createTable);
            st.close();
            conn.commit();
        }
        catch (SQLException ex) {
            conn.rollback();
            Object[] args = new Object[]{"DBFactionReputation"};
            String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_CREATE_TABLE", args);
            GDMsgLogger.addError(msg);
            throw ex;
        }
    }

    public static void delete(Connection conn) throws SQLException {
        String deleteEntry = "DELETE FROM GDC_FACTION_REPUTATION";
        try (PreparedStatement ps = conn.prepareStatement(deleteEntry);){
            ps.executeUpdate();
            ps.close();
        }
    }

    public static void insert(Connection conn, ARZRecord record, DBFactionReputation reputation) throws SQLException {
        String insert = "INSERT INTO GDC_FACTION_REPUTATION VALUES (?,?,?,?)";
        try (PreparedStatement ps = conn.prepareStatement(insert);){
            if (reputation.index > 0) {
                ps.setInt(1, reputation.index);
                ps.setInt(2, reputation.value);
                ps.setString(3, reputation.stateTag);
                ps.setString(4, reputation.stateText);
                ps.executeUpdate();
                ps.clearParameters();
                ps.close();
                conn.commit();
            }
        }
    }

    public static List<DBFactionReputation> get() {
        List<DBFactionReputation> list = null;
        String command = "SELECT * FROM GDC_FACTION_REPUTATION";
        try (Connection conn = GDDBData.getConnection();
             PreparedStatement ps = conn.prepareStatement(command);
             ResultSet rs = ps.executeQuery();){
            list = DBFactionReputation.wrap(rs);
            conn.commit();
        }
        catch (SQLException ex) {
            Object[] args = new Object[]{"-", "DBFactionReputation"};
            String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_READ_TABLE_BY_ID", args);
            GDMsgLogger.addError(msg);
            GDMsgLogger.addError(ex);
        }
        return list;
    }

    private static List<DBFactionReputation> wrap(ResultSet rs) throws SQLException {
        LinkedList<DBFactionReputation> list = new LinkedList<DBFactionReputation>();
        while (rs.next()) {
            DBFactionReputation rep = new DBFactionReputation();
            rep.index = rs.getInt(1);
            rep.value = rs.getInt(2);
            rep.stateTag = rs.getString(3);
            rep.stateText = rs.getString(4);
            if (rep.index <= 0) continue;
            list.add(rep);
        }
        return list;
    }
}

