/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.gdstash.db.DBFormula;
import org.gdstash.db.GDDBData;
import org.gdstash.db.GDDBUtil;
import org.gdstash.db.ParameterSet;
import org.gdstash.file.ARZRecord;
import org.gdstash.util.GDMsgFormatter;
import org.gdstash.util.GDMsgLogger;

public class DBFormulaSet {
    public static final String TABLE_NAME = "GD_FORMULASET";
    public static final int ROW_FORMULASET_ID = 1;
    private static ConcurrentHashMap<String, DBFormulaSet> hashBuffer = new ConcurrentHashMap();
    private String formulaSetID;
    private List<DBFormula> formulas;
    private ParameterSet parameterSet;

    public DBFormulaSet() {
        this.formulas = new LinkedList<DBFormula>();
        this.parameterSet = null;
    }

    public DBFormulaSet(ARZRecord record) {
        this.formulaSetID = record.getFileName();
        this.formulas = record.getFormulaSetFormulaList();
        this.parameterSet = null;
    }

    public String getFormulaSetID() {
        return this.formulaSetID;
    }

    public List<DBFormula> getFormulaList() {
        return this.formulas;
    }

    public Result getResult(ParameterSet ps) {
        this.parameterSet = ps;
        for (DBFormula formula : this.formulas) {
            formula.setParameterSet(this.parameterSet);
        }
        return this.getResult();
    }

    private Result getResult() {
        if (this.parameterSet == null) {
            return null;
        }
        Result result = new Result();
        String itemClass = this.parameterSet.getItemClass();
        if (itemClass.equals("ArmorProtective_Head")) {
            result.cost = this.getValue("armorCostEquation");
            result.physique = this.getValue("headStrengthEquation");
            result.spirit = this.getValue("headIntelligenceEquation");
        }
        if (itemClass.equals("ArmorProtective_Shoulders")) {
            result.cost = this.getValue("armorCostEquation");
            result.physique = this.getValue("shouldersStrengthEquation");
        }
        if (itemClass.equals("ArmorProtective_Chest")) {
            result.cost = this.getValue("armorCostEquation");
            result.cunning = 0.0;
            result.physique = this.getValue("chestStrengthEquation");
            result.spirit = this.getValue("chestIntelligenceEquation");
        }
        if (itemClass.equals("ArmorProtective_Hands")) {
            result.cost = this.getValue("armorCostEquation");
            result.physique = this.getValue("handsStrengthEquation");
        }
        if (itemClass.equals("ArmorProtective_Legs")) {
            result.cost = this.getValue("armorCostEquation");
            result.physique = this.getValue("legsStrengthEquation");
        }
        if (itemClass.equals("ArmorProtective_Feet")) {
            result.cost = this.getValue("armorCostEquation");
            result.physique = this.getValue("feetStrengthEquation");
        }
        if (itemClass.equals("ArmorProtective_Waist")) {
            result.cost = this.getValue("armorCostEquation");
            result.physique = this.getValue("waistStrengthEquation");
        }
        if (itemClass.equals("ArmorJewelry_Amulet")) {
            result.cost = this.getValue("jewelryCostEquation");
            result.spirit = this.getValue("amuletIntelligenceEquation");
        }
        if (itemClass.equals("ArmorJewelry_Medal")) {
            result.cost = this.getValue("jewelryCostEquation");
            result.spirit = this.getValue("amuletIntelligenceEquation");
        }
        if (itemClass.equals("ArmorJewelry_Ring")) {
            result.cost = this.getValue("jewelryCostEquation");
            result.spirit = this.getValue("ringIntelligenceEquation");
        }
        if (itemClass.equals("WeaponArmor_Offhand")) {
            result.cost = this.getValue("offhandCostEquation");
            result.spirit = this.getValue("offhandIntelligenceEquation");
        }
        if (itemClass.equals("WeaponArmor_Shield")) {
            result.cost = this.getValue("shieldCostEquation");
            result.physique = this.getValue("shieldStrengthEquation");
        }
        if (itemClass.equals("WeaponMelee_Axe")) {
            result.cost = this.getValue("weaponCostEquation");
            result.physique = this.getValue("axeStrengthEquation");
        }
        if (itemClass.equals("WeaponMelee_Mace")) {
            result.cost = this.getValue("weaponCostEquation");
            result.physique = this.getValue("maceStrengthEquation");
        }
        if (itemClass.equals("WeaponMelee_Sword")) {
            result.cost = this.getValue("weaponCostEquation");
            result.cunning = this.getValue("swordDexterityEquation");
        }
        if (itemClass.equals("WeaponMelee_Dagger")) {
            result.cost = this.getValue("weaponCostEquation");
            result.cunning = this.getValue("daggerDexterityEquation");
            result.spirit = this.getValue("daggerIntelligenceEquation");
        }
        if (itemClass.equals("WeaponMelee_Scepter")) {
            result.cost = this.getValue("weaponCostEquation");
            result.physique = this.getValue("scepterStrengthEquation");
            result.spirit = this.getValue("scepterIntelligenceEquation");
        }
        if (itemClass.equals("WeaponHunting_Ranged1h")) {
            result.cost = this.getValue("weaponRangedCostEquation");
            result.cunning = this.getValue("ranged1hDexterityEquation");
        }
        if (itemClass.equals("WeaponMelee_Axe2h")) {
            result.cost = this.getValue("weaponMelee2hCostEquation");
            result.physique = this.getValue("melee2hStrengthEquation");
        }
        if (itemClass.equals("WeaponMelee_Mace2h")) {
            result.cost = this.getValue("weaponMelee2hCostEquation");
            result.physique = this.getValue("melee2hStrengthEquation");
        }
        if (itemClass.equals("WeaponHunting_Spear")) {
            result.cost = this.getValue("weaponMelee2hCostEquation");
            result.physique = this.getValue("melee2hStrengthEquation");
        }
        if (itemClass.equals("WeaponMagical_Staff")) {
            result.cost = this.getValue("weaponCostEquation");
            result.cunning = this.getValue("daggerDexterityEquation");
            result.spirit = this.getValue("daggerIntelligenceEquation");
        }
        if (itemClass.equals("WeaponMelee_Sword2h")) {
            result.cost = this.getValue("weaponMelee2hCostEquation");
            result.physique = this.getValue("melee2hStrengthEquation");
        }
        if (itemClass.equals("WeaponHunting_Ranged2h")) {
            result.cost = this.getValue("weaponRanged2hCostEquation");
            result.cunning = this.getValue("ranged2hDexterityEquation");
        }
        return result;
    }

    private double getValue(String formulaID) {
        double value = 0.0;
        for (DBFormula formula : this.formulas) {
            if (!formula.getFormulaID().equals(formulaID)) continue;
            try {
                value = formula.getValue();
            }
            catch (IllegalStateException ex) {
                value = 0.0;
            }
            break;
        }
        return value;
    }

    public static void clearBuffer() {
        hashBuffer.clear();
    }

    public static void createTables() throws SQLException {
        String dropTable = "DROP TABLE GD_FORMULASET";
        String createTable = "CREATE TABLE GD_FORMULASET (FORMULASET_ID      VARCHAR(256) NOT NULL, PRIMARY KEY (FORMULASET_ID))";
        try (Connection conn = GDDBData.getConnection();){
            boolean auto = conn.getAutoCommit();
            conn.setAutoCommit(false);
            try (Statement st = conn.createStatement();){
                if (GDDBUtil.tableExists(conn, TABLE_NAME)) {
                    st.execute(dropTable);
                }
                st.execute(createTable);
                st.close();
                conn.commit();
            }
            catch (SQLException ex) {
                conn.rollback();
                Object[] args = new Object[]{"DBFormulaSet"};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_CREATE_TABLE", args);
                GDMsgLogger.addError(msg);
                throw ex;
            }
            finally {
                conn.setAutoCommit(auto);
            }
        }
        DBFormula.createTable();
    }

    public static void delete(String formulaSetID) throws SQLException {
        String deleteEntry = "DELETE FROM GD_FORMULASET WHERE FORMULASET_ID = ?";
        try (Connection conn = GDDBData.getConnection();){
            boolean auto = conn.getAutoCommit();
            conn.setAutoCommit(false);
            try (PreparedStatement ps = conn.prepareStatement(deleteEntry);){
                ps.setString(1, formulaSetID);
                ps.executeUpdate();
                ps.close();
                DBFormula.delete(conn, formulaSetID);
                conn.commit();
            }
            catch (SQLException ex) {
                conn.rollback();
                Object[] args = new Object[]{formulaSetID, "DBFormulaSet"};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_DEL_TABLE_BY_ID", args);
                GDMsgLogger.addError(msg);
                GDMsgLogger.addError(ex);
                throw ex;
            }
            finally {
                conn.setAutoCommit(auto);
            }
        }
    }

    public static void insert(ARZRecord record) throws SQLException {
        DBFormulaSet formulaSet = new DBFormulaSet(record);
        String insert = "INSERT INTO GD_FORMULASET VALUES (?)";
        try (Connection conn = GDDBData.getConnection();){
            boolean auto = conn.getAutoCommit();
            conn.setAutoCommit(false);
            try (PreparedStatement ps = conn.prepareStatement(insert);){
                ps.setString(1, record.getFileName());
                ps.executeUpdate();
                ps.close();
                conn.commit();
                DBFormula.insert(conn, formulaSet);
            }
            catch (SQLException ex) {
                conn.rollback();
                Object[] args = new Object[]{formulaSet.getFormulaSetID()};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_IN_FORMULASET", args);
                GDMsgLogger.addError(msg);
                throw ex;
            }
            finally {
                conn.setAutoCommit(auto);
            }
        }
    }

    public static void insertMod(ARZRecord record) throws SQLException {
        DBFormulaSet entry = DBFormulaSet.get(record.getFileName());
        if (entry != null) {
            DBFormulaSet.delete(record.getFileName());
        }
        DBFormulaSet.insert(record);
    }

    public static DBFormulaSet get(String formulaSetID) {
        DBFormulaSet set = null;
        set = hashBuffer.get(formulaSetID);
        if (set == null && (set = DBFormulaSet.getDB(formulaSetID)) != null) {
            hashBuffer.put(set.formulaSetID, set);
        }
        return set;
    }

    private static DBFormulaSet getDB(String formulaSetID) {
        DBFormulaSet set = null;
        String command = "SELECT * FROM GD_FORMULASET WHERE FORMULASET_ID = ?";
        try (Connection conn = GDDBData.getConnection();
             PreparedStatement ps = conn.prepareStatement(command);){
            ps.setString(1, formulaSetID);
            try (ResultSet rs = ps.executeQuery();){
                List<DBFormulaSet> list = DBFormulaSet.wrap(rs);
                set = list.isEmpty() ? null : list.get(0);
                conn.commit();
            }
        }
        catch (SQLException ex) {
            Object[] args = new Object[]{formulaSetID, "DBFormulaSet"};
            String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_READ_TABLE_BY_ID", args);
            GDMsgLogger.addError(msg);
            GDMsgLogger.addError(ex);
        }
        return set;
    }

    public static List<DBFormulaSet> getByFormulaSetIDs(List<String> formulaSetIDs) {
        LinkedList<DBFormulaSet> list = new LinkedList<DBFormulaSet>();
        for (String formulaSetID : formulaSetIDs) {
            DBFormulaSet set = DBFormulaSet.get(formulaSetID);
            if (set == null) continue;
            list.add(set);
        }
        return list;
    }

    private static List<DBFormulaSet> wrap(ResultSet rs) throws SQLException {
        LinkedList<DBFormulaSet> list = new LinkedList<DBFormulaSet>();
        while (rs.next()) {
            DBFormulaSet set = new DBFormulaSet();
            set.formulaSetID = rs.getString(1);
            if (set.formulaSetID != null) {
                set.formulas = DBFormula.getByFormulaSetID(set.formulaSetID);
            }
            list.add(set);
        }
        return list;
    }

    public static class Result {
        public double cost = 0.0;
        public double cunning = 0.0;
        public double physique = 0.0;
        public double spirit = 0.0;
    }
}

