/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.db;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.gdstash.db.DBAffixSet;
import org.gdstash.db.DBCharBonus;
import org.gdstash.db.DBDamage;
import org.gdstash.db.DBFormulaSet;
import org.gdstash.db.DBItemCraft;
import org.gdstash.db.DBLootTableItemAlloc;
import org.gdstash.db.DBSkill;
import org.gdstash.db.DBSkillBonus;
import org.gdstash.db.DamageCriteriaCombination;
import org.gdstash.db.GDDBData;
import org.gdstash.db.GDDBUtil;
import org.gdstash.db.ItemClass;
import org.gdstash.db.ItemCriteriaCombination;
import org.gdstash.db.ItemSlots;
import org.gdstash.db.ParameterSet;
import org.gdstash.db.SelectionCriteria;
import org.gdstash.db.criteria.AbstractItemCombination;
import org.gdstash.db.criteria.ItemIDItemCombination;
import org.gdstash.db.criteria.ItemIDItemDamageCombination;
import org.gdstash.file.ARZDecompress;
import org.gdstash.file.ARZRecord;
import org.gdstash.file.DDSLoader;
import org.gdstash.file.GDParseException;
import org.gdstash.ui.GDStashFrame;
import org.gdstash.util.GDMsgFormatter;
import org.gdstash.util.GDMsgLogger;

public class DBItem
implements Comparable,
ParameterSet {
    public static final String TABLE_NAME = "GD_ITEM";
    public static final String FIELD_ID = "ITEM_ID";
    public static final String TABLE_DAMAGE = "GD_ITEM_DAMAGE";
    public static final String TABLE_SKILLS = "GD_ITEM_SKILLS";
    public static final String TABLE_CHAR = "GD_ITEM_CHAR";
    public static final String TABLE_RACE = "GD_ITEM_CHARRACES";
    public static final int BLOB_SIZE_IMAGE = 65536;
    public static final int BLOB_SIZE_SHARD = 32768;
    public static final int ROW_ITEM_ID = 1;
    public static final int ROW_ITEM_CLASS = 2;
    public static final int ROW_ARMOR_CLASS = 3;
    public static final int ROW_ARTIFACT_CLASS = 4;
    public static final int ROW_BITMAP = 5;
    public static final int ROW_OVERLAY_BITMAP = 6;
    public static final int ROW_GENDER_CODE = 7;
    public static final int ROW_NAME = 8;
    public static final int ROW_QUALITY_TAG = 9;
    public static final int ROW_QUALITY_TEXT = 10;
    public static final int ROW_STYLE_TAG = 11;
    public static final int ROW_STYLE_TEXT = 12;
    public static final int ROW_NAME_FULL = 13;
    public static final int ROW_RARITY = 14;
    public static final int ROW_SET_ID = 15;
    public static final int ROW_SET_NAME = 16;
    public static final int ROW_BONUS_AFFIXSET_ID = 17;
    public static final int ROW_ITEM_SKILL_ID = 18;
    public static final int ROW_PET_BONUS_SKILL_ID = 19;
    public static final int ROW_COST_FORMULASET_ID = 20;
    public static final int ROW_SOULBOUND = 21;
    public static final int ROW_HIDE_PREFIX = 22;
    public static final int ROW_HIDE_SUFFIX = 23;
    public static final int ROW_QUESTITEM = 24;
    public static final int ROW_ENEMY_ONLY = 25;
    public static final int ROW_LEVEL = 26;
    public static final int ROW_REQ_LEVEL = 27;
    public static final int ROW_REQ_DEX = 28;
    public static final int ROW_REQ_INT = 29;
    public static final int ROW_REQ_STR = 30;
    public static final int ROW_OFFENSIVE_CHANCE = 31;
    public static final int ROW_RETALIATION_CHANCE = 32;
    public static final int ROW_CONV_IN = 33;
    public static final int ROW_CONV_OUT = 34;
    public static final int ROW_CONV_PERC = 35;
    public static final int ROW_PLUS_ALLSKILLS = 36;
    public static final int ROW_COMPONENT_PIECES = 37;
    public static final int ROW_MAX_STACKSIZE = 38;
    public static final int ROW_RNG_PERCENT = 39;
    public static final int ROW_SLOT_AXE_1H = 40;
    public static final int ROW_SLOT_AXE_2H = 41;
    public static final int ROW_SLOT_DAGGER_1H = 42;
    public static final int ROW_SLOT_MACE_1H = 43;
    public static final int ROW_SLOT_MACE_2H = 44;
    public static final int ROW_SLOT_SCEPTER_1H = 45;
    public static final int ROW_SLOT_SPEAR_2H = 46;
    public static final int ROW_SLOT_STAFF_2H = 47;
    public static final int ROW_SLOT_SWORD_1H = 48;
    public static final int ROW_SLOT_SWORD_2H = 49;
    public static final int ROW_SLOT_RANGED_1H = 50;
    public static final int ROW_SLOT_RANGED_2H = 51;
    public static final int ROW_SLOT_SHIELD = 52;
    public static final int ROW_SLOT_OFFHAND = 53;
    public static final int ROW_SLOT_AMULET = 54;
    public static final int ROW_SLOT_BELT = 55;
    public static final int ROW_SLOT_MEDAL = 56;
    public static final int ROW_SLOT_RING = 57;
    public static final int ROW_SLOT_HEAD = 58;
    public static final int ROW_SLOT_SHOULDERS = 59;
    public static final int ROW_SLOT_CHEST = 60;
    public static final int ROW_SLOT_HANDS = 61;
    public static final int ROW_SLOT_LEGS = 62;
    public static final int ROW_SLOT_FEET = 63;
    public static final int GENDERCODE_UNDEF = -1;
    public static final int GENDERCODE_MALE_SINGLE = 0;
    public static final int GENDERCODE_FEMALE_SINGLE = 1;
    public static final int GENDERCODE_NEUTRAL_SINGLE = 2;
    public static final int GENDERCODE_MALE_PLURAL = 3;
    public static final int GENDERCODE_FEMALE_PLURAL = 4;
    public static final int GENDERCODE_NEUTRAL_PLURAL = 5;
    public static final String CLASS_ARMOR_HEAD = "ArmorProtective_Head";
    public static final String CLASS_ARMOR_SHOULDERS = "ArmorProtective_Shoulders";
    public static final String CLASS_ARMOR_CHEST = "ArmorProtective_Chest";
    public static final String CLASS_ARMOR_HANDS = "ArmorProtective_Hands";
    public static final String CLASS_ARMOR_BELT = "ArmorProtective_Waist";
    public static final String CLASS_ARMOR_LEGS = "ArmorProtective_Legs";
    public static final String CLASS_ARMOR_FEET = "ArmorProtective_Feet";
    public static final String CLASS_JEWELRY_AMULET = "ArmorJewelry_Amulet";
    public static final String CLASS_JEWELRY_MEDAL = "ArmorJewelry_Medal";
    public static final String CLASS_JEWELRY_RING = "ArmorJewelry_Ring";
    public static final String CLASS_WEAPON_OFFHAND = "WeaponArmor_Offhand";
    public static final String CLASS_WEAPON_SHIELD = "WeaponArmor_Shield";
    public static final String CLASS_WEAPON_1H_AXE = "WeaponMelee_Axe";
    public static final String CLASS_WEAPON_1H_MACE = "WeaponMelee_Mace";
    public static final String CLASS_WEAPON_1H_SWORD = "WeaponMelee_Sword";
    public static final String CLASS_WEAPON_1H_DAGGER = "WeaponMelee_Dagger";
    public static final String CLASS_WEAPON_1H_SCEPTER = "WeaponMelee_Scepter";
    public static final String CLASS_WEAPON_1H_RANGED = "WeaponHunting_Ranged1h";
    public static final String CLASS_WEAPON_2H_AXE = "WeaponMelee_Axe2h";
    public static final String CLASS_WEAPON_2H_MACE = "WeaponMelee_Mace2h";
    public static final String CLASS_WEAPON_2H_SPEAR = "WeaponHunting_Spear";
    public static final String CLASS_WEAPON_2H_STAFF = "WeaponMagical_Staff";
    public static final String CLASS_WEAPON_2H_SWORD = "WeaponMelee_Sword2h";
    public static final String CLASS_WEAPON_2H_RANGED = "WeaponHunting_Ranged2h";
    public static final String CLASS_ARTIFACT = "ItemArtifact";
    public static final String CLASS_COMPONENT = "ItemRelic";
    public static final String CLASS_FORMULA_ARTIFACT = "ItemArtifactFormula";
    public static final String CLASS_POTION_HEALTH = "OneShot_PotionHealth";
    public static final String CLASS_POTION_MANA = "OneShot_PotionMana";
    public static final String CLASS_TONIC_CLARITY = "ItemDevotionReset";
    public static final String CLASS_POTION_SCROLL = "OneShot_Scroll";
    public static final String CLASS_ENCHANTMENT = "ItemEnchantment";
    public static final String CLASS_FACTION_BOOSTER = "ItemFactionBooster";
    public static final String CLASS_QUESTITEM = "QuestItem";
    public static final String CLASS_TRANSMUTER = "ItemTransmuter";
    public static final String CLASS_FACTION_WARRANT = "ItemFactionWarrant";
    public static final String CLASS_CRUCIBLE_UNLOCK = "ItemDifficultyUnlock";
    public static final String CLASS_NOTE = "ItemNote";
    public static final String CLASS_USABLE_SKILL = "ItemUsableSkill";
    public static final String CLASS_KICKSTARTER = "Kickstarter";
    public static final String RARITY_BROKEN = "Broken";
    public static final String RARITY_COMMON = "Common";
    public static final String RARITY_MAGICAL = "Magical";
    public static final String RARITY_RARE = "Rare";
    public static final String RARITY_EPIC = "Epic";
    public static final String RARITY_LEGENDARY = "Legendary";
    public static final String RARITY_QUEST = "Quest";
    public static final String STYLE_EPIC_EMPOWERED = "tagStyleUniqueTier2";
    public static final int RARITY_INT_BROKEN = 1;
    public static final int RARITY_INT_COMMON = 2;
    public static final int RARITY_INT_MAGICAL = 3;
    public static final int RARITY_INT_RARE = 4;
    public static final int RARITY_INT_EPIC = 5;
    public static final int RARITY_INT_LEGENDARY = 6;
    public static final int RARITY_INT_QUEST = 7;
    public static final String ARMOR_CLASS_CASTER = "Caster";
    public static final String ARMOR_CLASS_LIGHT = "Light";
    public static final String ARMOR_CLASS_HEAVY = "Heavy";
    public static final String ARTIFACT_CLASS_LESSER = "Lesser";
    public static final String ARTIFACT_CLASS_GREATER = "Greater";
    public static final String ARTIFACT_CLASS_DIVINE = "Divine";
    public static final String CONV_DAMAGE_TYPE_AETHER = "Aether";
    public static final String CONV_DAMAGE_TYPE_CHAOS = "Chaos";
    public static final String CONV_DAMAGE_TYPE_COLD = "Cold";
    public static final String CONV_DAMAGE_TYPE_FIRE = "Fire";
    public static final String CONV_DAMAGE_TYPE_VITALITY = "Life";
    public static final String CONV_DAMAGE_TYPE_LIGHTNING = "Lightning";
    public static final String CONV_DAMAGE_TYPE_PHYSICAL = "Physical";
    public static final String CONV_DAMAGE_TYPE_ACID = "Poison";
    public static final String ITEM_QUEST_AETHER_CLUSTER = "records/items/crafting/materials/craft_aethercrystalcluster.dbr";
    public static final String ITEM_QUEST_AETHER_CRYSTAL = "records/items/materia/compa_aethercrystal.dbr";
    public static final String ITEM_QUEST_AETHER_SHARD = "records/items/crafting/materials/craft_aethershard.dbr";
    public static final String ITEM_QUEST_ANCIENT_HEART = "records/items/crafting/materials/craft_ancientheart.dbr";
    public static final String ITEM_QUEST_BLOOD_CHTHON = "records/items/crafting/materials/craft_bloodchthon.dbr";
    public static final String ITEM_QUEST_CHTHONIC_SEAL = "records/items/crafting/materials/craft_cultistseal.dbr";
    public static final String ITEM_QUEST_DYNAMITE = "records/items/questitems/quest_dynamite.dbr";
    public static final String ITEM_QUEST_MANTICORE_EYE = "records/items/crafting/materials/craft_manticore.dbr";
    public static final String ITEM_QUEST_ROYAL_JELLY = "records/items/crafting/materials/craft_royaljelly.dbr";
    public static final String ITEM_QUEST_SCRAPMETAL = "records/items/questitems/scrapmetal.dbr";
    public static final String ITEM_QUEST_SKELETON_KEY = "records/items/crafting/materials/craft_skeletonkey.dbr";
    public static final String ITEM_QUEST_TAINTED_BRAIN = "records/items/crafting/materials/craft_taintedbrain.dbr";
    public static final List<String> QUEST_ITEMS = new LinkedList<String>();
    private static ConcurrentHashMap<String, DBItem> hashBuffer;
    private String itemID;
    private String itemClass;
    private String armorClass;
    private String artifactClass;
    private byte[] bitmap;
    private byte[] shardBitmap;
    private int genderCode;
    private String name;
    private String qualityTag;
    private String qualityText;
    private String styleTag;
    private String styleText;
    private String nameFull;
    private String rarity;
    private String setID;
    private String setName;
    private String bonusAffixSetID;
    private String itemSkillID;
    private String petBonusSkillID;
    private String costFormulaSetID;
    private boolean soulbound;
    private boolean hidePrefix;
    private boolean hideSuffix;
    private boolean questItem;
    private boolean enemyOnly;
    private int itemLevel;
    private int reqLevel;
    private int reqDex;
    private int reqInt;
    private int reqStr;
    private int offensiveChance;
    private int retaliationChance;
    private String convertIn;
    private String convertOut;
    private int convertPerc;
    private int plusAllSkills;
    private int componentPieces;
    private int maxStackSize;
    private int rngPercent;
    private ItemSlots slots;
    private DBAffixSet bonusAffixSet;
    private DBCharBonus charBonus;
    private List<DBDamage> damages = new LinkedList<DBDamage>();
    private List<DBSkillBonus> bonuses = new LinkedList<DBSkillBonus>();
    private DBSkill dbItemSkill;
    private DBSkill dbPetBonusSkill;
    private DBFormulaSet dbFormulaSet;
    private DBItemCraft dbCraft;
    private BufferedImage image;
    private BufferedImage shardImage;
    private BufferedImage overlayImage;
    private BufferedImage overlayShard;
    private boolean craftable;

    public DBItem() {
        this.slots = new ItemSlots();
        this.dbCraft = new DBItemCraft();
    }

    private DBItem(ARZRecord record) {
        this();
        this.itemID = record.getFileName();
        this.enemyOnly = this.itemID.startsWith("records/items/enemygear");
        this.setItemClass(record.getRecordClass(), record.getFileName());
        this.setQuestItem(record.isQuestItem());
        this.genderCode = record.getGenderCode();
        this.name = record.getItemName();
        this.setQualityTag(record.getQualityTag());
        this.setStyleTag(record.getStyleTag());
        this.nameFull = this.getItemName();
        this.setCraftID(record.getArtifactID());
        this.armorClass = record.getArmorClass();
        this.artifactClass = record.getArtifactClass();
        this.setBitmap(record.getBitmap());
        this.setShardBitmap(record.getShardBitmap());
        this.rarity = record.getRarity();
        this.setID = record.getItemSetID();
        this.setItemSetNameTag(record.getItemSetNameTag());
        this.bonusAffixSetID = record.getBonusAffixSetID();
        this.itemSkillID = record.getItemSkillID();
        this.petBonusSkillID = record.getPetBonusID();
        this.soulbound = record.isSoulbound();
        this.hidePrefix = record.isHidePrefix();
        this.hideSuffix = record.isHideSuffix();
        this.itemLevel = record.getItemLevel();
        this.reqLevel = record.getRequiredLevel();
        this.offensiveChance = record.getOffensiveChance();
        this.retaliationChance = record.getRetaliationChance();
        this.convertIn = record.getConvertIn();
        this.convertOut = record.getConvertOut();
        this.convertPerc = record.getConvertPerc();
        this.plusAllSkills = record.getPlusAllSkills();
        this.componentPieces = record.getComponentPieces();
        this.maxStackSize = record.getMaxStackSize();
        this.rngPercent = record.getRNGPercent();
        this.slots = record.getItemSlots();
        this.charBonus = record.dbCharBonus;
        this.damages = record.dbDamages;
        this.bonuses = record.dbSkillBonuses;
        this.setCostFormulaSetID(record.getCostFormulaSetID());
    }

    public DBItem(String itemID) {
        this();
        this.name = "Placeholder";
        this.image = null;
        if (!itemID.startsWith("items/gearaccessories/medals") && !itemID.startsWith("items/faction/accessories/medals") || itemID.contains("medal")) {
            // empty if block
        }
        if (!itemID.startsWith("items/gearaccessories/necklaces") && !itemID.startsWith("items/faction/accessories/necklaces") || itemID.contains("necklace")) {
            // empty if block
        }
        if (!itemID.startsWith("items/gearaccessories/rings") && !itemID.startsWith("items/faction/accessories/rings") || itemID.contains("ring")) {
            // empty if block
        }
        if (!itemID.startsWith("items/gearaccessories/waist") && !itemID.startsWith("items/faction/accessories/waist") || itemID.contains("waist")) {
            // empty if block
        }
        if (!itemID.startsWith("items/gearrelic") || itemID.contains("relic")) {
            // empty if block
        }
        if (!itemID.startsWith("items/materia") || itemID.contains("comp")) {
            // empty if block
        }
        if (!itemID.startsWith("items/enchants") || itemID.contains("enchant")) {
            // empty if block
        }
        if (!itemID.startsWith("items/gearfeet") && !itemID.startsWith("items/faction/feet") || itemID.contains("feet")) {
            // empty if block
        }
        if (!itemID.startsWith("items/gearhands") && !itemID.startsWith("items/faction/hands") || itemID.contains("hands")) {
            // empty if block
        }
        if (!itemID.startsWith("items/gearhead") && !itemID.startsWith("items/faction/head") || itemID.contains("head")) {
            // empty if block
        }
        if (!itemID.startsWith("items/gearlegs") && !itemID.startsWith("items/faction/legs") || itemID.contains("legs")) {
            // empty if block
        }
        if (!itemID.startsWith("items/gearshoulders") && !itemID.startsWith("items/faction/shoulders") || itemID.contains("shoulder")) {
            // empty if block
        }
        if (!itemID.startsWith("items/geartorso") && !itemID.startsWith("items/faction/torso") || itemID.contains("torso")) {
            // empty if block
        }
        if (!itemID.startsWith("items/gearweapons/axe1h") && !itemID.startsWith("items/faction/weapons/axe1h") || itemID.contains("axe")) {
            // empty if block
        }
        if (!itemID.startsWith("items/gearweapons/blunt1h") && !itemID.startsWith("items/faction/weapons/blunt1h") || itemID.contains("blunt")) {
            // empty if block
        }
        if (itemID.startsWith("items/gearweapons/caster") || itemID.startsWith("items/faction/weapons/caster")) {
            if (itemID.contains("dagger")) {
                // empty if block
            }
            if (itemID.contains("scepter")) {
                // empty if block
            }
        }
        if (!itemID.startsWith("items/gearweapons/focus") && !itemID.startsWith("items/faction/weapons/focus") || itemID.contains("focus")) {
            // empty if block
        }
        if (!itemID.startsWith("items/gearweapons/guns1h") && !itemID.startsWith("items/faction/weapons/guns1h") || itemID.contains("gun1h")) {
            // empty if block
        }
        if (!itemID.startsWith("items/gearweapons/guns2h") && !itemID.startsWith("items/faction/weapons/guns2h") || itemID.contains("gun2h")) {
            // empty if block
        }
        if (itemID.startsWith("items/gearweapons/melee2h") || itemID.startsWith("items/faction/weapons/melee2h")) {
            if (itemID.contains("axe2h")) {
                // empty if block
            }
            if (itemID.contains("blunt2h")) {
                // empty if block
            }
            if (itemID.contains("sword2h")) {
                // empty if block
            }
        }
        if (!itemID.startsWith("items/gearweapons/shields") && !itemID.startsWith("items/faction/weapons/shields") || itemID.contains("shield")) {
            // empty if block
        }
        if (!itemID.startsWith("items/gearweapons/spears") && !itemID.startsWith("items/faction/weapons/spears") || itemID.contains("spear")) {
            // empty if block
        }
        if (itemID.startsWith("items/gearweapons/staff") || itemID.startsWith("items/faction/weapons/staff")) {
            if (itemID.contains("fire")) {
                // empty if block
            }
            if (itemID.contains("frost")) {
                // empty if block
            }
            if (itemID.contains("lightning")) {
                // empty if block
            }
        }
        if (!itemID.startsWith("items/gearweapons/swords1h") && !itemID.startsWith("items/faction/weapons/swords1h") || itemID.contains("sword")) {
            // empty if block
        }
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!o.getClass().equals(DBItem.class)) {
            return false;
        }
        DBItem item = (DBItem)o;
        return item.itemID.equals(this.itemID);
    }

    public int hashCode() {
        return this.itemID.hashCode();
    }

    public int compareTo(Object o) {
        int iRarity;
        int iClass;
        if (!o.getClass().equals(DBItem.class)) {
            Object[] args = new Object[]{DBItem.class, o.toString()};
            String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_NOT_OF_TYPE", args);
            throw new ClassCastException(msg);
        }
        DBItem item = (DBItem)o;
        int oClass = ItemClass.getClassInt(this.itemClass);
        if (oClass < (iClass = ItemClass.getClassInt(item.itemClass))) {
            return -1;
        }
        if (oClass > iClass) {
            return 1;
        }
        int oRarity = this.getRarityInt();
        if (oRarity < (iRarity = item.getRarityInt())) {
            return -1;
        }
        if (oRarity > iRarity) {
            return 1;
        }
        String fullname1 = this.combineName(true);
        String fullname2 = item.combineName(true);
        if (fullname1 == null) {
            if (fullname2 != null) {
                return -1;
            }
        } else {
            if (fullname2 == null) {
                return 1;
            }
            if (!fullname2.equals(fullname1)) {
                return fullname1.compareTo(fullname2);
            }
        }
        if (this.reqLevel < item.reqLevel) {
            return -1;
        }
        if (this.reqLevel > item.reqLevel) {
            return 1;
        }
        return 0;
    }

    public String getItemID() {
        return this.itemID;
    }

    @Override
    public String getItemClass() {
        return this.itemClass;
    }

    public String getArmorClass() {
        return this.armorClass;
    }

    public String getArtifactClass() {
        return this.artifactClass;
    }

    public int getGenderCode() {
        return this.genderCode;
    }

    public String getName() {
        return this.name;
    }

    public String getItemName() {
        return this.combineName(false);
    }

    public String getItemNameWithDmg() {
        return this.combineName(true);
    }

    public String getQualityText() {
        return this.qualityText;
    }

    public String getStyleText() {
        return this.styleText;
    }

    public String getRarity() {
        return this.rarity;
    }

    public String getItemSetID() {
        return this.setID;
    }

    public String getItemSetName() {
        return this.setName;
    }

    public String getCraftID() {
        return this.dbCraft.getCraftID();
    }

    public String getBonusAffixSetID() {
        return this.bonusAffixSetID;
    }

    public String getItemSkillID() {
        return this.itemSkillID;
    }

    public String getPetBonusSkillID() {
        return this.petBonusSkillID;
    }

    public String getCostFormulaSetID() {
        return this.costFormulaSetID;
    }

    public boolean isSoulbound() {
        return this.soulbound;
    }

    public boolean isHidePrefix() {
        return this.hidePrefix;
    }

    public boolean isHideSuffix() {
        return this.hideSuffix;
    }

    public boolean isQuestItem() {
        return this.questItem;
    }

    public boolean isCraftable() {
        return this.craftable;
    }

    @Override
    public int getItemLevel() {
        return this.itemLevel;
    }

    public boolean isEnemyOnly() {
        return this.enemyOnly;
    }

    public int getRequiredlevel() {
        return this.reqLevel;
    }

    public int getRequiredCunning() {
        return this.reqDex;
    }

    public int getRequiredPhysique() {
        return this.reqStr;
    }

    public int getRequiredSpirit() {
        return this.reqInt;
    }

    public int getOffensiveChance() {
        return this.offensiveChance;
    }

    public int getRetaliationChance() {
        return this.retaliationChance;
    }

    public String getConvertIn() {
        return this.convertIn;
    }

    public String getConvertOut() {
        return this.convertOut;
    }

    public int getConvertPerc() {
        return this.convertPerc;
    }

    public int getPlusAllSkills() {
        return this.plusAllSkills;
    }

    public int getComponentPieces() {
        return this.componentPieces;
    }

    public int getMaxStackSize() {
        return this.maxStackSize;
    }

    public ItemSlots getSlots() {
        return this.slots.clone();
    }

    public boolean usesSlots() {
        if (this.slots == null) {
            return false;
        }
        return this.slots.usesSlots();
    }

    public boolean isSlotAxe1H() {
        return this.slots.slotAxe1H;
    }

    public boolean isSlotAxe2H() {
        return this.slots.slotAxe2H;
    }

    public boolean isSlotDagger1H() {
        return this.slots.slotDagger1H;
    }

    public boolean isSlotMace1H() {
        return this.slots.slotMace1H;
    }

    public boolean isSlotMace2H() {
        return this.slots.slotMace2H;
    }

    public boolean isSlotScepter1H() {
        return this.slots.slotScepter1H;
    }

    public boolean isSlotSpear2H() {
        return this.slots.slotSpear2H;
    }

    public boolean isSlotStaff2H() {
        return this.slots.slotStaff2H;
    }

    public boolean isSlotSword1H() {
        return this.slots.slotSword1H;
    }

    public boolean isSlotSword2H() {
        return this.slots.slotSword2H;
    }

    public boolean isSlotRanged1H() {
        return this.slots.slotRanged1H;
    }

    public boolean isSlotRanged2H() {
        return this.slots.slotRanged2H;
    }

    public boolean isSlotShield() {
        return this.slots.slotShield;
    }

    public boolean isSlotOffhand() {
        return this.slots.slotOffhand;
    }

    public boolean isSlotAmulet() {
        return this.slots.slotAmulet;
    }

    public boolean isSlotBelt() {
        return this.slots.slotBelt;
    }

    public boolean isSlotMedal() {
        return this.slots.slotMedal;
    }

    public boolean isSlotRing() {
        return this.slots.slotRing;
    }

    public boolean isSlotHead() {
        return this.slots.slotHead;
    }

    public boolean isSlotShoulders() {
        return this.slots.slotShoulders;
    }

    public boolean isSlotChest() {
        return this.slots.slotChest;
    }

    public boolean isSlotHands() {
        return this.slots.slotHands;
    }

    public boolean isSlotLegs() {
        return this.slots.slotLegs;
    }

    public boolean isSlotFeet() {
        return this.slots.slotFeet;
    }

    public DBAffixSet getBonusAffixSet() {
        return this.bonusAffixSet;
    }

    public DBCharBonus getCharBonus() {
        return this.charBonus;
    }

    public List<DBDamage> getDamageList() {
        return this.damages;
    }

    public List<DBSkillBonus> getSkillBonusList() {
        return this.bonuses;
    }

    public DBSkill getItemSkill() {
        return this.dbItemSkill;
    }

    public DBSkill getPetBonusSkill() {
        return this.dbPetBonusSkill;
    }

    public byte[] getBitmap() {
        return this.bitmap;
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public BufferedImage getShardImage() {
        return this.shardImage;
    }

    public BufferedImage getOverlayImage() {
        return this.overlayImage;
    }

    public BufferedImage getOverlayShard() {
        return this.overlayShard;
    }

    public DBFormulaSet.Result getStatRequirements(ParameterSet ps) {
        if (this.dbFormulaSet == null) {
            return null;
        }
        DBFormulaSet.Result result = this.dbFormulaSet.getResult(ps);
        if (result != null) {
            result.cunning = (int)(result.cunning + 0.5);
            result.physique = (int)(result.physique + 0.5);
            result.spirit = (int)(result.spirit + 0.5);
        }
        return result;
    }

    public void determineStatRequirements() {
        DBFormulaSet.Result result = this.getStatRequirements(this);
        if (result != null) {
            this.reqDex = (int)result.cunning;
            this.reqStr = (int)result.physique;
            this.reqInt = (int)result.spirit;
        }
    }

    @Override
    public float getCharAttackSpeed() {
        if (this.charBonus == null) {
            return 0.0f;
        }
        return this.charBonus.getAttackSpeedPerc();
    }

    @Override
    public int getDefenseAttrArmor() {
        int value = 0;
        for (DBDamage damage : this.damages) {
            if (!damage.getDamageType().equals("defensiveProtection")) continue;
            value = damage.getMinDamage();
            break;
        }
        return value;
    }

    @Override
    public int getShieldBlockDefense() {
        int value = 0;
        for (DBDamage damage : this.damages) {
            if (!damage.getDamageType().equals("defensiveBlock")) continue;
            value = damage.getMinDamage();
            break;
        }
        return value;
    }

    @Override
    public int getShieldBlockChance() {
        int value = 0;
        for (DBDamage damage : this.damages) {
            if (!damage.getDamageType().equals("defensiveBlock")) continue;
            value = damage.getDamageChance();
            break;
        }
        return value;
    }

    @Override
    public int getDamageAvgPierceRatio() {
        int value = 0;
        for (DBDamage damage : this.damages) {
            if (!damage.getDamageType().equals("offensivePierceRatio")) continue;
            value = damage.getMinDamage();
            if (damage.getMaxDamage() <= 0) break;
            value += damage.getMaxDamage();
            value /= 2;
            break;
        }
        return value;
    }

    @Override
    public int getDamageAvgBase() {
        int total = 0;
        int value = 0;
        for (DBDamage damage : this.damages) {
            if (damage.getDamageType().equals("offensiveBaseAether")) {
                value = damage.getMinDamage();
                if (damage.getMaxDamage() > 0) {
                    value += damage.getMaxDamage();
                    value /= 2;
                }
                total += value;
            }
            if (damage.getDamageType().equals("offensiveBaseChaos")) {
                value = damage.getMinDamage();
                if (damage.getMaxDamage() > 0) {
                    value += damage.getMaxDamage();
                    value /= 2;
                }
                total += value;
            }
            if (damage.getDamageType().equals("offensiveBaseCold")) {
                value = damage.getMinDamage();
                if (damage.getMaxDamage() > 0) {
                    value += damage.getMaxDamage();
                    value /= 2;
                }
                total += value;
            }
            if (damage.getDamageType().equals("offensiveBaseFire")) {
                value = damage.getMinDamage();
                if (damage.getMaxDamage() > 0) {
                    value += damage.getMaxDamage();
                    value /= 2;
                }
                total += value;
            }
            if (damage.getDamageType().equals("offensiveBaseLife")) {
                value = damage.getMinDamage();
                if (damage.getMaxDamage() > 0) {
                    value += damage.getMaxDamage();
                    value /= 2;
                }
                total += value;
            }
            if (damage.getDamageType().equals("offensiveBaseLightning")) {
                value = damage.getMinDamage();
                if (damage.getMaxDamage() > 0) {
                    value += damage.getMaxDamage();
                    value /= 2;
                }
                total += value;
            }
            if (damage.getDamageType().equals("offensivePhysical")) {
                value = damage.getMinDamage();
                if (damage.getMaxDamage() > 0) {
                    value += damage.getMaxDamage();
                    value /= 2;
                }
                total += value;
            }
            if (!damage.getDamageType().equals("offensiveBasePoison")) continue;
            value = damage.getMinDamage();
            if (damage.getMaxDamage() > 0) {
                value += damage.getMaxDamage();
                value /= 2;
            }
            total += value;
        }
        return total;
    }

    @Override
    public int getTotalAttCount() {
        int total = 0;
        for (DBDamage damage : this.damages) {
            if (damage.getMinDamage() > 0) {
                ++total;
            }
            if (damage.getDamageModifier() > 0) {
                ++total;
            }
            if (damage.getDurationModifier() > 0) {
                ++total;
            }
            if (damage.getMaxResist() <= 0) continue;
            ++total;
        }
        if (this.charBonus != null) {
            total += this.charBonus.getTotalAttCount();
        }
        return total;
    }

    @Override
    public int getItemPrefixCost() {
        return 0;
    }

    @Override
    public int getItemSuffixCost() {
        return 0;
    }

    private String appendNamePart(String s, int part, boolean withDmg) {
        switch (part) {
            case 2: {
                if (this.qualityText == null) break;
                if (!s.isEmpty()) {
                    s = s + " ";
                }
                s = s + this.qualityText;
                break;
            }
            case 3: {
                if (this.styleText == null) break;
                if (!s.isEmpty()) {
                    s = s + " ";
                }
                s = s + this.styleText;
                break;
            }
            case 4: {
                String dmg;
                if (this.name == null) break;
                if (!s.isEmpty()) {
                    s = s + " ";
                }
                s = s + this.name;
                if (!withDmg || (dmg = this.getMainDamageType()) == null) break;
                s = s + " [" + dmg + "]";
            }
        }
        return s;
    }

    private String combineName(boolean withDmg) {
        String fullname = "";
        fullname = this.appendNamePart(fullname, GDStashFrame.dbConfig.namePart1, withDmg);
        fullname = this.appendNamePart(fullname, GDStashFrame.dbConfig.namePart2, withDmg);
        fullname = this.appendNamePart(fullname, GDStashFrame.dbConfig.namePart3, withDmg);
        fullname = this.appendNamePart(fullname, GDStashFrame.dbConfig.namePart4, withDmg);
        fullname = this.appendNamePart(fullname, GDStashFrame.dbConfig.namePart5, withDmg);
        return fullname;
    }

    private int getRarityInt() {
        if (this.rarity == null) {
            return -1;
        }
        if (this.rarity.equals(RARITY_BROKEN)) {
            return 1;
        }
        if (this.rarity.equals(RARITY_COMMON)) {
            return 2;
        }
        if (this.rarity.equals(RARITY_MAGICAL)) {
            return 3;
        }
        if (this.rarity.equals(RARITY_RARE)) {
            return 4;
        }
        if (this.rarity.equals(RARITY_EPIC)) {
            return 5;
        }
        if (this.rarity.equals(RARITY_LEGENDARY)) {
            return 6;
        }
        if (this.rarity.equals(RARITY_QUEST)) {
            return 7;
        }
        if (this.rarity.equals(ARTIFACT_CLASS_LESSER)) {
            return 8;
        }
        if (this.rarity.equals(ARTIFACT_CLASS_GREATER)) {
            return 9;
        }
        if (this.rarity.equals(ARTIFACT_CLASS_DIVINE)) {
            return 10;
        }
        return -1;
    }

    private int getArmorClassInt() {
        if (this.armorClass == null) {
            return -1;
        }
        if (this.armorClass.equals(ARMOR_CLASS_CASTER)) {
            return 1;
        }
        if (this.armorClass.equals(ARMOR_CLASS_LIGHT)) {
            return 2;
        }
        if (this.armorClass.equals(ARMOR_CLASS_HEAVY)) {
            return 3;
        }
        return -1;
    }

    private int getArtifactClassInt() {
        if (this.artifactClass == null) {
            return -1;
        }
        if (this.artifactClass.equals(ARTIFACT_CLASS_LESSER)) {
            return 1;
        }
        if (this.artifactClass.equals(ARTIFACT_CLASS_GREATER)) {
            return 2;
        }
        if (this.artifactClass.equals(ARTIFACT_CLASS_DIVINE)) {
            return 3;
        }
        return -1;
    }

    public boolean isArmor() {
        return ItemClass.isArmor(this.itemClass);
    }

    public boolean isArtifact() {
        return ItemClass.isArtifact(this.itemClass);
    }

    public boolean isComponent() {
        return ItemClass.isComponent(this.itemClass);
    }

    public boolean isEnchantment() {
        return ItemClass.isEnchantment(this.itemClass);
    }

    public boolean isJewelry() {
        return ItemClass.isJewelry(this.itemClass);
    }

    public boolean isOffhand() {
        return ItemClass.isOffhand(this.itemClass);
    }

    public boolean isWeapon() {
        return ItemClass.isWeapon(this.itemClass);
    }

    public boolean is1HWeapon() {
        return ItemClass.is1HWeapon(this.itemClass);
    }

    public boolean is2HWeapon() {
        return ItemClass.is2HWeapon(this.itemClass);
    }

    public boolean isStackable() {
        return ItemClass.isStackable(this.itemClass);
    }

    public String getMainDamageType() {
        if (!this.isWeapon()) {
            return null;
        }
        DBDamage dmgMax = null;
        int max = 0;
        int dmg = 0;
        for (DBDamage damage : this.damages) {
            boolean found = false;
            if (damage.getDamageType().equals("offensiveAether")) {
                found = true;
            }
            if (damage.getDamageType().equals("offensiveBaseAether")) {
                found = true;
            }
            if (damage.getDamageType().equals("offensiveChaos")) {
                found = true;
            }
            if (damage.getDamageType().equals("offensiveBaseChaos")) {
                found = true;
            }
            if (damage.getDamageType().equals("offensiveCold")) {
                found = true;
            }
            if (damage.getDamageType().equals("offensiveBaseCold")) {
                found = true;
            }
            if (damage.getDamageType().equals("offensiveElemental")) {
                found = true;
            }
            if (damage.getDamageType().equals("offensiveFire")) {
                found = true;
            }
            if (damage.getDamageType().equals("offensiveBaseFire")) {
                found = true;
            }
            if (damage.getDamageType().equals("offensiveLife")) {
                found = true;
            }
            if (damage.getDamageType().equals("offensiveBaseLife")) {
                found = true;
            }
            if (damage.getDamageType().equals("offensiveLightning")) {
                found = true;
            }
            if (damage.getDamageType().equals("offensiveBaseLightning")) {
                found = true;
            }
            if (damage.getDamageType().equals("offensivePhysical")) {
                found = true;
            }
            if (damage.getDamageType().equals("offensiveBonusPhysical")) {
                found = true;
            }
            if (damage.getDamageType().equals("offensivePierce")) {
                found = true;
            }
            if (damage.getDamageType().equals("offensivePoison")) {
                found = true;
            }
            if (damage.getDamageType().equals("offensiveBasePoison")) {
                found = true;
            }
            if (!found || damage.getDamageChance() != 0 || damage.getMinDamage() <= 0) continue;
            dmg = damage.getMinDamage();
            dmg = damage.getMaxDamage() > 0 ? (dmg += damage.getMaxDamage()) : (dmg += damage.getMinDamage());
            if (dmg <= max) continue;
            max = dmg;
            dmgMax = damage;
        }
        String sDmg = null;
        if (dmgMax != null) {
            if (dmgMax.getDamageType().equals("offensiveAether")) {
                sDmg = GDMsgFormatter.getString(GDMsgFormatter.rbGD, "OFF_AETHER");
            }
            if (dmgMax.getDamageType().equals("offensiveBaseAether")) {
                sDmg = GDMsgFormatter.getString(GDMsgFormatter.rbGD, "OFF_AETHER");
            }
            if (dmgMax.getDamageType().equals("offensiveChaos")) {
                sDmg = GDMsgFormatter.getString(GDMsgFormatter.rbGD, "OFF_CHAOS");
            }
            if (dmgMax.getDamageType().equals("offensiveBaseChaos")) {
                sDmg = GDMsgFormatter.getString(GDMsgFormatter.rbGD, "OFF_CHAOS");
            }
            if (dmgMax.getDamageType().equals("offensiveCold")) {
                sDmg = GDMsgFormatter.getString(GDMsgFormatter.rbGD, "OFF_COLD");
            }
            if (dmgMax.getDamageType().equals("offensiveBaseCold")) {
                sDmg = GDMsgFormatter.getString(GDMsgFormatter.rbGD, "OFF_COLD");
            }
            if (dmgMax.getDamageType().equals("offensiveElemental")) {
                sDmg = GDMsgFormatter.getString(GDMsgFormatter.rbGD, "OFF_ELEMENTAL");
            }
            if (dmgMax.getDamageType().equals("offensiveFire")) {
                sDmg = GDMsgFormatter.getString(GDMsgFormatter.rbGD, "OFF_FIRE");
            }
            if (dmgMax.getDamageType().equals("offensiveBaseFire")) {
                sDmg = GDMsgFormatter.getString(GDMsgFormatter.rbGD, "OFF_FIRE");
            }
            if (dmgMax.getDamageType().equals("offensiveLife")) {
                sDmg = GDMsgFormatter.getString(GDMsgFormatter.rbGD, "OFF_LIFE");
            }
            if (dmgMax.getDamageType().equals("offensiveBaseLife")) {
                sDmg = GDMsgFormatter.getString(GDMsgFormatter.rbGD, "OFF_LIFE");
            }
            if (dmgMax.getDamageType().equals("offensiveLightning")) {
                sDmg = GDMsgFormatter.getString(GDMsgFormatter.rbGD, "OFF_LIGHTNING");
            }
            if (dmgMax.getDamageType().equals("offensiveBaseLightning")) {
                sDmg = GDMsgFormatter.getString(GDMsgFormatter.rbGD, "OFF_LIGHTNING");
            }
            if (dmgMax.getDamageType().equals("offensivePhysical")) {
                sDmg = GDMsgFormatter.getString(GDMsgFormatter.rbGD, "OFF_PHYSICAL");
            }
            if (dmgMax.getDamageType().equals("offensiveBonusPhysical")) {
                sDmg = GDMsgFormatter.getString(GDMsgFormatter.rbGD, "OFF_PHYSICAL");
            }
            if (dmgMax.getDamageType().equals("offensivePierce")) {
                sDmg = GDMsgFormatter.getString(GDMsgFormatter.rbGD, "OFF_PIERCE");
            }
            if (dmgMax.getDamageType().equals("offensivePoison")) {
                sDmg = GDMsgFormatter.getString(GDMsgFormatter.rbGD, "OFF_POISON");
            }
            if (dmgMax.getDamageType().equals("offensiveBasePoison")) {
                sDmg = GDMsgFormatter.getString(GDMsgFormatter.rbGD, "OFF_POISON");
            }
            return sDmg;
        }
        return null;
    }

    private void setItemClass(String itemClass, String filename) {
        this.itemClass = itemClass;
        if (itemClass.equals(CLASS_QUESTITEM)) {
            this.setQuestItem(true);
        }
        if (filename.equals("records/items/bonusitems/bonus_burrwitchbrew.dbr") || filename.equals("records/items/bonusitems/bonus_summonwisp.dbr") || filename.equals("records/items/transmutes/dlc_head_powderedwig.dbr") || filename.equals("records/items/transmutes/dlc_medal_backer.dbr") || filename.equals("records/items/transmutes/dlc_medal_ks_officer.dbr") || filename.equals("records/items/transmutes/dlc_medal_ks_service.dbr") || filename.equals("records/items/transmutes/dlc_medal_ks_veteran.dbr") || filename.equals("records/items/transmutes/dlc_torso_swashbucklerscoat.dbr") || filename.equals("records/items/transmutes/transmute_medal_backer.dbr") || filename.equals("records/items/transmutes/transmute_medal_ks_officer.dbr") || filename.equals("records/items/transmutes/transmute_medal_ks_service.dbr") || filename.equals("records/items/transmutes/transmute_medal_ks_veteran.dbr") || filename.equals("records/items/transmutes/transmute_powderedwig.dbr") || filename.equals("records/items/transmutes/transmute_swashbucklerscoat.dbr")) {
            this.itemClass = CLASS_KICKSTARTER;
        }
    }

    private void setQuestItem(boolean questItem) {
        if (!this.questItem) {
            this.questItem = questItem;
        }
    }

    private void setCraftID(String craftID) {
        this.dbCraft.setCraftID(craftID);
    }

    private void setItemNameTag(String itemNameTag) {
        String s = GDStashFrame.arcList.getTag("tags_items.txt", itemNameTag);
        if (s == null) {
            s = GDStashFrame.arcList.getTag("tags_storyelements.txt", itemNameTag);
        }
        this.genderCode = -1;
        if (s != null && s.startsWith("[")) {
            String code = s.substring(0, 4);
            s = s.substring(4);
            this.genderCode = ARZDecompress.getGenderCode(code);
        }
        if (this.genderCode == -1) {
            this.genderCode = 0;
        }
        this.name = s;
    }

    private void setQualityTag(String qualityTag) {
        this.qualityTag = qualityTag;
        if (qualityTag == null) {
            this.qualityText = null;
        } else {
            this.qualityText = GDStashFrame.arcList.getTag("tags_items.txt", qualityTag);
            if (this.qualityText != null) {
                String[] genders = ARZDecompress.getGenderTexts(this.qualityText);
                this.qualityText = genders[this.genderCode];
            }
        }
    }

    private void setStyleTag(String styleTag) {
        this.styleTag = styleTag;
        if (styleTag == null) {
            this.styleText = null;
        } else {
            this.styleText = GDStashFrame.arcList.getTag("tags_items.txt", styleTag);
            if (this.styleText != null) {
                String[] genders = ARZDecompress.getGenderTexts(this.styleText);
                this.styleText = genders[this.genderCode];
            }
        }
    }

    private void setItemSetNameTag(String setNameTag) {
        this.setName = GDStashFrame.arcList.getTag("tags_items.txt", setNameTag);
    }

    private void setCostFormulaSetID(String costFormulaSetID) {
        this.costFormulaSetID = costFormulaSetID;
        if (ItemClass.usesCostFormula(this.itemClass)) {
            if (costFormulaSetID == null) {
                costFormulaSetID = "records/game/itemcostformulas.dbr";
            }
            this.dbFormulaSet = ARZDecompress.getFormulaSet(costFormulaSetID);
        } else {
            this.dbFormulaSet = null;
        }
        if (this.dbFormulaSet != null) {
            this.determineStatRequirements();
        }
    }

    private void setBitmap(byte[] bitmap) {
        int size = 0;
        if (bitmap != null) {
            size = bitmap.length;
        }
        if (size >= 65536) {
            Object[] args = new Object[]{this.itemID};
            String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_IN_ITEM_IMAGE_SIZE", args);
            GDMsgLogger.addWarning(msg);
            return;
        }
        this.bitmap = bitmap;
    }

    private void setShardBitmap(byte[] shardBitmap) {
        int size = 0;
        if (shardBitmap != null) {
            size = shardBitmap.length;
        }
        if (size >= 32768) {
            Object[] args = new Object[]{this.itemID};
            String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_IN_ITEM_SHARD_SIZE", args);
            GDMsgLogger.addWarning(msg);
            return;
        }
        this.shardBitmap = shardBitmap;
    }

    public static void clearBuffer() {
        hashBuffer.clear();
    }

    public static void createTables() throws SQLException {
        String dropTable = "DROP TABLE GD_ITEM";
        String createTable = "CREATE TABLE GD_ITEM (ITEM_ID VARCHAR(256) NOT NULL, ITEM_CLASS   VARCHAR(32), ARMOR_CLASS  VARCHAR(16), ARTIFACT_CLASS VARCHAR(16), BITMAP       BLOB(64K), SHARD_BITMAP BLOB(32K), GENDER_CODE  INTEGER, NAME         VARCHAR(128), QUALITY_TAG  VARCHAR(64), QUALITY_TEXT VARCHAR(64), STYLE_TAG    VARCHAR(64), STYLE_TEXT   VARCHAR(64), NAME_FULL    VARCHAR(128), RARITY       VARCHAR(32), SET_ID       VARCHAR(256), SET_NAME     VARCHAR(128), BONUS_AFFIXSET_ID VARCHAR(256), ITEM_SKILL_ID   VARCHAR(256), PET_BONUS_SKILL_ID VARCHAR(256), COST_FORMULASET_ID VARCHAR(256), SOULBOUND       BOOLEAN, HIDE_PREFIX     BOOLEAN, HIDE_SUFFIX     BOOLEAN, QUESTITEM       BOOLEAN, ENEMY_ONLY      BOOLEAN, LEVEL           INTEGER, REQ_LEVEL       INTEGER, REQ_DEX         INTEGER, REQ_INT         INTEGER, REQ_STR         INTEGER, OFFENSE_PRC     INTEGER, RETAL_PRC       INTEGER, CONVERT_IN      VARCHAR(16), CONVERT_OUT     VARCHAR(16), CONVERT_PERC    INTEGER, PLUS_ALLSKILLS  INTEGER, COMPONENT_PIECES INTEGER, MAX_STACKSIZE   INTEGER, RNG_PERCENT     INTEGER, SLOT_AXE_1H     BOOLEAN, SLOT_AXE_2H     BOOLEAN, SLOT_DAGGER_1H  BOOLEAN, SLOT_MACE_1H    BOOLEAN, SLOT_MACE_2H    BOOLEAN, SLOT_SCEPTER_1H BOOLEAN, SLOT_SPEAR_2H   BOOLEAN, SLOT_STAFF_2H   BOOLEAN, SLOT_SWORD_1H   BOOLEAN, SLOT_SWORD_2H   BOOLEAN, SLOT_RANGED_1H  BOOLEAN, SLOT_RANGED_2H  BOOLEAN, SLOT_SHIELD     BOOLEAN, SLOT_OFFHAND    BOOLEAN, SLOT_AMULET     BOOLEAN, SLOT_BELT       BOOLEAN, SLOT_MEDAL      BOOLEAN, SLOT_RING       BOOLEAN, SLOT_HEAD       BOOLEAN, SLOT_SHOULDERS  BOOLEAN, SLOT_CHEST      BOOLEAN, SLOT_HANDS      BOOLEAN, SLOT_LEGS       BOOLEAN, SLOT_FEET       BOOLEAN, PRIMARY KEY (ITEM_ID))";
        try (Connection conn = GDDBData.getConnection();){
            boolean auto = conn.getAutoCommit();
            conn.setAutoCommit(false);
            try (Statement st = conn.createStatement();){
                if (GDDBUtil.tableExists(conn, TABLE_NAME)) {
                    st.execute(dropTable);
                }
                st.execute(createTable);
                st.close();
                conn.commit();
                DBItemCraft.createTables(conn);
                DBDamage.createTable(conn, TABLE_DAMAGE, FIELD_ID);
                DBSkillBonus.createTable(conn, TABLE_SKILLS, FIELD_ID);
                DBCharBonus.createTable(conn, TABLE_CHAR, TABLE_RACE, FIELD_ID);
            }
            catch (SQLException ex) {
                conn.rollback();
                Object[] args = new Object[]{"DBItem"};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_CREATE_TABLE", args);
                GDMsgLogger.addError(msg);
                throw ex;
            }
            finally {
                conn.setAutoCommit(auto);
            }
        }
    }

    public static void delete(String itemID) throws SQLException {
        String deleteEntry = "DELETE FROM GD_ITEM WHERE ITEM_ID = ?";
        try (Connection conn = GDDBData.getConnection();){
            boolean auto = conn.getAutoCommit();
            conn.setAutoCommit(false);
            try (PreparedStatement ps = conn.prepareStatement(deleteEntry);){
                ps.setString(1, itemID);
                ps.executeUpdate();
                ps.close();
                DBItemCraft.delete(conn, itemID);
                DBCharBonus.delete(conn, TABLE_CHAR, TABLE_RACE, FIELD_ID, itemID);
                DBDamage.delete(conn, TABLE_DAMAGE, FIELD_ID, itemID);
                DBSkillBonus.delete(conn, TABLE_SKILLS, FIELD_ID, itemID);
                conn.commit();
            }
            catch (SQLException ex) {
                conn.rollback();
                Object[] args = new Object[]{itemID, "DBItem"};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_DEL_TABLE_BY_ID", args);
                GDMsgLogger.addError(msg);
                GDMsgLogger.addError(ex);
                throw ex;
            }
            finally {
                conn.setAutoCommit(auto);
            }
        }
    }

    public static void insert(ARZRecord record) throws SQLException {
        DBItem item = new DBItem(record);
        String insertItem = "INSERT INTO GD_ITEM VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        try (Connection conn = GDDBData.getConnection();){
            boolean auto = conn.getAutoCommit();
            conn.setAutoCommit(false);
            try (PreparedStatement ps = conn.prepareStatement(insertItem);){
                ps.setString(1, item.itemID);
                ps.setString(2, item.itemClass);
                ps.setString(3, item.armorClass);
                ps.setString(4, item.artifactClass);
                if (item.bitmap == null) {
                    ps.setBlob(5, (Blob)null);
                } else {
                    ps.setBlob(5, new ByteArrayInputStream(item.bitmap));
                }
                if (item.shardBitmap == null) {
                    ps.setBlob(6, (Blob)null);
                } else {
                    ps.setBlob(6, new ByteArrayInputStream(item.shardBitmap));
                }
                ps.setInt(7, item.genderCode);
                ps.setString(8, item.name);
                ps.setString(9, item.qualityTag);
                ps.setString(10, item.qualityText);
                ps.setString(11, item.styleTag);
                ps.setString(12, item.styleText);
                ps.setString(13, item.nameFull);
                ps.setString(14, item.rarity);
                ps.setString(15, item.setID);
                ps.setString(16, item.setName);
                ps.setString(17, item.bonusAffixSetID);
                ps.setString(18, item.itemSkillID);
                ps.setString(19, item.petBonusSkillID);
                ps.setString(20, item.costFormulaSetID);
                ps.setBoolean(21, item.soulbound);
                ps.setBoolean(22, item.hidePrefix);
                ps.setBoolean(23, item.hideSuffix);
                ps.setBoolean(24, item.questItem);
                ps.setBoolean(25, item.enemyOnly);
                ps.setInt(26, item.itemLevel);
                ps.setInt(27, item.reqLevel);
                ps.setInt(28, item.reqDex);
                ps.setInt(29, item.reqInt);
                ps.setInt(30, item.reqStr);
                ps.setInt(31, item.offensiveChance);
                ps.setInt(32, item.retaliationChance);
                ps.setString(33, item.convertIn);
                ps.setString(34, item.convertOut);
                ps.setInt(35, item.convertPerc);
                ps.setInt(36, item.plusAllSkills);
                ps.setInt(37, item.componentPieces);
                ps.setInt(38, item.maxStackSize);
                ps.setInt(39, item.rngPercent);
                ps.setBoolean(40, item.slots.slotAxe1H);
                ps.setBoolean(41, item.slots.slotAxe2H);
                ps.setBoolean(42, item.slots.slotDagger1H);
                ps.setBoolean(43, item.slots.slotMace1H);
                ps.setBoolean(44, item.slots.slotMace2H);
                ps.setBoolean(45, item.slots.slotScepter1H);
                ps.setBoolean(46, item.slots.slotSpear2H);
                ps.setBoolean(47, item.slots.slotStaff2H);
                ps.setBoolean(48, item.slots.slotSword1H);
                ps.setBoolean(49, item.slots.slotSword2H);
                ps.setBoolean(50, item.slots.slotRanged1H);
                ps.setBoolean(51, item.slots.slotRanged2H);
                ps.setBoolean(52, item.slots.slotShield);
                ps.setBoolean(53, item.slots.slotOffhand);
                ps.setBoolean(54, item.slots.slotAmulet);
                ps.setBoolean(55, item.slots.slotBelt);
                ps.setBoolean(56, item.slots.slotMedal);
                ps.setBoolean(57, item.slots.slotRing);
                ps.setBoolean(58, item.slots.slotHead);
                ps.setBoolean(59, item.slots.slotShoulders);
                ps.setBoolean(60, item.slots.slotChest);
                ps.setBoolean(61, item.slots.slotHands);
                ps.setBoolean(62, item.slots.slotLegs);
                ps.setBoolean(63, item.slots.slotFeet);
                ps.executeUpdate();
                ps.close();
                conn.commit();
                if (item.dbCraft.getCraftID() != null) {
                    DBItemCraft.insert(conn, item);
                }
                DBCharBonus.insert(conn, TABLE_CHAR, TABLE_RACE, item.itemID, item.charBonus);
                DBDamage.insert(conn, TABLE_DAMAGE, item.itemID, item.damages);
                DBSkillBonus.insert(conn, TABLE_SKILLS, item.itemID, item.bonuses);
            }
            catch (SQLException ex) {
                conn.rollback();
                Object[] args = new Object[]{record.getFileName()};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_IN_ITEM", args);
                GDMsgLogger.addError(msg);
                throw ex;
            }
            finally {
                conn.setAutoCommit(auto);
            }
        }
    }

    public static void insertMod(ARZRecord record) throws SQLException {
        DBItem entry = DBItem.get(record.getFileName());
        if (entry != null) {
            DBItem.delete(record.getFileName());
        }
        DBItem.insert(record);
    }

    public static DBItem get(String itemID) {
        DBItem item = null;
        item = hashBuffer.get(itemID);
        if (item == null) {
            item = DBItem.getDB(itemID);
        }
        return item;
    }

    private static DBItem getDB(String itemID) {
        DBItem item = null;
        String command = "SELECT * FROM GD_ITEM WHERE ITEM_ID = ?";
        try (Connection conn = GDDBData.getConnection();
             PreparedStatement ps = conn.prepareStatement(command);){
            ps.setString(1, itemID);
            try (ResultSet rs = ps.executeQuery();){
                List<DBItem> list = DBItem.wrap(rs);
                item = list.isEmpty() ? null : list.get(0);
                conn.commit();
            }
        }
        catch (SQLException ex) {
            Object[] args = new Object[]{itemID, "DBItem"};
            String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_READ_TABLE_BY_ID", args);
            GDMsgLogger.addError(msg);
            GDMsgLogger.addError(ex);
        }
        return item;
    }

    public static List<DBItem> getByItemIDs(List<String> itemIDs) {
        LinkedList<DBItem> list = new LinkedList<DBItem>();
        for (String itemID : itemIDs) {
            DBItem item = DBItem.get(itemID);
            list.add(item);
        }
        return list;
    }

    private static List<DBItem> getByItemCriteria(SelectionCriteria criteria) {
        List<String> itemIDs = ItemIDItemCombination.getItemIDs(criteria, false, null);
        List<DBItem> listAll = DBItem.getByItemIDs(itemIDs);
        return listAll;
    }

    private static List<DBItem> getByDamageCriteria(SelectionCriteria criteria) {
        List<String> itemIDs = ItemIDItemDamageCombination.getItemIDs(criteria, false, null);
        List<DBItem> listAll = DBItem.getByItemIDs(itemIDs);
        return listAll;
    }

    public static List<DBItem> getByCriteria(SelectionCriteria criteria) {
        if (criteria.itemIDs != null && !criteria.itemIDs.isEmpty()) {
            return DBItem.getByItemIDs(criteria.itemIDs);
        }
        if (criteria.dmgClass.isEmpty() && !criteria.petBonus) {
            return DBItem.getByItemCriteria(criteria);
        }
        return DBItem.getByDamageCriteria(criteria);
    }

    private static void addSingleCriteriaCombo(List<DBItem> listAll, PreparedStatement ps, String command, ItemCriteriaCombination combo) {
        List<DBItem> list = DBItem.getBySingleCriteriaCombo(ps, command, combo);
        if (list != null && !list.isEmpty()) {
            listAll.addAll(list);
        }
    }

    private static List<DBItem> getBySingleCriteriaCombo(PreparedStatement ps, String command, ItemCriteriaCombination combo) {
        LinkedList<DBItem> list = new LinkedList();
        try {
            combo.fillItemStatement(ps);
            try (ResultSet rs = ps.executeQuery();){
                list = DBItem.wrap(rs);
            }
        }
        catch (SQLException ex) {
            Object[] args = new Object[]{command, combo.determineItemParameters()};
            String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_SELECT_FAILED", args);
            GDMsgLogger.addError(msg);
        }
        return list;
    }

    private static void addItemIDsSingleCriteriaCombo(List<String> listAll, PreparedStatement ps, String command, ItemCriteriaCombination combo) {
        List<String> list = DBItem.getItemIDsBySingleCriteriaCombo(ps, command, combo);
        if (list != null && !list.isEmpty()) {
            listAll.addAll(list);
        }
    }

    private static List<String> getItemIDsBySingleCriteriaCombo(PreparedStatement ps, String command, ItemCriteriaCombination combo) {
        LinkedList<String> list = new LinkedList();
        try {
            combo.fillItemStatement(ps);
            try (ResultSet rs = ps.executeQuery();){
                list = AbstractItemCombination.wrapString(rs, 1);
            }
        }
        catch (SQLException ex) {
            Object[] args = new Object[]{command, combo.determineItemParameters()};
            String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_SELECT_FAILED", args);
            GDMsgLogger.addError(msg);
        }
        return list;
    }

    private static void addSingleDamageCombo(List<String> listAll, PreparedStatement ps, String command, DamageCriteriaCombination dcc) throws SQLException {
        int nextPos = dcc.fillItemIDStatement(ps);
        if (nextPos == -1) {
            return;
        }
        List<String> damageIDs = dcc.getDamageTypeList();
        for (String damageID : damageIDs) {
            ps.setString(nextPos, damageID);
            ResultSet rs = ps.executeQuery();
            Throwable throwable = null;
            try {
                List<String> ids = AbstractItemCombination.wrapString(rs, 1);
                for (String id : ids) {
                    boolean found = false;
                    for (String s : listAll) {
                        if (!s.equals(id)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    listAll.add(id);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (rs == null) continue;
                if (throwable != null) {
                    try {
                        rs.close();
                    }
                    catch (Throwable x2) {
                        throwable.addSuppressed(x2);
                    }
                    continue;
                }
                rs.close();
            }
        }
    }

    private static List<DBItem> wrap(ResultSet rs) throws SQLException {
        LinkedList<DBItem> list = new LinkedList<DBItem>();
        Blob blob = null;
        while (rs.next()) {
            String msg;
            Object[] args;
            DBItem item = new DBItem();
            item.itemID = rs.getString(1);
            DBItem buff = hashBuffer.get(item.itemID);
            if (buff != null) {
                list.add(buff);
                continue;
            }
            item.itemClass = rs.getString(2);
            item.armorClass = rs.getString(3);
            item.artifactClass = rs.getString(4);
            blob = rs.getBlob(5);
            item.bitmap = (byte[])(blob == null ? null : blob.getBytes(1L, (int)blob.length()));
            if (item.bitmap != null) {
                try {
                    item.image = DDSLoader.getImage(item.bitmap);
                }
                catch (GDParseException ex) {
                    args = new Object[]{item.itemID};
                    msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_BITMAP_DECODE_FAILED", args);
                    GDMsgLogger.addError(msg);
                    item.image = null;
                }
                if (item.image != null) {
                    item.overlayImage = DDSLoader.getScaledImage(item.image, 16, 16);
                }
            }
            item.shardBitmap = (byte[])((blob = rs.getBlob(6)) == null ? null : blob.getBytes(1L, (int)blob.length()));
            if (item.shardBitmap != null) {
                try {
                    item.shardImage = DDSLoader.getImage(item.shardBitmap);
                }
                catch (GDParseException ex) {
                    args = new Object[]{item.itemID};
                    msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_BITMAP_DECODE_FAILED", args);
                    GDMsgLogger.addError(msg);
                    item.shardImage = null;
                }
                if (item.shardImage != null) {
                    item.overlayShard = DDSLoader.getScaledImage(item.shardImage, 16, 16);
                }
            }
            item.genderCode = rs.getInt(7);
            item.name = rs.getString(8);
            item.qualityTag = rs.getString(9);
            item.qualityText = rs.getString(10);
            item.styleTag = rs.getString(11);
            item.styleText = rs.getString(12);
            item.nameFull = rs.getString(13);
            item.rarity = rs.getString(14);
            item.setID = rs.getString(15);
            item.setName = rs.getString(16);
            item.bonusAffixSetID = rs.getString(17);
            item.itemSkillID = rs.getString(18);
            item.petBonusSkillID = rs.getString(19);
            item.costFormulaSetID = rs.getString(20);
            item.soulbound = rs.getBoolean(21);
            item.hidePrefix = rs.getBoolean(22);
            item.hideSuffix = rs.getBoolean(23);
            item.questItem = rs.getBoolean(24);
            item.enemyOnly = rs.getBoolean(25);
            item.itemLevel = rs.getInt(26);
            item.reqLevel = rs.getInt(27);
            item.reqDex = rs.getInt(28);
            item.reqInt = rs.getInt(29);
            item.reqStr = rs.getInt(30);
            item.offensiveChance = rs.getInt(31);
            item.retaliationChance = rs.getInt(32);
            item.convertIn = rs.getString(33);
            item.convertOut = rs.getString(34);
            item.convertPerc = rs.getInt(35);
            item.plusAllSkills = rs.getInt(36);
            item.componentPieces = rs.getInt(37);
            item.maxStackSize = rs.getInt(38);
            item.rngPercent = rs.getInt(39);
            item.slots.slotAxe1H = rs.getBoolean(40);
            item.slots.slotAxe2H = rs.getBoolean(41);
            item.slots.slotDagger1H = rs.getBoolean(42);
            item.slots.slotMace1H = rs.getBoolean(43);
            item.slots.slotMace2H = rs.getBoolean(44);
            item.slots.slotScepter1H = rs.getBoolean(45);
            item.slots.slotSpear2H = rs.getBoolean(46);
            item.slots.slotStaff2H = rs.getBoolean(47);
            item.slots.slotSword1H = rs.getBoolean(48);
            item.slots.slotSword2H = rs.getBoolean(49);
            item.slots.slotRanged1H = rs.getBoolean(50);
            item.slots.slotRanged2H = rs.getBoolean(51);
            item.slots.slotShield = rs.getBoolean(52);
            item.slots.slotOffhand = rs.getBoolean(53);
            item.slots.slotAmulet = rs.getBoolean(54);
            item.slots.slotBelt = rs.getBoolean(55);
            item.slots.slotMedal = rs.getBoolean(56);
            item.slots.slotRing = rs.getBoolean(57);
            item.slots.slotHead = rs.getBoolean(58);
            item.slots.slotShoulders = rs.getBoolean(59);
            item.slots.slotChest = rs.getBoolean(60);
            item.slots.slotHands = rs.getBoolean(61);
            item.slots.slotLegs = rs.getBoolean(62);
            item.slots.slotFeet = rs.getBoolean(63);
            item.charBonus = DBCharBonus.getByItemID(item.itemID);
            item.damages = DBDamage.getByItemID(item.itemID);
            item.bonuses = DBSkillBonus.getByItemID(item.itemID);
            if (item.bonusAffixSetID != null) {
                item.bonusAffixSet = DBAffixSet.get(item.bonusAffixSetID);
            }
            if (item.itemSkillID != null) {
                item.dbItemSkill = DBSkill.get(item.itemSkillID);
            }
            if (item.petBonusSkillID != null) {
                item.dbPetBonusSkill = DBSkill.get(item.petBonusSkillID);
            }
            if (item.costFormulaSetID == null && ItemClass.usesCostFormula(item.itemClass)) {
                item.costFormulaSetID = "records/game/itemcostformulas.dbr";
            }
            if (item.costFormulaSetID != null) {
                item.dbFormulaSet = DBFormulaSet.get(item.costFormulaSetID);
                if (item.dbFormulaSet != null) {
                    item.determineStatRequirements();
                }
            }
            item.craftable = DBLootTableItemAlloc.isCraftableItemID(item.itemID);
            if (!item.craftable) {
                item.craftable = DBItemCraft.isCraftableItemID(item.itemID);
            }
            list.add(item);
            hashBuffer.put(item.itemID, item);
        }
        return list;
    }

    static {
        QUEST_ITEMS.add(ITEM_QUEST_AETHER_CLUSTER);
        QUEST_ITEMS.add(ITEM_QUEST_AETHER_CRYSTAL);
        QUEST_ITEMS.add(ITEM_QUEST_AETHER_SHARD);
        QUEST_ITEMS.add(ITEM_QUEST_ANCIENT_HEART);
        QUEST_ITEMS.add(ITEM_QUEST_BLOOD_CHTHON);
        QUEST_ITEMS.add(ITEM_QUEST_CHTHONIC_SEAL);
        QUEST_ITEMS.add(ITEM_QUEST_DYNAMITE);
        QUEST_ITEMS.add(ITEM_QUEST_MANTICORE_EYE);
        QUEST_ITEMS.add(ITEM_QUEST_ROYAL_JELLY);
        QUEST_ITEMS.add(ITEM_QUEST_SCRAPMETAL);
        QUEST_ITEMS.add(ITEM_QUEST_SKELETON_KEY);
        QUEST_ITEMS.add(ITEM_QUEST_TAINTED_BRAIN);
        hashBuffer = new ConcurrentHashMap();
    }
}

