/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;
import org.gdstash.db.DBItemSet;
import org.gdstash.db.GDDBData;
import org.gdstash.db.GDDBUtil;
import org.gdstash.util.GDMsgFormatter;
import org.gdstash.util.GDMsgLogger;

public class DBItemSetAlloc {
    public static final String TABLE_NAME = "GD_ITEMSET_ALLOC";
    public static final int ROW_ITEMSET_ID = 1;
    public static final int ROW_ITEM_ID = 2;

    public static void createTable() throws SQLException {
        String dropTable = "DROP TABLE GD_ITEMSET_ALLOC";
        String createTable = "CREATE TABLE GD_ITEMSET_ALLOC (ITEMSET_ID  VARCHAR(256) NOT NULL, ITEM_ID     VARCHAR(256) NOT NULL, PRIMARY KEY (ITEMSET_ID, ITEM_ID))";
        try (Connection conn = GDDBData.getConnection();){
            boolean auto = conn.getAutoCommit();
            conn.setAutoCommit(false);
            try (Statement st = conn.createStatement();){
                if (GDDBUtil.tableExists(conn, TABLE_NAME)) {
                    st.execute(dropTable);
                }
                st.execute(createTable);
                st.close();
                conn.commit();
            }
            catch (SQLException ex) {
                conn.rollback();
                throw ex;
            }
            finally {
                conn.setAutoCommit(auto);
            }
        }
    }

    public static void delete(Connection conn, String itemSetID) throws SQLException {
        String deleteEntry = "DELETE FROM GD_ITEMSET_ALLOC WHERE ITEMSET_ID = ?";
        try (PreparedStatement ps = conn.prepareStatement(deleteEntry);){
            ps.setString(1, itemSetID);
            ps.executeUpdate();
            ps.close();
        }
    }

    public static void insert(Connection conn, DBItemSet dbItemSet) throws SQLException {
        if (dbItemSet.getItemIDList() == null) {
            return;
        }
        if (dbItemSet.getItemIDList().isEmpty()) {
            return;
        }
        String insert = "INSERT INTO GD_ITEMSET_ALLOC VALUES (?,?)";
        try (PreparedStatement ps = conn.prepareStatement(insert);){
            for (String item : dbItemSet.getItemIDList()) {
                ps.setString(1, dbItemSet.getItemSetID());
                ps.setString(2, item);
                ps.executeUpdate();
                ps.clearParameters();
            }
            ps.close();
            conn.commit();
        }
    }

    public static List<String> getByItemSetID(String itemSetID) {
        List<String> itemIDs = null;
        String command = "SELECT * FROM GD_ITEMSET_ALLOC WHERE ITEMSET_ID = ?";
        try (Connection conn = GDDBData.getConnection();
             PreparedStatement ps = conn.prepareStatement(command);){
            ps.setString(1, itemSetID);
            try (ResultSet rs = ps.executeQuery();){
                itemIDs = DBItemSetAlloc.wrap(rs);
                conn.commit();
            }
        }
        catch (SQLException ex) {
            Object[] args = new Object[]{itemSetID, "DBItemSetAlloc"};
            String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_READ_TABLE_BY_ID", args);
            GDMsgLogger.addError(msg);
            GDMsgLogger.addError(ex);
        }
        return itemIDs;
    }

    private static List<String> wrap(ResultSet rs) throws SQLException {
        LinkedList<String> list = new LinkedList<String>();
        boolean found = false;
        while (rs.next()) {
            String itemID = rs.getString(2);
            list.add(itemID);
        }
        return list;
    }
}

