/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;
import org.gdstash.db.DBLootTableSet;
import org.gdstash.db.GDDBData;
import org.gdstash.db.GDDBUtil;
import org.gdstash.util.GDMsgFormatter;
import org.gdstash.util.GDMsgLogger;

public class DBLootTableSetAlloc {
    public static final String TABLE_NAME = "GD_LOOTTABLESET_ALLOC";
    public static final int ROW_TABLESET_ID = 1;
    public static final int ROW_LEVEL_MIN = 2;
    public static final int ROW_TABLE_ID = 3;
    private int levelMin = -1;
    private String tableID = null;

    public int getMinLevel() {
        return this.levelMin;
    }

    public String getTableID() {
        return this.tableID;
    }

    public void setMinLevel(int levelMin) {
        this.levelMin = levelMin;
    }

    public void setTableID(String tableID) {
        this.tableID = tableID;
    }

    public static void createTable() throws SQLException {
        String dropTable = "DROP TABLE GD_LOOTTABLESET_ALLOC";
        String createTable = "CREATE TABLE GD_LOOTTABLESET_ALLOC (TABLESET_ID VARCHAR(256) NOT NULL, LEVEL_MIN   INTEGER, TABLE_ID    VARCHAR(256) NOT NULL, PRIMARY KEY (TABLESET_ID, LEVEL_MIN, TABLE_ID))";
        try (Connection conn = GDDBData.getConnection();){
            boolean auto = conn.getAutoCommit();
            conn.setAutoCommit(false);
            try (Statement st = conn.createStatement();){
                if (GDDBUtil.tableExists(conn, TABLE_NAME)) {
                    st.execute(dropTable);
                }
                st.execute(createTable);
                st.close();
                conn.commit();
            }
            catch (SQLException ex) {
                conn.rollback();
                Object[] args = new Object[]{"DBLootTableSetAlloc"};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_CREATE_TABLE", args);
                GDMsgLogger.addError(msg);
                throw ex;
            }
            finally {
                conn.setAutoCommit(auto);
            }
        }
    }

    public static void delete(Connection conn, String tableSetID) throws SQLException {
        String deleteEntry = "DELETE FROM GD_LOOTTABLESET_ALLOC WHERE TABLESET_ID = ?";
        try (PreparedStatement ps = conn.prepareStatement(deleteEntry);){
            ps.setString(1, tableSetID);
            ps.executeUpdate();
            ps.close();
        }
    }

    public static void insert(Connection conn, DBLootTableSet dbTableSet) throws SQLException {
        if (dbTableSet.getAllocList() == null) {
            return;
        }
        if (dbTableSet.getAllocList().isEmpty()) {
            return;
        }
        String insert = "INSERT INTO GD_LOOTTABLESET_ALLOC VALUES (?,?,?)";
        try (PreparedStatement ps = conn.prepareStatement(insert);){
            for (DBLootTableSetAlloc entry : dbTableSet.getAllocList()) {
                if (entry.tableID == null) continue;
                ps.setString(1, dbTableSet.getTableSetID());
                ps.setInt(2, entry.levelMin);
                ps.setString(3, entry.tableID);
                ps.executeUpdate();
                ps.clearParameters();
            }
            ps.close();
            conn.commit();
        }
    }

    public static List<DBLootTableSetAlloc> getByTableSetID(String tableSetID) {
        List<DBLootTableSetAlloc> list = null;
        String command = "SELECT * FROM GD_LOOTTABLESET_ALLOC WHERE TABLESET_ID = ?";
        try (Connection conn = GDDBData.getConnection();
             PreparedStatement ps = conn.prepareStatement(command);){
            ps.setString(1, tableSetID);
            try (ResultSet rs = ps.executeQuery();){
                list = DBLootTableSetAlloc.wrap(rs);
                conn.commit();
            }
        }
        catch (SQLException ex) {
            Object[] args = new Object[]{tableSetID, "DBLootTableSetAlloc"};
            String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_READ_TABLE_BY_ID", args);
            GDMsgLogger.addError(msg);
            GDMsgLogger.addError(ex);
        }
        return list;
    }

    private static List<DBLootTableSetAlloc> wrap(ResultSet rs) throws SQLException {
        LinkedList<DBLootTableSetAlloc> list = new LinkedList<DBLootTableSetAlloc>();
        while (rs.next()) {
            DBLootTableSetAlloc entry = new DBLootTableSetAlloc();
            entry.levelMin = rs.getInt(2);
            entry.tableID = rs.getString(3);
            list.add(entry);
        }
        return list;
    }
}

