/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.gdstash.db.DBCharBonus;
import org.gdstash.db.DBDamage;
import org.gdstash.db.GDDBData;
import org.gdstash.db.GDDBUtil;
import org.gdstash.description.BonusDetail;
import org.gdstash.file.ARZRecord;
import org.gdstash.util.GDMsgFormatter;
import org.gdstash.util.GDMsgLogger;

public class DBSkill {
    public static final String TABLE_NAME = "GD_SKILL";
    public static final String FIELD_ID = "SKILL_ID";
    public static final String TABLE_DAMAGE = "GD_SKILL_DAMAGE";
    public static final String TABLE_CHAR = "GD_SKILL_CHAR";
    public static final String TABLE_RACE = "GD_SKILL_CHARRACES";
    public static final String TEMPLATE_MASTERY = "database/templates/skill_mastery.tpl";
    public static final int ROW_SKILL_ID = 1;
    public static final int ROW_NAME = 2;
    public static final int ROW_DESCRIPTION = 3;
    public static final int ROW_MASTERY = 4;
    public static final int ROW_MANA_COST = 5;
    public static final int ROW_COOLDOWN_TIME = 6;
    public static final int ROW_WEAPON_DMG_PERC = 7;
    public static final int ROW_BUFF_SKILL_ID = 8;
    public static final int ROW_PET_SKILL_ID = 9;
    private static ConcurrentHashMap<String, DBSkill> hashBuffer = new ConcurrentHashMap();
    private String skillID;
    private String name;
    private String description;
    private boolean mastery;
    private int manaCost;
    private int cooldownTime;
    private int weaponDamagePerc;
    private String buffSkillID;
    private String petSkillID;
    private DBCharBonus charBonus;
    private List<DBDamage> damages;
    private DBSkill dbBuffSkill;
    private DBSkill dbPetSkill;

    public DBSkill() {
        this.skillID = null;
        this.name = null;
        this.mastery = false;
        this.buffSkillID = null;
        this.charBonus = null;
        this.damages = new LinkedList<DBDamage>();
    }

    private DBSkill(ARZRecord record) {
        this.skillID = record.getFileName();
        this.name = record.getSkillName();
        this.description = record.getSkillDescription();
        this.setTemplate(record.getTemplate());
        this.manaCost = record.getSkillManaCost();
        this.cooldownTime = record.getSkillCooldownTime();
        this.weaponDamagePerc = record.getSkillWeaponDamagePerc();
        this.buffSkillID = record.getSkillBuffID();
        this.petSkillID = record.getSkillPetID();
        this.charBonus = null;
        this.damages = new LinkedList<DBDamage>();
        this.charBonus = record.dbCharBonus;
        this.damages = record.dbDamages;
    }

    public String getSkillID() {
        return this.skillID;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        if (this.dbBuffSkill != null) {
            return this.dbBuffSkill.getDescription();
        }
        return this.description;
    }

    public boolean isMastery() {
        return this.mastery;
    }

    public int getManaCost() {
        if (this.dbBuffSkill != null) {
            return this.dbBuffSkill.getManaCost();
        }
        return this.manaCost;
    }

    public int getCooldownTime() {
        if (this.dbBuffSkill != null) {
            return this.dbBuffSkill.getCooldownTime();
        }
        return this.cooldownTime;
    }

    public int getWeaponDamagePerc() {
        if (this.dbBuffSkill != null) {
            return this.dbBuffSkill.getWeaponDamagePerc();
        }
        return this.weaponDamagePerc;
    }

    public DBCharBonus getCharBonus() {
        if (this.dbBuffSkill != null) {
            return this.dbBuffSkill.getCharBonus();
        }
        return this.charBonus;
    }

    public List<DBDamage> getDamageList() {
        if (this.dbBuffSkill != null) {
            return this.dbBuffSkill.getDamageList();
        }
        return this.damages;
    }

    public String getBuffSkillID() {
        return this.buffSkillID;
    }

    public DBSkill getBuffSkill() {
        return this.dbBuffSkill;
    }

    public String getPetSkillID() {
        return this.petSkillID;
    }

    public DBSkill getPetSkill() {
        return this.dbPetSkill;
    }

    private void setTemplate(String template) {
        this.mastery = template.equals(TEMPLATE_MASTERY);
    }

    public static void clearBuffer() {
        hashBuffer.clear();
    }

    public static void createTables() throws SQLException {
        String dropTable = "DROP TABLE GD_SKILL";
        String createTable = "CREATE TABLE GD_SKILL (SKILL_ID  VARCHAR(256) NOT NULL, NAME            VARCHAR(128), DESCRIPTION     VARCHAR(1024), MASTERY         BOOLEAN, MANA_COST       INTEGER, COOLDOWN_TIME   INTEGER, WEAPON_DMG_PERC INTEGER, BUFF_SKILL_ID   VARCHAR(256), PET_SKILL_ID    VARCHAR(256), PRIMARY KEY (SKILL_ID))";
        try (Connection conn = GDDBData.getConnection();){
            boolean auto = conn.getAutoCommit();
            conn.setAutoCommit(false);
            try (Statement st = conn.createStatement();){
                if (GDDBUtil.tableExists(conn, TABLE_NAME)) {
                    st.execute(dropTable);
                }
                st.execute(createTable);
                st.close();
                conn.commit();
                DBDamage.createTable(conn, TABLE_DAMAGE, FIELD_ID);
                DBCharBonus.createTable(conn, TABLE_CHAR, TABLE_RACE, FIELD_ID);
            }
            catch (SQLException ex) {
                conn.rollback();
                Object[] args = new Object[]{"DBSkill"};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_CREATE_TABLE", args);
                GDMsgLogger.addError(msg);
                throw ex;
            }
            finally {
                conn.setAutoCommit(auto);
            }
        }
    }

    public static void delete(String skillID) throws SQLException {
        String deleteEntry = "DELETE FROM GD_SKILL WHERE SKILL_ID = ?";
        try (Connection conn = GDDBData.getConnection();){
            boolean auto = conn.getAutoCommit();
            conn.setAutoCommit(false);
            try (PreparedStatement ps = conn.prepareStatement(deleteEntry);){
                ps.setString(1, skillID);
                ps.executeUpdate();
                ps.close();
                DBCharBonus.delete(conn, TABLE_CHAR, TABLE_RACE, FIELD_ID, skillID);
                DBDamage.delete(conn, TABLE_DAMAGE, FIELD_ID, skillID);
                conn.commit();
            }
            catch (SQLException ex) {
                conn.rollback();
                Object[] args = new Object[]{skillID, "DBSkill"};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_DEL_TABLE_BY_ID", args);
                GDMsgLogger.addError(msg);
                GDMsgLogger.addError(ex);
                throw ex;
            }
            finally {
                conn.setAutoCommit(auto);
            }
        }
    }

    public static void insert(ARZRecord record) throws SQLException {
        DBSkill skill = new DBSkill(record);
        String insert = "INSERT INTO GD_SKILL VALUES (?,?,?,?,?,?,?,?,?)";
        try (Connection conn = GDDBData.getConnection();){
            boolean auto = conn.getAutoCommit();
            conn.setAutoCommit(false);
            try (PreparedStatement ps = conn.prepareStatement(insert);){
                ps.setString(1, skill.skillID);
                ps.setString(2, skill.name);
                ps.setString(3, skill.description);
                ps.setBoolean(4, skill.mastery);
                ps.setInt(5, skill.manaCost);
                ps.setInt(6, skill.cooldownTime);
                ps.setInt(7, skill.weaponDamagePerc);
                ps.setString(8, skill.buffSkillID);
                ps.setString(9, skill.petSkillID);
                ps.executeUpdate();
                ps.close();
                conn.commit();
                DBCharBonus.insert(conn, TABLE_CHAR, TABLE_RACE, skill.skillID, skill.charBonus);
                DBDamage.insert(conn, TABLE_DAMAGE, skill.skillID, skill.damages);
            }
            catch (SQLException ex) {
                conn.rollback();
                Object[] args = new Object[]{skill.skillID};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_IN_SKILL", args);
                GDMsgLogger.addError(msg);
                throw ex;
            }
            finally {
                conn.setAutoCommit(auto);
            }
        }
    }

    public static void insertMod(ARZRecord record) throws SQLException {
        DBSkill entry = DBSkill.get(record.getFileName());
        if (entry != null) {
            DBSkill.delete(record.getFileName());
        }
        DBSkill.insert(record);
    }

    public static DBSkill get(String skillID) {
        DBSkill skill = null;
        skill = hashBuffer.get(skillID);
        if (skill == null && (skill = DBSkill.getDB(skillID)) != null) {
            hashBuffer.put(skill.skillID, skill);
        }
        return skill;
    }

    private static DBSkill getDB(String skillID) {
        DBSkill skill = null;
        String command = "SELECT * FROM GD_SKILL WHERE SKILL_ID = ?";
        try (Connection conn = GDDBData.getConnection();
             PreparedStatement ps = conn.prepareStatement(command);){
            ps.setString(1, skillID);
            try (ResultSet rs = ps.executeQuery();){
                List<DBSkill> list = DBSkill.wrap(rs);
                skill = list.isEmpty() ? null : list.get(0);
                conn.commit();
            }
        }
        catch (SQLException ex) {
            Object[] args = new Object[]{skillID, "DBSkill"};
            String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_READ_TABLE_BY_ID", args);
            GDMsgLogger.addError(msg);
            GDMsgLogger.addError(ex);
        }
        return skill;
    }

    private static List<DBSkill> wrap(ResultSet rs) throws SQLException {
        LinkedList<DBSkill> list = new LinkedList<DBSkill>();
        while (rs.next()) {
            DBSkill skill = new DBSkill();
            skill.skillID = rs.getString(1);
            skill.name = rs.getString(2);
            skill.description = rs.getString(3);
            skill.mastery = rs.getBoolean(4);
            skill.manaCost = rs.getInt(5);
            skill.cooldownTime = rs.getInt(6);
            skill.weaponDamagePerc = rs.getInt(7);
            skill.buffSkillID = rs.getString(8);
            skill.petSkillID = rs.getString(9);
            skill.charBonus = DBCharBonus.getBySkillID(skill.skillID);
            skill.damages = DBDamage.getBySkillID(skill.skillID);
            if (skill.buffSkillID != null && !skill.buffSkillID.equals(skill.skillID)) {
                skill.dbBuffSkill = DBSkill.get(skill.buffSkillID);
            }
            if (skill.petSkillID != null && !skill.petSkillID.equals(skill.skillID)) {
                skill.dbPetSkill = DBSkill.get(skill.petSkillID);
            }
            list.add(skill);
        }
        return list;
    }

    public BonusDetail getBonusDetail() {
        BonusDetail bonus = new BonusDetail(this);
        return bonus;
    }
}

