/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;
import org.gdstash.db.GDDBData;
import org.gdstash.db.GDDBUtil;
import org.gdstash.description.BonusDetail;
import org.gdstash.util.GDMsgFormatter;
import org.gdstash.util.GDMsgLogger;

public class DBSkillBonus
implements Cloneable {
    public static final int ROW_ITEM_ID = 1;
    public static final int ROW_BONUS_TYPE = 2;
    public static final int ROW_INDEX = 3;
    public static final int ROW_BONUS_ENTITY = 4;
    public static final int ROW_BONUS_VALUE = 5;
    public static final int ROW_ENTITY_NAME = 6;
    public static final int TYPE_MASTERY = 1;
    public static final int TYPE_SKILL = 2;
    private String itemID;
    private int type;
    private int index;
    private String bonusEntity;
    private int bonusValue;
    private String entityName;

    public DBSkillBonus() {
        this.itemID = null;
        this.type = 0;
        this.index = 0;
        this.bonusEntity = null;
        this.bonusValue = 0;
        this.entityName = null;
    }

    public DBSkillBonus(int index, int type, String bonusEntity) {
        this.itemID = null;
        this.type = type;
        this.index = index;
        this.bonusEntity = bonusEntity;
        this.bonusValue = 0;
        this.entityName = null;
    }

    public DBSkillBonus(int index, int type, int bonusValue) {
        this.itemID = null;
        this.type = type;
        this.index = index;
        this.bonusEntity = null;
        this.bonusValue = bonusValue;
        this.entityName = null;
    }

    private DBSkillBonus(DBSkillBonus bonus) {
        this.itemID = bonus.itemID;
        this.type = bonus.type;
        this.index = bonus.index;
        this.bonusEntity = bonus.bonusEntity;
        this.bonusValue = bonus.bonusValue;
        this.entityName = bonus.entityName;
    }

    public Object clome() {
        return new DBSkillBonus(this);
    }

    public String getID() {
        return this.itemID;
    }

    public int getSkillBonusType() {
        return this.type;
    }

    public int getIndex() {
        return this.index;
    }

    public String getEntity() {
        return this.bonusEntity;
    }

    public int getValue() {
        return this.bonusValue;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public static void addEntity(List<DBSkillBonus> list, int index, int type, String bonusEntity) {
        boolean found = false;
        for (DBSkillBonus bonus : list) {
            if (bonus.getIndex() != index || bonus.getSkillBonusType() != type) continue;
            bonus.setEntity(bonusEntity);
            found = true;
            break;
        }
        if (!found) {
            DBSkillBonus bonus;
            bonus = new DBSkillBonus(index, type, bonusEntity);
            list.add(bonus);
        }
    }

    public static void addValue(List<DBSkillBonus> list, int index, int type, int bonusValue) {
        boolean found = false;
        for (DBSkillBonus bonus : list) {
            if (bonus.getIndex() != index || bonus.getSkillBonusType() != type) continue;
            bonus.setValue(bonusValue);
            found = true;
            break;
        }
        if (!found) {
            DBSkillBonus bonus;
            bonus = new DBSkillBonus(index, type, bonusValue);
            list.add(bonus);
        }
    }

    public void setID(String itemID) {
        this.itemID = itemID;
    }

    public void setSkillBonusType(int type) {
        this.type = type;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public void setEntity(String bonusEntity) {
        this.bonusEntity = bonusEntity;
    }

    public void setValue(int bonusValue) {
        this.bonusValue = bonusValue;
    }

    public void setEntityName(String entityName) {
        this.entityName = entityName;
    }

    public static void createTable(Connection conn, String tabName, String idName) throws SQLException {
        String dropTable = "DROP TABLE " + tabName;
        String createTable = "CREATE TABLE " + tabName + " (" + idName + "    VARCHAR(256) NOT NULL, " + "TYPE         INTEGER, " + "INDEX        INTEGER, " + "BONUS_ENTITY VARCHAR(128), " + "BONUS_VALUE  INTEGER, " + "ENTITY_NAME  VARCHAR(128), " + "PRIMARY KEY (" + idName + ", TYPE, INDEX))";
        try (Statement st = conn.createStatement();){
            if (GDDBUtil.tableExists(conn, tabName)) {
                st.execute(dropTable);
            }
            st.execute(createTable);
            st.close();
            conn.commit();
        }
        catch (SQLException ex) {
            Object[] args = new Object[]{tabName};
            String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_CREATE_TABLE", args);
            GDMsgLogger.addError(msg);
            throw ex;
        }
    }

    public static void delete(Connection conn, String tabName, String idName, String itemID) throws SQLException {
        String deleteEntry = "DELETE FROM " + tabName + " WHERE " + idName + " = ?";
        try (PreparedStatement ps = conn.prepareStatement(deleteEntry);){
            ps.setString(1, itemID);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException ex) {
            conn.rollback();
        }
    }

    public static void insert(Connection conn, String tabName, String id, List<DBSkillBonus> bonuses) throws SQLException {
        String insert = "INSERT INTO " + tabName + " VALUES (?,?,?,?,?,?)";
        if (bonuses == null) {
            return;
        }
        if (bonuses.isEmpty()) {
            return;
        }
        try (PreparedStatement ps = conn.prepareStatement(insert);){
            for (DBSkillBonus bonus : bonuses) {
                ps.setString(1, id);
                ps.setInt(2, bonus.type);
                ps.setInt(3, bonus.index);
                ps.setString(4, bonus.bonusEntity);
                ps.setInt(5, bonus.bonusValue);
                ps.setString(6, bonus.entityName);
                ps.executeUpdate();
                ps.clearParameters();
            }
            ps.close();
            conn.commit();
        }
    }

    public static List<DBSkillBonus> getByItemID(String itemID) {
        List<DBSkillBonus> list = new LinkedList<DBSkillBonus>();
        String command = "SELECT * FROM GD_ITEM_SKILLS WHERE ITEM_ID = ?";
        try (Connection conn = GDDBData.getConnection();
             PreparedStatement ps = conn.prepareStatement(command);){
            ps.setString(1, itemID);
            try (ResultSet rs = ps.executeQuery();){
                list = DBSkillBonus.wrap(rs);
                conn.commit();
            }
        }
        catch (SQLException ex) {
            Object[] args = new Object[]{itemID, "GD_ITEM_SKILLS"};
            String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_READ_TABLE_BY_ID", args);
            GDMsgLogger.addError(msg);
            GDMsgLogger.addError(ex);
        }
        return list;
    }

    public static List<DBSkillBonus> getByAffixID(String affixID) {
        List<DBSkillBonus> list = new LinkedList<DBSkillBonus>();
        String command = "SELECT * FROM GD_AFFIX_SKILLS WHERE AFFIX_ID = ?";
        try (Connection conn = GDDBData.getConnection();
             PreparedStatement ps = conn.prepareStatement(command);){
            ps.setString(1, affixID);
            try (ResultSet rs = ps.executeQuery();){
                list = DBSkillBonus.wrap(rs);
                conn.commit();
            }
        }
        catch (SQLException ex) {
            Object[] args = new Object[]{affixID, "GD_AFFIX_SKILLS"};
            String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_READ_TABLE_BY_ID", args);
            GDMsgLogger.addError(msg);
            GDMsgLogger.addError(ex);
        }
        return list;
    }

    private static List<DBSkillBonus> wrap(ResultSet rs) throws SQLException {
        LinkedList<DBSkillBonus> list = new LinkedList<DBSkillBonus>();
        while (rs.next()) {
            DBSkillBonus bonus = new DBSkillBonus();
            bonus.itemID = rs.getString(1);
            bonus.type = rs.getInt(2);
            bonus.index = rs.getInt(3);
            bonus.bonusEntity = rs.getString(4);
            bonus.bonusValue = rs.getInt(5);
            bonus.entityName = rs.getString(6);
            list.add(bonus);
        }
        return list;
    }

    public static void add(List<DBSkillBonus> list, List<DBSkillBonus> addList) {
        if (addList == null) {
            return;
        }
        for (DBSkillBonus bonusAdd : addList) {
            if (bonusAdd == null || bonusAdd.bonusEntity == null) continue;
            try {
                bonusAdd = (DBSkillBonus)bonusAdd.clone();
            }
            catch (CloneNotSupportedException ex) {
                // empty catch block
            }
            boolean found = false;
            for (DBSkillBonus bonus : list) {
                if (bonus == null || bonusAdd.type != bonus.type || !bonusAdd.bonusEntity.equals(bonus.bonusEntity)) continue;
                bonus.bonusValue += bonusAdd.bonusValue;
                found = true;
                break;
            }
            if (found) continue;
            list.add(bonusAdd);
        }
    }

    public BonusDetail getBonusDetail() {
        BonusDetail bonus = new BonusDetail(this);
        return bonus;
    }
}

