/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.db;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;
import org.gdstash.db.DBAffix;
import org.gdstash.db.DBFormulaSet;
import org.gdstash.db.DBItem;
import org.gdstash.db.GDDBData;
import org.gdstash.db.GDDBUtil;
import org.gdstash.db.ItemSlots;
import org.gdstash.db.ParameterSet;
import org.gdstash.db.SelectionCriteria;
import org.gdstash.db.criteria.AbstractItemCombination;
import org.gdstash.db.criteria.StashIDItemCombination;
import org.gdstash.db.criteria.StashIDItemDamageCombination;
import org.gdstash.db.criteria.StashIDPrefixCombination;
import org.gdstash.db.criteria.StashIDSuffixCombination;
import org.gdstash.file.GDReader;
import org.gdstash.file.GDWriter;
import org.gdstash.item.GDItem;
import org.gdstash.ui.GDStashFrame;
import org.gdstash.util.GDConstants;
import org.gdstash.util.GDLog;
import org.gdstash.util.GDMsgFormatter;
import org.gdstash.util.GDMsgLogger;

public class DBStashItem
implements Cloneable,
ParameterSet {
    public static final String TABLE_NAME = "STASH_ITEM_V4";
    public static final String TABLE_NAME_V1 = "STASH_ITEM";
    public static final String TABLE_NAME_V2 = "STASH_ITEM_V2";
    public static final String TABLE_NAME_V3 = "STASH_ITEM_V3";
    public static final String TABLE_NAME_V4 = "STASH_ITEM_V4";
    public static final int VERSION_STASH_FILE = 1;
    public static final int ROW_STASH_ID = 1;
    public static final int ROW_ITEM_ID = 2;
    public static final int ROW_PREFIX_ID = 3;
    public static final int ROW_SUFFIX_ID = 4;
    public static final int ROW_MODIFIER_ID = 5;
    public static final int ROW_TRANSMUTE_ID = 6;
    public static final int ROW_ITEM_SEED = 7;
    public static final int ROW_RELIC_ID = 8;
    public static final int ROW_RELICBONUS_ID = 9;
    public static final int ROW_RELIC_SEED = 10;
    public static final int ROW_ENCHANTMENT_ID = 11;
    public static final int ROW_UNKNOWN = 12;
    public static final int ROW_ENCHANTMENT_SEED = 13;
    public static final int ROW_ITEM_VAR1 = 14;
    public static final int ROW_STACKCOUNT = 15;
    public static final int ROW_HARDCORE = 16;
    public static final int ROW_CHARNAME = 17;
    public static final int ROW_SOULBOUND = 18;
    public static final int ROW_RARITY = 19;
    public static final int ROW_REQ_LEVEL = 20;
    public static final int ROW_REQ_DEX = 21;
    public static final int ROW_REQ_INT = 22;
    public static final int ROW_REQ_STR = 23;
    public static final int ROW_ITEM_CLASS = 24;
    public static final int ROW_ARMOR_CLASS = 25;
    public static final int ROW_ARTIFACT_CLASS = 26;
    public static final int ROW_ITEM_LEVEL = 27;
    public static final int ROW_SET_ID = 28;
    public static final int ROW_ITEM_NAME = 29;
    public static final int ROW_PET_BONUS_SKILL_ID = 30;
    public static final int ROW_ENEMY_ONLY = 31;
    public static final int ROW_SLOT_AXE_1H = 32;
    public static final int ROW_SLOT_AXE_2H = 33;
    public static final int ROW_SLOT_DAGGER_1H = 34;
    public static final int ROW_SLOT_MACE_1H = 35;
    public static final int ROW_SLOT_MACE_2H = 36;
    public static final int ROW_SLOT_SCEPTER_1H = 37;
    public static final int ROW_SLOT_SPEAR_2H = 38;
    public static final int ROW_SLOT_STAFF_2H = 39;
    public static final int ROW_SLOT_SWORD_1H = 40;
    public static final int ROW_SLOT_SWORD_2H = 41;
    public static final int ROW_SLOT_RANGED_1H = 42;
    public static final int ROW_SLOT_RANGED_2H = 43;
    public static final int ROW_SLOT_SHIELD = 44;
    public static final int ROW_SLOT_OFFHAND = 45;
    public static final int ROW_SLOT_AMULET = 46;
    public static final int ROW_SLOT_BELT = 47;
    public static final int ROW_SLOT_MEDAL = 48;
    public static final int ROW_SLOT_RING = 49;
    public static final int ROW_SLOT_HEAD = 50;
    public static final int ROW_SLOT_SHOULDERS = 51;
    public static final int ROW_SLOT_CHEST = 52;
    public static final int ROW_SLOT_HANDS = 53;
    public static final int ROW_SLOT_LEGS = 54;
    public static final int ROW_SLOT_FEET = 55;
    private int stashID = -1;
    private String itemID;
    private String prefixID;
    private String suffixID;
    private String modifierID;
    private String transmuteID;
    private int seed;
    private String relicID;
    private String relicBonusID;
    private int relicSeed;
    private String enchantmentID;
    private int unknown;
    private int enchantmentSeed;
    private int var1;
    private int stackCount;
    private boolean hardcore;
    private String charname;
    private boolean soulbound;
    private String rarity;
    private int reqLevel;
    private int reqDex;
    private int reqInt;
    private int reqStr;
    private String itemClass;
    private String armorClass;
    private String artifactClass;
    private int itemLevel;
    private String setID;
    private String itemName;
    private String petBonusSkillID;
    private boolean enemyOnly;
    private ItemSlots slots;
    private DBItem dbItem;
    private DBAffix dbPrefix;
    private DBAffix dbSuffix;
    private DBAffix dbModifier;
    private DBItem dbComponent;
    private DBAffix dbBonus;
    private DBItem dbEnchantment;

    public DBStashItem() {
        this.itemID = null;
        this.prefixID = null;
        this.suffixID = null;
        this.modifierID = null;
        this.transmuteID = null;
        this.seed = 0;
        this.relicID = null;
        this.relicBonusID = null;
        this.relicSeed = 0;
        this.enchantmentID = null;
        this.unknown = 0;
        this.enchantmentSeed = 0;
        this.var1 = 0;
        this.stackCount = 0;
        this.hardcore = false;
        this.charname = null;
        this.slots = new ItemSlots();
        this.fillDependentStats(null);
    }

    public DBStashItem(String charname, boolean hardcore) {
        this();
        this.charname = charname;
        this.hardcore = hardcore;
    }

    public DBStashItem(DBItem item) {
        this();
        if (item != null) {
            this.itemID = item.getItemID();
            if (item.isComponent()) {
                this.var1 = item.getComponentPieces();
            }
        }
        this.fillDependentStats(null);
    }

    public DBStashItem(DBStashItem item) {
        this.itemID = item.itemID;
        this.prefixID = item.prefixID;
        this.suffixID = item.suffixID;
        this.modifierID = item.modifierID;
        this.transmuteID = item.transmuteID;
        this.seed = item.seed;
        this.relicID = item.relicID;
        this.relicBonusID = item.relicBonusID;
        this.relicSeed = item.relicSeed;
        this.enchantmentID = item.enchantmentID;
        this.unknown = item.unknown;
        this.enchantmentSeed = item.enchantmentSeed;
        this.var1 = item.var1;
        this.stackCount = item.stackCount;
        this.hardcore = item.hardcore;
        this.charname = item.charname;
        this.slots = item.slots.clone();
        this.fillDependentStats(null);
    }

    public DBStashItem clone() {
        DBStashItem item = new DBStashItem(this);
        return item;
    }

    public int getStashID() {
        return this.stashID;
    }

    public String getItemID() {
        return this.itemID;
    }

    public String getPrefixID() {
        return this.prefixID;
    }

    public String getSuffixID() {
        return this.suffixID;
    }

    public String getModifierID() {
        return this.modifierID;
    }

    public String getTransmuteID() {
        return this.transmuteID;
    }

    public int getItemSeed() {
        return this.seed;
    }

    public String getComponentID() {
        return this.relicID;
    }

    public String getCompletionBonusID() {
        return this.relicBonusID;
    }

    public int getComponentSeed() {
        return this.relicSeed;
    }

    public String getAugmentID() {
        return this.enchantmentID;
    }

    public int getUnknown() {
        return this.unknown;
    }

    public int getAugmentSeed() {
        return this.enchantmentSeed;
    }

    public int getVar1() {
        return this.var1;
    }

    public int getStackCount() {
        return this.stackCount;
    }

    public boolean isHardcore() {
        return this.hardcore;
    }

    public String getCharName() {
        return this.charname;
    }

    public boolean isSoulbound() {
        return this.soulbound;
    }

    public String getRarity() {
        return this.rarity;
    }

    public int getRequiredlevel() {
        return this.reqLevel;
    }

    public int getRequiredCunning() {
        return this.reqDex;
    }

    public int getRequiredPhysique() {
        return this.reqStr;
    }

    public int getRequiredSpirit() {
        return this.reqInt;
    }

    public DBItem getDBItem() {
        return this.dbItem;
    }

    public DBAffix getDBPrefix() {
        return this.dbPrefix;
    }

    public DBAffix getDBSuffix() {
        return this.dbSuffix;
    }

    public DBAffix getDBModifier() {
        return this.dbModifier;
    }

    public DBItem getDBComponent() {
        return this.dbComponent;
    }

    public DBAffix getDBCompletionBonus() {
        return this.dbBonus;
    }

    public DBItem getDBAugment() {
        return this.dbEnchantment;
    }

    public boolean isComponent() {
        if (this.dbItem == null) {
            return false;
        }
        return this.dbItem.isComponent();
    }

    public boolean isIncompleteComponent() {
        if (this.dbItem == null) {
            return true;
        }
        if (this.dbItem.isComponent()) {
            return this.getVar1() != this.dbItem.getComponentPieces();
        }
        if (this.dbComponent == null) {
            return true;
        }
        return this.getVar1() != this.dbComponent.getComponentPieces();
    }

    public int getComponentPieces() {
        if (this.dbItem == null) {
            return 0;
        }
        if (this.dbItem.isComponent()) {
            return this.dbItem.getComponentPieces();
        }
        if (this.dbComponent == null) {
            return 0;
        }
        return this.dbComponent.getComponentPieces();
    }

    public boolean isStackable() {
        if (this.dbItem == null) {
            return false;
        }
        if (this.dbItem.getItemClass().equals("ItemRelic")) {
            return this.getVar1() >= this.dbItem.getComponentPieces();
        }
        return this.dbItem.isStackable();
    }

    public int getDefaultStackSize() {
        if (this.dbItem == null) {
            return 1;
        }
        int size = this.dbItem.getMaxStackSize();
        if (size == 0) {
            size = 1;
            String itemClass = this.dbItem.getItemClass();
            if (itemClass.equals("ItemRelic")) {
                size = 100;
            }
            if (itemClass.equals("OneShot_PotionHealth")) {
                size = 100;
            }
            if (itemClass.equals("OneShot_PotionMana")) {
                size = 100;
            }
            if (itemClass.equals("QuestItem") && DBItem.QUEST_ITEMS.contains(this.itemID)) {
                size = 100;
            }
            if (itemClass.equals("ItemEnchantment")) {
                size = 100;
            }
        }
        if (size > this.stackCount) {
            size = this.stackCount;
        }
        return size;
    }

    public void setStashID(int stashID) {
        this.stashID = stashID;
    }

    public void setItemID(String itemID) {
        this.itemID = itemID;
    }

    public void setPrefixID(String prefixID) {
        this.prefixID = prefixID;
    }

    public void setSuffixID(String suffixID) {
        this.suffixID = suffixID;
    }

    public void setModifierID(String modifierID) {
        this.modifierID = modifierID;
    }

    public void setTransmuteID(String transmuteID) {
        this.transmuteID = transmuteID;
    }

    public void setItemSeed(int seed) {
        this.seed = seed;
    }

    public void setComponentID(String relicID) {
        this.relicID = relicID;
    }

    public void setCompletionBonusID(String relicBonusID) {
        this.relicBonusID = relicBonusID;
    }

    public void setComponentSeed(int relicSeed) {
        this.relicSeed = relicSeed;
    }

    public void setAugmentID(String enchantmentID) {
        this.enchantmentID = enchantmentID;
    }

    public void setUnknown(int unknown) {
        this.unknown = unknown;
    }

    public void setAugmentSeed(int enchantmentSeed) {
        this.enchantmentSeed = enchantmentSeed;
    }

    public void setVar1(int var1) {
        this.var1 = var1;
    }

    public void setStackCount(int stackCount) {
        this.stackCount = stackCount;
    }

    public void setHardcore(boolean hardcore) {
        this.hardcore = hardcore;
    }

    public void setCharName(String charname) {
        this.charname = charname;
    }

    public void setSoulbound(boolean soulbound) {
        this.soulbound = soulbound;
    }

    public void fillDependentStats(GDLog log) {
        DBFormulaSet.Result result;
        String msg;
        Object[] args;
        this.soulbound = false;
        this.rarity = null;
        this.reqLevel = 0;
        this.reqDex = 0;
        this.reqInt = 0;
        this.reqStr = 0;
        this.itemClass = null;
        this.armorClass = null;
        this.artifactClass = null;
        this.itemLevel = 0;
        this.setID = null;
        this.itemName = null;
        this.petBonusSkillID = null;
        this.enemyOnly = false;
        if (this.slots != null) {
            this.slots.clear();
        }
        this.dbItem = null;
        this.dbPrefix = null;
        this.dbSuffix = null;
        this.dbModifier = null;
        this.dbComponent = null;
        this.dbBonus = null;
        this.dbEnchantment = null;
        if (this.getStackCount() == 0) {
            this.setStackCount(1);
        }
        if (this.getItemID() == null) {
            return;
        }
        this.dbItem = DBItem.get(this.getItemID());
        if (this.dbItem == null) {
            args = new Object[]{"", 0, this.getItemID()};
            msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_ITEM_NOT_FOUND", args);
            if (log == null) {
                GDMsgLogger.addWarning(msg);
            } else {
                log.addWarning(msg);
            }
        }
        if (this.dbItem == null) {
            return;
        }
        if (this.getPrefixID() != null) {
            this.dbPrefix = DBAffix.get(this.getPrefixID());
            if (this.dbPrefix == null) {
                args = new Object[]{"", 0, this.dbItem.getItemName(), this.getPrefixID()};
                msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_AFFIX_NOT_FOUND", args);
                if (log == null) {
                    GDMsgLogger.addWarning(msg);
                } else {
                    log.addWarning(msg);
                }
            }
        }
        if (this.getSuffixID() != null) {
            this.dbSuffix = DBAffix.get(this.getSuffixID());
            if (this.dbSuffix == null) {
                args = new Object[]{"", 0, this.dbItem.getItemName(), this.getSuffixID()};
                msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_AFFIX_NOT_FOUND", args);
                if (log == null) {
                    GDMsgLogger.addWarning(msg);
                } else {
                    log.addWarning(msg);
                }
            }
        }
        if (this.getModifierID() != null) {
            this.dbModifier = DBAffix.get(this.getModifierID());
            if (this.dbModifier == null) {
                args = new Object[]{"", 0, this.dbItem.getItemName(), this.getModifierID()};
                msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_AFFIX_NOT_FOUND", args);
                if (log == null) {
                    GDMsgLogger.addWarning(msg);
                } else {
                    log.addWarning(msg);
                }
            }
        }
        if (this.getComponentID() != null) {
            this.dbComponent = DBItem.get(this.getComponentID());
            if (this.dbComponent == null) {
                args = new Object[]{"", 0, this.getComponentID()};
                msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_ITEM_NOT_FOUND", args);
                if (log == null) {
                    GDMsgLogger.addWarning(msg);
                } else {
                    log.addWarning(msg);
                }
            }
        }
        if (this.getCompletionBonusID() != null) {
            this.dbBonus = DBAffix.get(this.getCompletionBonusID());
            if (this.dbBonus == null) {
                args = new Object[]{"", 0, this.dbItem.getItemName(), this.getCompletionBonusID()};
                msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_AFFIX_NOT_FOUND", args);
                if (log == null) {
                    GDMsgLogger.addWarning(msg);
                } else {
                    log.addWarning(msg);
                }
            }
        }
        if (this.getAugmentID() != null) {
            this.dbEnchantment = DBItem.get(this.getAugmentID());
            if (this.dbEnchantment == null) {
                args = new Object[]{"", 0, this.dbItem.getItemName(), this.getAugmentID()};
                msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_AUGMENT_NOT_FOUND", args);
                if (log == null) {
                    GDMsgLogger.addWarning(msg);
                } else {
                    log.addWarning(msg);
                }
            }
        }
        if ((result = this.dbItem.getStatRequirements(this)) != null) {
            this.reqDex = (int)result.cunning;
            this.reqInt = (int)result.spirit;
            this.reqStr = (int)result.physique;
        }
        if (this.dbItem.isComponent()) {
            if (this.getVar1() > this.dbItem.getComponentPieces()) {
                this.setVar1(this.dbItem.getComponentPieces());
            }
            if (this.getCompletionBonusID() != null) {
                this.setCompletionBonusID(null);
            }
        }
        this.soulbound = this.dbItem.isSoulbound();
        if (this.dbComponent != null && this.dbComponent.isSoulbound()) {
            this.soulbound = true;
        }
        if (this.dbEnchantment != null && this.dbEnchantment.isSoulbound()) {
            this.soulbound = true;
        }
        this.rarity = this.determineRarity();
        this.reqLevel = this.determineRequiredLevel();
        this.itemClass = this.dbItem.getItemClass();
        this.armorClass = this.dbItem.getArmorClass();
        this.artifactClass = this.dbItem.getArtifactClass();
        this.itemLevel = this.dbItem.getItemLevel();
        this.setID = this.dbItem.getItemSetID();
        this.itemName = this.getCompleteName().toUpperCase(GDMsgFormatter.locale);
        this.petBonusSkillID = this.dbItem.getPetBonusSkillID();
        this.enemyOnly = this.dbItem.isEnemyOnly();
        this.slots = this.dbItem.getSlots();
        if (!this.soulbound && !this.dbItem.isQuestItem()) {
            this.charname = null;
        }
    }

    private String appendNamePart(String s, int part, boolean withDmg) {
        if (this.dbItem == null) {
            return s;
        }
        String sPart = null;
        switch (part) {
            case 1: {
                if (this.dbPrefix == null || this.dbItem.isHidePrefix() || (sPart = this.dbPrefix.getGenderText(this.dbItem.getGenderCode())) == null) break;
                if (!s.isEmpty()) {
                    s = s + " ";
                }
                s = s + sPart;
                break;
            }
            case 2: {
                sPart = this.dbItem.getQualityText();
                if (sPart == null) break;
                if (!s.isEmpty()) {
                    s = s + " ";
                }
                s = s + sPart;
                break;
            }
            case 3: {
                sPart = this.dbItem.getStyleText();
                if (sPart == null) break;
                if (!s.isEmpty()) {
                    s = s + " ";
                }
                s = s + sPart;
                break;
            }
            case 4: {
                String dmg;
                sPart = this.dbItem.getName();
                if (sPart == null) break;
                if (!s.isEmpty()) {
                    s = s + " ";
                }
                s = s + sPart;
                if (!withDmg || (dmg = this.dbItem.getMainDamageType()) == null) break;
                s = s + " [" + dmg + "]";
                break;
            }
            case 5: {
                if (this.dbSuffix == null || this.dbItem.isHideSuffix() || (sPart = this.dbSuffix.getGenderText(this.dbItem.getGenderCode())) == null) break;
                if (!s.isEmpty()) {
                    s = s + " ";
                }
                s = s + sPart;
            }
        }
        return s;
    }

    public String getCompleteName() {
        if (this.dbItem == null) {
            return null;
        }
        String name = "";
        name = this.appendNamePart(name, GDStashFrame.dbConfig.namePart1, false);
        name = this.appendNamePart(name, GDStashFrame.dbConfig.namePart2, false);
        name = this.appendNamePart(name, GDStashFrame.dbConfig.namePart3, false);
        name = this.appendNamePart(name, GDStashFrame.dbConfig.namePart4, false);
        name = this.appendNamePart(name, GDStashFrame.dbConfig.namePart5, false);
        return name;
    }

    public String determineRarity() {
        String itemRarity = "Common";
        String prefixRarity = "Common";
        String suffixRarity = "Common";
        if (this.dbItem == null) {
            return "Broken";
        }
        if (this.dbItem.getRarity() != null) {
            itemRarity = this.dbItem.getRarity();
        }
        if (this.dbPrefix != null && this.dbPrefix.getRarity() != null) {
            prefixRarity = this.dbPrefix.getRarity();
        }
        if (this.dbSuffix != null && this.dbSuffix.getRarity() != null) {
            suffixRarity = this.dbSuffix.getRarity();
        }
        String rarity = null;
        rarity = DBStashItem.determineBetterRarity(prefixRarity, suffixRarity);
        rarity = DBStashItem.determineBetterRarity(itemRarity, rarity);
        return rarity;
    }

    private static String determineBetterRarity(String rarity1, String rarity2) {
        if (rarity1.equals("Quest")) {
            return rarity1;
        }
        if (rarity2.equals("Quest")) {
            return rarity2;
        }
        String rarity = rarity1;
        if (rarity.equals("Legendary")) {
            return rarity;
        }
        if (rarity.equals("Epic") && rarity2.equals("Legendary")) {
            rarity = rarity2;
        }
        if (rarity.equals("Rare") && (rarity2.equals("Legendary") || rarity2.equals("Epic"))) {
            rarity = rarity2;
        }
        if (rarity.equals("Magical") && (rarity2.equals("Legendary") || rarity2.equals("Epic") || rarity2.equals("Rare"))) {
            rarity = rarity2;
        }
        if (rarity.equals("Common") && (rarity2.equals("Legendary") || rarity2.equals("Epic") || rarity2.equals("Rare") || rarity2.equals("Magical"))) {
            rarity = rarity2;
        }
        return rarity;
    }

    public int determineRequiredLevel() {
        int level = 0;
        if (this.dbItem == null) {
            return 0;
        }
        if (this.dbItem != null && this.dbItem.getRequiredlevel() >= level) {
            level = this.dbItem.getRequiredlevel();
        }
        if (this.dbPrefix != null && this.dbPrefix.getRequiredlevel() >= level) {
            level = this.dbPrefix.getRequiredlevel();
        }
        if (this.dbSuffix != null && this.dbSuffix.getRequiredlevel() >= level) {
            level = this.dbSuffix.getRequiredlevel();
        }
        if (this.dbModifier != null && this.dbModifier.getRequiredlevel() >= level) {
            level = this.dbModifier.getRequiredlevel();
        }
        if (this.dbComponent != null && this.dbComponent.getRequiredlevel() >= level) {
            level = this.dbComponent.getRequiredlevel();
        }
        if (this.dbBonus != null && this.dbBonus.getRequiredlevel() >= level) {
            level = this.dbBonus.getRequiredlevel();
        }
        if (this.dbEnchantment != null && this.dbEnchantment.getRequiredlevel() >= level) {
            level = this.dbEnchantment.getRequiredlevel();
        }
        return level;
    }

    @Override
    public String getItemClass() {
        if (this.dbItem == null) {
            return null;
        }
        return this.dbItem.getItemClass();
    }

    @Override
    public float getCharAttackSpeed() {
        if (this.dbItem == null) {
            return 0.0f;
        }
        return this.dbItem.getCharAttackSpeed();
    }

    @Override
    public int getDefenseAttrArmor() {
        if (this.dbItem == null) {
            return 0;
        }
        return this.dbItem.getDefenseAttrArmor();
    }

    @Override
    public int getItemLevel() {
        if (this.dbItem == null) {
            return 0;
        }
        return this.dbItem.getItemLevel();
    }

    @Override
    public int getShieldBlockDefense() {
        if (this.dbItem == null) {
            return 0;
        }
        return this.dbItem.getShieldBlockDefense();
    }

    @Override
    public int getShieldBlockChance() {
        if (this.dbItem == null) {
            return 0;
        }
        return this.dbItem.getShieldBlockChance();
    }

    @Override
    public int getDamageAvgPierceRatio() {
        if (this.dbItem == null) {
            return 0;
        }
        return this.dbItem.getDamageAvgPierceRatio();
    }

    @Override
    public int getDamageAvgBase() {
        if (this.dbItem == null) {
            return 0;
        }
        return this.dbItem.getDamageAvgBase();
    }

    @Override
    public int getTotalAttCount() {
        if (this.dbItem == null) {
            return 0;
        }
        int total = this.dbItem.getTotalAttCount();
        if (this.dbPrefix != null) {
            total += this.dbPrefix.getTotalAttCount();
        }
        if (this.dbSuffix != null) {
            total += this.dbSuffix.getTotalAttCount();
        }
        return total;
    }

    @Override
    public int getItemPrefixCost() {
        if (this.dbPrefix == null) {
            return 0;
        }
        return this.dbPrefix.getLootRandomCost();
    }

    @Override
    public int getItemSuffixCost() {
        if (this.dbSuffix == null) {
            return 0;
        }
        return this.dbSuffix.getLootRandomCost();
    }

    public static void createTable() throws SQLException {
        String dropTable = "DROP TABLE STASH_ITEM_V4";
        String createTable = "CREATE TABLE STASH_ITEM_V4 (STASH_ID        INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1),ITEM_ID         VARCHAR(256) NOT NULL, PREFIX_ID       VARCHAR(256), SUFFIX_ID       VARCHAR(256), MODIFIER_ID     VARCHAR(256), TRANSMUTE_ID    VARCHAR(256), ITEM_SEED       INTEGER, RELIC_ID        VARCHAR(256), RELICBONUS_ID   VARCHAR(256), RELIC_SEED      INTEGER, ENCHANTMENT_ID  VARCHAR(256), UNKNOWN_VAR     INTEGER, ENCHANTMENT_SEED INTEGER, ITEM_VAR1       INTEGER, STACK_COUNT     INTEGER, HARDCORE        BOOLEAN, CHARNAME        VARCHAR(64), SOULBOUND       BOOLEAN, RARITY          VARCHAR(32), REQ_LEVEL       INTEGER, REQ_DEX         INTEGER, REQ_INT         INTEGER, REQ_STR         INTEGER, ITEM_CLASS      VARCHAR(32), ARMOR_CLASS     VARCHAR(16), ARTIFACT_CLASS  VARCHAR(16), ITEM_LEVEL      INTEGER, SET_ID          VARCHAR(256), NAME            VARCHAR(128), PET_BONUS_SKILL_ID VARCHAR(256), ENEMY_ONLY      BOOLEAN, SLOT_AXE_1H     BOOLEAN, SLOT_AXE_2H     BOOLEAN, SLOT_DAGGER_1H  BOOLEAN, SLOT_MACE_1H    BOOLEAN, SLOT_MACE_2H    BOOLEAN, SLOT_SCEPTER_1H BOOLEAN, SLOT_SPEAR_2H   BOOLEAN, SLOT_STAFF_2H   BOOLEAN, SLOT_SWORD_1H   BOOLEAN, SLOT_SWORD_2H   BOOLEAN, SLOT_RANGED_1H  BOOLEAN, SLOT_RANGED_2H  BOOLEAN, SLOT_SHIELD     BOOLEAN, SLOT_OFFHAND    BOOLEAN, SLOT_AMULET     BOOLEAN, SLOT_BELT       BOOLEAN, SLOT_MEDAL      BOOLEAN, SLOT_RING       BOOLEAN, SLOT_HEAD       BOOLEAN, SLOT_SHOULDERS  BOOLEAN, SLOT_CHEST      BOOLEAN, SLOT_HANDS      BOOLEAN, SLOT_LEGS       BOOLEAN, SLOT_FEET       BOOLEAN, PRIMARY KEY (STASH_ID))";
        try (Connection conn = GDDBData.getConnection();){
            boolean auto = conn.getAutoCommit();
            conn.setAutoCommit(false);
            try (Statement st = conn.createStatement();){
                if (GDDBUtil.tableExists(conn, "STASH_ITEM_V4")) {
                    st.execute(dropTable);
                }
                st.execute(createTable);
                st.close();
                conn.commit();
            }
            catch (SQLException ex) {
                conn.rollback();
                Object[] args = new Object[]{"DBStashItem"};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_CREATE_TABLE", args);
                GDMsgLogger.addError(msg);
                throw ex;
            }
            finally {
                conn.setAutoCommit(auto);
            }
        }
    }

    public static void storeGDItems(List<GDItem> items) {
        if (items == null) {
            return;
        }
        int iFound = 0;
        int iInsert = 0;
        for (GDItem item : items) {
            String msg;
            Object[] args;
            boolean found = false;
            try {
                found = DBStashItem.isStored(item.getStashItem());
            }
            catch (SQLException ex) {
                args = new Object[]{item.getItemID()};
                msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_STASH_ITEM_SEARCH", args);
                GDMsgLogger.addError(msg);
                GDMsgLogger.addError(ex);
                continue;
            }
            if (found) {
                ++iFound;
                continue;
            }
            try {
                DBStashItem.insert(item.getStashItem());
                ++iInsert;
            }
            catch (SQLException ex) {
                args = new Object[]{item.getItemID()};
                msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_STASH_ITEM_STORE", args);
                GDMsgLogger.addError(msg);
                GDMsgLogger.addError(ex);
            }
        }
        Object[] args = new Object[]{iInsert};
        String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "INFO_STASH_STORED_NUM", args);
        GDMsgLogger.addSuccess(msg);
        Object[] args2 = new Object[]{iFound};
        msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "INFO_STASH_FOUND_NUM", args2);
        GDMsgLogger.addWarning(msg);
    }

    public static void storeDBItems(List<DBStashItem> items) {
        if (items == null) {
            return;
        }
        int iFound = 0;
        int iInsert = 0;
        for (DBStashItem item : items) {
            String msg;
            Object[] args;
            boolean found = false;
            try {
                found = DBStashItem.isStored(item);
            }
            catch (SQLException ex) {
                args = new Object[]{item.itemID};
                msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_STASH_ITEM_SEARCH", args);
                GDMsgLogger.addError(msg);
                GDMsgLogger.addError(ex);
                continue;
            }
            if (found) {
                ++iFound;
                continue;
            }
            try {
                DBStashItem.insert(item);
                ++iInsert;
            }
            catch (SQLException ex) {
                args = new Object[]{item.itemID};
                msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_STASH_ITEM_STORE", args);
                GDMsgLogger.addError(msg);
                GDMsgLogger.addError(ex);
            }
        }
        Object[] args = new Object[]{iInsert};
        String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "INFO_STASH_STORED_NUM", args);
        GDMsgLogger.addError(msg);
        Object[] args2 = new Object[]{iFound};
        msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "INFO_STASH_FOUND_NUM", args2);
    }

    public static boolean storeItem(GDItem item) {
        return DBStashItem.storeItem(item.getStashItem());
    }

    public static boolean storeItem(DBStashItem item) {
        boolean success = false;
        boolean found = false;
        try {
            found = DBStashItem.isStored(item);
        }
        catch (SQLException ex) {
            Object[] args = new Object[]{item.itemID};
            String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_STASH_ITEM_STORE", args);
            GDMsgLogger.addError(msg);
            GDMsgLogger.addError(ex);
            return false;
        }
        if (found) {
            Object[] args = new Object[]{item.itemID};
            String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_STASH_ITEM_IN_STORE", args);
            GDMsgLogger.addError(msg);
            return false;
        }
        try {
            DBStashItem.insert(item);
            success = true;
        }
        catch (SQLException ex) {
            Object[] args = new Object[]{item.itemID};
            String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_STASH_ITEM_STORE", args);
            GDMsgLogger.addError(msg);
            GDMsgLogger.addError(ex);
        }
        return success;
    }

    private static void insert(DBStashItem item) throws SQLException {
        if (item.isStackable()) {
            DBStashItem.insertStack(item);
        } else {
            DBStashItem.insertNonStack(item);
        }
    }

    private static void insertStack(DBStashItem item) throws SQLException {
        DBStashItem si = DBStashItem.getStashItemForStack(item);
        if (si == null) {
            DBStashItem.insertNonStack(item);
        } else {
            DBStashItem.updateStackCount(si.stashID, si.stackCount + item.stackCount);
        }
    }

    private static void updateStackCount(int stashID, int stackSize) throws SQLException {
        try (Connection conn = GDDBData.getConnection();){
            boolean auto = conn.getAutoCommit();
            conn.setAutoCommit(false);
            try {
                DBStashItem.updateStackCount(conn, stashID, stackSize);
                conn.commit();
            }
            catch (SQLException ex) {
                conn.rollback();
                throw ex;
            }
            finally {
                conn.setAutoCommit(auto);
            }
        }
    }

    private static void updateStackCount(Connection conn, int stashID, int stackSize) throws SQLException {
        String update = "UPDATE STASH_ITEM_V4 SET STACK_COUNT = ? WHERE STASH_ID = ?";
        try (PreparedStatement ps = conn.prepareStatement(update);){
            ps.setInt(1, stackSize);
            ps.setInt(2, stashID);
            ps.executeUpdate();
            ps.close();
        }
    }

    private static void insertNonStack(DBStashItem item) throws SQLException {
        try (Connection conn = GDDBData.getConnection();){
            boolean auto = conn.getAutoCommit();
            conn.setAutoCommit(false);
            try {
                DBStashItem.insertNonStack(conn, item);
                conn.commit();
            }
            catch (SQLException ex) {
                conn.rollback();
                throw ex;
            }
            finally {
                conn.setAutoCommit(auto);
            }
        }
    }

    private static void insertNonStack(Connection conn, DBStashItem item) throws SQLException {
        String insert = "INSERT INTO STASH_ITEM_V4(ITEM_ID, PREFIX_ID, SUFFIX_ID, MODIFIER_ID, TRANSMUTE_ID, ITEM_SEED, RELIC_ID, RELICBONUS_ID, RELIC_SEED, ENCHANTMENT_ID, UNKNOWN_VAR, ENCHANTMENT_SEED, ITEM_VAR1, STACK_COUNT, HARDCORE, CHARNAME, SOULBOUND, RARITY, REQ_LEVEL, REQ_DEX, REQ_INT, REQ_STR, ITEM_CLASS, ARMOR_CLASS, ARTIFACT_CLASS, ITEM_LEVEL, SET_ID, NAME, PET_BONUS_SKILL_ID, ENEMY_ONLY, SLOT_AXE_1H, SLOT_AXE_2H, SLOT_DAGGER_1H, SLOT_MACE_1H, SLOT_MACE_2H, SLOT_SCEPTER_1H, SLOT_SPEAR_2H, SLOT_STAFF_2H, SLOT_SWORD_1H, SLOT_SWORD_2H, SLOT_RANGED_1H, SLOT_RANGED_2H, SLOT_SHIELD, SLOT_OFFHAND, SLOT_AMULET, SLOT_BELT, SLOT_MEDAL, SLOT_RING, SLOT_HEAD, SLOT_SHOULDERS, SLOT_CHEST, SLOT_HANDS, SLOT_LEGS, SLOT_FEET) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        try (PreparedStatement ps = conn.prepareStatement(insert);){
            ps.setString(1, item.itemID);
            if (item.prefixID == null) {
                ps.setString(2, "");
            } else {
                ps.setString(2, item.prefixID);
            }
            if (item.suffixID == null) {
                ps.setString(3, "");
            } else {
                ps.setString(3, item.suffixID);
            }
            if (item.modifierID == null) {
                ps.setString(4, "");
            } else {
                ps.setString(4, item.modifierID);
            }
            if (item.transmuteID == null) {
                ps.setString(5, "");
            } else {
                ps.setString(5, item.transmuteID);
            }
            ps.setInt(6, item.seed);
            if (item.relicID == null) {
                ps.setString(7, "");
            } else {
                ps.setString(7, item.relicID);
            }
            if (item.relicBonusID == null) {
                ps.setString(8, "");
            } else {
                ps.setString(8, item.relicBonusID);
            }
            ps.setInt(9, item.relicSeed);
            if (item.enchantmentID == null) {
                ps.setString(10, "");
            } else {
                ps.setString(10, item.enchantmentID);
            }
            ps.setInt(11, item.unknown);
            ps.setInt(12, item.enchantmentSeed);
            ps.setInt(13, item.var1);
            ps.setInt(14, item.stackCount);
            ps.setBoolean(15, item.hardcore);
            if (item.charname == null) {
                ps.setString(16, "");
            } else {
                ps.setString(16, item.charname);
            }
            ps.setBoolean(17, item.soulbound);
            ps.setString(18, item.rarity);
            ps.setInt(19, item.reqLevel);
            ps.setInt(20, item.reqDex);
            ps.setInt(21, item.reqInt);
            ps.setInt(22, item.reqStr);
            ps.setString(23, item.itemClass);
            ps.setString(24, item.armorClass);
            ps.setString(25, item.artifactClass);
            ps.setInt(26, item.itemLevel);
            ps.setString(27, item.setID);
            ps.setString(28, item.itemName);
            ps.setString(29, item.petBonusSkillID);
            ps.setBoolean(30, item.enemyOnly);
            ps.setBoolean(31, item.slots.slotAxe1H);
            ps.setBoolean(32, item.slots.slotAxe2H);
            ps.setBoolean(33, item.slots.slotDagger1H);
            ps.setBoolean(34, item.slots.slotMace1H);
            ps.setBoolean(35, item.slots.slotMace2H);
            ps.setBoolean(36, item.slots.slotScepter1H);
            ps.setBoolean(37, item.slots.slotSpear2H);
            ps.setBoolean(38, item.slots.slotStaff2H);
            ps.setBoolean(39, item.slots.slotSword1H);
            ps.setBoolean(40, item.slots.slotSword2H);
            ps.setBoolean(41, item.slots.slotRanged1H);
            ps.setBoolean(42, item.slots.slotRanged2H);
            ps.setBoolean(43, item.slots.slotShield);
            ps.setBoolean(44, item.slots.slotOffhand);
            ps.setBoolean(45, item.slots.slotAmulet);
            ps.setBoolean(46, item.slots.slotBelt);
            ps.setBoolean(47, item.slots.slotMedal);
            ps.setBoolean(48, item.slots.slotRing);
            ps.setBoolean(49, item.slots.slotHead);
            ps.setBoolean(50, item.slots.slotShoulders);
            ps.setBoolean(51, item.slots.slotChest);
            ps.setBoolean(52, item.slots.slotHands);
            ps.setBoolean(53, item.slots.slotLegs);
            ps.setBoolean(54, item.slots.slotFeet);
            ps.executeUpdate();
            ps.close();
        }
    }

    public static boolean isStored(GDItem item) throws SQLException {
        return DBStashItem.isStored(item.getStashItem());
    }

    private static boolean isStored(DBStashItem item) throws SQLException {
        if (item.isStackable()) {
            return false;
        }
        return DBStashItem.isStoredNonStack(item);
    }

    private static DBStashItem getStashItemForStack(DBStashItem item) throws SQLException {
        DBStashItem si = null;
        String command = "SELECT * FROM STASH_ITEM_V4 WHERE ITEM_ID = ? AND ITEM_VAR1 = ? AND HARDCORE = ? AND CHARNAME = ?";
        try (Connection conn = GDDBData.getConnection();
             PreparedStatement ps = conn.prepareStatement(command);){
            ps.setString(1, item.itemID);
            ps.setInt(2, item.var1);
            ps.setBoolean(3, item.hardcore);
            if (item.charname == null) {
                ps.setString(4, "");
            } else {
                ps.setString(4, item.charname);
            }
            try (ResultSet rs = ps.executeQuery();){
                List<DBStashItem> list = DBStashItem.wrap(rs);
                si = list.isEmpty() ? null : list.get(0);
                conn.commit();
            }
            catch (SQLException ex) {
                si = null;
                throw ex;
            }
        }
        return si;
    }

    private static int getStashIDForStack(DBStashItem item) throws SQLException {
        int id = -1;
        String command = "SELECT STASH_ID FROM STASH_ITEM_V4 WHERE ITEM_ID = ? AND HARDCORE = ? AND CHARNAME = ?";
        try (Connection conn = GDDBData.getConnection();
             PreparedStatement ps = conn.prepareStatement(command);){
            ps.setString(1, item.itemID);
            ps.setBoolean(2, item.hardcore);
            if (item.charname == null) {
                ps.setString(3, "");
            } else {
                ps.setString(3, item.charname);
            }
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    id = rs.getInt(1);
                }
                conn.commit();
            }
            catch (SQLException ex) {
                id = -1;
                throw ex;
            }
        }
        return id;
    }

    private static boolean isStoredStack(DBStashItem item) throws SQLException {
        boolean found = false;
        String command = "SELECT * FROM STASH_ITEM_V4 WHERE ITEM_ID = ? AND HARDCORE = ? AND CHARNAME = ?";
        try (Connection conn = GDDBData.getConnection();
             PreparedStatement ps = conn.prepareStatement(command);){
            ps.setString(1, item.itemID);
            ps.setBoolean(2, item.hardcore);
            if (item.charname == null) {
                ps.setString(3, "");
            } else {
                ps.setString(3, item.charname);
            }
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    found = true;
                }
                conn.commit();
            }
        }
        return found;
    }

    private static boolean isStoredNonStack(DBStashItem item) throws SQLException {
        boolean found = false;
        String command = "SELECT * FROM STASH_ITEM_V4 WHERE ITEM_ID = ? AND PREFIX_ID = ? AND SUFFIX_ID = ? AND MODIFIER_ID = ? AND TRANSMUTE_ID = ? AND ITEM_SEED = ? AND RELIC_ID = ? AND RELICBONUS_ID = ? AND RELIC_SEED = ? AND ENCHANTMENT_ID =? AND UNKNOWN_VAR = ? AND ENCHANTMENT_SEED = ? AND ITEM_VAR1 = ? AND STACK_COUNT = ? AND HARDCORE = ? AND CHARNAME = ?";
        try (Connection conn = GDDBData.getConnection();
             PreparedStatement ps = conn.prepareStatement(command);){
            ps.setString(1, item.itemID);
            if (item.prefixID == null) {
                ps.setString(2, "");
            } else {
                ps.setString(2, item.prefixID);
            }
            if (item.suffixID == null) {
                ps.setString(3, "");
            } else {
                ps.setString(3, item.suffixID);
            }
            if (item.modifierID == null) {
                ps.setString(4, "");
            } else {
                ps.setString(4, item.modifierID);
            }
            if (item.transmuteID == null) {
                ps.setString(5, "");
            } else {
                ps.setString(5, item.transmuteID);
            }
            ps.setInt(6, item.seed);
            if (item.relicID == null) {
                ps.setString(7, "");
            } else {
                ps.setString(7, item.relicID);
            }
            if (item.relicBonusID == null) {
                ps.setString(8, "");
            } else {
                ps.setString(8, item.relicBonusID);
            }
            ps.setInt(9, item.relicSeed);
            if (item.enchantmentID == null) {
                ps.setString(10, "");
            } else {
                ps.setString(10, item.enchantmentID);
            }
            ps.setInt(11, item.unknown);
            ps.setInt(12, item.enchantmentSeed);
            ps.setInt(13, item.var1);
            ps.setInt(14, item.stackCount);
            ps.setBoolean(15, item.hardcore);
            if (item.charname == null) {
                ps.setString(16, "");
            } else {
                ps.setString(16, item.charname);
            }
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    found = true;
                }
                conn.commit();
            }
        }
        return found;
    }

    public static boolean delete(GDItem item) {
        return DBStashItem.delete(item.getStashItem());
    }

    private static boolean delete(DBStashItem item) {
        if (item.isStackable()) {
            return DBStashItem.deleteStack(item);
        }
        return DBStashItem.deleteNonStack(item);
    }

    private static boolean deleteStack(DBStashItem item) {
        DBStashItem si = null;
        try {
            si = DBStashItem.getStashItemForStack(item);
        }
        catch (SQLException ex) {
            return false;
        }
        if (si == null) {
            return false;
        }
        if (si.stackCount <= item.stackCount) {
            DBStashItem.deleteStackDB(si);
        } else {
            try {
                DBStashItem.updateStackCount(si.stashID, si.stackCount - item.stackCount);
            }
            catch (SQLException ex) {
                return false;
            }
        }
        return true;
    }

    private static boolean deleteStackDB(DBStashItem item) {
        if (item == null) {
            return false;
        }
        boolean success = false;
        String command = "DELETE FROM STASH_ITEM_V4 WHERE ITEM_ID = ? AND ITEM_VAR1 = ? AND HARDCORE = ? AND CHARNAME = ?";
        try (Connection conn = GDDBData.getConnection();){
            boolean auto = conn.getAutoCommit();
            conn.setAutoCommit(false);
            try (PreparedStatement ps = conn.prepareStatement(command);){
                ps.setString(1, item.itemID);
                ps.setInt(2, item.var1);
                ps.setBoolean(3, item.hardcore);
                if (item.charname == null) {
                    ps.setString(4, "");
                } else {
                    ps.setString(4, item.charname);
                }
                ps.executeUpdate();
                ps.close();
                conn.commit();
                success = true;
            }
            catch (SQLException ex) {
                conn.rollback();
                throw ex;
            }
            finally {
                conn.setAutoCommit(auto);
            }
        }
        catch (SQLException ex) {
            Object[] args = new Object[]{item.itemID};
            String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_STASH_ITEM_DELETE", args);
            GDMsgLogger.addError(msg);
            GDMsgLogger.addError(ex);
        }
        return success;
    }

    private static boolean deleteNonStack(DBStashItem item) {
        if (item == null) {
            return false;
        }
        boolean success = false;
        String command = "DELETE FROM STASH_ITEM_V4 WHERE ITEM_ID = ? AND PREFIX_ID = ? AND SUFFIX_ID = ? AND MODIFIER_ID = ? AND TRANSMUTE_ID = ? AND ITEM_SEED = ? AND RELIC_ID = ? AND RELICBONUS_ID = ? AND RELIC_SEED = ? AND ENCHANTMENT_ID =? AND UNKNOWN_VAR = ? AND ENCHANTMENT_SEED = ? AND ITEM_VAR1 = ? AND STACK_COUNT = ? AND HARDCORE = ? AND CHARNAME = ?";
        try (Connection conn = GDDBData.getConnection();){
            boolean auto = conn.getAutoCommit();
            conn.setAutoCommit(false);
            try (PreparedStatement ps = conn.prepareStatement(command);){
                ps.setString(1, item.itemID);
                if (item.prefixID == null) {
                    ps.setString(2, "");
                } else {
                    ps.setString(2, item.prefixID);
                }
                if (item.suffixID == null) {
                    ps.setString(3, "");
                } else {
                    ps.setString(3, item.suffixID);
                }
                if (item.modifierID == null) {
                    ps.setString(4, "");
                } else {
                    ps.setString(4, item.modifierID);
                }
                if (item.transmuteID == null) {
                    ps.setString(5, "");
                } else {
                    ps.setString(5, item.transmuteID);
                }
                ps.setInt(6, item.seed);
                if (item.relicID == null) {
                    ps.setString(7, "");
                } else {
                    ps.setString(7, item.relicID);
                }
                if (item.relicBonusID == null) {
                    ps.setString(8, "");
                } else {
                    ps.setString(8, item.relicBonusID);
                }
                ps.setInt(9, item.relicSeed);
                if (item.enchantmentID == null) {
                    ps.setString(10, "");
                } else {
                    ps.setString(10, item.enchantmentID);
                }
                ps.setInt(11, item.unknown);
                ps.setInt(12, item.enchantmentSeed);
                ps.setInt(13, item.var1);
                ps.setInt(14, item.stackCount);
                ps.setBoolean(15, item.hardcore);
                if (item.charname == null) {
                    ps.setString(16, "");
                } else {
                    ps.setString(16, item.charname);
                }
                ps.executeUpdate();
                ps.close();
                conn.commit();
                success = true;
            }
            catch (SQLException ex) {
                conn.rollback();
                throw ex;
            }
            finally {
                conn.setAutoCommit(auto);
            }
        }
        catch (SQLException ex) {
            Object[] args = new Object[]{item.itemID};
            String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_STASH_ITEM_DELETE", args);
            GDMsgLogger.addError(msg);
            GDMsgLogger.addError(ex);
        }
        return success;
    }

    public static void updateDependentFields(List<DBStashItem> items) {
        String msg;
        Object[] args;
        if (items == null) {
            return;
        }
        int iFound = 0;
        int iMissing = 0;
        int iRemoved = 0;
        int iError = 0;
        for (DBStashItem item : items) {
            if (item.stashID == -1) {
                ++iMissing;
                continue;
            }
            try {
                if (item.getDBItem() == null) {
                    ++iRemoved;
                    DBStashItem.deleteItemByStashID(item);
                    continue;
                }
                DBStashItem.updateDependentFields(item);
                ++iFound;
            }
            catch (SQLException ex) {
                ++iError;
            }
        }
        if (iFound > 0) {
            args = new Object[]{iFound};
            msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "INFO_STASH_UPD_FOUND", args);
            GDMsgLogger.addInfo(msg);
        }
        if (iMissing > 0) {
            args = new Object[]{iMissing};
            msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "INFO_STASH_UPD_MISS", args);
            GDMsgLogger.addWarning(msg);
        }
        if (iRemoved > 0) {
            args = new Object[]{iRemoved};
            msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "INFO_STASH_CONV_DEL", args);
            GDMsgLogger.addWarning(msg);
        }
        if (iError > 0) {
            args = new Object[]{iError};
            msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "INFO_STASH_UPD_ERROR", args);
            GDMsgLogger.addError(msg);
        }
    }

    private static void deleteItemByStashID(DBStashItem item) throws SQLException {
        if (item == null) {
            return;
        }
        if (item.stashID == -1) {
            return;
        }
        String command = "DELETE FROM STASH_ITEM_V4 WHERE STASH_ID = ?";
        try (Connection conn = GDDBData.getConnection();){
            boolean auto = conn.getAutoCommit();
            conn.setAutoCommit(false);
            try (PreparedStatement ps = conn.prepareStatement(command);){
                ps.setInt(1, item.stashID);
                ps.executeUpdate();
                ps.close();
                conn.commit();
            }
            catch (SQLException ex) {
                conn.rollback();
                throw ex;
            }
            finally {
                conn.setAutoCommit(auto);
            }
        }
    }

    private static void updateDependentFields(DBStashItem item) throws SQLException {
        String update = "UPDATE STASH_ITEM_V4 SET PREFIX_ID = ?, SUFFIX_ID = ?, MODIFIER_ID = ?, TRANSMUTE_ID = ?, ITEM_SEED = ?, RELIC_ID = ?, RELICBONUS_ID = ?, RELIC_SEED = ?, ENCHANTMENT_ID = ?, UNKNOWN_VAR = ?, ENCHANTMENT_SEED = ?, ITEM_VAR1 = ?, STACK_COUNT = ?, HARDCORE = ?, CHARNAME = ?, SOULBOUND = ?, RARITY = ?,  REQ_LEVEL = ?, REQ_DEX = ?, REQ_INT = ?, REQ_STR = ?, ITEM_CLASS = ?, ARMOR_CLASS = ?, ARTIFACT_CLASS = ?, ITEM_LEVEL = ?, SET_ID = ?, NAME = ?, PET_BONUS_SKILL_ID = ?, ENEMY_ONLY = ? WHERE STASH_ID = ?";
        try (Connection conn = GDDBData.getConnection();){
            boolean auto = conn.getAutoCommit();
            conn.setAutoCommit(false);
            try (PreparedStatement ps = conn.prepareStatement(update);){
                if (item.prefixID == null) {
                    ps.setString(1, "");
                } else {
                    ps.setString(1, item.prefixID);
                }
                if (item.suffixID == null) {
                    ps.setString(2, "");
                } else {
                    ps.setString(2, item.suffixID);
                }
                if (item.modifierID == null) {
                    ps.setString(3, "");
                } else {
                    ps.setString(3, item.modifierID);
                }
                if (item.transmuteID == null) {
                    ps.setString(4, "");
                } else {
                    ps.setString(4, item.transmuteID);
                }
                ps.setInt(5, item.seed);
                if (item.relicID == null) {
                    ps.setString(6, "");
                } else {
                    ps.setString(6, item.relicID);
                }
                if (item.relicBonusID == null) {
                    ps.setString(7, "");
                } else {
                    ps.setString(7, item.relicBonusID);
                }
                ps.setInt(8, item.relicSeed);
                if (item.enchantmentID == null) {
                    ps.setString(9, "");
                } else {
                    ps.setString(9, item.enchantmentID);
                }
                ps.setInt(10, item.unknown);
                ps.setInt(11, item.enchantmentSeed);
                ps.setInt(12, item.var1);
                ps.setInt(13, item.stackCount);
                ps.setBoolean(14, item.hardcore);
                if (item.charname == null) {
                    ps.setString(15, "");
                } else {
                    ps.setString(15, item.charname);
                }
                ps.setBoolean(16, item.soulbound);
                ps.setString(17, item.rarity);
                ps.setInt(18, item.reqLevel);
                ps.setInt(19, item.reqDex);
                ps.setInt(20, item.reqInt);
                ps.setInt(21, item.reqStr);
                ps.setString(22, item.itemClass);
                ps.setString(23, item.armorClass);
                ps.setString(24, item.artifactClass);
                ps.setInt(25, item.itemLevel);
                ps.setString(26, item.setID);
                ps.setString(27, item.itemName);
                ps.setString(28, item.petBonusSkillID);
                ps.setBoolean(29, item.enemyOnly);
                ps.setInt(30, item.stashID);
                ps.executeUpdate();
                ps.close();
                conn.commit();
            }
            catch (SQLException ex) {
                conn.rollback();
                throw ex;
            }
            finally {
                conn.setAutoCommit(auto);
            }
        }
    }

    public static void convertStash(String tableName, List<DBStashItem> items) {
        String msg;
        Object[] args;
        if (items == null) {
            return;
        }
        int iFound = 0;
        int iMissing = 0;
        int iRemoved = 0;
        int iError = 0;
        for (DBStashItem item : items) {
            if (item.stashID == -1) {
                ++iMissing;
                continue;
            }
            if (item.getDBItem() == null) {
                ++iRemoved;
            }
            try {
                DBStashItem.convertStash(tableName, item);
                ++iFound;
            }
            catch (SQLException ex) {
                ++iError;
            }
        }
        if (iFound > 0) {
            args = new Object[]{iFound};
            msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "INFO_STASH_CONV_FOUND", args);
            GDMsgLogger.addInfo(msg);
        }
        if (iMissing > 0) {
            args = new Object[]{iMissing};
            msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "INFO_STASH_CONV_MISS", args);
            GDMsgLogger.addWarning(msg);
        }
        if (iRemoved > 0) {
            args = new Object[]{iRemoved};
            msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "INFO_STASH_CONV_DEL", args);
            GDMsgLogger.addWarning(msg);
        }
        if (iError > 0) {
            args = new Object[]{iError};
            msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "INFO_STASH_CONV_ERROR", args);
            GDMsgLogger.addError(msg);
        }
    }

    private static void convertStash(String tableName, DBStashItem item) throws SQLException {
        try (Connection conn = GDDBData.getConnection();){
            boolean auto = conn.getAutoCommit();
            conn.setAutoCommit(false);
            try {
                if (item.getDBItem() != null) {
                    DBStashItem.insert(conn, item);
                }
                DBStashItem.deleteOld(conn, tableName, item);
                conn.commit();
            }
            catch (SQLException ex) {
                conn.rollback();
                throw ex;
            }
            finally {
                conn.setAutoCommit(auto);
            }
        }
    }

    public static void moveStash(Connection connOld, Connection connNew, String tableName, List<DBStashItem> items) {
        String msg;
        Object[] args;
        if (items == null) {
            return;
        }
        int iFound = 0;
        int iMissing = 0;
        int iRemoved = 0;
        int iError = 0;
        for (DBStashItem item : items) {
            if (item.stashID == -1) {
                ++iMissing;
                continue;
            }
            if (item.getDBItem() == null) {
                ++iRemoved;
            }
            try {
                DBStashItem.moveStash(connOld, connNew, tableName, item);
                ++iFound;
            }
            catch (SQLException ex) {
                ++iError;
            }
        }
        if (iFound > 0) {
            args = new Object[]{iFound};
            msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "INFO_STASH_CONV_FOUND", args);
            GDMsgLogger.addInfo(msg);
        }
        if (iMissing > 0) {
            args = new Object[]{iMissing};
            msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "INFO_STASH_CONV_MISS", args);
            GDMsgLogger.addWarning(msg);
        }
        if (iRemoved > 0) {
            args = new Object[]{iRemoved};
            msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "INFO_STASH_CONV_DEL", args);
            GDMsgLogger.addWarning(msg);
        }
        if (iError > 0) {
            args = new Object[]{iError};
            msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "INFO_STASH_CONV_ERROR", args);
            GDMsgLogger.addError(msg);
        }
    }

    private static void moveStash(Connection connOld, Connection connNew, String tableName, DBStashItem item) throws SQLException {
        boolean autoOld = connOld.getAutoCommit();
        connOld.setAutoCommit(false);
        boolean autoNew = connNew.getAutoCommit();
        connNew.setAutoCommit(false);
        try {
            if (item.getDBItem() != null) {
                DBStashItem.insert(connNew, item);
            }
            DBStashItem.deleteOld(connOld, tableName, item);
            connNew.commit();
            connOld.commit();
        }
        catch (SQLException ex) {
            connNew.rollback();
            connOld.rollback();
            throw ex;
        }
        finally {
            connOld.setAutoCommit(autoOld);
            connNew.setAutoCommit(autoNew);
        }
    }

    private static void insert(Connection conn, DBStashItem item) throws SQLException {
        if (item.isStackable()) {
            DBStashItem.insertStack(conn, item);
        } else {
            DBStashItem.insertNonStack(conn, item);
        }
    }

    private static void insertStack(Connection conn, DBStashItem item) throws SQLException {
        DBStashItem si = DBStashItem.getStashItemForStack(item);
        if (si == null) {
            DBStashItem.insertNonStack(conn, item);
        } else {
            DBStashItem.updateStackCount(conn, si.stashID, si.stackCount + item.stackCount);
        }
    }

    private static void deleteOld(Connection conn, String tableName, DBStashItem item) throws SQLException {
        if (item == null) {
            return;
        }
        if (item.stashID == -1) {
            return;
        }
        String command = "DELETE FROM " + tableName + " WHERE STASH_ID = ?";
        try (PreparedStatement ps = conn.prepareStatement(command);){
            ps.setInt(1, item.stashID);
            ps.executeUpdate();
            ps.close();
        }
    }

    public static void dropOldStash(Connection conn, String tableName) {
        String dropTable = "DROP TABLE " + tableName;
        try {
            boolean auto = conn.getAutoCommit();
            conn.setAutoCommit(false);
            try (Statement st = conn.createStatement();){
                if (GDDBUtil.tableExists(conn, tableName)) {
                    List<DBStashItem> items = DBStashItem.getAllOld(conn, tableName);
                    if (items.isEmpty()) {
                        st.execute(dropTable);
                    } else {
                        Object[] args = new Object[]{tableName};
                        String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "TABLE_CONTAINS_ENTRIES", args);
                        GDMsgLogger.addError(msg);
                    }
                }
                st.close();
                conn.commit();
            }
            catch (SQLException ex) {
                conn.rollback();
                Object[] args = new Object[]{tableName};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_DROP_TABLE", args);
                GDMsgLogger.addError(msg);
                throw ex;
            }
            finally {
                conn.setAutoCommit(auto);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static GDItem getStack(GDItem item) {
        DBStashItem si = DBStashItem.getStack(item.getStashItem());
        if (si == null) {
            return null;
        }
        return new GDItem(si);
    }

    private static DBStashItem getStack(DBStashItem item) {
        if (item == null) {
            return null;
        }
        String command = "SELECT * FROM STASH_ITEM_V4 WHERE ITEM_ID = ? AND CHARNAME = ?";
        if (!GDStashFrame.iniConfig.sectRestrict.transferSCHC) {
            command = command + " AND HARDCORE = ?";
        }
        try (Connection conn = GDDBData.getConnection();
             PreparedStatement ps = conn.prepareStatement(command);){
            ps.setString(1, item.itemID);
            if (item.charname == null) {
                ps.setString(2, "");
            } else {
                ps.setString(2, item.charname);
            }
            if (!GDStashFrame.iniConfig.sectRestrict.transferSCHC) {
                ps.setBoolean(3, item.hardcore);
            }
            try (ResultSet rs = ps.executeQuery();){
                List<DBStashItem> list = DBStashItem.wrap(rs);
                item = list.isEmpty() ? null : list.get(0);
                conn.commit();
            }
            catch (SQLException ex) {
                item = null;
                throw ex;
            }
        }
        catch (SQLException ex) {
            Object[] args = new Object[]{item.itemID, "DBStashItem"};
            String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_READ_TABLE_BY_ID", args);
            GDMsgLogger.addError(GDMsgFormatter.getString(GDMsgFormatter.rbMsg, "ERR_STASH_ITEM_READ_ALL"));
            GDMsgLogger.addError(ex);
        }
        return item;
    }

    public static DBStashItem get(int stashID, boolean isHardcore, String charName) {
        DBStashItem item = null;
        String command = "SELECT * FROM STASH_ITEM_V4 WHERE STASH_ID = ?";
        if (!GDStashFrame.iniConfig.sectRestrict.transferSCHC) {
            command = isHardcore ? command + " AND HARDCORE = true" : command + " AND HARDCORE = false";
        }
        if (!GDStashFrame.iniConfig.sectRestrict.transferSoulbound && charName != null) {
            command = command + " AND ( CHARNAME = '" + charName + "' OR CHARNAME = '' )";
        }
        try (Connection conn = GDDBData.getConnection();
             PreparedStatement ps = conn.prepareStatement(command);){
            ps.setInt(1, stashID);
            try (ResultSet rs = ps.executeQuery();){
                List<DBStashItem> list = DBStashItem.wrap(rs);
                item = list.isEmpty() ? null : list.get(0);
                conn.commit();
            }
            catch (SQLException ex) {
                item = null;
                throw ex;
            }
        }
        catch (SQLException ex) {
            Object[] args = new Object[]{Integer.toString(stashID), "DBStashItem"};
            String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_READ_TABLE_BY_ID", args);
            GDMsgLogger.addError(GDMsgFormatter.getString(GDMsgFormatter.rbMsg, "ERR_STASH_ITEM_READ_ALL"));
            GDMsgLogger.addError(ex);
        }
        return item;
    }

    public static List<DBStashItem> getAllOld(Connection conn, String tableName) {
        List<DBStashItem> list = new LinkedList<DBStashItem>();
        String command = "SELECT * FROM " + tableName;
        try (PreparedStatement ps = conn.prepareStatement(command);
             ResultSet rs = ps.executeQuery();){
            list = DBStashItem.wrap(rs);
            conn.commit();
        }
        catch (SQLException ex) {
            GDMsgLogger.addError(GDMsgFormatter.getString(GDMsgFormatter.rbMsg, "ERR_READ_TABLE_BY_ID"));
            GDMsgLogger.addError(ex);
        }
        return list;
    }

    public static List<DBStashItem> getAll() {
        List<DBStashItem> list = new LinkedList<DBStashItem>();
        String command = "SELECT * FROM STASH_ITEM_V4";
        try (Connection conn = GDDBData.getConnection();
             PreparedStatement ps = conn.prepareStatement(command);
             ResultSet rs = ps.executeQuery();){
            list = DBStashItem.wrap(rs);
            conn.commit();
        }
        catch (SQLException ex) {
            GDMsgLogger.addError(GDMsgFormatter.getString(GDMsgFormatter.rbMsg, "ERR_READ_TABLE_BY_ID"));
            GDMsgLogger.addError(ex);
        }
        return list;
    }

    public static List<GDItem> getGDItemsByItemID(String itemID, boolean isHardcore) {
        List<GDItem> list = new LinkedList<GDItem>();
        String command = "SELECT * FROM STASH_ITEM_V4 WHERE ITEM_ID = ?";
        if (!GDStashFrame.iniConfig.sectRestrict.transferSCHC) {
            command = command + " AND HARDCORE = ?";
        }
        try (Connection conn = GDDBData.getConnection();
             PreparedStatement ps = conn.prepareStatement(command);){
            ps.setString(1, itemID);
            if (!GDStashFrame.iniConfig.sectRestrict.transferSCHC) {
                ps.setBoolean(2, isHardcore);
            }
            try (ResultSet rs = ps.executeQuery();){
                list = DBStashItem.wrapGDItem(rs);
                conn.commit();
            }
        }
        catch (SQLException ex) {
            Object[] args = new Object[]{itemID, "DBStashItem"};
            String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_READ_TABLE_BY_ID", args);
            GDMsgLogger.addError(msg);
            GDMsgLogger.addError(ex);
        }
        return list;
    }

    public static List<GDItem> getGDItemsByItemIDs(List<String> itemIDs, boolean isHarcore) {
        LinkedList<GDItem> list = new LinkedList<GDItem>();
        for (String itemID : itemIDs) {
            List<GDItem> l = DBStashItem.getGDItemsByItemID(itemID, isHarcore);
            if (l.isEmpty()) continue;
            list.addAll(l);
        }
        return list;
    }

    public static List<GDItem> getGDItemsByItemID(String itemID) {
        List<GDItem> list = new LinkedList<GDItem>();
        String command = "SELECT * FROM STASH_ITEM_V4 WHERE ITEM_ID = ?";
        try (Connection conn = GDDBData.getConnection();
             PreparedStatement ps = conn.prepareStatement(command);){
            ps.setString(1, itemID);
            try (ResultSet rs = ps.executeQuery();){
                list = DBStashItem.wrapGDItem(rs);
                conn.commit();
            }
        }
        catch (SQLException ex) {
            Object[] args = new Object[]{itemID, "DBStashItem"};
            String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_READ_TABLE_BY_ID", args);
            GDMsgLogger.addError(msg);
            GDMsgLogger.addError(ex);
        }
        return list;
    }

    public static List<GDItem> getGDItemsByItemIDs(List<String> itemIDs) {
        LinkedList<GDItem> list = new LinkedList<GDItem>();
        for (String itemID : itemIDs) {
            List<GDItem> l = DBStashItem.getGDItemsByItemID(itemID);
            if (l.isEmpty()) continue;
            list.addAll(l);
        }
        return list;
    }

    private static List<GDItem> getGDItemsByStashIDs(List<Integer> stashIDs, boolean isHardcore, String charName) {
        LinkedList<GDItem> list = new LinkedList<GDItem>();
        if (stashIDs == null) {
            return list;
        }
        for (Integer iID : stashIDs) {
            int stashID = iID;
            DBStashItem si = DBStashItem.get(stashID, isHardcore, charName);
            if (si == null) continue;
            GDItem item = new GDItem(si);
            list.add(item);
        }
        return list;
    }

    private static List<DBStashItem> wrap(ResultSet rs) throws SQLException {
        LinkedList<DBStashItem> list = new LinkedList<DBStashItem>();
        while (rs.next()) {
            try {
                DBStashItem item = DBStashItem.wrapSingle(rs);
                list.add(item);
            }
            catch (SQLException sQLException) {}
        }
        return list;
    }

    private static List<GDItem> wrapGDItem(ResultSet rs) throws SQLException {
        GDItem item = null;
        LinkedList<GDItem> list = new LinkedList<GDItem>();
        while (rs.next()) {
            try {
                DBStashItem si = DBStashItem.wrapSingle(rs);
                item = new GDItem(si);
                list.add(item);
            }
            catch (SQLException sQLException) {}
        }
        return list;
    }

    private static DBStashItem wrapSingle(ResultSet rs) throws SQLException {
        DBStashItem item = new DBStashItem();
        try {
            item.stashID = rs.getInt(1);
            item.itemID = rs.getString(2);
            item.prefixID = rs.getString(3);
            if (item.prefixID != null && item.prefixID.equals("")) {
                item.prefixID = null;
            }
            item.suffixID = rs.getString(4);
            if (item.suffixID != null && item.suffixID.equals("")) {
                item.suffixID = null;
            }
            item.modifierID = rs.getString(5);
            if (item.modifierID != null && item.modifierID.equals("")) {
                item.modifierID = null;
            }
            item.transmuteID = rs.getString(6);
            if (item.transmuteID != null && item.transmuteID.equals("")) {
                item.transmuteID = null;
            }
            item.seed = rs.getInt(7);
            item.relicID = rs.getString(8);
            if (item.relicID != null && item.relicID.equals("")) {
                item.relicID = null;
            }
            item.relicBonusID = rs.getString(9);
            if (item.relicBonusID != null && item.relicBonusID.equals("")) {
                item.relicBonusID = null;
            }
            item.relicSeed = rs.getInt(10);
            item.enchantmentID = rs.getString(11);
            if (item.enchantmentID != null && item.enchantmentID.equals("")) {
                item.enchantmentID = null;
            }
            item.unknown = rs.getInt(12);
            item.enchantmentSeed = rs.getInt(13);
            item.var1 = rs.getInt(14);
            item.stackCount = rs.getInt(15);
            item.hardcore = rs.getBoolean(16);
            item.charname = rs.getString(17);
            if (item.charname != null && item.charname.equals("")) {
                item.charname = null;
            }
            item.fillDependentStats(null);
        }
        catch (SQLException ex) {
            if (item.itemID != null) {
                Object[] args = new Object[]{item.itemID, item.stashID};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_STASH_READ_BY_STASH", args);
                throw new ClassCastException(msg);
            }
            if (item.stashID != -1) {
                Object[] args = new Object[]{item.stashID, "DBStashItem"};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_READ_TABLE_BY_ID", args);
                GDMsgLogger.addError(msg);
            } else {
                GDMsgLogger.addError(GDMsgFormatter.getString(GDMsgFormatter.rbMsg, "ERR_STASH_READ"));
            }
            GDMsgLogger.addError(ex);
            throw ex;
        }
        return item;
    }

    private static List<Integer> getStashIDsByItemIDs(List<String> itemIDs, boolean isHardcore, String charName) {
        LinkedList<Integer> listAll = new LinkedList<Integer>();
        for (String itemID : itemIDs) {
            List<Integer> list = DBStashItem.getStashIDsByItemID(itemID, isHardcore, charName);
            if (list == null) continue;
            listAll.addAll(list);
        }
        return listAll;
    }

    private static List<Integer> getStashIDsByItemID(String itemID, boolean isHardcore, String charName) {
        List<Integer> list = new LinkedList<Integer>();
        String command = "SELECT STASH_ID FROM STASH_ITEM_V4 WHERE ITEM_ID = ?";
        if (!GDStashFrame.iniConfig.sectRestrict.transferSCHC) {
            command = isHardcore ? command + " AND HARDCORE = true" : command + " AND HARDCORE = false";
        }
        if (!GDStashFrame.iniConfig.sectRestrict.transferSoulbound && charName != null) {
            command = command + " AND CHARNAME = '" + charName + "'";
        }
        try (Connection conn = GDDBData.getConnection();
             PreparedStatement ps = conn.prepareStatement(command);){
            ps.setString(1, itemID);
            try (ResultSet rs = ps.executeQuery();){
                list = AbstractItemCombination.wrapInteger(rs, 1);
                conn.commit();
            }
        }
        catch (SQLException ex) {
            Object[] args = new Object[]{itemID, "DBStashItem"};
            String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_READ_TABLE_BY_ID", args);
            GDMsgLogger.addError(msg);
            GDMsgLogger.addError(ex);
        }
        return list;
    }

    private static void mergeStashIDs(List<Integer> listAll, List<Integer> list) {
        if (list == null) {
            return;
        }
        for (Integer sInt : list) {
            int stashID = sInt;
            boolean found = false;
            for (int sid : listAll) {
                if (sid != stashID) continue;
                found = true;
                break;
            }
            if (found) continue;
            listAll.add(sInt);
        }
    }

    private static List<Integer> getByStatCriteria(SelectionCriteria criteria, boolean isHardcore, String charName) {
        LinkedList<Integer> itemsAll = new LinkedList<Integer>();
        List<Integer> items = null;
        List<Integer> prefixes = null;
        List<Integer> suffixes = null;
        items = StashIDItemCombination.getStashIDs(criteria, isHardcore, charName);
        prefixes = StashIDPrefixCombination.getStashIDs(criteria, isHardcore, charName);
        suffixes = StashIDSuffixCombination.getStashIDs(criteria, isHardcore, charName);
        DBStashItem.mergeStashIDs(itemsAll, items);
        DBStashItem.mergeStashIDs(itemsAll, prefixes);
        DBStashItem.mergeStashIDs(itemsAll, suffixes);
        return itemsAll;
    }

    private static List<Integer> getByDamageCriteria(SelectionCriteria criteria, boolean isHardcore, String charName) {
        LinkedList<Integer> itemsAll = new LinkedList<Integer>();
        List<Integer> items = null;
        List<Integer> prefixes = null;
        List<Integer> suffixes = null;
        items = criteria.itemIDs != null && !criteria.itemIDs.isEmpty() ? StashIDItemCombination.getStashIDs(criteria, isHardcore, charName) : StashIDItemDamageCombination.getStashIDs(criteria, isHardcore, charName);
        prefixes = StashIDPrefixCombination.getStashIDs(criteria, isHardcore, charName);
        suffixes = StashIDSuffixCombination.getStashIDs(criteria, isHardcore, charName);
        DBStashItem.mergeStashIDs(itemsAll, items);
        DBStashItem.mergeStashIDs(itemsAll, prefixes);
        DBStashItem.mergeStashIDs(itemsAll, suffixes);
        return itemsAll;
    }

    public static List<GDItem> getGDItemByCriteria(SelectionCriteria criteria, boolean isHardcore, String charName) {
        List<Integer> stashIDs = null;
        stashIDs = criteria.itemIDs != null && !criteria.itemIDs.isEmpty() ? DBStashItem.getStashIDsByItemIDs(criteria.itemIDs, isHardcore, charName) : (criteria.dmgClass.isEmpty() && !criteria.petBonus ? DBStashItem.getByStatCriteria(criteria, isHardcore, charName) : DBStashItem.getByDamageCriteria(criteria, isHardcore, charName));
        return DBStashItem.getGDItemsByStashIDs(stashIDs, isHardcore, charName);
    }

    public boolean read(InputStream reader, String filename) {
        boolean success = false;
        byte len = 0;
        try {
            len = GDReader.readByte(reader);
            if (len > 0) {
                this.itemID = GDReader.readString(reader, len);
            }
            if ((len = GDReader.readByte(reader)) > 0) {
                this.prefixID = GDReader.readString(reader, len);
            }
            if ((len = GDReader.readByte(reader)) > 0) {
                this.suffixID = GDReader.readString(reader, len);
            }
            if ((len = GDReader.readByte(reader)) > 0) {
                this.modifierID = GDReader.readString(reader, len);
            }
            if ((len = GDReader.readByte(reader)) > 0) {
                this.transmuteID = GDReader.readString(reader, len);
            }
            this.seed = GDReader.readInt(reader);
            len = GDReader.readByte(reader);
            if (len > 0) {
                this.relicID = GDReader.readString(reader, len);
            }
            if ((len = GDReader.readByte(reader)) > 0) {
                this.relicBonusID = GDReader.readString(reader, len);
            }
            this.relicSeed = GDReader.readInt(reader);
            len = GDReader.readByte(reader);
            if (len > 0) {
                this.enchantmentID = GDReader.readString(reader, len);
            }
            this.unknown = GDReader.readInt(reader);
            this.enchantmentSeed = GDReader.readInt(reader);
            this.var1 = GDReader.readInt(reader);
            this.stackCount = GDReader.readInt(reader);
            byte b = GDReader.readByte(reader);
            this.hardcore = b != 0;
            len = GDReader.readByte(reader);
            if (len > 0) {
                this.charname = GDReader.readString(reader, len);
            }
            success = true;
        }
        catch (IOException ex) {
            Object[] args = new Object[]{filename};
            String s = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_READ_FILE", args);
            GDMsgLogger.addError(s);
            GDMsgLogger.addError(ex);
            success = false;
        }
        if (success) {
            this.fillDependentStats(null);
            if (GDMsgLogger.errorsInLog()) {
                success = false;
            }
        }
        return success;
    }

    public void write(FileOutputStream writer, Charset cs) throws IOException {
        writer.write(GDWriter.lengthToByte(this.itemID));
        if (this.itemID != null) {
            writer.write(this.itemID.getBytes(cs));
        }
        writer.write(GDWriter.lengthToByte(this.prefixID));
        if (this.prefixID != null) {
            writer.write(this.prefixID.getBytes(cs));
        }
        writer.write(GDWriter.lengthToByte(this.suffixID));
        if (this.suffixID != null) {
            writer.write(this.suffixID.getBytes(cs));
        }
        writer.write(GDWriter.lengthToByte(this.modifierID));
        if (this.modifierID != null) {
            writer.write(this.modifierID.getBytes(cs));
        }
        writer.write(GDWriter.lengthToByte(this.transmuteID));
        if (this.transmuteID != null) {
            writer.write(this.transmuteID.getBytes(cs));
        }
        writer.write(GDWriter.intToBytes4(this.seed));
        writer.write(GDWriter.lengthToByte(this.relicID));
        if (this.relicID != null) {
            writer.write(this.relicID.getBytes(cs));
        }
        writer.write(GDWriter.lengthToByte(this.relicBonusID));
        if (this.relicBonusID != null) {
            writer.write(this.relicBonusID.getBytes(cs));
        }
        writer.write(GDWriter.intToBytes4(this.relicSeed));
        writer.write(GDWriter.lengthToByte(this.enchantmentID));
        if (this.enchantmentID != null) {
            writer.write(this.enchantmentID.getBytes(cs));
        }
        writer.write(GDWriter.intToBytes4(this.unknown));
        writer.write(GDWriter.intToBytes4(this.enchantmentSeed));
        writer.write(GDWriter.intToBytes4(this.var1));
        writer.write(GDWriter.intToBytes4(this.stackCount));
        if (this.hardcore) {
            writer.write(1);
        } else {
            writer.write(0);
        }
        writer.write(GDWriter.lengthToByte(this.charname));
        if (this.charname != null) {
            writer.write(this.charname.getBytes(cs));
        }
    }

    public static List<GDItem> load(File file) {
        LinkedList<GDItem> items = new LinkedList<GDItem>();
        String filename = null;
        try {
            filename = file.getCanonicalPath();
        }
        catch (IOException ex) {
            filename = null;
        }
        try (BufferedInputStream reader = new BufferedInputStream(new FileInputStream(file));){
            int version = GDReader.readInt(reader);
            int size = GDReader.readInt(reader);
            for (int i = 0; i < size; ++i) {
                DBStashItem si = new DBStashItem();
                boolean read = si.read(reader, filename);
                if (!read) continue;
                GDItem item = new GDItem(si, filename);
                items.add(item);
            }
        }
        catch (IOException ex) {
            GDMsgLogger.addError(GDMsgFormatter.getString(GDMsgFormatter.rbMsg, "ERR_LOAD_FILE"));
            GDMsgLogger.addError(ex);
            items = null;
        }
        return items;
    }

    public static boolean read(File file) {
        boolean success = false;
        LinkedList<DBStashItem> items = new LinkedList<DBStashItem>();
        String filename = null;
        try {
            filename = file.getCanonicalPath();
        }
        catch (IOException ex) {
            filename = null;
        }
        try (BufferedInputStream reader = new BufferedInputStream(new FileInputStream(file));){
            int version = GDReader.readInt(reader);
            int size = GDReader.readInt(reader);
            for (int i = 0; i < size; ++i) {
                DBStashItem item = new DBStashItem();
                boolean read = item.read(reader, filename);
                if (!read) continue;
                items.add(item);
            }
            DBStashItem.storeDBItems(items);
            success = true;
        }
        catch (IOException ex) {
            GDMsgLogger.addError(GDMsgFormatter.getString(GDMsgFormatter.rbMsg, "ERR_IMPORT_FILE"));
            GDMsgLogger.addError(ex);
        }
        return success;
    }

    public static boolean write(File file) {
        boolean success = false;
        try {
            file.createNewFile();
            try (FileOutputStream writer = new FileOutputStream(file);){
                List<DBStashItem> items = DBStashItem.getAll();
                writer.write(GDWriter.intToBytes4(1));
                int size = items.size();
                writer.write(GDWriter.intToBytes4(size));
                for (DBStashItem item : items) {
                    item.write(writer, GDConstants.CHARSET_STASH);
                }
                writer.flush();
                success = true;
            }
        }
        catch (IOException ex) {
            GDMsgLogger.addError(GDMsgFormatter.getString(GDMsgFormatter.rbMsg, "ERR_WRITE_FILE"));
            GDMsgLogger.addError(ex);
        }
        return success;
    }

    public void readNewFormat(int version) throws IOException {
        switch (version) {
            case 3: {
                this.readNewFormat_V3();
                break;
            }
            case 4: {
                this.readNewFormat_V4();
                break;
            }
            default: {
                throw new IOException(GDMsgFormatter.getString(GDMsgFormatter.rbMsg, "ERR_UNSUPPORTED_VERSION"));
            }
        }
        this.fillDependentStats(null);
    }

    private void readNewFormat_V3() throws IOException {
        String s = null;
        int i = 0;
        i = GDReader.readEncInt(true);
        this.setStackCount(i);
        s = GDReader.readEncString();
        this.setItemID(s);
        s = GDReader.readEncString();
        this.setPrefixID(s);
        s = GDReader.readEncString();
        this.setSuffixID(s);
        s = GDReader.readEncString();
        this.setModifierID(s);
        s = GDReader.readEncString();
        this.setTransmuteID(s);
        i = GDReader.readEncInt(true);
        this.setItemSeed(i);
        s = GDReader.readEncString();
        this.setComponentID(s);
        s = GDReader.readEncString();
        this.setCompletionBonusID(s);
        i = GDReader.readEncInt(true);
        this.setComponentSeed(i);
        s = GDReader.readEncString();
        this.setAugmentID(s);
        i = GDReader.readEncInt(true);
        this.setUnknown(i);
        i = GDReader.readEncInt(true);
        this.setAugmentSeed(i);
        i = GDReader.readEncInt(true);
        this.setVar1(i);
    }

    private void readNewFormat_V4() throws IOException {
        String s = null;
        int i = 0;
        s = GDReader.readEncString();
        this.setItemID(s);
        s = GDReader.readEncString();
        this.setPrefixID(s);
        s = GDReader.readEncString();
        this.setSuffixID(s);
        s = GDReader.readEncString();
        this.setModifierID(s);
        s = GDReader.readEncString();
        this.setTransmuteID(s);
        i = GDReader.readEncInt(true);
        this.setItemSeed(i);
        s = GDReader.readEncString();
        this.setComponentID(s);
        s = GDReader.readEncString();
        this.setCompletionBonusID(s);
        i = GDReader.readEncInt(true);
        this.setComponentSeed(i);
        s = GDReader.readEncString();
        this.setAugmentID(s);
        i = GDReader.readEncInt(true);
        this.setUnknown(i);
        i = GDReader.readEncInt(true);
        this.setAugmentSeed(i);
        i = GDReader.readEncInt(true);
        this.setVar1(i);
        i = GDReader.readEncInt(true);
        this.setStackCount(i);
    }

    public int getByteSize() {
        int size = 0;
        String s = null;
        size += 4;
        s = this.getItemID();
        if (s != null) {
            size += s.length();
        }
        size += 4;
        s = this.getPrefixID();
        if (s != null) {
            size += s.length();
        }
        size += 4;
        s = this.getSuffixID();
        if (s != null) {
            size += s.length();
        }
        size += 4;
        s = this.getModifierID();
        if (s != null) {
            size += s.length();
        }
        size += 4;
        s = this.getTransmuteID();
        if (s != null) {
            size += s.length();
        }
        size += 4;
        size += 4;
        s = this.getComponentID();
        if (s != null) {
            size += s.length();
        }
        size += 4;
        s = this.getCompletionBonusID();
        if (s != null) {
            size += s.length();
        }
        size += 4;
        size += 4;
        s = this.getAugmentID();
        if (s != null) {
            size += s.length();
        }
        size += 4;
        size += 4;
        size += 4;
        return size += 4;
    }

    public void write() throws IOException {
        GDWriter.writeString(this.getItemID());
        GDWriter.writeString(this.getPrefixID());
        GDWriter.writeString(this.getSuffixID());
        GDWriter.writeString(this.getModifierID());
        GDWriter.writeString(this.getTransmuteID());
        GDWriter.writeInt(this.getItemSeed());
        GDWriter.writeString(this.getComponentID());
        GDWriter.writeString(this.getCompletionBonusID());
        GDWriter.writeInt(this.getComponentSeed());
        GDWriter.writeString(this.getAugmentID());
        GDWriter.writeInt(this.getUnknown());
        GDWriter.writeInt(this.getAugmentSeed());
        GDWriter.writeInt(this.getVar1());
        GDWriter.writeInt(this.getStackCount());
    }
}

