/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.db;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.gdstash.db.ItemCriteriaCombination;
import org.gdstash.db.SelectionCriteria;
import org.gdstash.ui.GDStashFrame;

public class DamageCriteriaCombination {
    private List<String> damageTypes;
    private ItemCriteriaCombination itemCombo;
    private SelectionCriteria criteria;

    public DamageCriteriaCombination(SelectionCriteria criteria) {
        this.criteria = criteria;
        this.itemCombo = new ItemCriteriaCombination(criteria);
        this.damageTypes = null;
    }

    public DamageCriteriaCombination(SelectionCriteria criteria, ItemCriteriaCombination combo, List<String> damageTypes) {
        this.criteria = criteria;
        this.itemCombo = combo;
        this.damageTypes = damageTypes;
    }

    public List<String> getDamageTypeList() {
        return this.damageTypes;
    }

    public void setItemClass(String itemClass) {
        this.itemCombo.setItemClass(itemClass);
    }

    public String determineItemParameters() {
        if (this.itemCombo == null) {
            return null;
        }
        return this.itemCombo.determineItemParameters();
    }

    public String determineItemIDStatement() {
        String command = "SELECT I.ITEM_ID FROM GD_ITEM I INNER JOIN GD_ITEM_DAMAGE D ON I.ITEM_ID = D.ITEM_ID WHERE I.ITEM_CLASS = ?";
        if (this.itemCombo.usesItemRarity()) {
            command = command + " AND I.RARITY = ?";
        }
        if (this.itemCombo.usesArmorClass()) {
            command = command + " AND I.ARMOR_CLASS = ?";
        }
        if (this.itemCombo.usesArtifactClass()) {
            command = command + " AND I.ARTIFACT_CLASS = ?";
        }
        if (this.itemCombo.getMinLevel() != -1) {
            command = command + " AND I.REQ_LEVEL >= ?";
        }
        if (this.itemCombo.getMaxLevel() != -1) {
            command = command + " AND I.REQ_LEVEL <= ?";
        }
        if (this.itemCombo.getMaxCunning() != -1) {
            command = command + " AND I.REQ_DEX <= ?";
        }
        if (this.itemCombo.getMaxPhysique() != -1) {
            command = command + " AND I.REQ_STR <= ?";
        }
        if (this.itemCombo.getMaxSpirit() != -1) {
            command = command + " AND I.REQ_INT <= ?";
        }
        if (this.itemCombo.isNoEnemyOnly()) {
            command = command + " AND I.ENEMY_ONLY = ?";
        }
        command = command + this.itemCombo.determineSlotConditions("I.");
        command = command + " AND (D.DAMAGE_TYPE = ? AND ((D.DAMAGE_MIN > 0) OR (D.MODIFIER > 0)))";
        return command;
    }

    public String determineStashIDItemStatement(boolean isHardcore) {
        String command = "SELECT S.STASH_ID FROM STASH_ITEM_V4 S, GD_ITEM I, GD_ITEM_DAMAGE D WHERE S.ITEM_ID = I.ITEM_ID AND I.ITEM_ID = D.ITEM_ID AND I.ITEM_CLASS = ?";
        if (!GDStashFrame.iniConfig.sectRestrict.transferSCHC) {
            command = isHardcore ? command + " AND S.HARDCORE = true" : command + " AND S.HARDCORE = false";
        }
        if (this.itemCombo.usesItemRarity()) {
            command = command + " AND I.RARITY = ?";
        }
        if (this.itemCombo.usesArmorClass()) {
            command = command + " AND I.ARMOR_CLASS = ?";
        }
        if (this.itemCombo.usesArtifactClass()) {
            command = command + " AND I.ARTIFACT_CLASS = ?";
        }
        if (this.itemCombo.getMinLevel() != -1) {
            command = command + " AND I.REQ_LEVEL >= ?";
        }
        if (this.itemCombo.getMaxLevel() != -1) {
            command = command + " AND I.REQ_LEVEL <= ?";
        }
        if (this.itemCombo.getMaxCunning() != -1) {
            command = command + " AND I.REQ_DEX <= ?";
        }
        if (this.itemCombo.getMaxPhysique() != -1) {
            command = command + " AND I.REQ_STR <= ?";
        }
        if (this.itemCombo.getMaxSpirit() != -1) {
            command = command + " AND I.REQ_INT <= ?";
        }
        if (this.itemCombo.isNoEnemyOnly()) {
            command = command + " AND I.ENEMY_ONLY = ?";
        }
        command = command + this.itemCombo.determineSlotConditions("I.");
        command = command + " AND (D.DAMAGE_TYPE = ? AND ((D.DAMAGE_MIN > 0) OR (D.MODIFIER > 0)))";
        return command;
    }

    public int fillItemIDStatement(PreparedStatement ps) throws SQLException {
        if (this.damageTypes == null) {
            return -1;
        }
        return this.itemCombo.fillItemStatement(ps);
    }

    public String determineStashIDPrefixStatement(boolean isHardcore) {
        String command = "SELECT S.STASH_ID FROM STASH_ITEM_V4 S, GD_ITEM I, GD_AFFIX A, GD_AFFIX_DAMAGE D WHERE S.ITEM_ID = I.ITEM_ID AND S.PREFIX_ID = A.AFFIX_ID AND A.TYPE = 1 AND A.AFFIX_ID = D.AFFIX_ID AND I.ITEM_CLASS = ?";
        if (!GDStashFrame.iniConfig.sectRestrict.transferSCHC) {
            command = isHardcore ? command + " AND S.HARDCORE = true" : command + " AND S.HARDCORE = false";
        }
        if (this.itemCombo.usesArmorClass()) {
            command = command + " AND I.ARMOR_CLASS = ?";
        }
        if (this.itemCombo.usesArtifactClass()) {
            command = command + " AND I.ARTIFACT_CLASS = ?";
        }
        if (this.itemCombo.getMaxLevel() != -1) {
            command = command + " AND I.REQ_LEVEL <= ?";
        }
        if (this.itemCombo.getMaxCunning() != -1) {
            command = command + " AND I.REQ_DEX <= ?";
        }
        if (this.itemCombo.getMaxPhysique() != -1) {
            command = command + " AND I.REQ_STR <= ?";
        }
        if (this.itemCombo.getMaxSpirit() != -1) {
            command = command + " AND I.REQ_INT <= ?";
        }
        if (this.itemCombo.isNoEnemyOnly()) {
            command = command + " AND I.ENEMY_ONLY = ?";
        }
        if (this.itemCombo.usesItemRarity()) {
            command = command + " AND A.RARITY = ?";
        }
        if (this.itemCombo.getMinLevel() != -1) {
            command = command + " AND A.REQ_LEVEL >= ?";
        }
        if (this.itemCombo.getMaxLevel() != -1) {
            command = command + " AND A.REQ_LEVEL <= ?";
        }
        command = command + this.itemCombo.determineSlotConditions("I.");
        command = command + " AND (D.DAMAGE_TYPE = ? AND ((D.DAMAGE_MIN > 0) OR (D.MODIFIER > 0)))";
        return command;
    }

    public String determineStashIDSuffixStatement(boolean isHardcore) {
        String command = "SELECT S.STASH_ID FROM STASH_ITEM_V4 S, GD_ITEM I, GD_AFFIX A, GD_AFFIX_DAMAGE D WHERE S.ITEM_ID = I.ITEM_ID AND S.SUFFIX_ID = A.AFFIX_ID AND A.TYPE = 2 AND A.AFFIX_ID = D.AFFIX_ID AND I.ITEM_CLASS = ?";
        if (!GDStashFrame.iniConfig.sectRestrict.transferSCHC) {
            command = isHardcore ? command + " AND S.HARDCORE = true" : command + " AND S.HARDCORE = false";
        }
        if (this.itemCombo.usesArmorClass()) {
            command = command + " AND I.ARMOR_CLASS = ?";
        }
        if (this.itemCombo.usesArtifactClass()) {
            command = command + " AND I.ARTIFACT_CLASS = ?";
        }
        if (this.itemCombo.getMaxLevel() != -1) {
            command = command + " AND I.REQ_LEVEL <= ?";
        }
        if (this.itemCombo.getMaxCunning() != -1) {
            command = command + " AND I.REQ_DEX <= ?";
        }
        if (this.itemCombo.getMaxPhysique() != -1) {
            command = command + " AND I.REQ_STR <= ?";
        }
        if (this.itemCombo.getMaxSpirit() != -1) {
            command = command + " AND I.REQ_INT <= ?";
        }
        if (this.itemCombo.isNoEnemyOnly()) {
            command = command + " AND I.ENEMY_ONLY = ?";
        }
        if (this.itemCombo.usesItemRarity()) {
            command = command + " AND A.RARITY = ?";
        }
        if (this.itemCombo.getMinLevel() != -1) {
            command = command + " AND A.REQ_LEVEL >= ?";
        }
        if (this.itemCombo.getMaxLevel() != -1) {
            command = command + " AND A.REQ_LEVEL <= ?";
        }
        command = command + this.itemCombo.determineSlotConditions("I.");
        command = command + " AND (D.DAMAGE_TYPE = ? AND ((D.DAMAGE_MIN > 0) OR (D.MODIFIER > 0)))";
        return command;
    }

    public int fillAffixIDStatement(PreparedStatement ps) throws SQLException {
        if (this.damageTypes == null) {
            return -1;
        }
        ps.clearParameters();
        int nextPos = 1;
        ps.setString(nextPos, this.itemCombo.getItemClass());
        ++nextPos;
        if (this.itemCombo.usesArmorClass()) {
            ps.setString(nextPos, this.itemCombo.getArmorClass());
            ++nextPos;
        }
        if (this.itemCombo.usesArtifactClass()) {
            ps.setString(nextPos, this.itemCombo.getArtifactClass());
            ++nextPos;
        }
        if (this.itemCombo.getMaxLevel() != -1) {
            ps.setInt(nextPos, this.itemCombo.getMaxLevel());
            ++nextPos;
        }
        if (this.itemCombo.getMaxCunning() != -1) {
            ps.setInt(nextPos, this.itemCombo.getMaxCunning());
            ++nextPos;
        }
        if (this.itemCombo.getMaxPhysique() != -1) {
            ps.setInt(nextPos, this.itemCombo.getMaxPhysique());
            ++nextPos;
        }
        if (this.itemCombo.getMaxSpirit() != -1) {
            ps.setInt(nextPos, this.itemCombo.getMaxSpirit());
            ++nextPos;
        }
        if (this.itemCombo.isNoEnemyOnly()) {
            ps.setBoolean(nextPos, false);
            ++nextPos;
        }
        if (this.itemCombo.usesItemRarity()) {
            ps.setString(nextPos, this.itemCombo.getItemRarity());
            ++nextPos;
        }
        if (this.itemCombo.getMinLevel() != -1) {
            ps.setInt(nextPos, this.itemCombo.getMinLevel());
            ++nextPos;
        }
        if (this.itemCombo.getMaxLevel() != -1) {
            ps.setInt(nextPos, this.itemCombo.getMaxLevel());
            ++nextPos;
        }
        return nextPos;
    }

    public List<DamageCriteriaCombination> createItemDamageCombinations() {
        LinkedList<DamageCriteriaCombination> list = new LinkedList<DamageCriteriaCombination>();
        List<String> damageIDs = DamageCriteriaCombination.createDamageIDCombinations(this.criteria);
        Iterator<String> iterIC = this.criteria.itemClass.iterator();
        while (iterIC.hasNext()) {
            this.itemCombo.setItemClass(iterIC.next());
            List<ItemCriteriaCombination> itemCombos = this.itemCombo.createItemCombinations();
            for (ItemCriteriaCombination combo : itemCombos) {
                DamageCriteriaCombination dcc = new DamageCriteriaCombination(this.criteria, combo, damageIDs);
                list.add(dcc);
            }
        }
        return list;
    }

    public List<DamageCriteriaCombination> createAffixDamageCombinations() {
        LinkedList<DamageCriteriaCombination> list = new LinkedList<DamageCriteriaCombination>();
        List<String> damageIDs = DamageCriteriaCombination.createDamageIDCombinations(this.criteria);
        Iterator<String> iterIC = this.criteria.itemClass.iterator();
        while (iterIC.hasNext()) {
            this.itemCombo.setItemClass(iterIC.next());
            List<ItemCriteriaCombination> itemCombos = this.itemCombo.createAffixCombinations();
            for (ItemCriteriaCombination combo : itemCombos) {
                DamageCriteriaCombination dcc = new DamageCriteriaCombination(this.criteria, combo, damageIDs);
                list.add(dcc);
            }
        }
        return list;
    }

    public static List<String> createDamageIDCombinations(SelectionCriteria criteria) {
        LinkedList<String> list = new LinkedList<String>();
        for (Integer iClass : criteria.dmgClass) {
            int dmgClass = iClass;
            for (Integer iType : criteria.dmgType) {
                int dmgType = iType;
                if (dmgType == 101) {
                    if (dmgClass == 1) {
                        list.add("defensivePoison");
                    }
                    if (dmgClass == 2) {
                        list.add("offensiveBasePoison");
                        list.add("offensivePoison");
                    }
                    if (dmgClass == 3) {
                        list.add("retaliationPoison");
                    }
                }
                if (dmgType == 102) {
                    if (dmgClass == 1) {
                        list.add("defensiveAether");
                    }
                    if (dmgClass == 2) {
                        list.add("offensiveBaseAether");
                        list.add("offensiveAether");
                    }
                    if (dmgClass == 3) {
                        list.add("retaliationAether");
                    }
                }
                if (dmgType == 103) {
                    if (dmgClass == 1) {
                        list.add("defensiveChaos");
                    }
                    if (dmgClass == 2) {
                        list.add("offensiveBaseChaos");
                        list.add("offensiveChaos");
                    }
                    if (dmgClass == 3) {
                        list.add("retaliationChaos");
                    }
                }
                if (dmgType == 104) {
                    if (dmgClass == 1) {
                        list.add("defensiveCold");
                    }
                    if (dmgClass == 2) {
                        list.add("offensiveBaseCold");
                        list.add("offensiveCold");
                    }
                    if (dmgClass == 3) {
                        list.add("retaliationCold");
                    }
                }
                if (dmgType == 105) {
                    if (dmgClass == 1) {
                        list.add("defensiveElemental");
                        list.add("defensiveElementalResistance");
                    }
                    if (dmgClass == 2) {
                        list.add("offensiveElemental");
                    }
                    if (dmgClass == 3) {
                        list.add("retaliationElemental");
                    }
                }
                if (dmgType == 106) {
                    if (dmgClass == 1) {
                        list.add("defensiveFire");
                    }
                    if (dmgClass == 2) {
                        list.add("offensiveBaseFire");
                        list.add("offensiveFire");
                    }
                    if (dmgClass == 3) {
                        list.add("retaliationFire");
                    }
                }
                if (dmgType == 107) {
                    if (dmgClass == 1) {
                        list.add("defensiveLife");
                    }
                    if (dmgClass == 2) {
                        list.add("offensiveBaseLife");
                        list.add("offensiveLife");
                    }
                    if (dmgClass == 3) {
                        list.add("retaliationLife");
                    }
                }
                if (dmgType == 108) {
                    if (dmgClass == 1) {
                        list.add("defensiveLightning");
                    }
                    if (dmgClass == 2) {
                        list.add("offensiveBaseLightning");
                        list.add("offensiveLightning");
                    }
                    if (dmgClass == 3) {
                        list.add("retaliationLightning");
                    }
                }
                if (dmgType == 109) {
                    if (dmgClass == 1) {
                        list.add("defensivePhysical");
                    }
                    if (dmgClass == 2) {
                        list.add("offensivePhysical");
                        list.add("offensiveBonusPhysical");
                    }
                    if (dmgClass == 3) {
                        list.add("retaliationPhysical");
                    }
                }
                if (dmgType == 110) {
                    if (dmgClass == 1) {
                        list.add("defensivePierce");
                    }
                    if (dmgClass == 2) {
                        list.add("offensivePierce");
                    }
                    if (dmgClass == 3) {
                        list.add("retaliationPierce");
                    }
                }
                if (dmgType == 201) {
                    if (dmgClass == 2) {
                        list.add("offensiveSlowPoison");
                    }
                    if (dmgClass == 3) {
                        list.add("retaliationSlowPoison");
                    }
                }
                if (dmgType == 204) {
                    if (dmgClass == 2) {
                        list.add("offensiveSlowCold");
                    }
                    if (dmgClass == 3) {
                        list.add("retaliationSlowCold");
                    }
                }
                if (dmgType == 206) {
                    if (dmgClass == 2) {
                        list.add("offensiveSlowFire");
                    }
                    if (dmgClass == 3) {
                        list.add("retaliationSlowFire");
                    }
                }
                if (dmgType == 207) {
                    if (dmgClass == 2) {
                        list.add("offensiveSlowLife");
                    }
                    if (dmgClass == 3) {
                        list.add("retaliationSlowLife");
                    }
                }
                if (dmgType == 208) {
                    if (dmgClass == 2) {
                        list.add("offensiveSlowLightning");
                    }
                    if (dmgClass == 3) {
                        list.add("retaliationSlowLightning");
                    }
                }
                if (dmgType == 209) {
                    if (dmgClass == 2) {
                        list.add("offensiveSlowPhysical");
                    }
                    if (dmgClass == 3) {
                        list.add("retaliationSlowPhysical");
                    }
                }
                if (dmgType == 210) {
                    if (dmgClass == 1) {
                        list.add("defensiveBleeding");
                    }
                    if (dmgClass == 2) {
                        list.add("offensiveSlowBleeding");
                        list.add("offensivePoison");
                    }
                    if (dmgClass == 3) {
                        list.add("retaliationSlowBleeding");
                    }
                }
                if (dmgType == 301) {
                    if (dmgClass == 2) {
                        list.add("offensiveTotalDamage");
                    }
                    if (dmgClass == 3) {
                        list.add("retaliationTotalDamage");
                    }
                }
                if (dmgType == 302 && dmgClass == 2) {
                    list.add("offensiveCritDamage");
                }
                if (dmgType == 303 && dmgClass == 2) {
                    list.add("offensiveLifeLeech");
                }
                if (dmgType == 304 && dmgClass == 1) {
                    list.add("defensiveReflect");
                }
                if (dmgType == 305) {
                    if (dmgClass == 2) {
                        list.add("offensiveSlowAttackSpeed");
                    }
                    if (dmgClass == 3) {
                        list.add("retaliationSlowAttackSpeed");
                    }
                }
                if (dmgType == 306 && dmgClass == 2) {
                    list.add("offensiveSlowTotalSpeed");
                }
                if (dmgType == 307) {
                    if (dmgClass == 2) {
                        list.add("offensiveSlowDefensiveAbility");
                    }
                    if (dmgClass == 3) {
                        list.add("retaliationSlowDefensiveAbility");
                    }
                }
                if (dmgType != 308) continue;
                if (dmgClass == 2) {
                    list.add("offensiveSlowOffensiveAbility");
                }
                if (dmgClass != 3) continue;
                list.add("retaliationSlowOffensiveAbility");
            }
        }
        return list;
    }
}

