/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.db;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.List;
import org.gdstash.db.DBAffix;
import org.gdstash.db.DBAffixSet;
import org.gdstash.db.DBConfig;
import org.gdstash.db.DBEngineGame;
import org.gdstash.db.DBEnginePlayer;
import org.gdstash.db.DBFaction;
import org.gdstash.db.DBFormulaSet;
import org.gdstash.db.DBItem;
import org.gdstash.db.DBItemCraft;
import org.gdstash.db.DBItemSet;
import org.gdstash.db.DBLootTable;
import org.gdstash.db.DBLootTableSet;
import org.gdstash.db.DBSkill;
import org.gdstash.db.DBStashItem;
import org.gdstash.db.GDDBUtil;
import org.gdstash.file.ARZRecord;
import org.gdstash.ui.GDStashFrame;
import org.gdstash.util.GDConstants;
import org.gdstash.util.GDMsgFormatter;
import org.gdstash.util.GDMsgLogger;

public class GDDBData {
    public static final String DERBY_LANG_DUPLICATE_KEY_CONSTRAINT = "23505";
    private static final String oldURL = "jdbc:derby:db;";
    private static String dbURL = null;
    private static String mod = null;

    private static void fillDBUrl(String mod) {
        String dbDir = null;
        dbDir = mod == null ? "db" : (mod.isEmpty() ? "db" : "db_" + mod);
        String dir = GDConstants.USER_HOME + GDConstants.FILE_SEPARATOR + "GDStash" + GDConstants.FILE_SEPARATOR + dbDir;
        dbURL = "jdbc:derby:" + dir + ";";
    }

    public static boolean doesExist() {
        GDDBData.fillDBUrl(null);
        return GDDBUtil.doesExist(dbURL);
    }

    public static boolean doesExist(String mod) {
        GDDBData.fillDBUrl(mod);
        return GDDBUtil.doesExist(dbURL);
    }

    public static Connection getConnection() throws SQLException {
        String mod = null;
        if (GDStashFrame.iniConfig != null && GDStashFrame.iniConfig.sectHistory != null) {
            mod = GDStashFrame.iniConfig.sectHistory.lastMod;
        }
        return GDDBData.getConnection(mod);
    }

    public static Connection getConnection(String mod) throws SQLException {
        GDDBData.fillDBUrl(mod);
        String url = dbURL + "create=true";
        Connection conn = DriverManager.getConnection(url);
        conn.setAutoCommit(false);
        return conn;
    }

    public static Connection getOldConnection() throws SQLException {
        String url = "jdbc:derby:db;create=false";
        Connection conn = DriverManager.getConnection(url);
        conn.setAutoCommit(false);
        return conn;
    }

    public static void createConfigTables() throws SQLException {
        try (Connection conn = GDDBData.getConnection();){
            if (GDDBUtil.tableExists(conn, "INFO_CONFIG")) {
                String version = DBConfig.getConfigVersion();
                if (version == null || !version.equals("0.9.9d")) {
                    DBConfig.createTable();
                }
            } else {
                DBConfig.createTable();
            }
            if (!GDDBUtil.tableExists(conn, "STASH_ITEM_V4")) {
                DBStashItem.createTable();
            }
            conn.commit();
        }
    }

    private static void createDataTables() throws SQLException {
        DBItem.createTables();
        DBItemSet.createTables();
        DBAffix.createTables();
        DBAffixSet.createTables();
        DBFormulaSet.createTables();
        DBLootTable.createTables();
        DBLootTableSet.createTables();
        DBSkill.createTables();
        DBEngineGame.createTable();
        DBFaction.createTable();
        DBEnginePlayer.createTable();
    }

    public static void clearBuffers() {
        DBAffix.clearBuffer();
        DBAffixSet.clearBuffer();
        DBFormulaSet.clearBuffer();
        DBItem.clearBuffer();
        DBItemCraft.clearBuffer();
        DBLootTable.clearBuffer();
        DBLootTableSet.clearBuffer();
        DBSkill.clearBuffer();
    }

    public static boolean insertData(ARZRecord[] records) {
        boolean success = false;
        try {
            GDDBData.createDataTables();
            GDDBData.insertRecords(records);
            success = true;
        }
        catch (Exception ex) {
            GDMsgLogger.addError(ex);
        }
        return success;
    }

    private static void insertRecords(ARZRecord[] records) throws SQLException {
        for (int i = 0; i < records.length; ++i) {
            if (records[i] == null) continue;
            try {
                boolean processed = false;
                if (records[i].isGameEngine()) {
                    DBEngineGame.insert(records[i]);
                    processed = true;
                }
                if (records[i].isFaction()) {
                    DBFaction.insert(records[i]);
                    processed = true;
                }
                if (records[i].isPlayerEngine()) {
                    DBEnginePlayer.insert(records[i]);
                    processed = true;
                }
                if (records[i].isAffix()) {
                    DBAffix.insert(records[i]);
                    processed = true;
                }
                if (records[i].isAffixSet()) {
                    DBAffixSet.insert(records[i]);
                    processed = true;
                }
                if (records[i].isItemSet()) {
                    DBItemSet.insert(records[i]);
                    processed = true;
                }
                if (records[i].isLootTable()) {
                    DBLootTable.insert(records[i]);
                    processed = true;
                }
                if (records[i].isLootTableSet()) {
                    DBLootTableSet.insert(records[i]);
                    processed = true;
                }
                if (records[i].isFormulaSet()) {
                    DBFormulaSet.insert(records[i]);
                    processed = true;
                }
                if (records[i].isSkill()) {
                    DBSkill.insert(records[i]);
                    processed = true;
                }
                if (processed || records[i].getFileDescription() != null && records[i].getFileDescription().startsWith("BASE")) continue;
                if (records[i].getItemName() == null) {
                    if (records[i].getItemNameTag() == null) continue;
                    Object[] args = new Object[]{records[i].getItemNameTag(), "tags_items.txt"};
                    String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_TAG_NOT_FOUND", args);
                    GDMsgLogger.addWarning(msg);
                    continue;
                }
                if (records[i].getBitmapID() == null || records[i].getBitmap() == null) continue;
                DBItem.insert(records[i]);
                continue;
            }
            catch (Exception ex) {
                GDMsgLogger.addError(ex);
            }
        }
        GDDBData.clearBuffers();
        if (GDMsgLogger.errorsInLog()) {
            throw new SQLException(GDMsgFormatter.getString(GDMsgFormatter.rbMsg, "ERR_DB_IMPORT"));
        }
    }

    public static boolean insertModData(ARZRecord[] records) {
        boolean success = false;
        try {
            GDDBData.insertModRecords(records);
            success = true;
        }
        catch (Exception ex) {
            GDMsgLogger.addError(ex);
        }
        return success;
    }

    private static void insertModRecords(ARZRecord[] records) throws SQLException {
        for (int i = 0; i < records.length; ++i) {
            if (records[i] == null) continue;
            try {
                boolean processed = false;
                if (records[i].isGameEngine()) {
                    DBEngineGame.insertMod(records[i]);
                    processed = true;
                }
                if (records[i].isFaction()) {
                    DBFaction.insertMod(records[i]);
                    processed = true;
                }
                if (records[i].isPlayerEngine()) {
                    DBEnginePlayer.insertMod(records[i]);
                    processed = true;
                }
                if (records[i].isAffix()) {
                    DBAffix.insertMod(records[i]);
                    processed = true;
                }
                if (records[i].isAffixSet()) {
                    DBAffixSet.insertMod(records[i]);
                    processed = true;
                }
                if (records[i].isItemSet()) {
                    DBItemSet.insertMod(records[i]);
                    processed = true;
                }
                if (records[i].isLootTable()) {
                    DBLootTable.insertMod(records[i]);
                    processed = true;
                }
                if (records[i].isLootTableSet()) {
                    DBLootTableSet.insertMod(records[i]);
                    processed = true;
                }
                if (records[i].isFormulaSet()) {
                    DBFormulaSet.insertMod(records[i]);
                    processed = true;
                }
                if (records[i].isSkill()) {
                    DBSkill.insertMod(records[i]);
                    processed = true;
                }
                if (processed || records[i].getFileDescription() != null && records[i].getFileDescription().startsWith("BASE")) continue;
                if (records[i].getItemName() == null) {
                    if (records[i].getItemNameTag() == null) continue;
                    Object[] args = new Object[]{records[i].getItemNameTag(), "tags_items.txt"};
                    String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_TAG_NOT_FOUND", args);
                    GDMsgLogger.addWarning(msg);
                    continue;
                }
                if (records[i].getBitmapID() == null || records[i].getBitmap() == null) continue;
                DBItem.insertMod(records[i]);
                continue;
            }
            catch (SQLException ex) {
                GDMsgLogger.addError(ex);
            }
        }
        GDDBData.clearBuffers();
        if (GDMsgLogger.errorsInLog()) {
            throw new SQLException(GDMsgFormatter.getString(GDMsgFormatter.rbMsg, "ERR_DB_IMPORT"));
        }
    }

    public static boolean updateStash() {
        boolean success = false;
        try {
            boolean updated = false;
            if (GDDBUtil.doesExist(oldURL)) {
                if (GDDBUtil.tableExists(GDDBData.getOldConnection(), "STASH_ITEM")) {
                    GDDBData.moveStash(GDDBData.getOldConnection(), GDDBData.getConnection(), "STASH_ITEM");
                    updated = true;
                } else if (GDDBUtil.tableExists(GDDBData.getOldConnection(), "STASH_ITEM_V2")) {
                    GDDBData.moveStash(GDDBData.getOldConnection(), GDDBData.getConnection(), "STASH_ITEM_V2");
                    updated = true;
                } else if (GDDBUtil.tableExists(GDDBData.getOldConnection(), "STASH_ITEM_V3")) {
                    GDDBData.moveStash(GDDBData.getOldConnection(), GDDBData.getConnection(), "STASH_ITEM_V3");
                    updated = true;
                }
            }
            if (!updated) {
                if (GDDBUtil.tableExists("STASH_ITEM")) {
                    GDDBData.convertStash("STASH_ITEM");
                } else if (GDDBUtil.tableExists("STASH_ITEM_V2")) {
                    GDDBData.convertStash("STASH_ITEM_V2");
                } else if (GDDBUtil.tableExists("STASH_ITEM_V3")) {
                    GDDBData.convertStash("STASH_ITEM_V3");
                } else {
                    GDDBData.updateDependent();
                }
            }
            success = !GDMsgLogger.errorsInLog();
        }
        catch (SQLException ex) {
            GDMsgLogger.addError(ex);
        }
        catch (Exception ex) {
            GDMsgLogger.addError(ex);
        }
        return success;
    }

    private static void updateDependent() throws SQLException {
        if (GDDBUtil.tableExists("STASH_ITEM_V4")) {
            List<DBStashItem> items = DBStashItem.getAll();
            DBStashItem.updateDependentFields(items);
        }
    }

    private static void convertStash(String tableName) throws SQLException {
        if (GDDBUtil.tableExists(tableName)) {
            List<DBStashItem> items = DBStashItem.getAllOld(GDDBData.getConnection(), tableName);
            DBStashItem.convertStash(tableName, items);
            DBStashItem.dropOldStash(GDDBData.getConnection(), tableName);
        }
    }

    private static void moveStash(Connection connOld, Connection connNew, String tableName) throws SQLException {
        if (GDDBUtil.tableExists(connOld, tableName)) {
            List<DBStashItem> items = DBStashItem.getAllOld(connOld, tableName);
            DBStashItem.moveStash(connOld, connNew, tableName, items);
            DBStashItem.dropOldStash(connOld, tableName);
        }
    }
}

