/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.db;

import java.util.LinkedList;
import java.util.List;
import org.gdstash.db.DamageCriteriaCombination;
import org.gdstash.util.GDLog;
import org.gdstash.util.GDMsgFormatter;

public class SelectionCriteria {
    public static int SELECTION_MODE_ITEM = 1;
    public static int SELECTION_MODE_COMPONENT = 2;
    public static int SELECTION_MODE_DAMAGE = 3;
    public static int SELECTION_MODE_AFFIX = 4;
    public int selMode = SELECTION_MODE_ITEM;
    public List<String> itemIDs = null;
    public List<String> itemClass = new LinkedList<String>();
    public List<String> armorClass = new LinkedList<String>();
    public List<String> artifactClass = new LinkedList<String>();
    public List<String> itemRarity = new LinkedList<String>();
    public List<String> itemStyle = new LinkedList<String>();
    public String itemName;
    public int levelMin = -1;
    public int levelMax = -1;
    public int cunningMax = -1;
    public int physiqueMax = -1;
    public int spiritMax = -1;
    public boolean noEnemyOnly = true;
    public List<Integer> dmgClass = new LinkedList<Integer>();
    public List<Integer> dmgType = new LinkedList<Integer>();
    public boolean dmgFlat;
    public boolean dmgPercentage;
    public boolean slotAxe1H = false;
    public boolean slotAxe2H = false;
    public boolean slotDagger1H = false;
    public boolean slotMace1H = false;
    public boolean slotMace2H = false;
    public boolean slotScepter1H = false;
    public boolean slotSpear2H;
    public boolean slotStaff2H;
    public boolean slotSword1H = false;
    public boolean slotSword2H = false;
    public boolean slotRanged1H = false;
    public boolean slotRanged2H = false;
    public boolean slotShield = false;
    public boolean slotOffhand = false;
    public boolean slotAmulet = false;
    public boolean slotBelt = false;
    public boolean slotMedal = false;
    public boolean slotRing = false;
    public boolean slotHead = false;
    public boolean slotShoulders = false;
    public boolean slotChest = false;
    public boolean slotHands = false;
    public boolean slotLegs = false;
    public boolean slotFeet = false;
    public boolean petBonus = false;
    public StatCriteria statFlat = new StatCriteria();
    public StatCriteria statPerc = new StatCriteria();

    public void checkCriteria(GDLog log) {
        List<String> list;
        if (this.selMode != SELECTION_MODE_AFFIX && (this.itemIDs == null || this.itemIDs.isEmpty()) && (this.itemClass == null || this.itemClass.isEmpty())) {
            log.addError(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "ERR_SEL_ITEM_TYPE"));
        }
        if (!(this.dmgClass != null && !this.dmgClass.isEmpty() || this.dmgType == null || this.dmgType.isEmpty() || this.petBonus)) {
            log.addError(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "ERR_SEL_DMG_CLASS"));
        }
        if (!(this.dmgType != null && !this.dmgType.isEmpty() || this.dmgClass == null || this.dmgClass.isEmpty() || this.petBonus)) {
            log.addError(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "ERR_SEL_DMG_TYPE"));
        }
        if (!(this.dmgClass == null || this.dmgClass.isEmpty() || this.dmgType == null || this.dmgType.isEmpty() || (list = DamageCriteriaCombination.createDamageIDCombinations(this)) != null && !list.isEmpty())) {
            log.addError(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "ERR_SEL_DMG_COMBI"));
        }
    }

    public static class StatCriteria {
        public boolean physique = false;
        public boolean cunning = false;
        public boolean spirit = false;
        public boolean defense = false;
        public boolean offense = false;
        public boolean health = false;
        public boolean healthRegen = false;
        public boolean energyRegen = false;
        public boolean attackSpeed = false;
        public boolean castSpeed = false;
        public boolean runSpeed = false;
        public boolean totalSpeed = false;
        public boolean cooldown = false;
        public boolean shieldRecovery = false;

        public boolean isUsed() {
            if (this.physique) {
                return true;
            }
            if (this.cunning) {
                return true;
            }
            if (this.spirit) {
                return true;
            }
            if (this.defense) {
                return true;
            }
            if (this.offense) {
                return true;
            }
            if (this.health) {
                return true;
            }
            if (this.healthRegen) {
                return true;
            }
            if (this.energyRegen) {
                return true;
            }
            if (this.attackSpeed) {
                return true;
            }
            if (this.castSpeed) {
                return true;
            }
            if (this.runSpeed) {
                return true;
            }
            if (this.totalSpeed) {
                return true;
            }
            if (this.cooldown) {
                return true;
            }
            return this.shieldRecovery;
        }
    }
}

