/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.db.criteria;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.gdstash.db.ItemClass;
import org.gdstash.db.SelectionCriteria;
import org.gdstash.db.criteria.CriteriaCombination;
import org.gdstash.db.criteria.CriteriaCombinationLevel2;
import org.gdstash.util.GDMsgFormatter;

public class AbstractItemCombination
implements CriteriaCombination,
Cloneable {
    private String itemClass;
    private String armorClass;
    private String artifactClass;
    private String itemRarity;
    private boolean useArmorClass;
    private boolean useArtifactClass;
    private boolean useItemRarity;
    private boolean useItemName;
    private boolean useSlots;
    private boolean petBonus;
    private String itemName;
    private int levelMin;
    private int levelMax;
    private int cunningMax;
    private int physiqueMax;
    private int spiritMax;
    private boolean noEnemyOnly;
    private SelectionCriteria criteria;

    public AbstractItemCombination() {
        this.itemClass = null;
        this.armorClass = null;
        this.artifactClass = null;
        this.itemRarity = null;
        this.useArmorClass = false;
        this.useArtifactClass = false;
        this.useItemRarity = false;
        this.useItemName = false;
        this.useSlots = false;
        this.petBonus = false;
        this.itemName = null;
        this.levelMin = -1;
        this.levelMax = -1;
        this.cunningMax = -1;
        this.physiqueMax = -1;
        this.spiritMax = -1;
        this.noEnemyOnly = true;
        this.criteria = null;
    }

    public AbstractItemCombination(AbstractItemCombination combo) {
        this.itemClass = combo.itemClass;
        this.armorClass = combo.armorClass;
        this.artifactClass = combo.artifactClass;
        this.itemRarity = combo.itemRarity;
        this.useArmorClass = combo.useArmorClass;
        this.useArtifactClass = combo.useArtifactClass;
        this.useItemRarity = combo.useItemRarity;
        this.useItemName = combo.useItemName;
        this.useSlots = combo.useSlots;
        this.petBonus = combo.petBonus;
        this.itemName = combo.itemName;
        this.levelMin = combo.levelMin;
        this.levelMax = combo.levelMax;
        this.cunningMax = combo.cunningMax;
        this.physiqueMax = combo.physiqueMax;
        this.spiritMax = combo.spiritMax;
        this.noEnemyOnly = combo.noEnemyOnly;
        this.criteria = combo.criteria;
    }

    public AbstractItemCombination(SelectionCriteria criteria) {
        this();
        this.setItemName(criteria.itemName);
        this.levelMin = criteria.levelMin;
        this.levelMax = criteria.levelMax;
        this.cunningMax = criteria.cunningMax;
        this.physiqueMax = criteria.physiqueMax;
        this.spiritMax = criteria.spiritMax;
        this.noEnemyOnly = criteria.noEnemyOnly;
        this.petBonus = criteria.petBonus;
        this.criteria = criteria;
    }

    @Override
    public AbstractItemCombination clone() {
        AbstractItemCombination combo = new AbstractItemCombination(this);
        return combo;
    }

    public String getItemClass() {
        return this.itemClass;
    }

    public String getArmorClass() {
        return this.armorClass;
    }

    public String getArtifactClass() {
        return this.artifactClass;
    }

    public String getItemRarity() {
        return this.itemRarity;
    }

    @Override
    public boolean usesArmorClass() {
        return this.useArmorClass;
    }

    @Override
    public boolean usesArtifactClass() {
        return this.useArtifactClass;
    }

    @Override
    public boolean usesItemRarity() {
        return this.useItemRarity;
    }

    @Override
    public boolean usesItemName() {
        return this.useItemName;
    }

    public boolean usesSlots() {
        return this.useSlots;
    }

    public boolean usesPetBonus() {
        return this.petBonus;
    }

    public String getItemName() {
        return this.itemName;
    }

    public int getMinLevel() {
        return this.levelMin;
    }

    public int getMaxLevel() {
        return this.levelMax;
    }

    public int getMaxCunning() {
        return this.cunningMax;
    }

    public int getMaxPhysique() {
        return this.physiqueMax;
    }

    public int getMaxSpirit() {
        return this.spiritMax;
    }

    public boolean isNoEnemyOnly() {
        return this.noEnemyOnly;
    }

    public SelectionCriteria getCriteria() {
        return this.criteria;
    }

    public List<String> getItemRarities() {
        if (this.criteria == null) {
            return new LinkedList<String>();
        }
        return this.criteria.itemRarity;
    }

    public List<String> getArmorClasses() {
        if (this.criteria == null) {
            return new LinkedList<String>();
        }
        return this.criteria.armorClass;
    }

    public List<String> getArtifactClasses() {
        if (this.criteria == null) {
            return new LinkedList<String>();
        }
        return this.criteria.artifactClass;
    }

    private void init() {
        this.useArmorClass = false;
        if (!this.criteria.armorClass.isEmpty() && this.isArmor()) {
            this.useArmorClass = true;
        }
        this.useArtifactClass = false;
        if (!this.criteria.artifactClass.isEmpty() && this.isArtifact()) {
            this.useArtifactClass = true;
        }
        this.useItemRarity = false;
        if (!this.criteria.itemRarity.isEmpty() && ItemClass.hasRarity(this.itemClass)) {
            this.useItemRarity = true;
        }
        this.useItemName = false;
        if (this.criteria.itemName != null && !this.criteria.itemName.isEmpty()) {
            this.useItemName = true;
        }
        this.useSlots = false;
        if (this.hasSlots()) {
            this.useSlots = true;
        }
    }

    private boolean isArmor() {
        if (this.itemClass == null) {
            return false;
        }
        return this.itemClass.equals("ArmorProtective_Head") || this.itemClass.equals("ArmorProtective_Shoulders") || this.itemClass.equals("ArmorProtective_Chest") || this.itemClass.equals("ArmorProtective_Hands") || this.itemClass.equals("ArmorProtective_Legs") || this.itemClass.equals("ArmorProtective_Feet");
    }

    private boolean isArtifact() {
        if (this.itemClass == null) {
            return false;
        }
        return this.itemClass.equals("ItemArtifact");
    }

    private boolean hasSlots() {
        if (this.itemClass == null) {
            return false;
        }
        return this.itemClass.equals("ItemRelic") || this.itemClass.equals("ItemEnchantment");
    }

    public static List<String> wrapString(ResultSet rs, int pos) throws SQLException {
        LinkedList<String> list = new LinkedList<String>();
        while (rs.next()) {
            String s = rs.getString(pos);
            if (s == null || s.isEmpty()) continue;
            list.add(s);
        }
        return list;
    }

    public static List<Integer> wrapInteger(ResultSet rs, int pos) throws SQLException {
        LinkedList<Integer> list = new LinkedList<Integer>();
        while (rs.next()) {
            int i = rs.getInt(pos);
            Integer iI = new Integer(i);
            list.add(iI);
        }
        return list;
    }

    public String determineSlotConditions(String prefix) {
        String command = "";
        if (!this.useSlots) {
            return command;
        }
        boolean firstSlot = true;
        if (this.criteria.slotAxe1H) {
            if (firstSlot) {
                firstSlot = false;
                command = command + " AND ( ";
            } else {
                command = command + " OR ";
            }
            command = prefix == null ? command + "SLOT_AXE_1H = true" : command + prefix + "SLOT_AXE_1H = true";
        }
        if (this.criteria.slotAxe2H) {
            if (firstSlot) {
                firstSlot = false;
                command = command + " AND ( ";
            } else {
                command = command + " OR ";
            }
            command = prefix == null ? command + "SLOT_AXE_2H = true" : command + prefix + "SLOT_AXE_2H = true";
        }
        if (this.criteria.slotDagger1H) {
            if (firstSlot) {
                firstSlot = false;
                command = command + " AND ( ";
            } else {
                command = command + " OR ";
            }
            command = prefix == null ? command + "SLOT_DAGGER_1H = true" : command + prefix + "SLOT_DAGGER_1H = true";
        }
        if (this.criteria.slotMace1H) {
            if (firstSlot) {
                firstSlot = false;
                command = command + " AND ( ";
            } else {
                command = command + " OR ";
            }
            command = prefix == null ? command + "SLOT_MACE_1H = true" : command + prefix + "SLOT_MACE_1H = true";
        }
        if (this.criteria.slotMace2H) {
            if (firstSlot) {
                firstSlot = false;
                command = command + " AND ( ";
            } else {
                command = command + " OR ";
            }
            command = prefix == null ? command + "SLOT_MACE_2H = true" : command + prefix + "SLOT_MACE_2H = true";
        }
        if (this.criteria.slotScepter1H) {
            if (firstSlot) {
                firstSlot = false;
                command = command + " AND ( ";
            } else {
                command = command + " OR ";
            }
            command = prefix == null ? command + "SLOT_SCEPTER_1H = true" : command + prefix + "SLOT_SCEPTER_1H = true";
        }
        if (this.criteria.slotSpear2H) {
            if (firstSlot) {
                firstSlot = false;
                command = command + " AND ( ";
            } else {
                command = command + " OR ";
            }
            command = prefix == null ? command + "SLOT_SPEAR_2H = true" : command + prefix + "SLOT_SPEAR_2H = true";
        }
        if (this.criteria.slotStaff2H) {
            if (firstSlot) {
                firstSlot = false;
                command = command + " AND ( ";
            } else {
                command = command + " OR ";
            }
            command = prefix == null ? command + "SLOT_STAFF_2H = true" : command + prefix + "SLOT_STAFF_2H = true";
        }
        if (this.criteria.slotSword1H) {
            if (firstSlot) {
                firstSlot = false;
                command = command + " AND ( ";
            } else {
                command = command + " OR ";
            }
            command = prefix == null ? command + "SLOT_SWORD_1H = true" : command + prefix + "SLOT_SWORD_1H = true";
        }
        if (this.criteria.slotSword2H) {
            if (firstSlot) {
                firstSlot = false;
                command = command + " AND ( ";
            } else {
                command = command + " OR ";
            }
            command = prefix == null ? command + "SLOT_SWORD_2H = true" : command + prefix + "SLOT_SWORD_2H = true";
        }
        if (this.criteria.slotRanged1H) {
            if (firstSlot) {
                firstSlot = false;
                command = command + " AND ( ";
            } else {
                command = command + " OR ";
            }
            command = prefix == null ? command + "SLOT_RANGED_1H = true" : command + prefix + "SLOT_RANGED_1H = true";
        }
        if (this.criteria.slotRanged2H) {
            if (firstSlot) {
                firstSlot = false;
                command = command + " AND ( ";
            } else {
                command = command + " OR ";
            }
            command = prefix == null ? command + "SLOT_RANGED_2H = true" : command + prefix + "SLOT_RANGED_2H = true";
        }
        if (this.criteria.slotShield) {
            if (firstSlot) {
                firstSlot = false;
                command = command + " AND ( ";
            } else {
                command = command + " OR ";
            }
            command = prefix == null ? command + "SLOT_SHIELD = true" : command + prefix + "SLOT_SHIELD = true";
        }
        if (this.criteria.slotOffhand) {
            if (firstSlot) {
                firstSlot = false;
                command = command + " AND ( ";
            } else {
                command = command + " OR ";
            }
            command = prefix == null ? command + "SLOT_OFFHAND = true" : command + prefix + "SLOT_OFFHAND = true";
        }
        if (this.criteria.slotAmulet) {
            if (firstSlot) {
                firstSlot = false;
                command = command + " AND ( ";
            } else {
                command = command + " OR ";
            }
            command = prefix == null ? command + "SLOT_AMULET = true" : command + prefix + "SLOT_AMULET = true";
        }
        if (this.criteria.slotBelt) {
            if (firstSlot) {
                firstSlot = false;
                command = command + " AND ( ";
            } else {
                command = command + " OR ";
            }
            command = prefix == null ? command + "SLOT_BELT = true" : command + prefix + "SLOT_BELT = true";
        }
        if (this.criteria.slotMedal) {
            if (firstSlot) {
                firstSlot = false;
                command = command + " AND ( ";
            } else {
                command = command + " OR ";
            }
            command = prefix == null ? command + "SLOT_MEDAL = true" : command + prefix + "SLOT_MEDAL = true";
        }
        if (this.criteria.slotRing) {
            if (firstSlot) {
                firstSlot = false;
                command = command + " AND ( ";
            } else {
                command = command + " OR ";
            }
            command = prefix == null ? command + "SLOT_RING = true" : command + prefix + "SLOT_RING = true";
        }
        if (this.criteria.slotHead) {
            if (firstSlot) {
                firstSlot = false;
                command = command + " AND ( ";
            } else {
                command = command + " OR ";
            }
            command = prefix == null ? command + "SLOT_HEAD = true" : command + prefix + "SLOT_HEAD = true";
        }
        if (this.criteria.slotShoulders) {
            if (firstSlot) {
                firstSlot = false;
                command = command + " AND ( ";
            } else {
                command = command + " OR ";
            }
            command = prefix == null ? command + "SLOT_SHOULDERS = true" : command + prefix + "SLOT_SHOULDERS = true";
        }
        if (this.criteria.slotChest) {
            if (firstSlot) {
                firstSlot = false;
                command = command + " AND ( ";
            } else {
                command = command + " OR ";
            }
            command = prefix == null ? command + "SLOT_CHEST = true" : command + prefix + "SLOT_CHEST = true";
        }
        if (this.criteria.slotHands) {
            if (firstSlot) {
                firstSlot = false;
                command = command + " AND ( ";
            } else {
                command = command + " OR ";
            }
            command = prefix == null ? command + "SLOT_HANDS = true" : command + prefix + "SLOT_HANDS = true";
        }
        if (this.criteria.slotLegs) {
            if (firstSlot) {
                firstSlot = false;
                command = command + " AND ( ";
            } else {
                command = command + " OR ";
            }
            command = prefix == null ? command + "SLOT_LEGS = true" : command + prefix + "SLOT_LEGS = true";
        }
        if (this.criteria.slotFeet) {
            if (firstSlot) {
                firstSlot = false;
                command = command + " AND ( ";
            } else {
                command = command + " OR ";
            }
            command = prefix == null ? command + "SLOT_FEET = true" : command + prefix + "SLOT_FEET = true";
        }
        if (!firstSlot) {
            command = command + " )";
        }
        return command;
    }

    public String determineAttributeConditions(String prefix) {
        String command = "";
        if (!this.criteria.statFlat.isUsed() && !this.criteria.statPerc.isUsed()) {
            return command;
        }
        boolean firstSlot = true;
        if (this.criteria.statFlat.cunning) {
            if (firstSlot) {
                firstSlot = false;
                command = command + " AND ( ";
            } else {
                command = command + " OR ";
            }
            command = prefix == null ? command + "CUNNING > 0" : command + prefix + "CUNNING > 0";
        }
        if (this.criteria.statPerc.cunning) {
            if (firstSlot) {
                firstSlot = false;
                command = command + " AND ( ";
            } else {
                command = command + " OR ";
            }
            command = prefix == null ? command + "CUNNING_PERC > 0" : command + prefix + "CUNNING_PERC > 0";
        }
        if (this.criteria.statFlat.physique) {
            if (firstSlot) {
                firstSlot = false;
                command = command + " AND ( ";
            } else {
                command = command + " OR ";
            }
            command = prefix == null ? command + "PHYSIQUE > 0" : command + prefix + "PHYSIQUE > 0";
        }
        if (this.criteria.statPerc.physique) {
            if (firstSlot) {
                firstSlot = false;
                command = command + " AND ( ";
            } else {
                command = command + " OR ";
            }
            command = prefix == null ? command + "PHYSIQUE_PERC > 0" : command + prefix + "PHYSIQUE_PERC > 0";
        }
        if (this.criteria.statFlat.spirit) {
            if (firstSlot) {
                firstSlot = false;
                command = command + " AND ( ";
            } else {
                command = command + " OR ";
            }
            command = prefix == null ? command + "SPIRIT > 0" : command + prefix + "SPIRIT > 0";
        }
        if (this.criteria.statPerc.spirit) {
            if (firstSlot) {
                firstSlot = false;
                command = command + " AND ( ";
            } else {
                command = command + " OR ";
            }
            command = prefix == null ? command + "SPIRIT_PERC > 0" : command + prefix + "SPIRIT_PERC > 0";
        }
        if (this.criteria.statFlat.defense) {
            if (firstSlot) {
                firstSlot = false;
                command = command + " AND ( ";
            } else {
                command = command + " OR ";
            }
            command = prefix == null ? command + "DEFENSE > 0" : command + prefix + "DEFENSE > 0";
        }
        if (this.criteria.statPerc.defense) {
            if (firstSlot) {
                firstSlot = false;
                command = command + " AND ( ";
            } else {
                command = command + " OR ";
            }
            command = prefix == null ? command + "DEFENSE_PERC > 0" : command + prefix + "DEFENSE_PERC > 0";
        }
        if (this.criteria.statFlat.offense) {
            if (firstSlot) {
                firstSlot = false;
                command = command + " AND ( ";
            } else {
                command = command + " OR ";
            }
            command = prefix == null ? command + "OFFENSE > 0" : command + prefix + "OFFENSE > 0";
        }
        if (this.criteria.statPerc.offense) {
            if (firstSlot) {
                firstSlot = false;
                command = command + " AND ( ";
            } else {
                command = command + " OR ";
            }
            command = prefix == null ? command + "OFFENSE_PERC > 0" : command + prefix + "OFFENSE_PERC > 0";
        }
        if (this.criteria.statFlat.health) {
            if (firstSlot) {
                firstSlot = false;
                command = command + " AND ( ";
            } else {
                command = command + " OR ";
            }
            command = prefix == null ? command + "HEALTH > 0" : command + prefix + "HEALTH > 0";
        }
        if (this.criteria.statPerc.health) {
            if (firstSlot) {
                firstSlot = false;
                command = command + " AND ( ";
            } else {
                command = command + " OR ";
            }
            command = prefix == null ? command + "HEALTH_PERC > 0" : command + prefix + "HEALTH_PERC > 0";
        }
        if (this.criteria.statFlat.healthRegen) {
            if (firstSlot) {
                firstSlot = false;
                command = command + " AND ( ";
            } else {
                command = command + " OR ";
            }
            command = prefix == null ? command + "HEALTHREGEN > 0" : command + prefix + "HEALTHREGEN > 0";
        }
        if (this.criteria.statPerc.healthRegen) {
            if (firstSlot) {
                firstSlot = false;
                command = command + " AND ( ";
            } else {
                command = command + " OR ";
            }
            command = prefix == null ? command + "HEALTHREGEN_PERC > 0" : command + prefix + "HEALTHREGEN_PERC > 0";
        }
        if (this.criteria.statFlat.energyRegen) {
            if (firstSlot) {
                firstSlot = false;
                command = command + " AND ( ";
            } else {
                command = command + " OR ";
            }
            command = prefix == null ? command + "MANAREGEN > 0" : command + prefix + "MANAREGEN > 0";
        }
        if (this.criteria.statPerc.energyRegen) {
            if (firstSlot) {
                firstSlot = false;
                command = command + " AND ( ";
            } else {
                command = command + " OR ";
            }
            command = prefix == null ? command + "MANAREGEN_PERC > 0" : command + prefix + "MANAREGEN_PERC > 0";
        }
        if (this.criteria.statPerc.attackSpeed) {
            if (firstSlot) {
                firstSlot = false;
                command = command + " AND ( ";
            } else {
                command = command + " OR ";
            }
            command = prefix == null ? command + "ATTACKSPEED > 0 OR ATTACKSPEED_PERC > 0" : command + prefix + "ATTACKSPEED > 0 OR ATTACKSPEED_PERC > 0";
        }
        if (this.criteria.statPerc.castSpeed) {
            if (firstSlot) {
                firstSlot = false;
                command = command + " AND ( ";
            } else {
                command = command + " OR ";
            }
            command = prefix == null ? command + "CASTSPEED_PERC > 0" : command + prefix + "CASTSPEED_PERC > 0";
        }
        if (this.criteria.statPerc.runSpeed) {
            if (firstSlot) {
                firstSlot = false;
                command = command + " AND ( ";
            } else {
                command = command + " OR ";
            }
            command = prefix == null ? command + "RUNSPEED_PERC > 0" : command + prefix + "RUNSPEED_PERC > 0";
        }
        if (this.criteria.statPerc.totalSpeed) {
            if (firstSlot) {
                firstSlot = false;
                command = command + " AND ( ";
            } else {
                command = command + " OR ";
            }
            command = prefix == null ? command + "TOTALSPEED_PERC > 0" : command + prefix + "TOTALSPEED_PERC > 0";
        }
        if (this.criteria.statPerc.cooldown) {
            if (firstSlot) {
                firstSlot = false;
                command = command + " AND ( ";
            } else {
                command = command + " OR ";
            }
            command = prefix == null ? command + "COOLDOWN_RED > 0 OR COOLDOWN_RED_PERC > 0" : command + prefix + "COOLDOWN_RED > 0 OR COOLDOWN_RED_PERC > 0";
        }
        if (this.criteria.statPerc.shieldRecovery) {
            if (firstSlot) {
                firstSlot = false;
                command = command + " AND ( ";
            } else {
                command = command + " OR ";
            }
            command = prefix == null ? command + "SHIELD_REC_RED_PERC > 0" : command + prefix + "SHIELD_REC_RED_PERC > 0";
        }
        if (!firstSlot) {
            command = command + " )";
        }
        return command;
    }

    public static List<String> createDamageIDCombinations(SelectionCriteria criteria) {
        LinkedList<String> list = new LinkedList<String>();
        for (Integer iClass : criteria.dmgClass) {
            int dmgClass = iClass;
            for (Integer iType : criteria.dmgType) {
                int dmgType = iType;
                if (dmgType == 101) {
                    if (dmgClass == 1) {
                        list.add("defensivePoison");
                    }
                    if (dmgClass == 2) {
                        list.add("offensiveBasePoison");
                        list.add("offensivePoison");
                    }
                    if (dmgClass == 3) {
                        list.add("retaliationPoison");
                    }
                }
                if (dmgType == 102) {
                    if (dmgClass == 1) {
                        list.add("defensiveAether");
                    }
                    if (dmgClass == 2) {
                        list.add("offensiveBaseAether");
                        list.add("offensiveAether");
                    }
                    if (dmgClass == 3) {
                        list.add("retaliationAether");
                    }
                }
                if (dmgType == 103) {
                    if (dmgClass == 1) {
                        list.add("defensiveChaos");
                    }
                    if (dmgClass == 2) {
                        list.add("offensiveBaseChaos");
                        list.add("offensiveChaos");
                    }
                    if (dmgClass == 3) {
                        list.add("retaliationChaos");
                    }
                }
                if (dmgType == 104) {
                    if (dmgClass == 1) {
                        list.add("defensiveCold");
                    }
                    if (dmgClass == 2) {
                        list.add("offensiveBaseCold");
                        list.add("offensiveCold");
                    }
                    if (dmgClass == 3) {
                        list.add("retaliationCold");
                    }
                }
                if (dmgType == 105) {
                    if (dmgClass == 1) {
                        list.add("defensiveElemental");
                        list.add("defensiveElementalResistance");
                    }
                    if (dmgClass == 2) {
                        list.add("offensiveElemental");
                    }
                    if (dmgClass == 3) {
                        list.add("retaliationElemental");
                    }
                }
                if (dmgType == 106) {
                    if (dmgClass == 1) {
                        list.add("defensiveFire");
                    }
                    if (dmgClass == 2) {
                        list.add("offensiveBaseFire");
                        list.add("offensiveFire");
                    }
                    if (dmgClass == 3) {
                        list.add("retaliationFire");
                    }
                }
                if (dmgType == 107) {
                    if (dmgClass == 1) {
                        list.add("defensiveLife");
                    }
                    if (dmgClass == 2) {
                        list.add("offensiveBaseLife");
                        list.add("offensiveLife");
                    }
                    if (dmgClass == 3) {
                        list.add("retaliationLife");
                    }
                }
                if (dmgType == 108) {
                    if (dmgClass == 1) {
                        list.add("defensiveLightning");
                    }
                    if (dmgClass == 2) {
                        list.add("offensiveBaseLightning");
                        list.add("offensiveLightning");
                    }
                    if (dmgClass == 3) {
                        list.add("retaliationLightning");
                    }
                }
                if (dmgType == 109) {
                    if (dmgClass == 1) {
                        list.add("defensivePhysical");
                    }
                    if (dmgClass == 2) {
                        list.add("offensivePhysical");
                        list.add("offensiveBonusPhysical");
                    }
                    if (dmgClass == 3) {
                        list.add("retaliationPhysical");
                    }
                }
                if (dmgType == 110) {
                    if (dmgClass == 1) {
                        list.add("defensivePierce");
                    }
                    if (dmgClass == 2) {
                        list.add("offensivePierce");
                    }
                    if (dmgClass == 3) {
                        list.add("retaliationPierce");
                    }
                }
                if (dmgType == 201) {
                    if (dmgClass == 2) {
                        list.add("offensiveSlowPoison");
                    }
                    if (dmgClass == 3) {
                        list.add("retaliationSlowPoison");
                    }
                }
                if (dmgType == 204) {
                    if (dmgClass == 2) {
                        list.add("offensiveSlowCold");
                    }
                    if (dmgClass == 3) {
                        list.add("retaliationSlowCold");
                    }
                }
                if (dmgType == 206) {
                    if (dmgClass == 2) {
                        list.add("offensiveSlowFire");
                    }
                    if (dmgClass == 3) {
                        list.add("retaliationSlowFire");
                    }
                }
                if (dmgType == 207) {
                    if (dmgClass == 2) {
                        list.add("offensiveSlowLife");
                    }
                    if (dmgClass == 3) {
                        list.add("retaliationSlowLife");
                    }
                }
                if (dmgType == 208) {
                    if (dmgClass == 2) {
                        list.add("offensiveSlowLightning");
                    }
                    if (dmgClass == 3) {
                        list.add("retaliationSlowLightning");
                    }
                }
                if (dmgType == 209) {
                    if (dmgClass == 2) {
                        list.add("offensiveSlowPhysical");
                    }
                    if (dmgClass == 3) {
                        list.add("retaliationSlowPhysical");
                    }
                }
                if (dmgType == 210) {
                    if (dmgClass == 1) {
                        list.add("defensiveBleeding");
                    }
                    if (dmgClass == 2) {
                        list.add("offensiveSlowBleeding");
                    }
                    if (dmgClass == 3) {
                        list.add("retaliationSlowBleeding");
                    }
                }
                if (dmgType == 301) {
                    if (dmgClass == 2) {
                        list.add("offensiveTotalDamage");
                    }
                    if (dmgClass == 3) {
                        list.add("retaliationTotalDamage");
                    }
                }
                if (dmgType == 302 && dmgClass == 2) {
                    list.add("offensiveCritDamage");
                }
                if (dmgType == 303 && dmgClass == 2) {
                    list.add("offensiveLifeLeech");
                }
                if (dmgType == 304 && dmgClass == 1) {
                    list.add("defensiveReflect");
                }
                if (dmgType == 305) {
                    if (dmgClass == 2) {
                        list.add("offensiveSlowAttackSpeed");
                    }
                    if (dmgClass == 3) {
                        list.add("retaliationSlowAttackSpeed");
                    }
                }
                if (dmgType == 306 && dmgClass == 2) {
                    list.add("offensiveSlowTotalSpeed");
                }
                if (dmgType == 307) {
                    if (dmgClass == 2) {
                        list.add("offensiveSlowDefensiveAbility");
                    }
                    if (dmgClass == 3) {
                        list.add("retaliationSlowDefensiveAbility");
                    }
                }
                if (dmgType != 308) continue;
                if (dmgClass == 2) {
                    list.add("offensiveSlowOffensiveAbility");
                }
                if (dmgClass != 3) continue;
                list.add("retaliationSlowOffensiveAbility");
            }
        }
        return list;
    }

    @Override
    public void setItemClass(String itemClass) {
        this.itemClass = itemClass;
        if (itemClass != null && itemClass.isEmpty()) {
            this.itemClass = null;
        }
        this.init();
    }

    @Override
    public void setArmorClass(String armorClass) {
        this.armorClass = armorClass;
        if (armorClass != null && armorClass.isEmpty()) {
            this.armorClass = null;
        }
    }

    @Override
    public void setArtifactClass(String artifactClass) {
        this.artifactClass = artifactClass;
        if (artifactClass != null && artifactClass.isEmpty()) {
            this.artifactClass = null;
        }
    }

    @Override
    public void setItemRarity(String itemRarity) {
        this.itemRarity = itemRarity;
        if (itemRarity != null && itemRarity.isEmpty()) {
            this.itemRarity = null;
        }
    }

    @Override
    public void setItemName(String itemName) {
        this.itemName = itemName;
        if (itemName != null && itemName.isEmpty()) {
            this.itemName = null;
        }
    }

    @Override
    public String determineStatement(boolean isHardcore, String charName) {
        String command = "SELECT I.ITEM_ID FROM GD_ITEM I";
        boolean charFilled = this.getCriteria().statFlat.isUsed() || this.getCriteria().statPerc.isUsed();
        command = charFilled ? command + ", " + "GD_ITEM_CHAR" + " C WHERE I.ITEM_ID = C.ITEM_ID AND " : command + " WHERE ";
        command = command + "I.ITEM_CLASS = ?";
        if (this.usesItemRarity()) {
            command = command + " AND I.RARITY = ?";
        }
        if (this.usesArmorClass()) {
            command = command + " AND I.ARMOR_CLASS = ?";
        }
        if (this.usesArtifactClass()) {
            command = command + " AND I.ARTIFACT_CLASS = ?";
        }
        if (this.usesItemName()) {
            command = command + " AND UPPER(I.NAME_FULL) LIKE ?";
        }
        if (this.getMinLevel() != -1) {
            command = command + " AND I.REQ_LEVEL >= ?";
        }
        if (this.getMaxLevel() != -1) {
            command = command + " AND I.REQ_LEVEL <= ?";
        }
        if (this.getMaxCunning() != -1) {
            command = command + " AND I.REQ_DEX <= ?";
        }
        if (this.getMaxPhysique() != -1) {
            command = command + " AND I.REQ_STR <= ?";
        }
        if (this.getMaxSpirit() != -1) {
            command = command + " AND I.REQ_INT <= ?";
        }
        if (this.usesPetBonus()) {
            command = command + " AND I.PET_BONUS_SKILL_ID IS NOT NULL";
        }
        if (this.isNoEnemyOnly()) {
            command = command + " AND I.ENEMY_ONLY = ?";
        }
        command = command + this.determineSlotConditions("I.");
        if (charFilled) {
            command = command + this.determineAttributeConditions("C.");
        }
        return command;
    }

    @Override
    public List<CriteriaCombination> createLevel1Combinations(CriteriaCombination cc) {
        CriteriaCombination combo = cc.clone();
        LinkedList<CriteriaCombination> list = new LinkedList<CriteriaCombination>();
        Iterator<String> iterIC = this.getCriteria().itemClass.iterator();
        while (iterIC.hasNext()) {
            Iterator<String> iterAC;
            combo.setItemClass(iterIC.next());
            boolean found = false;
            if (combo.usesItemRarity()) {
                Iterator<String> iterIR = this.getItemRarities().iterator();
                while (iterIR.hasNext()) {
                    combo.setItemRarity(iterIR.next());
                    if (combo.usesArmorClass()) {
                        Iterator<String> iterAC2 = this.getArmorClasses().iterator();
                        while (iterAC2.hasNext()) {
                            combo.setArmorClass(iterAC2.next());
                            list.add(combo.clone());
                        }
                        found = true;
                    }
                    if (found) continue;
                    list.add(combo.clone());
                }
                continue;
            }
            if (combo.usesArmorClass()) {
                iterAC = this.getArmorClasses().iterator();
                while (iterAC.hasNext()) {
                    combo.setArmorClass(iterAC.next());
                    list.add(combo.clone());
                }
                found = true;
            }
            if (combo.usesArtifactClass()) {
                iterAC = this.getArtifactClasses().iterator();
                while (iterAC.hasNext()) {
                    combo.setArtifactClass(iterAC.next());
                    list.add(combo.clone());
                }
                found = true;
            }
            if (found) continue;
            list.add(combo.clone());
        }
        return list;
    }

    @Override
    public int fillLevel1Statement(PreparedStatement ps) throws SQLException {
        ps.clearParameters();
        int nextPos = 1;
        ps.setString(nextPos, this.getItemClass());
        ++nextPos;
        if (this.usesItemRarity()) {
            ps.setString(nextPos, this.getItemRarity());
            ++nextPos;
        }
        if (this.usesArmorClass()) {
            ps.setString(nextPos, this.getArmorClass());
            ++nextPos;
        }
        if (this.usesArtifactClass()) {
            ps.setString(nextPos, this.getArtifactClass());
            ++nextPos;
        }
        if (this.usesItemName()) {
            ps.setString(nextPos, this.getItemName().toUpperCase(GDMsgFormatter.locale));
            ++nextPos;
        }
        if (this.getMinLevel() != -1) {
            ps.setInt(nextPos, this.getMinLevel());
            ++nextPos;
        }
        if (this.getMaxLevel() != -1) {
            ps.setInt(nextPos, this.getMaxLevel());
            ++nextPos;
        }
        if (this.getMaxCunning() != -1) {
            ps.setInt(nextPos, this.getMaxCunning());
            ++nextPos;
        }
        if (this.getMaxPhysique() != -1) {
            ps.setInt(nextPos, this.getMaxPhysique());
            ++nextPos;
        }
        if (this.getMaxSpirit() != -1) {
            ps.setInt(nextPos, this.getMaxSpirit());
            ++nextPos;
        }
        if (this.isNoEnemyOnly()) {
            ps.setBoolean(nextPos, false);
            ++nextPos;
        }
        return nextPos;
    }

    @Override
    public List<CriteriaCombinationLevel2> getLevel2Combinations() {
        return null;
    }

    @Override
    public String determineLevel1Parameters() {
        String param = this.getItemClass();
        if (this.usesItemRarity()) {
            param = param + ", " + this.getItemRarity();
        }
        if (this.usesArmorClass()) {
            param = param + ", " + this.getArmorClass();
        }
        if (this.usesArtifactClass()) {
            param = param + ", " + this.getArtifactClass();
        }
        if (this.usesItemName()) {
            param = param + ", " + this.getItemName();
        }
        if (this.getMinLevel() != -1) {
            param = param + ", " + Integer.toString(this.getMinLevel());
        }
        if (this.getMaxLevel() != -1) {
            param = param + ", " + Integer.toString(this.getMaxLevel());
        }
        if (this.getMaxCunning() != -1) {
            param = param + ", " + Integer.toString(this.getMaxCunning());
        }
        if (this.getMaxPhysique() != -1) {
            param = param + ", " + Integer.toString(this.getMaxPhysique());
        }
        if (this.getMaxSpirit() != -1) {
            param = param + ", " + Integer.toString(this.getMaxSpirit());
        }
        if (this.isNoEnemyOnly()) {
            param = param + "false";
        }
        return param;
    }

    @Override
    public void addSingleIntCombo(List<Integer> listAll, PreparedStatement ps, String command) throws SQLException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addSingleStringCombo(List<String> listAll, PreparedStatement ps, String command) throws SQLException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public static void mergeStringList(List<String> listAll, List<String> list) {
        for (String s : list) {
            if (listAll.contains(s)) continue;
            listAll.add(s);
        }
    }
}

