/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.db.criteria;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import org.gdstash.db.SelectionCriteria;
import org.gdstash.db.criteria.AbstractItemCombination;
import org.gdstash.db.criteria.CriteriaCombinationLevel2;

public class AbstractItemDamageCombination
extends AbstractItemCombination {
    private List<CriteriaCombinationLevel2> damageTypes;

    public AbstractItemDamageCombination() {
        this.damageTypes = null;
    }

    public AbstractItemDamageCombination(AbstractItemDamageCombination combo) {
        super(combo);
        this.damageTypes = combo.damageTypes;
    }

    public AbstractItemDamageCombination(SelectionCriteria criteria) {
        super(criteria);
        this.createLevel2();
    }

    @Override
    public AbstractItemDamageCombination clone() {
        AbstractItemDamageCombination combo = new AbstractItemDamageCombination(this);
        return combo;
    }

    private void createLevel2() {
        List<String> list = AbstractItemCombination.createDamageIDCombinations(this.getCriteria());
        if (list != null) {
            this.damageTypes = new LinkedList<CriteriaCombinationLevel2>();
            for (String s : list) {
                Level2Combination l2 = new Level2Combination(this, s);
                this.damageTypes.add(l2);
            }
        }
    }

    @Override
    public String determineStatement(boolean isHardcore, String charName) {
        boolean damageFilled;
        boolean charFilled;
        String command = "SELECT I.ITEM_ID FROM GD_ITEM I";
        boolean bl = charFilled = this.getCriteria().statFlat.isUsed() || this.getCriteria().statPerc.isUsed();
        if (charFilled) {
            command = command + ", " + "GD_ITEM_CHAR" + " C";
        }
        boolean bl2 = damageFilled = !this.getCriteria().dmgClass.isEmpty() && !this.getCriteria().dmgType.isEmpty();
        if (damageFilled) {
            command = command + ", " + "GD_ITEM_DAMAGE" + " D";
        }
        command = command + " WHERE ";
        if (charFilled) {
            command = command + "I.ITEM_ID = C.ITEM_ID AND ";
        }
        if (damageFilled) {
            command = command + "I.ITEM_ID = D.ITEM_ID AND ";
        }
        command = command + "I.ITEM_CLASS = ?";
        if (this.usesItemRarity()) {
            command = command + " AND I.RARITY = ?";
        }
        if (this.usesArmorClass()) {
            command = command + " AND I.ARMOR_CLASS = ?";
        }
        if (this.usesArtifactClass()) {
            command = command + " AND I.ARTIFACT_CLASS = ?";
        }
        if (this.usesItemName()) {
            command = command + " AND UPPER(I.NAME_FULL) LIKE ?";
        }
        if (this.getMinLevel() != -1) {
            command = command + " AND I.REQ_LEVEL >= ?";
        }
        if (this.getMaxLevel() != -1) {
            command = command + " AND I.REQ_LEVEL <= ?";
        }
        if (this.getMaxCunning() != -1) {
            command = command + " AND I.REQ_DEX <= ?";
        }
        if (this.getMaxPhysique() != -1) {
            command = command + " AND I.REQ_STR <= ?";
        }
        if (this.getMaxSpirit() != -1) {
            command = command + " AND I.REQ_INT <= ?";
        }
        if (this.usesPetBonus()) {
            command = command + " AND I.PET_BONUS_SKILL_ID IS NOT NULL";
        }
        if (this.isNoEnemyOnly()) {
            command = command + " AND I.ENEMY_ONLY = ?";
        }
        command = command + this.determineSlotConditions("I.");
        if (charFilled) {
            command = command + this.determineAttributeConditions("C.");
        }
        if (damageFilled) {
            command = command + " AND (D.DAMAGE_TYPE = ?";
            if (this.getCriteria().dmgFlat == this.getCriteria().dmgPercentage) {
                command = command + " AND ((D.DAMAGE_MIN > 0) OR (D.MODIFIER > 0)))";
            } else {
                if (this.getCriteria().dmgFlat) {
                    command = command + " AND D.DAMAGE_MIN > 0)";
                }
                if (this.getCriteria().dmgPercentage) {
                    command = command + " AND D.MODIFIER > 0)";
                }
            }
        }
        return command;
    }

    @Override
    public List<CriteriaCombinationLevel2> getLevel2Combinations() {
        return this.damageTypes;
    }

    public static class Level2Combination
    implements CriteriaCombinationLevel2 {
        private AbstractItemDamageCombination combo;
        private String damageID;

        public Level2Combination(AbstractItemDamageCombination combo, String damageID) {
            this.combo = combo;
            this.damageID = damageID;
        }

        @Override
        public void fillLevel2Statement(PreparedStatement ps, int nextPos) throws SQLException {
            ps.setString(nextPos, this.damageID);
        }

        @Override
        public String determineLevel2Parameters() {
            String s = this.combo.determineLevel1Parameters();
            s = s + ", " + this.damageID;
            return s;
        }
    }
}

