/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.db.criteria;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.gdstash.db.SelectionCriteria;
import org.gdstash.db.criteria.AbstractItemCombination;
import org.gdstash.db.criteria.AbstractItemDamageCombination;
import org.gdstash.db.criteria.CriteriaCombinationLevel2;
import org.gdstash.ui.GDStashFrame;
import org.gdstash.util.GDMsgFormatter;
import org.gdstash.util.GDMsgLogger;

public class AbstractStashDamageCombination
extends AbstractItemDamageCombination {
    public AbstractStashDamageCombination() {
    }

    public AbstractStashDamageCombination(AbstractItemDamageCombination combo) {
        super(combo);
    }

    public AbstractStashDamageCombination(SelectionCriteria criteria) {
        super(criteria);
    }

    @Override
    public AbstractStashDamageCombination clone() {
        AbstractStashDamageCombination combo = new AbstractStashDamageCombination(this);
        return combo;
    }

    @Override
    public String determineStatement(boolean isHardcore, String charName) {
        boolean damageFilled;
        boolean charFilled;
        String command = "SELECT S.STASH_ID FROM STASH_ITEM_V4 S";
        boolean bl = charFilled = this.getCriteria().statFlat.isUsed() || this.getCriteria().statPerc.isUsed();
        if (charFilled) {
            command = command + ", " + "GD_ITEM_CHAR" + " C";
        }
        boolean bl2 = damageFilled = !this.getCriteria().dmgClass.isEmpty() && !this.getCriteria().dmgType.isEmpty();
        if (damageFilled) {
            command = command + ", " + "GD_ITEM_DAMAGE" + " D";
        }
        command = command + " WHERE ";
        if (charFilled) {
            command = command + "S.ITEM_ID = C.ITEM_ID AND ";
        }
        if (damageFilled) {
            command = command + "S.ITEM_ID = D.ITEM_ID AND ";
        }
        command = command + "S.ITEM_CLASS = ?";
        if (!GDStashFrame.iniConfig.sectRestrict.transferSCHC) {
            command = isHardcore ? command + " AND S.HARDCORE = true" : command + " AND S.HARDCORE = false";
        }
        if (!GDStashFrame.iniConfig.sectRestrict.transferSoulbound && charName != null) {
            command = command + " AND ( S.CHARNAME = '" + charName + "' OR S.CHARNAME = '' )";
        }
        if (this.usesItemRarity()) {
            command = command + " AND S.RARITY = ?";
        }
        if (this.usesArmorClass()) {
            command = command + " AND S.ARMOR_CLASS = ?";
        }
        if (this.usesArtifactClass()) {
            command = command + " AND S.ARTIFACT_CLASS = ?";
        }
        if (this.usesItemName()) {
            command = command + " AND S.NAME LIKE ?";
        }
        if (this.getMinLevel() != -1) {
            command = command + " AND S.REQ_LEVEL >= ?";
        }
        if (this.getMaxLevel() != -1) {
            command = command + " AND S.REQ_LEVEL <= ?";
        }
        if (this.getMaxCunning() != -1) {
            command = command + " AND S.REQ_DEX <= ?";
        }
        if (this.getMaxPhysique() != -1) {
            command = command + " AND S.REQ_STR <= ?";
        }
        if (this.getMaxSpirit() != -1) {
            command = command + " AND S.REQ_INT <= ?";
        }
        if (this.usesPetBonus()) {
            command = command + " AND S.PET_BONUS_SKILL_ID IS NOT NULL";
        }
        if (this.isNoEnemyOnly()) {
            command = command + " AND S.ENEMY_ONLY = ?";
        }
        command = command + this.determineSlotConditions("S.");
        if (charFilled) {
            command = command + this.determineAttributeConditions("C.");
        }
        if (damageFilled) {
            command = command + " AND (D.DAMAGE_TYPE = ?";
            if (this.getCriteria().dmgFlat == this.getCriteria().dmgPercentage) {
                command = command + " AND ((D.DAMAGE_MIN > 0) OR (D.MODIFIER > 0)))";
            } else {
                if (this.getCriteria().dmgFlat) {
                    command = command + " AND D.DAMAGE_MIN > 0)";
                }
                if (this.getCriteria().dmgPercentage) {
                    command = command + " AND D.MODIFIER > 0)";
                }
            }
        }
        return command;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void addSingleIntCombo(List<Integer> listAll, PreparedStatement ps, String command) throws SQLException, UnsupportedOperationException {
        int nextPos = this.fillLevel1Statement(ps);
        if (nextPos == -1) {
            return;
        }
        List<CriteriaCombinationLevel2> combos = this.getLevel2Combinations();
        if (combos.isEmpty()) {
            try (ResultSet rs = ps.executeQuery();){
                List<Integer> ids = AbstractItemCombination.wrapInteger(rs, 1);
                if (ids == null) return;
                listAll.addAll(ids);
                return;
            }
            catch (SQLException ex) {
                Object[] args = new Object[]{command, ""};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_SELECT_FAILED", args);
                GDMsgLogger.addError(msg);
                throw ex;
            }
        }
        for (CriteriaCombinationLevel2 combo : combos) {
            combo.fillLevel2Statement(ps, nextPos);
            try {
                ResultSet rs = ps.executeQuery();
                Throwable throwable = null;
                try {
                    List<Integer> ids = AbstractItemCombination.wrapInteger(rs, 1);
                    if (ids == null) continue;
                    listAll.addAll(ids);
                }
                catch (Throwable x2) {
                    throwable = x2;
                    throw x2;
                }
                finally {
                    if (rs == null) continue;
                    if (throwable != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    rs.close();
                }
            }
            catch (SQLException ex) {
                Object[] args = new Object[]{command, combo.determineLevel2Parameters()};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_SELECT_FAILED", args);
                GDMsgLogger.addError(msg);
                throw ex;
            }
        }
    }

    public static void mergeIntList(List<Integer> listAll, List<Integer> list) {
        for (Integer i : list) {
            if (listAll.contains(i)) continue;
            listAll.add(i);
        }
    }
}

