/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.db.criteria;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import org.gdstash.db.GDDBData;
import org.gdstash.db.SelectionCriteria;
import org.gdstash.db.criteria.AbstractItemCombination;
import org.gdstash.db.criteria.CriteriaCombination;
import org.gdstash.util.GDMsgFormatter;
import org.gdstash.util.GDMsgLogger;

public class ItemIDItemCombination
extends AbstractItemCombination {
    public ItemIDItemCombination() {
    }

    public ItemIDItemCombination(ItemIDItemCombination combo) {
        super(combo);
    }

    public ItemIDItemCombination(SelectionCriteria criteria) {
        super(criteria);
    }

    @Override
    public ItemIDItemCombination clone() {
        ItemIDItemCombination combo = new ItemIDItemCombination(this);
        return combo;
    }

    @Override
    public String determineStatement(boolean isHardcore, String charName) {
        String command = "SELECT I.ITEM_ID FROM GD_ITEM I";
        command = this.getCriteria().statFlat.isUsed() || this.getCriteria().statPerc.isUsed() ? command + ", " + "GD_ITEM_CHAR" + " C WHERE I.ITEM_ID = C.ITEM_ID AND " : command + " WHERE ";
        command = command + "I.ITEM_CLASS = ?";
        if (this.usesItemRarity()) {
            command = command + " AND I.RARITY = ?";
        }
        if (this.usesArmorClass()) {
            command = command + " AND I.ARMOR_CLASS = ?";
        }
        if (this.usesArtifactClass()) {
            command = command + " AND I.ARTIFACT_CLASS = ?";
        }
        if (this.usesItemName()) {
            command = command + " AND UPPER(I.NAME_FULL) LIKE ?";
        }
        if (this.getMinLevel() != -1) {
            command = command + " AND I.REQ_LEVEL >= ?";
        }
        if (this.getMaxLevel() != -1) {
            command = command + " AND I.REQ_LEVEL <= ?";
        }
        if (this.getMaxCunning() != -1) {
            command = command + " AND I.REQ_DEX <= ?";
        }
        if (this.getMaxPhysique() != -1) {
            command = command + " AND I.REQ_STR <= ?";
        }
        if (this.getMaxSpirit() != -1) {
            command = command + " AND I.REQ_INT <= ?";
        }
        if (this.usesPetBonus()) {
            command = command + " AND I.PET_BONUS_SKILL_ID IS NOT NULL";
        }
        if (this.isNoEnemyOnly()) {
            command = command + " AND I.ENEMY_ONLY = ?";
        }
        command = command + this.determineSlotConditions("I.");
        command = command + this.determineAttributeConditions("C.");
        return command;
    }

    @Override
    public void addSingleStringCombo(List<String> listAll, PreparedStatement ps, String command) throws SQLException, UnsupportedOperationException {
        int nextPos = this.fillLevel1Statement(ps);
        try (ResultSet rs = ps.executeQuery();){
            List<String> ids = AbstractItemCombination.wrapString(rs, 1);
            if (ids != null) {
                AbstractItemCombination.mergeStringList(listAll, ids);
            }
        }
        catch (SQLException ex) {
            Object[] args = new Object[]{command, this.determineLevel1Parameters()};
            String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_SELECT_FAILED", args);
            GDMsgLogger.addError(msg);
            throw ex;
        }
    }

    public static List<String> getItemIDs(SelectionCriteria criteria, boolean isHardcore, String charName) {
        ItemIDItemCombination combo = new ItemIDItemCombination(criteria);
        return ItemIDItemCombination.getItemIDs(combo, isHardcore, charName);
    }

    public static List<String> getItemIDs(ItemIDItemCombination combo, boolean isHardcore, String charName) {
        LinkedList<String> listAll = new LinkedList<String>();
        try (Connection conn = GDDBData.getConnection();){
            List<CriteriaCombination> combos = combo.createLevel1Combinations(combo);
            for (CriteriaCombination cc : combos) {
                String command = cc.determineStatement(isHardcore, charName);
                try (PreparedStatement ps = conn.prepareStatement(command);){
                    cc.addSingleStringCombo(listAll, ps, command);
                }
                catch (SQLException ex) {
                    Object[] args = new Object[]{command};
                    String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_PREPARE_FAILED", args);
                    GDMsgLogger.addError(msg);
                }
                conn.commit();
            }
        }
        catch (SQLException ex) {
            GDMsgLogger.addError(GDMsgFormatter.getString(GDMsgFormatter.rbMsg, "ERR_DB_CONN_FAILED"));
        }
        return listAll;
    }
}

