/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.db.criteria;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import org.gdstash.db.GDDBData;
import org.gdstash.db.SelectionCriteria;
import org.gdstash.db.criteria.AbstractItemCombination;
import org.gdstash.db.criteria.AbstractStashDamageCombination;
import org.gdstash.db.criteria.CriteriaCombination;
import org.gdstash.ui.GDStashFrame;
import org.gdstash.util.GDMsgFormatter;
import org.gdstash.util.GDMsgLogger;

public class StashIDItemCombination
extends AbstractItemCombination {
    public StashIDItemCombination() {
    }

    public StashIDItemCombination(StashIDItemCombination combo) {
        super(combo);
    }

    public StashIDItemCombination(SelectionCriteria criteria) {
        super(criteria);
    }

    @Override
    public StashIDItemCombination clone() {
        StashIDItemCombination combo = new StashIDItemCombination(this);
        return combo;
    }

    @Override
    public String determineStatement(boolean isHardcore, String charName) {
        String command = "SELECT S.STASH_ID FROM STASH_ITEM_V4 S";
        boolean charFilled = this.getCriteria().statFlat.isUsed() || this.getCriteria().statPerc.isUsed();
        command = charFilled ? command + ", " + "GD_ITEM_CHAR" + " C WHERE S.ITEM_ID = C.ITEM_ID AND " : command + " WHERE ";
        command = command + "S.ITEM_CLASS = ?";
        if (!GDStashFrame.iniConfig.sectRestrict.transferSCHC) {
            command = isHardcore ? command + " AND S.HARDCORE = true" : command + " AND S.HARDCORE = false";
        }
        if (!GDStashFrame.iniConfig.sectRestrict.transferSoulbound && charName != null) {
            command = command + " AND ( S.CHARNAME = '" + charName + "' OR S.CHARNAME = '' )";
        }
        if (this.usesItemRarity()) {
            command = command + " AND S.RARITY = ?";
        }
        if (this.usesArmorClass()) {
            command = command + " AND S.ARMOR_CLASS = ?";
        }
        if (this.usesArtifactClass()) {
            command = command + " AND S.ARTIFACT_CLASS = ?";
        }
        if (this.usesItemName()) {
            command = command + " AND S.NAME LIKE ?";
        }
        if (this.getMinLevel() != -1) {
            command = command + " AND S.REQ_LEVEL >= ?";
        }
        if (this.getMaxLevel() != -1) {
            command = command + " AND S.REQ_LEVEL <= ?";
        }
        if (this.getMaxCunning() != -1) {
            command = command + " AND S.REQ_DEX <= ?";
        }
        if (this.getMaxPhysique() != -1) {
            command = command + " AND S.REQ_STR <= ?";
        }
        if (this.getMaxSpirit() != -1) {
            command = command + " AND S.REQ_INT <= ?";
        }
        if (this.usesPetBonus()) {
            command = command + " AND S.PET_BONUS_SKILL_ID IS NOT NULL";
        }
        if (this.isNoEnemyOnly()) {
            command = command + " AND S.ENEMY_ONLY = ?";
        }
        command = command + this.determineSlotConditions("S.");
        if (charFilled) {
            command = command + this.determineAttributeConditions("C.");
        }
        return command;
    }

    @Override
    public void addSingleIntCombo(List<Integer> listAll, PreparedStatement ps, String command) throws SQLException, UnsupportedOperationException {
        int nextPos = this.fillLevel1Statement(ps);
        try (ResultSet rs = ps.executeQuery();){
            List<Integer> ids = AbstractItemCombination.wrapInteger(rs, 1);
            if (ids != null) {
                AbstractStashDamageCombination.mergeIntList(listAll, ids);
            }
        }
        catch (SQLException ex) {
            Object[] args = new Object[]{command, this.determineLevel1Parameters()};
            String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_SELECT_FAILED", args);
            GDMsgLogger.addError(msg);
            throw ex;
        }
    }

    public static List<Integer> getStashIDs(SelectionCriteria criteria, boolean isHardcore, String charName) {
        StashIDItemCombination combo = new StashIDItemCombination(criteria);
        return StashIDItemCombination.getStashIDs(combo, isHardcore, charName);
    }

    public static List<Integer> getStashIDs(StashIDItemCombination combo, boolean isHardcore, String charName) {
        LinkedList<Integer> listAll = new LinkedList<Integer>();
        try (Connection conn = GDDBData.getConnection();){
            List<CriteriaCombination> combos = combo.createLevel1Combinations(combo);
            for (CriteriaCombination cc : combos) {
                String command = cc.determineStatement(isHardcore, charName);
                try (PreparedStatement ps = conn.prepareStatement(command);){
                    cc.addSingleIntCombo(listAll, ps, command);
                }
                catch (SQLException ex) {
                    Object[] args = new Object[]{command};
                    String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_PREPARE_FAILED", args);
                    GDMsgLogger.addError(msg);
                }
                conn.commit();
            }
        }
        catch (SQLException ex) {
            GDMsgLogger.addError(GDMsgFormatter.getString(GDMsgFormatter.rbMsg, "ERR_DB_CONN_FAILED"));
        }
        return listAll;
    }
}

