/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.db.criteria;

import java.util.List;
import org.gdstash.db.SelectionCriteria;
import org.gdstash.db.criteria.AbstractStashDamageCombination;
import org.gdstash.db.criteria.StashIDItemDamageCombination;
import org.gdstash.ui.GDStashFrame;

public class StashIDSuffixCombination
extends AbstractStashDamageCombination {
    public StashIDSuffixCombination() {
    }

    public StashIDSuffixCombination(StashIDSuffixCombination combo) {
        super(combo);
    }

    public StashIDSuffixCombination(SelectionCriteria criteria) {
        super(criteria);
    }

    @Override
    public StashIDSuffixCombination clone() {
        StashIDSuffixCombination combo = new StashIDSuffixCombination(this);
        return combo;
    }

    @Override
    public String determineStatement(boolean isHardcore, String charName) {
        boolean damageFilled;
        boolean charFilled;
        String command = "SELECT S.STASH_ID FROM STASH_ITEM_V4 S, GD_AFFIX A";
        boolean bl = charFilled = this.getCriteria().statFlat.isUsed() || this.getCriteria().statPerc.isUsed();
        if (charFilled) {
            command = command + ", " + "GD_AFFIX_CHAR" + " C";
        }
        boolean bl2 = damageFilled = !this.getCriteria().dmgClass.isEmpty() && !this.getCriteria().dmgType.isEmpty();
        if (damageFilled) {
            command = command + ", " + "GD_AFFIX_DAMAGE" + " D";
        }
        command = command + " WHERE ";
        if (charFilled) {
            command = command + "A.AFFIX_ID = C.AFFIX_ID AND ";
        }
        if (damageFilled) {
            command = command + "A.AFFIX_ID = D.AFFIX_ID AND ";
        }
        command = command + "S.SUFFIX_ID = A.AFFIX_ID AND A.TYPE = 2 AND S.ITEM_CLASS = ?";
        if (!GDStashFrame.iniConfig.sectRestrict.transferSCHC) {
            command = isHardcore ? command + " AND S.HARDCORE = true" : command + " AND S.HARDCORE = false";
        }
        if (!GDStashFrame.iniConfig.sectRestrict.transferSoulbound && charName != null) {
            command = command + " AND ( S.CHARNAME = '" + charName + "' OR S.CHARNAME = '' )";
        }
        if (this.usesItemRarity()) {
            command = command + " AND S.RARITY = ?";
        }
        if (this.usesArmorClass()) {
            command = command + " AND S.ARMOR_CLASS = ?";
        }
        if (this.usesArtifactClass()) {
            command = command + " AND S.ARTIFACT_CLASS = ?";
        }
        if (this.usesItemName()) {
            command = command + " AND S.NAME LIKE ?";
        }
        if (this.getMinLevel() != -1) {
            command = command + " AND S.REQ_LEVEL >= ?";
        }
        if (this.getMaxLevel() != -1) {
            command = command + " AND S.REQ_LEVEL <= ?";
        }
        if (this.getMaxCunning() != -1) {
            command = command + " AND S.REQ_DEX <= ?";
        }
        if (this.getMaxPhysique() != -1) {
            command = command + " AND S.REQ_STR <= ?";
        }
        if (this.getMaxSpirit() != -1) {
            command = command + " AND S.REQ_INT <= ?";
        }
        if (this.usesPetBonus()) {
            command = command + " AND A.PET_AFFIX_ID IS NOT NULL";
        }
        if (this.isNoEnemyOnly()) {
            command = command + " AND S.ENEMY_ONLY = ?";
        }
        command = command + this.determineSlotConditions("S.");
        if (charFilled) {
            command = command + this.determineAttributeConditions("C.");
        }
        if (damageFilled) {
            command = command + " AND (D.DAMAGE_TYPE = ?";
            if (this.getCriteria().dmgFlat == this.getCriteria().dmgPercentage) {
                command = command + " AND ((D.DAMAGE_MIN > 0) OR (D.MODIFIER > 0)))";
            } else {
                if (this.getCriteria().dmgFlat) {
                    command = command + " AND D.DAMAGE_MIN > 0)";
                }
                if (this.getCriteria().dmgPercentage) {
                    command = command + " AND D.MODIFIER > 0)";
                }
            }
        }
        return command;
    }

    public static List<Integer> getStashIDs(SelectionCriteria criteria, boolean isHardcore, String charName) {
        StashIDSuffixCombination combo = new StashIDSuffixCombination(criteria);
        return StashIDItemDamageCombination.getStashIDs(combo, isHardcore, charName);
    }
}

