/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.description;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.gdstash.db.DBCharBonus;
import org.gdstash.db.DBDamage;
import org.gdstash.db.DBSkill;
import org.gdstash.db.DBSkillBonus;
import org.gdstash.db.DBStashItem;
import org.gdstash.description.BonusInfo;
import org.gdstash.description.TagInfo;
import org.gdstash.description.TagInfoHashMap;
import org.gdstash.util.GDMsgFormatter;
import org.gdstash.util.GDMsgLogger;

public class BonusDetail {
    public static final int TYPE_DAMAGE = 1;
    public static final int TYPE_CHARBONUS = 2;
    public static final int TYPE_SKILLBONUS = 3;
    public static final int TYPE_SKILL = 4;
    public Object entity;
    public int type;
    public List<BonusInfo> infos;

    public BonusDetail(DBStashItem item, int detailType, DBDamage damage, String prefix) {
        this.entity = damage;
        this.type = 1;
        this.infos = BonusDetail.createDamageInfos(item, detailType, damage, prefix);
    }

    public BonusDetail(DBStashItem item, int detailType, DBCharBonus charBonus, String prefix) {
        this.entity = charBonus;
        this.type = 2;
        this.infos = BonusDetail.createStatInfos(item, detailType, charBonus, prefix);
    }

    public BonusDetail(DBSkillBonus skillBonus) {
        this.entity = skillBonus;
        this.type = 3;
        this.infos = new LinkedList<BonusInfo>();
        this.createSkillBonusInfos();
    }

    public BonusDetail(DBSkill skill) {
        this.entity = skill;
        this.type = 4;
        this.infos = new LinkedList<BonusInfo>();
        this.createSkillInfos();
    }

    private void add(BonusInfo info) {
        if (info == null) {
            return;
        }
        if (info.text != null) {
            this.infos.add(info);
        }
    }

    public static List<BonusInfo> createDamageInfos(DBStashItem item, int detailType, DBDamage damage, String prefix) {
        if (damage.getDamageType() == null) {
            return null;
        }
        TagInfo info = TagInfoHashMap.getInfo(damage.getDamageType());
        if (info == null) {
            return null;
        }
        if (info.getTag() != null) {
            return BonusDetail.parseDamage(item, detailType, damage, prefix, info);
        }
        return null;
    }

    private static String buildText(String tag, List lArgs) {
        Object[] args = new Object[lArgs.size()];
        int i = 0;
        Iterator iter = lArgs.iterator();
        while (iter.hasNext()) {
            args[i] = iter.next();
            ++i;
        }
        String text = GDMsgFormatter.format(GDMsgFormatter.rbGD, tag, args);
        return text;
    }

    private static int adjustValue(DBStashItem item, int detailType, int value) {
        float f;
        int var1;
        int pieces;
        int result = value;
        if (item == null) {
            return result;
        }
        if (detailType == 1 && item.isComponent()) {
            pieces = item.getComponentPieces();
            var1 = item.getVar1();
            if (var1 == 0) {
                var1 = 1;
            }
            if (var1 < pieces) {
                f = result;
                result = (int)(f = (float)((double)(f * (float)var1 / (float)pieces) + 0.5));
                if (result < 1) {
                    result = 1;
                }
            }
        }
        if (detailType == 2 && item.getDBComponent() != null) {
            pieces = item.getComponentPieces();
            var1 = item.getVar1();
            if (var1 == 0) {
                var1 = 1;
            }
            if (var1 < pieces) {
                f = result;
                result = (int)(f = (float)((double)(f * (float)var1 / (float)pieces) + 0.5));
                if (result < 1) {
                    result = 1;
                }
            }
        }
        return result;
    }

    private static List<BonusInfo> parseDefense(DBStashItem item, int detailType, DBDamage damage, String prefix, TagInfo tagInfo) {
        LinkedList<BonusInfo> infos = new LinkedList<BonusInfo>();
        String tag = null;
        LinkedList<Object> lArgs = null;
        BonusInfo info = null;
        String dmgType = GDMsgFormatter.getString(GDMsgFormatter.rbGD, tagInfo.getTag());
        if (prefix != null) {
            Object[] args = new Object[]{prefix, dmgType};
            dmgType = GDMsgFormatter.format(GDMsgFormatter.rbGD, "TXT_STAT_PREFIX", args);
        }
        if (damage.getMinDamage() > 0) {
            lArgs = new LinkedList<Object>();
            lArgs.add(dmgType);
            if (damage.getMinDuration() == 0) {
                lArgs.add(BonusDetail.adjustValue(item, detailType, damage.getMinDamage()));
            } else {
                lArgs.add(BonusDetail.adjustValue(item, detailType, damage.getMinDamage() * damage.getMinDuration()));
            }
            info = new BonusInfo(tagInfo);
            info.prefix = prefix;
            info.dmgFlat = true;
            tag = "TXT_DEF_ABS";
            if (tagInfo.isMinAsPerc()) {
                tag = tag + "_PERC";
            }
            if (damage.getDamageChance() > 0) {
                lArgs.add(damage.getDamageChance());
                tag = tag + "_CHANCE";
                if (tagInfo.getTag().equals("DEF_BLOCK_CHANCE")) {
                    tag = "TXT_DEF_UNI_SHIELD_BLOCK";
                    lArgs.clear();
                    lArgs.add(damage.getMinDamage());
                    lArgs.add(damage.getDamageChance());
                }
                info.dmgChance = true;
            }
            info.text = BonusDetail.buildText(tag, lArgs);
            infos.add(info);
        }
        if (damage.getDamageModifier() > 0) {
            lArgs = new LinkedList();
            lArgs.add(dmgType);
            lArgs.add(BonusDetail.adjustValue(item, detailType, damage.getDamageModifier()));
            info = new BonusInfo(tagInfo);
            info.prefix = prefix;
            info.dmgPerc = true;
            tag = "TXT_DEF_PERC";
            info.text = BonusDetail.buildText(tag, lArgs);
            infos.add(info);
        }
        if (damage.getMinDuration() > 0) {
            String dotType = GDMsgFormatter.getString(GDMsgFormatter.rbGD, tagInfo.getTag() + "_DOT");
            if (prefix != null) {
                Object[] args = new Object[]{prefix, dmgType};
                dmgType = GDMsgFormatter.format(GDMsgFormatter.rbGD, "TXT_STAT_PREFIX", args);
            }
            lArgs = new LinkedList();
            lArgs.add(dotType);
            lArgs.add(damage.getMinDuration());
            info = new BonusInfo(tagInfo);
            info.prefix = prefix;
            info.dmgPerc = true;
            tag = "TXT_DEF_DUR";
            info.text = BonusDetail.buildText(tag, lArgs);
            infos.add(info);
        }
        if (damage.getMaxResist() > 0) {
            lArgs = new LinkedList();
            lArgs.add(dmgType);
            lArgs.add(damage.getMaxResist());
            info = new BonusInfo(tagInfo);
            info.prefix = prefix;
            info.dmgPerc = true;
            info.dmgMaxResist = true;
            tag = "TXT_DEF_MAX";
            info.text = BonusDetail.buildText(tag, lArgs);
            infos.add(info);
        }
        return infos;
    }

    private static List<BonusInfo> parseOffense(DBStashItem item, int detailType, DBDamage damage, String prefix, TagInfo tagInfo) {
        LinkedList<BonusInfo> infos = new LinkedList<BonusInfo>();
        String tag = null;
        LinkedList<Object> lArgs = null;
        BonusInfo info = null;
        String dmgType = GDMsgFormatter.getString(GDMsgFormatter.rbGD, tagInfo.getTag());
        if (prefix != null) {
            Object[] args = new Object[]{prefix, dmgType};
            dmgType = GDMsgFormatter.format(GDMsgFormatter.rbGD, "TXT_STAT_PREFIX", args);
        }
        if (dmgType.equals("")) {
            return infos;
        }
        if (damage.getMinDamage() > 0) {
            lArgs = new LinkedList<Object>();
            lArgs.add(dmgType);
            if (damage.getMinDuration() == 0) {
                lArgs.add(BonusDetail.adjustValue(item, detailType, damage.getMinDamage()));
            } else if (tagInfo.isMinAsPerc()) {
                lArgs.add(BonusDetail.adjustValue(item, detailType, damage.getMinDamage()));
            } else {
                lArgs.add(BonusDetail.adjustValue(item, detailType, damage.getMinDamage() * damage.getMinDuration()));
                lArgs.add(BonusDetail.adjustValue(item, detailType, damage.getMinDamage()));
            }
            info = new BonusInfo(tagInfo);
            info.prefix = prefix;
            info.dmgGlobal = damage.isGlobal();
            info.dmgXOR = damage.isXOR();
            info.dmgFlat = true;
            tag = "TXT_OFF_ABS";
            if (tagInfo.isMinAsPerc()) {
                tag = tag + "_PERC";
            }
            if (tagInfo.isMinAsDuration()) {
                tag = tag + "_TIME";
            }
            if (damage.getMaxDamage() > 0) {
                tag = tag + "_RANGE";
                if (damage.getMinDuration() == 0) {
                    lArgs.add(BonusDetail.adjustValue(item, detailType, damage.getMaxDamage()));
                } else if (tagInfo.isMinAsPerc()) {
                    lArgs.add(BonusDetail.adjustValue(item, detailType, damage.getMaxDamage()));
                } else {
                    lArgs.add(BonusDetail.adjustValue(item, detailType, damage.getMaxDamage() * damage.getMinDuration()));
                    lArgs.add(BonusDetail.adjustValue(item, detailType, damage.getMaxDamage()));
                }
            }
            if (damage.getMinDuration() > 0) {
                tag = tag + "_DUR";
                lArgs.add(damage.getMinDuration());
                info.dmgDuration = true;
            }
            if (damage.getDamageChance() > 0) {
                if (damage.isGlobal()) {
                    if (damage.isXOR()) {
                        tag = tag + "_CHANCE";
                        lArgs.add(damage.getDamageChance());
                        info.dmgChance = true;
                    }
                } else {
                    tag = tag + "_CHANCE";
                    lArgs.add(damage.getDamageChance());
                    info.dmgChance = true;
                }
            }
            info.text = BonusDetail.buildText(tag, lArgs);
            infos.add(info);
        }
        if (damage.getDamageModifier() > 0) {
            lArgs = new LinkedList();
            lArgs.add(dmgType);
            lArgs.add(BonusDetail.adjustValue(item, detailType, damage.getDamageModifier()));
            info = new BonusInfo(tagInfo);
            info.prefix = prefix;
            info.dmgGlobal = damage.isGlobal();
            info.dmgXOR = damage.isXOR();
            info.dmgPerc = true;
            tag = "TXT_OFF_PERC";
            if (damage.getDurationModifier() > 0) {
                tag = tag + "_DUR";
                lArgs.add(damage.getDurationModifier());
            }
            if (damage.getDamageModifierChance() > 0) {
                tag = tag + "_CHANCE";
                lArgs.add(damage.getDamageModifierChance());
                info.dmgChance = true;
            }
            info.text = BonusDetail.buildText(tag, lArgs);
            infos.add(info);
        }
        return infos;
    }

    private static List<BonusInfo> parseDamage(DBStashItem item, int detailType, DBDamage damage, String prefix, TagInfo tagInfo) {
        int infoType = tagInfo.getInfoType();
        switch (infoType) {
            case 1: {
                return BonusDetail.parseDefense(item, detailType, damage, prefix, tagInfo);
            }
            case 2: {
                return BonusDetail.parseOffense(item, detailType, damage, prefix, tagInfo);
            }
            case 3: {
                return BonusDetail.parseOffense(item, detailType, damage, prefix, tagInfo);
            }
        }
        return null;
    }

    public static List<BonusInfo> createStatInfos(DBStashItem item, int detailType, DBCharBonus bonus, String prefix) {
        List<BonusInfo> list;
        LinkedList<BonusInfo> infos = new LinkedList<BonusInfo>();
        BonusInfo info = null;
        if (bonus == null) {
            return infos;
        }
        if (bonus.getTotalSpeedPerc() > 0 && (info = BonusDetail.getStatInfo(item, detailType, "STAT_SPEED_TOTAL", prefix, bonus.getTotalSpeedPerc(), true)) != null) {
            infos.add(info);
        }
        if (bonus.getAttackSpeed() > 0 && (info = BonusDetail.getStatInfo(item, detailType, "STAT_SPEED_ATTACK", prefix, bonus.getAttackSpeed(), true)) != null) {
            infos.add(info);
        }
        if (bonus.getAttackSpeedPerc() > 0 && (info = BonusDetail.getStatInfo(item, detailType, "STAT_SPEED_ATTACK", prefix, bonus.getAttackSpeedPerc(), true)) != null) {
            infos.add(info);
        }
        if (bonus.getCastSpeedPerc() > 0 && (info = BonusDetail.getStatInfo(item, detailType, "STAT_SPEED_CAST", prefix, bonus.getCastSpeedPerc(), true)) != null) {
            infos.add(info);
        }
        if (bonus.getRunSpeedPerc() > 0 && (info = BonusDetail.getStatInfo(item, detailType, "STAT_SPEED_RUN", prefix, bonus.getRunSpeedPerc(), true)) != null) {
            infos.add(info);
        }
        if (bonus.getShieldRecoveryRedPerc() > 0 && (info = BonusDetail.getStatInfo(item, detailType, "STAT_SHIELD_RECOVERY_RED", prefix, bonus.getShieldRecoveryRedPerc(), true)) != null) {
            infos.add(info);
        }
        if (bonus.getCunning() > 0 && (info = BonusDetail.getStatInfo(item, detailType, "STAT_CUNNING", prefix, bonus.getCunning(), false)) != null) {
            infos.add(info);
        }
        if (bonus.getCunningPerc() > 0 && (info = BonusDetail.getStatInfo(item, detailType, "STAT_CUNNING", prefix, bonus.getCunningPerc(), true)) != null) {
            infos.add(info);
        }
        if (bonus.getPhysique() > 0 && (info = BonusDetail.getStatInfo(item, detailType, "STAT_PHYSIQUE", prefix, bonus.getPhysique(), false)) != null) {
            infos.add(info);
        }
        if (bonus.getPhysiquePerc() > 0 && (info = BonusDetail.getStatInfo(item, detailType, "STAT_PHYSIQUE", prefix, bonus.getPhysiquePerc(), true)) != null) {
            infos.add(info);
        }
        if (bonus.getSpirit() > 0 && (info = BonusDetail.getStatInfo(item, detailType, "STAT_SPIRIT", prefix, bonus.getSpirit(), false)) != null) {
            infos.add(info);
        }
        if (bonus.getSpiritPerc() > 0 && (info = BonusDetail.getStatInfo(item, detailType, "STAT_SPIRIT", prefix, bonus.getSpiritPerc(), true)) != null) {
            infos.add(info);
        }
        if (bonus.getDefense() > 0 && (info = BonusDetail.getStatInfo(item, detailType, "STAT_DEF_ABIL_SHORT", prefix, bonus.getDefense(), false)) != null) {
            infos.add(info);
        }
        if (bonus.getDefensePerc() > 0 && (info = BonusDetail.getStatInfo(item, detailType, "STAT_DEF_ABIL_SHORT", prefix, bonus.getDefensePerc(), true)) != null) {
            infos.add(info);
        }
        if (bonus.getOffense() > 0 && (info = BonusDetail.getStatInfo(item, detailType, "STAT_OFF_ABIL_SHORT", prefix, bonus.getOffense(), false)) != null) {
            infos.add(info);
        }
        if (bonus.getOffensePerc() > 0 && (info = BonusDetail.getStatInfo(item, detailType, "STAT_OFF_ABIL_SHORT", prefix, bonus.getOffensePerc(), true)) != null) {
            infos.add(info);
        }
        if (bonus.getAvoidProjectilesPerc() > 0 && (info = BonusDetail.getStatInfo(item, detailType, "STAT_AVOID_PROJECTILE", prefix, bonus.getAvoidProjectilesPerc(), true)) != null) {
            infos.add(info);
        }
        if (bonus.getAvoidMeleeAttackPerc() > 0 && (info = BonusDetail.getStatInfo(item, detailType, "STAT_AVOID_MELEE", prefix, bonus.getAvoidMeleeAttackPerc(), true)) != null) {
            infos.add(info);
        }
        if (bonus.getHealth() > 0 && (info = BonusDetail.getStatInfo(item, detailType, "STAT_HEALTH", prefix, bonus.getHealth(), false)) != null) {
            infos.add(info);
        }
        if (bonus.getHealthPerc() > 0 && (info = BonusDetail.getStatInfo(item, detailType, "STAT_HEALTH", prefix, bonus.getHealthPerc(), true)) != null) {
            infos.add(info);
        }
        if (bonus.getHealthRegen() > 0 && (info = BonusDetail.getStatInfo(item, detailType, "STAT_REGEN_HEALTH", prefix, bonus.getHealthRegen(), false)) != null) {
            infos.add(info);
        }
        if (bonus.getHealthRegenPerc() > 0 && (info = BonusDetail.getStatInfo(item, detailType, "STAT_REGEN_HEALTH", prefix, bonus.getHealthRegenPerc(), true)) != null) {
            infos.add(info);
        }
        if (bonus.getConstitutionPerc() > 0 && (info = BonusDetail.getStatInfo(item, detailType, "STAT_CONSTITUTION", prefix, bonus.getConstitutionPerc(), true)) != null) {
            infos.add(info);
        }
        if (bonus.getMana() > 0 && (info = BonusDetail.getStatInfo(item, detailType, "STAT_ENERGY", prefix, bonus.getMana(), false)) != null) {
            infos.add(info);
        }
        if (bonus.getManaPerc() > 0 && (info = BonusDetail.getStatInfo(item, detailType, "STAT_ENERGY", prefix, bonus.getManaPerc(), true)) != null) {
            infos.add(info);
        }
        if (bonus.getManaLimit() > 0 && (info = BonusDetail.getStatInfo(item, detailType, "STAT_ENERGY_LIMIT", prefix, bonus.getManaLimit(), false)) != null) {
            infos.add(info);
        }
        if (bonus.getManaLimitPerc() > 0 && (info = BonusDetail.getStatInfo(item, detailType, "STAT_ENERGY_LIMIT", prefix, bonus.getManaLimitPerc(), true)) != null) {
            infos.add(info);
        }
        if (bonus.getManaReserve() > 0 && (info = BonusDetail.getStatInfo(item, detailType, "STAT_ENERGY_RESERVE", prefix, bonus.getManaReserve(), false)) != null) {
            infos.add(info);
        }
        if (bonus.getManaReservePerc() > 0 && (info = BonusDetail.getStatInfo(item, detailType, "STAT_ENERGY_RESERVE", prefix, bonus.getManaReservePerc(), true)) != null) {
            infos.add(info);
        }
        if (bonus.getManaRegen() > 0 && (info = BonusDetail.getStatInfo(item, detailType, "STAT_REGEN_ENERGY", prefix, bonus.getManaRegen(), false)) != null) {
            infos.add(info);
        }
        if (bonus.getManaRegenPerc() > 0 && (info = BonusDetail.getStatInfo(item, detailType, "STAT_REGEN_ENERGY", prefix, bonus.getManaRegenPerc(), true)) != null) {
            infos.add(info);
        }
        if (bonus.getExperienceIncPerc() > 0 && (info = BonusDetail.getStatInfo(item, detailType, "STAT_XP_INCREASE", prefix, bonus.getExperienceIncPerc(), true)) != null) {
            infos.add(info);
        }
        if (bonus.getRequirementRedPerc() > 0 && (info = BonusDetail.getStatInfo(item, detailType, "STAT_REQ_REDUCTION", prefix, bonus.getRequirementRedPerc(), true)) != null) {
            infos.add(info);
        }
        if (bonus.getReducedArmorStrPerc() > 0 && (info = BonusDetail.getStatInfo(item, detailType, "STAT_RED_ARMOR_STR", prefix, bonus.getReducedArmorStrPerc(), true)) != null) {
            infos.add(info);
        }
        if (bonus.getReducedRangedDexPerc() > 0 && (info = BonusDetail.getStatInfo(item, detailType, "STAT_RED_RANGED_DEX", prefix, bonus.getReducedRangedDexPerc(), true)) != null) {
            infos.add(info);
        }
        if (bonus.getReducedWeaponStrPerc() > 0 && (info = BonusDetail.getStatInfo(item, detailType, "STAT_RED_WEAPON_STR", prefix, bonus.getReducedWeaponStrPerc(), true)) != null) {
            infos.add(info);
        }
        if (bonus.getReducedMeleeDexPerc() > 0 && (info = BonusDetail.getStatInfo(item, detailType, "STAT_RED_MELEE_DEX", prefix, bonus.getReducedMeleeDexPerc(), true)) != null) {
            infos.add(info);
        }
        if (bonus.getReducedMeleeStrPerc() > 0 && (info = BonusDetail.getStatInfo(item, detailType, "STAT_RED_MELEE_STR", prefix, bonus.getReducedMeleeStrPerc(), true)) != null) {
            infos.add(info);
        }
        if (bonus.getCooldownRed() > 0 && (info = BonusDetail.getStatInfo(item, detailType, "STAT_COOLDOWN_REDUCTION", prefix, bonus.getCooldownRed(), true)) != null) {
            infos.add(info);
        }
        if (bonus.getCooldownRedPerc() > 0 && (info = BonusDetail.getStatInfo(item, detailType, "STAT_COOLDOWN_REDUCTION", prefix, bonus.getCooldownRedPerc(), true)) != null) {
            infos.add(info);
        }
        if (bonus.getManaCostRed() > 0 && (info = BonusDetail.getStatInfo(item, detailType, "STAT_MANACOST_REDUCTION", prefix, bonus.getManaCostRed(), false)) != null) {
            infos.add(info);
        }
        if (bonus.getManaCostRedPerc() > 0 && (info = BonusDetail.getStatInfo(item, detailType, "STAT_MANACOST_REDUCTION", prefix, bonus.getManaCostRedPerc(), true)) != null) {
            infos.add(info);
        }
        if (bonus.getEnergyAbsorbPerc() > 0 && (info = BonusDetail.getStatInfo(item, detailType, "STAT_ENERGY_ABSORB", prefix, bonus.getEnergyAbsorbPerc(), true)) != null) {
            infos.add(info);
        }
        if (bonus.getLightRadius() > 0 && (info = BonusDetail.getStatInfo(item, detailType, "STAT_LIGHT_RADIUS", prefix, bonus.getLightRadius(), false)) != null) {
            infos.add(info);
        }
        if (!bonus.getRaceBonusList().isEmpty() && (list = BonusDetail.getRaceBonusInfo("TXT_UNI_RACE_DAMAGE", prefix, bonus.getRaceBonusList())) != null) {
            infos.addAll(list);
        }
        return infos;
    }

    private static BonusInfo getStatInfo(DBStashItem item, int detailType, String statType, String prefix, int value, boolean isPercent) {
        Object[] args;
        TagInfo tagInfo = TagInfoHashMap.getInfo(statType);
        if (tagInfo == null) {
            return null;
        }
        BonusInfo info = new BonusInfo(tagInfo);
        String tag = null;
        tag = isPercent ? "TXT_PERC" : "TXT_ABS";
        String stat = GDMsgFormatter.getString(GDMsgFormatter.rbGD, statType);
        if (prefix != null) {
            args = new Object[]{prefix, stat};
            stat = GDMsgFormatter.format(GDMsgFormatter.rbGD, "TXT_STAT_PREFIX", args);
        }
        args = new Object[]{stat, BonusDetail.adjustValue(item, detailType, value)};
        try {
            info.text = GDMsgFormatter.format(GDMsgFormatter.rbGD, tag, args);
            info.tag = statType;
            info.prefix = prefix;
            info.bonusPerc = isPercent;
        }
        catch (IllegalArgumentException ex) {
            Object[] errargs = new Object[]{tag, "GrimDawn"};
            String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_PROP_TAG_ARGS", errargs);
            GDMsgLogger.addError(msg);
            info = null;
        }
        return info;
    }

    private static List<BonusInfo> getRaceBonusInfo(String statType, String prefix, List<DBCharBonus.RaceBonus> bonuses) {
        TagInfo tagInfo = TagInfoHashMap.getInfo(statType);
        if (tagInfo == null) {
            return null;
        }
        LinkedList<BonusInfo> list = null;
        BonusInfo info = null;
        if (tagInfo.getTag().equals("TXT_UNI_RACE_DAMAGE")) {
            list = new LinkedList<BonusInfo>();
            for (DBCharBonus.RaceBonus rb : bonuses) {
                Object[] args = new Object[]{rb.perc, rb.race};
                try {
                    info = new BonusInfo(tagInfo);
                    info.text = GDMsgFormatter.format(GDMsgFormatter.rbGD, tagInfo.getTag(), args);
                    info.tag = statType;
                    info.prefix = prefix;
                    info.bonusPerc = true;
                }
                catch (IllegalArgumentException ex) {
                    Object[] errargs = new Object[]{tagInfo.getTag(), "GrimDawn"};
                    String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_PROP_TAG_ARGS", errargs);
                    GDMsgLogger.addError(msg);
                    info = null;
                }
                if (info == null) continue;
                list.add(info);
            }
        }
        return list;
    }

    private void createSkillBonusInfos() {
        DBSkillBonus bonus = (DBSkillBonus)this.entity;
        int value = bonus.getValue();
        if (value > 0) {
            BonusInfo info = new BonusInfo();
            Object[] args = new Object[]{value, bonus.getEntityName()};
            info.text = GDMsgFormatter.format(GDMsgFormatter.rbGD, "TXT_SKILL_BONUS", args);
            info.sbMastery = bonus.getSkillBonusType() == 1;
            info.sbPlus = value;
            this.add(info);
        }
    }

    private void createSkillInfos() {
        DBSkill skill = (DBSkill)this.entity;
        String skillName = null;
        if (skill.getName() != null) {
            skillName = skill.getName();
        } else if (skill.getBuffSkill() != null) {
            skillName = skill.getBuffSkill().getName();
        } else if (skill.getPetSkill() != null) {
            skillName = skill.getPetSkill().getName();
        }
        if (skillName != null) {
            BonusInfo info = new BonusInfo();
            Object[] sargs = new Object[]{skillName};
            info.text = GDMsgFormatter.format(GDMsgFormatter.rbGD, "TXT_SKILL_GRANTED", sargs);
            this.add(info);
        }
    }
}

