/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.description;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.gdstash.db.DBCharBonus;
import org.gdstash.db.DBDamage;
import org.gdstash.db.DBItem;
import org.gdstash.db.DBSkill;
import org.gdstash.db.DBSkillBonus;
import org.gdstash.db.DBStashItem;
import org.gdstash.description.AffixComparator;
import org.gdstash.description.BonusDetail;
import org.gdstash.description.BonusInfo;
import org.gdstash.description.BonusInfoSort;
import org.gdstash.description.ItemComparator;
import org.gdstash.item.GDItem;
import org.gdstash.item.ItemInfo;
import org.gdstash.util.GDMsgFormatter;

public class DetailComposer {
    public static final String HTML_HTMLTAG_START = "<html>";
    public static final String HTML_HTMLTAG_END = "</html>";
    public static final String HTML_NEWLINE = "<br>";
    public static final String HTML_LIST_UNSORTED_START = "<ul>";
    public static final String HTML_LIST_UNSORTED_END = "</ul>";
    public static final String HTML_LISTITEM_START = "<li>";
    public static final String HTML_LISTITEM_END = "</li>";
    public static final String HTML_COLOR_LEGENDARY = "<font color = \"#9782AE\">";
    public static final String HTML_COLOR_EPIC = "<font color = \"#2B76AE\">";
    public static final String HTML_COLOR_RARE = "<font color = \"#30B437\">";
    public static final String HTML_COLOR_MAGIC = "<font color = \"#B6AC13\">";
    public static final String HTML_COLOR_QUEST = "<font color = \"#9782AE\">";
    public static final String HTML_COLOR_COMPONENT = "<font color = \"#DA9345\">";
    public static final String HTML_COLOR_ELIXIR = "<font color = \"#FF4100\">";
    public static final String HTML_COLOR_ENCHANTMENT = "<font color = \"#88BE00\">";
    public static final String HTML_COLOR_SKILL = "<font color = \"#598AE5\">";
    public static final String HTML_COLOR_ITEM_TYPE = "<font color = \"#C0A560\">";
    public static final String HTML_COLOR_DAMAGE_VALUE = "<font color = \"#9C8872\">";
    public static final String HTML_COLOR_DAMAGE_TYPE = "<font color = \"#97734C\">";
    public static final String HTML_COLOR_WHITE = "<font color = \"#FFFFFF\">";
    public static final String HTML_COLOR_GRAY = "<font color = \"#787878\">";
    public static final String HTML_COLOR_BLACK = "<font color = \"#000000\">";
    public static final String HTML_COLOR_END = "</font>";
    public static final int DETAIL_ITEM = 1;
    public static final int DETAIL_COMPONENT = 2;
    private static AffixComparator compAffix = new AffixComparator();
    private static ItemComparator compItem = new ItemComparator();
    public String preText = null;
    public List<BonusDetail> bonuses = new LinkedList<BonusDetail>();
    public List<BonusInfoSort> sorted;

    public void add(BonusDetail bonus) {
        if (bonus == null) {
            return;
        }
        if (bonus.infos == null) {
            return;
        }
        if (bonus.infos.size() > 0) {
            this.bonuses.add(bonus);
        }
    }

    public void add(DetailComposer composer) {
        if (composer == null) {
            return;
        }
        if (composer.bonuses == null) {
            return;
        }
        if (composer.bonuses.size() > 0) {
            this.bonuses.addAll(composer.bonuses);
        }
    }

    private void sortAffixBonuses() {
        this.sorted = new LinkedList<BonusInfoSort>();
        BonusInfoSort sort = null;
        for (BonusDetail bonus : this.bonuses) {
            for (BonusInfo info : bonus.infos) {
                sort = new BonusInfoSort(bonus, info);
                this.sorted.add(sort);
            }
        }
        Collections.sort(this.sorted, compAffix);
    }

    public String getAffixText() {
        boolean bracket;
        this.sortAffixBonuses();
        String s = this.preText;
        boolean separator = bracket = this.preText.indexOf("[") != -1;
        int count = 0;
        for (BonusInfoSort sort : this.sorted) {
            if (count > 0 && (sort.info.dmgChance || sort.info.dmgGlobal || sort.info.infoType == 3) || sort.info.dmgDuration && count > 1) continue;
            if (!bracket) {
                s = s == null ? "[" : s + " [";
                bracket = true;
            }
            if (separator) {
                s = s + ". ";
            } else {
                separator = true;
            }
            s = s + sort.info.text;
            if (++count < 4) continue;
            break;
        }
        if (bracket) {
            s = s + "]";
        }
        return s;
    }

    private void sortItemBonuses() {
        this.sorted = new LinkedList<BonusInfoSort>();
        BonusInfoSort sort = null;
        for (BonusDetail bonus : this.bonuses) {
            for (BonusInfo info : bonus.infos) {
                sort = new BonusInfoSort(bonus, info);
                this.sorted.add(sort);
            }
        }
        Collections.sort(this.sorted, compItem);
    }

    public static DetailComposer createComposer(DBStashItem item, int detailType, DBCharBonus charBonus, List<DBDamage> damages, List<DBSkillBonus> skillBonuses) {
        DetailComposer comp = new DetailComposer();
        BonusDetail bonus = null;
        bonus = new BonusDetail(item, detailType, charBonus, null);
        if (!bonus.infos.isEmpty()) {
            comp.add(bonus);
        }
        for (DBDamage damage : damages) {
            bonus = new BonusDetail(item, detailType, damage, null);
            if (bonus.infos == null || bonus.infos.isEmpty()) continue;
            comp.add(bonus);
        }
        if (skillBonuses != null && !skillBonuses.isEmpty()) {
            for (DBSkillBonus skillBonus : skillBonuses) {
                bonus = skillBonus.getBonusDetail();
                if (bonus.infos.isEmpty()) continue;
                comp.add(bonus);
            }
        }
        return comp;
    }

    public static DetailComposer createComposer(DBStashItem item, int detailType, DBCharBonus charBonus, List<DBDamage> damages) {
        return DetailComposer.createComposer(item, detailType, charBonus, damages, null);
    }

    public static String getComposerBonuses(DetailComposer comp, boolean showBase, boolean showRest, boolean separateBase) {
        comp.sortItemBonuses();
        boolean inBase = false;
        boolean inOffGlobal = false;
        int offPercent = 0;
        boolean inRetGlobal = false;
        int retPercent = 0;
        String s = null;
        for (BonusInfoSort sort : comp.sorted) {
            if (!showBase && sort.isBaseStat() || !showRest && !sort.isBaseStat()) continue;
            if (sort.isBaseStat()) {
                inBase = true;
            } else if (inBase) {
                if (separateBase) {
                    s = s == null ? HTML_NEWLINE : s + HTML_NEWLINE;
                }
                inBase = false;
            }
            if (sort.isGlobal()) {
                String title;
                Object[] args;
                if (sort.getInfoType() == 2) {
                    if (!inOffGlobal) {
                        inOffGlobal = true;
                        offPercent = sort.getGlobalOffensePerc();
                        if (offPercent == 0) continue;
                        args = new Object[]{offPercent};
                        title = "";
                        title = sort.isXOR() ? GDMsgFormatter.format(GDMsgFormatter.rbGD, "TXT_CHANCE_XOR", args) : GDMsgFormatter.format(GDMsgFormatter.rbGD, "TXT_CHANCE_GLOBAL", args);
                        s = s == null ? title + HTML_NEWLINE + HTML_LIST_UNSORTED_START : s + title + HTML_NEWLINE + HTML_LIST_UNSORTED_START;
                        s = s + HTML_LISTITEM_START + sort.info.text + HTML_LISTITEM_END;
                    } else {
                        if (offPercent == 0) continue;
                        s = s == null ? HTML_LISTITEM_START + sort.info.text + HTML_LISTITEM_END : s + HTML_LISTITEM_START + sort.info.text + HTML_LISTITEM_END;
                    }
                }
                if (sort.getInfoType() != 3) continue;
                if (!inRetGlobal) {
                    inRetGlobal = true;
                    retPercent = sort.getGlobalRetaliationPerc();
                    if (retPercent == 0) continue;
                    args = new Object[]{retPercent};
                    title = "";
                    title = sort.isXOR() ? GDMsgFormatter.format(GDMsgFormatter.rbGD, "TXT_CHANCE_XOR", args) : GDMsgFormatter.format(GDMsgFormatter.rbGD, "TXT_CHANCE_GLOBAL", args);
                    s = s == null ? title + HTML_NEWLINE + HTML_LIST_UNSORTED_START : s + title + HTML_NEWLINE + HTML_LIST_UNSORTED_START;
                    s = s + HTML_LISTITEM_START + sort.info.text + HTML_LISTITEM_END;
                    continue;
                }
                if (retPercent == 0) continue;
                if (s == null) {
                    s = HTML_LISTITEM_START + sort.info.text + HTML_LISTITEM_END;
                    continue;
                }
                s = s + HTML_LISTITEM_START + sort.info.text + HTML_LISTITEM_END;
                continue;
            }
            if (inOffGlobal) {
                if (offPercent != 0) {
                    s = s == null ? HTML_LIST_UNSORTED_END : s + HTML_LIST_UNSORTED_END;
                }
                inOffGlobal = false;
            }
            if (inRetGlobal) {
                if (retPercent != 0) {
                    s = s == null ? HTML_LIST_UNSORTED_END : s + HTML_LIST_UNSORTED_END;
                }
                inRetGlobal = false;
            }
            if (s == null) {
                s = sort.info.text + HTML_NEWLINE;
                continue;
            }
            s = s + sort.info.text + HTML_NEWLINE;
        }
        if (inOffGlobal && offPercent != 0) {
            s = s == null ? HTML_LIST_UNSORTED_END : s + HTML_LIST_UNSORTED_END;
        }
        if (inRetGlobal && retPercent != 0) {
            s = s == null ? HTML_LIST_UNSORTED_END : s + HTML_LIST_UNSORTED_END;
        }
        return s;
    }

    private static String getDamageType(String s) {
        String tag = null;
        if (s.equals("Aether")) {
            tag = "OFF_AETHER";
        }
        if (s.equals("Chaos")) {
            tag = "OFF_CHAOS";
        }
        if (s.equals("Cold")) {
            tag = "OFF_COLD";
        }
        if (s.equals("Fire")) {
            tag = "OFF_FIRE";
        }
        if (s.equals("Life")) {
            tag = "OFF_LIFE";
        }
        if (s.equals("Lightning")) {
            tag = "OFF_LIGHTNING";
        }
        if (s.equals("Physical")) {
            tag = "OFF_PHYSICAL";
        }
        if (s.equals("Poison")) {
            tag = "OFF_POISON";
        }
        if (tag == null) {
            return null;
        }
        return GDMsgFormatter.format(GDMsgFormatter.rbGD, tag, null);
    }

    private static String getConversion(DBItem item) {
        String s = null;
        if (item.getConvertPerc() > 0) {
            String in = DetailComposer.getDamageType(item.getConvertIn());
            String out = DetailComposer.getDamageType(item.getConvertOut());
            if (in != null && out != null) {
                Object[] args = new Object[]{item.getConvertPerc(), in, out};
                s = GDMsgFormatter.format(GDMsgFormatter.rbGD, "TXT_CONVERT_FROM_TO", args);
                s = s + HTML_NEWLINE;
            }
        }
        return s;
    }

    private static String getSkills(DBStashItem item, int detailType, List<DBSkill> list) {
        if (list == null) {
            return null;
        }
        if (list.isEmpty()) {
            return null;
        }
        if (item != null) {
            if (detailType == 1 && item.isComponent() && item.isIncompleteComponent()) {
                return null;
            }
            if (detailType == 2) {
                if (item.getDBComponent() == null) {
                    return null;
                }
                if (item.isIncompleteComponent()) {
                    return null;
                }
            }
        }
        String s = null;
        String text = null;
        for (DBSkill skill : list) {
            DetailComposer comp;
            String part;
            Object[] iArgs;
            if (skill.getName() == null) {
                text = GDMsgFormatter.format(GDMsgFormatter.rbGD, "TXT_PET_BONUS", null);
            } else {
                Object[] args = new Object[]{skill.getName()};
                text = GDMsgFormatter.format(GDMsgFormatter.rbGD, "TXT_SKILL_GRANTED", args);
            }
            s = s == null ? HTML_COLOR_SKILL + text + HTML_COLOR_END + HTML_NEWLINE : s + HTML_COLOR_SKILL + text + HTML_COLOR_END + HTML_NEWLINE;
            if (skill.getManaCost() > 0) {
                iArgs = new Object[]{skill.getManaCost()};
                text = GDMsgFormatter.format(GDMsgFormatter.rbGD, "TXT_ENERGY_COST", iArgs);
                s = s + text + HTML_NEWLINE;
            }
            if (skill.getCooldownTime() > 0) {
                iArgs = new Object[]{skill.getCooldownTime()};
                text = GDMsgFormatter.format(GDMsgFormatter.rbGD, "TXT_COOLDOWN_TIME", iArgs);
                s = s + text + HTML_NEWLINE;
            }
            if (skill.getWeaponDamagePerc() > 0) {
                iArgs = new Object[]{skill.getWeaponDamagePerc()};
                text = GDMsgFormatter.format(GDMsgFormatter.rbGD, "TXT_WEAPON_DAMAGE", iArgs);
                s = s + text + HTML_NEWLINE;
            }
            if ((part = DetailComposer.getComposerBonuses(comp = DetailComposer.createComposer(item, 1, skill.getCharBonus(), skill.getDamageList()), true, true, true)) == null) continue;
            s = s + part;
        }
        return s;
    }

    private static String getItemReqs(GDItem item) {
        String text;
        Object[] args;
        String s = null;
        int value = 0;
        value = item.getRequiredLevel();
        if (value > 0) {
            args = new Object[]{value};
            text = GDMsgFormatter.format(GDMsgFormatter.rbGD, "TXT_REQ_LEVEL", args);
            s = s == null ? text + HTML_NEWLINE : s + text + HTML_NEWLINE;
        }
        if ((value = item.getRequiredPhysique()) > 0) {
            args = new Object[]{value};
            text = GDMsgFormatter.format(GDMsgFormatter.rbGD, "TXT_REQ_PHYSIQUE", args);
            s = s == null ? text + HTML_NEWLINE : s + text + HTML_NEWLINE;
        }
        if ((value = item.getRequiredCunning()) > 0) {
            args = new Object[]{value};
            text = GDMsgFormatter.format(GDMsgFormatter.rbGD, "TXT_REQ_CUNNING", args);
            s = s == null ? text + HTML_NEWLINE : s + text + HTML_NEWLINE;
        }
        if ((value = item.getRequiredSpirit()) > 0) {
            args = new Object[]{value};
            text = GDMsgFormatter.format(GDMsgFormatter.rbGD, "TXT_REQ_SPIRIT", args);
            s = s == null ? text + HTML_NEWLINE : s + text + HTML_NEWLINE;
        }
        return s;
    }

    public static String getItemText(GDItem item, ItemInfo info) {
        String text;
        DetailComposer compItem = DetailComposer.createComposer(item.getDBStashItem(), 1, info.itemCharBonus, info.itemDamages, info.itemSkillBonuses);
        DetailComposer compPet = DetailComposer.createComposer(item.getDBStashItem(), 1, info.petCharBonus, info.petDamages);
        DetailComposer compComponent = DetailComposer.createComposer(item.getDBStashItem(), 2, info.componentCharBonus, info.componentDamages, info.componentSkillBonuses);
        DetailComposer compCompletion = DetailComposer.createComposer(item.getDBStashItem(), 1, info.completionCharBonus, info.completionDamages, info.completionSkillBonuses);
        DetailComposer compEnchantment = DetailComposer.createComposer(item.getDBStashItem(), 1, info.enchantmentCharBonus, info.enchantmentDamages);
        boolean fCompletion = false;
        String s = HTML_HTMLTAG_START;
        String part = null;
        part = item.getItemCategory();
        if (part != null) {
            s = s + part + HTML_NEWLINE + HTML_NEWLINE;
        }
        boolean base = false;
        part = DetailComposer.getComposerBonuses(compItem, true, false, true);
        if (part != null) {
            s = s + part;
            base = true;
        }
        if ((part = DetailComposer.getConversion(item.getDBItem())) != null) {
            s = s + part;
            base = true;
        }
        if (base) {
            s = s + HTML_NEWLINE;
        }
        if ((part = DetailComposer.getComposerBonuses(compItem, false, true, true)) != null) {
            s = s + part;
        }
        if ((part = DetailComposer.getComposerBonuses(compPet, true, true, true)) != null) {
            text = GDMsgFormatter.format(GDMsgFormatter.rbGD, "TXT_PET_BONUS", null);
            s = s + HTML_NEWLINE + text + HTML_NEWLINE + part;
        }
        if (item.getPlusAllSkills() > 0) {
            Object[] args = new Object[]{item.getPlusAllSkills()};
            String text2 = GDMsgFormatter.format(GDMsgFormatter.rbGD, "TXT_PLUS_ALLSKILLS", args);
            s = s + text2 + HTML_NEWLINE;
        }
        if ((part = DetailComposer.getSkills(item.getDBStashItem(), 1, info.itemSkills)) != null) {
            s = s + HTML_NEWLINE + part;
        }
        if ((part = DetailComposer.getSkills(item.getDBStashItem(), 1, info.petSkills)) != null) {
            s = s + HTML_NEWLINE + part;
        }
        if ((part = DetailComposer.getComposerBonuses(compComponent, true, true, false)) != null) {
            text = HTML_COLOR_COMPONENT + item.getComponentName() + HTML_COLOR_END;
            s = s + HTML_NEWLINE + text + HTML_NEWLINE + part;
        }
        if ((part = DetailComposer.getSkills(item.getDBStashItem(), 2, info.componentSkills)) != null) {
            s = s + HTML_NEWLINE + part;
        }
        if (!item.isComponent() && item.getComponentName() == null && (part = DetailComposer.getComposerBonuses(compCompletion, true, true, true)) != null) {
            text = GDMsgFormatter.format(GDMsgFormatter.rbGD, "TXT_COMPLETION_BONUS", null);
            text = HTML_COLOR_ITEM_TYPE + text + HTML_COLOR_END;
            s = s + HTML_NEWLINE + text + HTML_NEWLINE + part;
            fCompletion = true;
        }
        if ((part = DetailComposer.getSkills(item.getDBStashItem(), 1, info.completionSkills)) != null) {
            if (!fCompletion) {
                text = GDMsgFormatter.format(GDMsgFormatter.rbGD, "TXT_COMPLETION_BONUS", null);
                text = HTML_COLOR_ITEM_TYPE + text + HTML_COLOR_END;
                s = s + HTML_NEWLINE + text + HTML_NEWLINE + part;
            } else {
                s = s + HTML_NEWLINE + part;
            }
        }
        if ((part = DetailComposer.getComposerBonuses(compEnchantment, true, true, false)) != null) {
            text = HTML_COLOR_ENCHANTMENT + item.getEnchantmentName() + HTML_COLOR_END;
            s = s + HTML_NEWLINE + text + HTML_NEWLINE + part;
        }
        if ((part = DetailComposer.getItemReqs(item)) != null) {
            s = s + HTML_NEWLINE + part;
        }
        s = s + HTML_HTMLTAG_END;
        return s;
    }
}

