/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.file;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.imageio.ImageIO;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4FastDecompressor;
import org.gdstash.file.ARCFilePart;
import org.gdstash.file.ARCFileToC;
import org.gdstash.file.ARCHeader;
import org.gdstash.file.ARZRecord;
import org.gdstash.file.DDSLoader;
import org.gdstash.file.GDByteBuffer;
import org.gdstash.file.GDParseException;
import org.gdstash.file.GDReader;
import org.gdstash.file.GDWriter;
import org.gdstash.util.GDConstants;
import org.gdstash.util.GDLog;
import org.gdstash.util.GDMsgFormatter;
import org.gdstash.util.GDMsgLogger;

public class ARCDecompress {
    public static final char TEXT_SEPARATOR_0A = '\n';
    public static final char TEXT_SEPARATOR_0D = '\r';
    public static final int FILE_TYPE_ARC = 0;
    public static final int FILE_TYPE_ZIP = 1;
    private String fileName;
    private int fileType;
    private ARCHeader header;
    private ARCFilePart[] parts;
    private String[] strings;
    private ARCFileToC[] tocs;

    public ARCDecompress(String fileName) {
        this.fileName = fileName;
        String extension = fileName.substring(fileName.length() - 4).toUpperCase(GDConstants.LOCALE_US);
        this.fileType = extension.equals(".ZIP") ? 1 : 0;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!o.getClass().equals(ARCDecompress.class)) {
            return false;
        }
        ARCDecompress arc = (ARCDecompress)o;
        return this.fileName.equals(arc.fileName);
    }

    public String getFileName() {
        return this.fileName;
    }

    public void close() {
        this.header = null;
        this.parts = null;
        this.strings = null;
        this.tocs = null;
    }

    public void decompress(GDLog log) {
        if (this.fileType == 0) {
            this.decompressARC(log);
        }
        if (this.fileType == 1) {
            this.decompressZIP();
        }
    }

    private void decompressARC(GDLog log) {
        GDLog tLog = new GDLog();
        File file = new File(this.fileName);
        try {
            if (!file.exists()) {
                Object[] args = new Object[]{file.getCanonicalPath()};
                String s = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_FILE_NOT_FOUND", args);
                throw new FileNotFoundException(s);
            }
            if (!file.isFile()) {
                Object[] args = new Object[]{file.getCanonicalPath()};
                String s = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_FILE_NOT_FOUND", args);
                throw new FileNotFoundException(s);
            }
            if (!file.canRead()) {
                Object[] args = new Object[]{file.getCanonicalPath()};
                String s = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_FILE_CANNOT_READ", args);
                throw new IOException(s);
            }
            this.decompressARCMemoryMap(file);
        }
        catch (Error | Exception ex) {
            tLog.addError(ex);
        }
        if (tLog.containsErrors()) {
            Object[] args = new Object[]{file.getName()};
            String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_FILE_EXTRACT_FAIL", args);
            tLog.addError(msg);
        }
        if (log == null) {
            GDMsgLogger.addLog(tLog);
        } else {
            log.addLog(tLog);
        }
    }

    private void decompressARCByteBuffer(File file) throws IOException, GDParseException {
        GDByteBuffer buffer = null;
        try {
            buffer = new GDByteBuffer(file);
            this.header = this.getHeader(buffer);
            this.parts = this.getFileParts(buffer);
            this.strings = this.getStrings(buffer);
            this.tocs = this.getFileToCs(buffer);
            this.extractFiles(buffer);
        }
        catch (GDParseException ex) {
            throw ex;
        }
        finally {
            buffer = null;
        }
    }

    private void decompressARCMemoryMap(File file) throws IOException, GDParseException {
        MappedByteBuffer buffer = null;
        try (RandomAccessFile raf = new RandomAccessFile(file, "r");){
            buffer = raf.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, raf.length());
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            this.header = this.getHeader(buffer);
            this.parts = this.getFileParts(buffer);
            this.strings = this.getStrings(buffer);
            this.tocs = this.getFileToCs(buffer);
            this.extractFiles(buffer);
        }
        catch (IOException | GDParseException ex) {
            throw ex;
        }
        finally {
            buffer = null;
        }
    }

    private String decompressZipFile(ZipFile file, ZipEntry entry) throws IOException {
        String text = "";
        StringBuffer line = new StringBuffer(128);
        BufferedInputStream is = new BufferedInputStream(file.getInputStream(entry));
        InputStreamReader isr = new InputStreamReader((InputStream)is, GDConstants.CHARSET_PROPERTIES);
        BufferedReader reader = new BufferedReader(isr);
        int len = (int)entry.getSize();
        char[] chars = new char[len];
        reader.read(chars, 0, len);
        int i = 0;
        while (i < chars.length) {
            if (chars[i] == '\r' && chars[i + 1] == '\n') {
                text = text + line.toString() + GDConstants.LINE_SEPARATOR;
                line = new StringBuffer(128);
                i += 2;
                continue;
            }
            line.append(chars[i]);
            ++i;
        }
        return text;
    }

    private void decompressZIP() {
        String[] fileNames = new String[]{"tags_items.txt", "tags_storyelements.txt", "tags_skills.txt"};
        int len = fileNames.length;
        this.strings = new String[len];
        this.tocs = new ARCFileToC[len];
        try (ZipFile file = new ZipFile(this.fileName);){
            for (int i = 0; i < len; ++i) {
                String search = fileNames[i];
                ZipEntry entry = null;
                entry = file.getEntry(search);
                if (entry == null) continue;
                this.strings[i] = search;
                this.tocs[i] = new ARCFileToC();
                this.tocs[i].text = this.decompressZipFile(file, entry);
            }
        }
        catch (Error | Exception ex) {
            GDMsgLogger.addError(ex);
        }
    }

    private ARCHeader getHeader(GDByteBuffer buffer) throws GDParseException {
        ARCHeader header = new ARCHeader();
        header.unknown = buffer.getInt();
        header.version = buffer.getInt();
        header.num_files = buffer.getInt();
        header.rec_num = buffer.getInt();
        header.rec_size = buffer.getInt();
        header.str_size = buffer.getInt();
        header.rec_offset = buffer.getInt();
        if (header.version != 3) {
            throw new GDParseException(GDMsgFormatter.getString(GDMsgFormatter.rbMsg, "ERR_UNSUPPORTED_VERSION"), 0L);
        }
        return header;
    }

    private ARCHeader getHeader(MappedByteBuffer buffer) throws GDParseException {
        ARCHeader header = new ARCHeader();
        header.unknown = buffer.getInt();
        header.version = buffer.getInt();
        header.num_files = buffer.getInt();
        header.rec_num = buffer.getInt();
        header.rec_size = buffer.getInt();
        header.str_size = buffer.getInt();
        header.rec_offset = buffer.getInt();
        if (header.version != 3) {
            throw new GDParseException(GDMsgFormatter.getString(GDMsgFormatter.rbMsg, "ERR_UNSUPPORTED_VERSION"), 0L);
        }
        return header;
    }

    private ARCFilePart[] getFileParts(GDByteBuffer buffer) {
        if (this.header.rec_num == 0) {
            return null;
        }
        ARCFilePart[] parts = new ARCFilePart[this.header.rec_num];
        buffer.position(this.header.rec_offset);
        for (int i = 0; i < parts.length; ++i) {
            ARCFilePart part = new ARCFilePart();
            part.offset = buffer.getInt();
            part.len_comp = buffer.getInt();
            part.len_decomp = buffer.getInt();
            parts[i] = part;
        }
        return parts;
    }

    private ARCFilePart[] getFileParts(MappedByteBuffer buffer) {
        if (this.header.rec_num == 0) {
            return null;
        }
        ARCFilePart[] parts = new ARCFilePart[this.header.rec_num];
        buffer.position(this.header.rec_offset);
        for (int i = 0; i < parts.length; ++i) {
            ARCFilePart part = new ARCFilePart();
            part.offset = buffer.getInt();
            part.len_comp = buffer.getInt();
            part.len_decomp = buffer.getInt();
            parts[i] = part;
        }
        return parts;
    }

    private String[] getStrings(GDByteBuffer buffer) {
        String[] strings = new String[this.header.num_files];
        buffer.position(this.header.rec_offset + this.header.rec_size);
        for (int i = 0; i < strings.length; ++i) {
            String s;
            strings[i] = s = buffer.getString0();
        }
        return strings;
    }

    private String[] getStrings(MappedByteBuffer buffer) {
        byte[] bytes = new byte[this.header.str_size];
        String[] strings = new String[this.header.num_files];
        buffer.position(this.header.rec_offset + this.header.rec_size);
        buffer.get(bytes);
        int offset = 0;
        for (int i = 0; i < strings.length; ++i) {
            String s;
            strings[i] = s = GDReader.getString0(bytes, offset);
            offset = offset + s.length() + 1;
        }
        return strings;
    }

    private ARCFileToC[] getFileToCs(GDByteBuffer buffer) {
        ARCFileToC[] tocs = new ARCFileToC[this.header.num_files];
        buffer.position(this.header.rec_offset + this.header.rec_size + this.header.str_size);
        for (int i = 0; i < tocs.length; ++i) {
            ARCFileToC toc = new ARCFileToC();
            toc.type = buffer.getInt();
            toc.offset = buffer.getInt();
            toc.len_comp = buffer.getInt();
            toc.len_decomp = buffer.getInt();
            toc.hash_decomp = buffer.getInt();
            toc.fileTime = buffer.getLong();
            toc.num_parts = buffer.getInt();
            toc.index = buffer.getInt();
            toc.str_len = buffer.getInt();
            toc.str_offset = buffer.getInt();
            tocs[i] = toc;
        }
        return tocs;
    }

    private ARCFileToC[] getFileToCs(MappedByteBuffer buffer) {
        ARCFileToC[] tocs = new ARCFileToC[this.header.num_files];
        buffer.position(this.header.rec_offset + this.header.rec_size + this.header.str_size);
        for (int i = 0; i < tocs.length; ++i) {
            ARCFileToC toc = new ARCFileToC();
            toc.type = buffer.getInt();
            toc.offset = buffer.getInt();
            toc.len_comp = buffer.getInt();
            toc.len_decomp = buffer.getInt();
            toc.hash_decomp = buffer.getInt();
            toc.fileTime = buffer.getLong();
            toc.num_parts = buffer.getInt();
            toc.index = buffer.getInt();
            toc.str_len = buffer.getInt();
            toc.str_offset = buffer.getInt();
            tocs[i] = toc;
        }
        return tocs;
    }

    public void fillPictureData(ARZRecord[] records) {
        for (int i = 0; i < records.length; ++i) {
            if (records[i] == null) continue;
            records[i].fillImages(this);
        }
    }

    private void extractFiles(GDByteBuffer buffer) {
        LZ4Factory factory = LZ4Factory.fastestInstance();
        LZ4FastDecompressor decomp = factory.fastDecompressor();
        for (int i = 0; i < this.header.num_files; ++i) {
            if (this.tocs[i].len_decomp == 0 && this.tocs[i].num_parts == 0) continue;
            if (this.tocs[i].type == 1 && this.tocs[i].len_comp == this.tocs[i].len_decomp) {
                this.tocs[i].data = buffer.getBytes(this.tocs[i].offset, this.tocs[i].len_decomp);
                continue;
            }
            this.tocs[i].data = new byte[this.tocs[i].len_decomp];
            int offDecomp = 0;
            for (int j = 0; j < this.tocs[i].num_parts; ++j) {
                byte[] bComp;
                ARCFilePart part = this.parts[this.tocs[i].index + j];
                if (part.len_comp == part.len_decomp) {
                    bComp = buffer.getBytes(part.offset, part.len_comp);
                    for (int k = 0; k < bComp.length; ++k) {
                        this.tocs[i].data[k + offDecomp] = bComp[k];
                    }
                } else {
                    bComp = buffer.getBytes(part.offset, part.len_comp);
                    decomp.decompress(bComp, 0, this.tocs[i].data, offDecomp, part.len_decomp);
                }
                offDecomp += part.len_decomp;
            }
        }
        this.header = null;
        this.parts = null;
    }

    private void extractFiles(MappedByteBuffer buffer) {
        LZ4Factory factory = LZ4Factory.fastestInstance();
        LZ4FastDecompressor decomp = factory.fastDecompressor();
        for (int i = 0; i < this.header.num_files; ++i) {
            if (this.tocs[i].type == 1 && this.tocs[i].len_comp == this.tocs[i].len_decomp) {
                this.tocs[i].data = GDReader.getBytes(buffer, this.tocs[i].offset, this.tocs[i].len_comp);
                continue;
            }
            this.tocs[i].data = new byte[this.tocs[i].len_decomp];
            int offDecomp = 0;
            for (int j = 0; j < this.tocs[i].num_parts; ++j) {
                byte[] bComp;
                ARCFilePart part = this.parts[this.tocs[i].index + j];
                if (part.len_comp == part.len_decomp) {
                    bComp = GDReader.getBytes(buffer, part.offset, part.len_comp);
                    for (int k = 0; k < bComp.length; ++k) {
                        this.tocs[i].data[k + offDecomp] = bComp[k];
                    }
                } else {
                    bComp = GDReader.getBytes(buffer, part.offset, part.len_comp);
                    decomp.decompress(bComp, 0, this.tocs[i].data, offDecomp, part.len_decomp);
                }
                offDecomp += part.len_decomp;
            }
        }
        this.header = null;
        this.parts = null;
    }

    public void writeFiles(String dir, String subDir) {
        if (dir == null) {
            return;
        }
        GDLog log = new GDLog();
        this.decompress(log);
        if (log.containsErrors()) {
            GDMsgLogger.addLog(log);
            return;
        }
        int index = 0;
        for (int i = 0; i < this.tocs.length; ++i) {
            block9: {
                if (this.tocs[i].len_decomp == 0 && this.tocs[i].num_parts == 0) continue;
                String newName = dir + GDConstants.FILE_SEPARATOR + subDir + GDConstants.FILE_SEPARATOR + this.strings[index];
                int pos = newName.indexOf("/");
                while (pos != -1) {
                    newName = newName.substring(0, pos) + GDConstants.FILE_SEPARATOR + newName.substring(pos + 1);
                    pos = newName.indexOf("/");
                }
                try {
                    GDWriter.write(newName, this.tocs[i].data);
                    if (!newName.endsWith(".tex")) break block9;
                    String pngName = newName.substring(0, newName.length() - 4) + ".png";
                    BufferedImage image = null;
                    try {
                        image = DDSLoader.getImage(this.tocs[i].data);
                    }
                    catch (Exception ex) {
                        image = null;
                    }
                    if (image != null) {
                        File fImg = new File(pngName);
                        ImageIO.write((RenderedImage)image, "PNG", fImg);
                    }
                }
                catch (IOException ex) {
                    Object[] args = new Object[]{ex.getMessage(), this.strings[index]};
                    String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_FILE_WRITE_ERROR", args);
                    log.addError(msg);
                }
            }
            ++index;
        }
        this.close();
        GDMsgLogger.addLog(log);
    }

    public byte[] getTexture(String filename) {
        String s = filename;
        int pos = s.indexOf("/");
        if (pos != -1) {
            s = s.substring(pos + 1);
        }
        int index = 0;
        for (int i = 0; i < this.tocs.length; ++i) {
            if (this.tocs[i].len_decomp == 0 && this.tocs[i].num_parts == 0) continue;
            if (this.strings[index].equals(s)) {
                return this.tocs[i].data;
            }
            ++index;
        }
        return null;
    }

    public BufferedImage getImage(String filename) {
        byte[] data = this.getTexture(filename);
        if (data != null) {
            try {
                return DDSLoader.getImage(data);
            }
            catch (GDParseException ex) {
                return null;
            }
        }
        return null;
    }

    private static String removeControlChars(String s) {
        if (s != null) {
            int pos = s.indexOf("^");
            while (pos != -1) {
                String temp = s;
                s = temp.substring(0, pos) + temp.substring(pos + 2);
                pos = s.indexOf("^");
            }
        }
        return s;
    }

    private void convertText(int index) {
        if (this.tocs[index].text == null) {
            String text = "";
            StringBuffer line = new StringBuffer(128);
            int j = 0;
            while (j < this.tocs[index].data.length) {
                if (this.tocs[index].data[j] == 13 && this.tocs[index].data[j + 1] == 10) {
                    text = text + line.toString() + GDConstants.LINE_SEPARATOR;
                    line = new StringBuffer(128);
                    j += 2;
                    continue;
                }
                line.append((char)this.tocs[index].data[j]);
                ++j;
            }
            if (line.length() > 0) {
                text = text + line.toString() + GDConstants.LINE_SEPARATOR;
            }
            this.tocs[index].text = text;
            this.tocs[index].data = null;
        }
    }

    private String findTag(String text, String tag) {
        int pos1 = text.indexOf(tag + "=");
        if (pos1 == -1) {
            return null;
        }
        String result = null;
        int pos2 = text.indexOf(10, pos1);
        result = pos2 == -1 ? text.substring(pos1 + tag.length() + 1) : (text.charAt(pos2 - 1) == '\r' ? text.substring(pos1 + tag.length() + 1, pos2 - 1) : text.substring(pos1 + tag.length() + 1, pos2));
        return result;
    }

    public String getTag(String filename, String tag) {
        String text;
        int pos1;
        int i;
        String result = null;
        int index = 0;
        for (i = 0; i < this.tocs.length; ++i) {
            if (this.tocs[i].len_decomp == 0 && this.tocs[i].num_parts == 0) continue;
            if (this.strings[index].equals(filename)) {
                if (this.tocs[i].text == null) {
                    this.convertText(i);
                }
                if ((pos1 = (text = this.tocs[i].text).indexOf(tag + "=")) == -1) break;
                result = this.findTag(this.tocs[i].text, tag);
                break;
            }
            ++index;
        }
        if (result == null) {
            for (i = 0; i < this.tocs.length; ++i) {
                if (this.tocs[i].text == null) {
                    this.convertText(i);
                }
                if ((pos1 = (text = this.tocs[i].text).indexOf(tag + "=")) != -1) {
                    result = this.findTag(this.tocs[i].text, tag);
                }
                if (result != null) break;
            }
        }
        if (result != null) {
            result = ARCDecompress.removeControlChars(result);
        }
        return result;
    }
}

