/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.file;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.text.DecimalFormat;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4FastDecompressor;
import org.gdstash.db.DBDamage;
import org.gdstash.db.DBFormulaSet;
import org.gdstash.db.DBSkillBonus;
import org.gdstash.db.GDDBData;
import org.gdstash.file.ARZHeader;
import org.gdstash.file.ARZRecord;
import org.gdstash.file.ARZString;
import org.gdstash.file.GDParseException;
import org.gdstash.file.GDReader;
import org.gdstash.file.GDWriter;
import org.gdstash.ui.GDStashFrame;
import org.gdstash.util.GDConstants;
import org.gdstash.util.GDMsgFormatter;
import org.gdstash.util.GDMsgLogger;

public class ARZDecompress {
    public static final short REC_VALUE_INT = 0;
    public static final short REC_VALUE_FLOAT = 1;
    public static final short REC_VALUE_STRING = 2;
    public static final short REC_VALUE_BOOL = 3;
    private static ARZHeader header;
    private static ARZString[] strings;
    private static ARZRecord[] records;

    public static void clear() {
        header = null;
        strings = null;
        records = null;
    }

    public static void decompress(String filename) {
        try {
            File file = new File(filename);
            if (!file.exists()) {
                Object[] args = new Object[]{filename};
                String s = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_FILE_NOT_FOUND", args);
                throw new FileNotFoundException(s);
            }
            if (!file.isFile()) {
                Object[] args = new Object[]{filename};
                String s = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_FILE_NOT_FOUND", args);
                throw new FileNotFoundException(s);
            }
            if (!file.canRead()) {
                Object[] args = new Object[]{filename};
                String s = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_FILE_CANNOT_READ", args);
                throw new IOException(s);
            }
            MappedByteBuffer buffer = null;
            try (RandomAccessFile raf = new RandomAccessFile(file, "r");){
                buffer = raf.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, raf.length());
                buffer.order(ByteOrder.LITTLE_ENDIAN);
                header = ARZDecompress.getHeader(buffer);
                strings = ARZDecompress.getStrings(buffer);
                records = ARZDecompress.getRecords(buffer);
                ARZDecompress.extractRecords(buffer);
            }
            catch (IOException ex) {
                throw ex;
            }
            finally {
                buffer = null;
            }
        }
        catch (Exception ex) {
            GDMsgLogger.addError(ex);
        }
        GDStashFrame.arcList.fillPictureData(records);
        ARZDecompress.resolveAttrib();
        GDStashFrame.listToLog();
        if (GDMsgLogger.errorsInLog()) {
            GDMsgLogger.addError(GDMsgFormatter.getString(GDMsgFormatter.rbMsg, "ERR_DB_EXTRACT_FAIL"));
        }
    }

    private static ARZHeader getHeader(MappedByteBuffer buffer) throws GDParseException {
        ARZHeader header = new ARZHeader();
        header.unknown = buffer.getShort();
        header.version = buffer.getShort();
        header.rec_start = buffer.getInt();
        header.rec_size = buffer.getInt();
        header.rec_num = buffer.getInt();
        header.str_start = buffer.getInt();
        header.str_size = buffer.getInt();
        if (header.unknown != 2 || header.version != 3) {
            throw new GDParseException(GDMsgFormatter.getString(GDMsgFormatter.rbMsg, "ERR_UNSUPPORTED_VERSION"), 0L);
        }
        return header;
    }

    private static ARZString[] getStrings(MappedByteBuffer buffer) {
        buffer.position(ARZDecompress.header.str_start);
        int num = buffer.getInt();
        ARZString[] strings = new ARZString[num];
        for (int i = 0; i < strings.length; ++i) {
            ARZString str = new ARZString();
            str.len = buffer.getInt();
            str.str = GDReader.getString(buffer, str.len);
            strings[i] = str;
        }
        return strings;
    }

    private static ARZRecord[] getRecords(MappedByteBuffer buffer) {
        ARZRecord[] records = new ARZRecord[ARZDecompress.header.rec_num];
        buffer.position(ARZDecompress.header.rec_start);
        for (int i = 0; i < records.length; ++i) {
            try {
                ARZRecord rec = new ARZRecord();
                rec.strID = buffer.getInt();
                rec.len_str = buffer.getInt();
                rec.str = GDReader.getString(buffer, rec.len_str);
                rec.offset = buffer.getInt();
                rec.len_comp = buffer.getInt();
                rec.len_decomp = buffer.getInt();
                rec.filedata = GDReader.getBytes8(buffer);
                records[i] = rec;
                continue;
            }
            catch (Exception ex) {
                GDMsgLogger.addError(ex);
                ARZDecompress.records[i] = null;
            }
        }
        return records;
    }

    private static void extractRecords(MappedByteBuffer buffer) {
        DecimalFormat formatter = new DecimalFormat("#0.000000");
        LZ4Factory factory = LZ4Factory.fastestInstance();
        LZ4FastDecompressor decomp = factory.fastDecompressor();
        for (int i = 0; i < records.length; ++i) {
            try {
                if (records[i] == null) continue;
                records[i].setFileName(ARZDecompress.strings[ARZDecompress.records[i].strID].str);
                if (ARZDecompress.records[i].error) {
                    ARZDecompress.records[i] = null;
                    continue;
                }
                if (!ARZRecord.processDir(records[i].getFileName())) {
                    ARZDecompress.records[i] = null;
                    continue;
                }
                ARZDecompress.records[i].storeInDB = true;
                byte[] bComp = GDReader.getBytes(buffer, ARZDecompress.records[i].offset + 24, ARZDecompress.records[i].len_comp);
                byte[] bDecomp = new byte[ARZDecompress.records[i].len_decomp];
                decomp.decompress(bComp, bDecomp);
                String value = "";
                int offset = 0;
                while (offset < bDecomp.length) {
                    int typeOffset = offset;
                    short varType = GDReader.getUShort(bDecomp, offset);
                    int count = GDReader.getUShort(bDecomp, offset += 2);
                    int strIdx = GDReader.getUInt(bDecomp, offset += 2);
                    offset += 4;
                    for (int j = 0; j < count; ++j) {
                        switch (varType) {
                            case 0: {
                                int valInt = GDReader.getInt(bDecomp, offset);
                                value = String.valueOf(valInt);
                                break;
                            }
                            case 1: {
                                float valFloat = GDReader.getFloat(bDecomp, offset);
                                value = formatter.format(valFloat);
                                break;
                            }
                            case 2: {
                                int valStrIdx = GDReader.getUInt(bDecomp, offset);
                                value = ARZDecompress.strings[valStrIdx].str;
                                break;
                            }
                            case 3: {
                                boolean valBool = GDReader.getBool(bDecomp, offset);
                                if (valBool) {
                                    value = "1";
                                    break;
                                }
                                value = "0";
                                break;
                            }
                            default: {
                                Object[] args = new Object[]{records[i].getFileName(), ARZDecompress.strings[strIdx].str};
                                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_UNKNOWN_VAR_TYPE", args);
                                throw new GDParseException(msg, typeOffset);
                            }
                        }
                        offset += 4;
                        String attrib = ARZDecompress.strings[strIdx].str;
                        if (attrib.equals("templateName") && !ARZRecord.processTemplate(value)) {
                            ARZDecompress.records[i] = null;
                            break;
                        }
                        ARZDecompress.fillAttrib(attrib, i, value);
                    }
                    if (records[i] != null) continue;
                }
                if (records[i] == null || records[i].getTemplate() != null) continue;
                ARZDecompress.records[i] = null;
                continue;
            }
            catch (Exception ex) {
                Object[] args = new Object[]{records[i].getFileName()};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_IN_ENTRY", args);
                GDMsgLogger.addError(msg);
                GDMsgLogger.addError(ex);
                ARZDecompress.records[i] = null;
            }
        }
    }

    private static int parseInt(String s) {
        int val = 0;
        int pos = s.indexOf(".");
        if (pos == -1) {
            pos = s.indexOf(",");
        }
        val = pos == -1 ? Integer.parseInt(s) : (int)ARZDecompress.parseFloat(s);
        return val;
    }

    private static float parseFloat(String s) {
        boolean val = false;
        int pos = s.indexOf(",");
        if (pos != -1) {
            s = s.substring(0, pos) + "." + s.substring(pos + 1);
        }
        return Float.parseFloat(s);
    }

    private static void fillAttrib(String attrib, int pos, String value) throws GDParseException {
        if (attrib.equals("templateName")) {
            records[pos].setTemplate(value);
            return;
        }
        if (attrib.equals("Class")) {
            records[pos].setRecordClass(value);
            return;
        }
        if (attrib.equals("FileDescription")) {
            records[pos].setFileDescription(value);
            return;
        }
        if (attrib.equals("itemClassification")) {
            records[pos].setRarity(value);
            return;
        }
        if (attrib.equals("itemSkillName")) {
            records[pos].setItemSkillID(value);
            return;
        }
        if (attrib.equals("levelRequirement")) {
            int level = ARZDecompress.parseInt(value);
            records[pos].setRequiredLevel(level);
            return;
        }
        if (attrib.equals("offensiveGlobalChance")) {
            int chance = ARZDecompress.parseInt(value);
            records[pos].setOffensiveChance(chance);
            return;
        }
        if (attrib.equals("petBonusName")) {
            records[pos].setPetBonusID(value);
            return;
        }
        if (attrib.equals("retaliationGlobalChance")) {
            int chance = ARZDecompress.parseInt(value);
            records[pos].setRetaliationChance(chance);
            return;
        }
        boolean processed = false;
        if (records[pos].isGameEngine()) {
            processed = ARZDecompress.fillEngineGame(attrib, pos, value);
            return;
        }
        if (records[pos].isFaction()) {
            processed = ARZDecompress.fillFaction(attrib, pos, value);
            return;
        }
        if (records[pos].isPlayerEngine()) {
            processed = ARZDecompress.fillEnginePlayer(attrib, pos, value);
            return;
        }
        if (records[pos].isSkill() && (processed = ARZDecompress.fillAttribSkill(attrib, pos, value))) {
            return;
        }
        if (records[pos].isAffix() && (processed = ARZDecompress.fillAttribAffix(attrib, pos, value))) {
            return;
        }
        if (records[pos].isAffixSet() && (processed = ARZDecompress.fillAttribAffixSet(attrib, pos, value))) {
            return;
        }
        if (records[pos].isItemSet() && (processed = ARZDecompress.fillAttribItemSet(attrib, pos, value))) {
            return;
        }
        if (records[pos].isLootTable() && (processed = ARZDecompress.fillAttribLootTable(attrib, pos, value))) {
            return;
        }
        if (records[pos].isLootTableSet() && (processed = ARZDecompress.fillAttribLootTableSet(attrib, pos, value))) {
            return;
        }
        if (records[pos].isFormulaSet() && (processed = ARZDecompress.fillAttribFormula(attrib, pos, value))) {
            return;
        }
        processed = ARZDecompress.fillAttribItem(attrib, pos, value);
        if (processed) {
            return;
        }
        processed = ARZDecompress.fillAttribCharBonus(attrib, pos, value);
        if (processed) {
            return;
        }
        processed = ARZDecompress.fillAttribDamage(attrib, pos, value);
        if (processed) {
            return;
        }
        processed = ARZDecompress.fillAttribSkillBonus(attrib, pos, value);
        if (processed) {
            return;
        }
    }

    private static boolean fillAttribAffix(String attrib, int pos, String value) {
        if (attrib.equals("lootRandomizerCost")) {
            int iVal = 0;
            try {
                iVal = Integer.parseInt(value);
            }
            catch (NumberFormatException ex) {
                iVal = 0;
                Object[] args = new Object[]{records[pos].getFileName(), attrib, value};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_TAG_INVALID_VALUE", args);
                GDMsgLogger.addError(msg);
            }
            records[pos].setLootRandomCost(iVal);
            return true;
        }
        if (attrib.equals("lootRandomizerJitter")) {
            int iVal = 0;
            try {
                iVal = (int)ARZDecompress.parseFloat(value);
            }
            catch (NumberFormatException ex) {
                iVal = 0;
                Object[] args = new Object[]{records[pos].getFileName(), attrib, value};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_TAG_INVALID_VALUE", args);
                GDMsgLogger.addError(msg);
            }
            records[pos].setRNGPercent(iVal);
            return true;
        }
        if (attrib.equals("lootRandomizerName")) {
            records[pos].setLootRandomName(value);
            return true;
        }
        return false;
    }

    private static boolean fillAttribAffixSet(String attrib, int pos, String value) {
        if (attrib.startsWith("randomizerLevelMax")) {
            String s = attrib.substring(18);
            int i = ARZDecompress.parseInt(s);
            int level = ARZDecompress.parseInt(value);
            records[pos].addRandomizerMaxLevelEntry(i, level);
            return true;
        }
        if (attrib.startsWith("randomizerLevelMin")) {
            String s = attrib.substring(18);
            int i = ARZDecompress.parseInt(s);
            int level = ARZDecompress.parseInt(value);
            records[pos].addRandomizerMinLevelEntry(i, level);
            return true;
        }
        if (attrib.startsWith("randomizerName")) {
            String s = attrib.substring(14);
            int i = ARZDecompress.parseInt(s);
            records[pos].addRandomizerAffixIDEntry(i, value);
            return true;
        }
        return false;
    }

    private static boolean fillAttribItem(String attrib, int pos, String value) {
        if (attrib.equals("amulet")) {
            records[pos].setSlotAmulet(value.equals("1"));
            return true;
        }
        if (attrib.equals("armorClassification")) {
            records[pos].setArmorClass(value);
            return true;
        }
        if (attrib.equals("artifactClassification")) {
            records[pos].setArtifactClass(value);
            return true;
        }
        if (attrib.equals("artifactName")) {
            records[pos].setArtifactID(value);
            return true;
        }
        if (attrib.equals("attributeScalePercent")) {
            int iVal = 0;
            try {
                iVal = (int)ARZDecompress.parseFloat(value);
            }
            catch (NumberFormatException ex) {
                iVal = 0;
                Object[] args = new Object[]{records[pos].getFileName(), attrib, value};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_TAG_INVALID_VALUE", args);
                GDMsgLogger.addError(msg);
            }
            records[pos].setRNGPercent(iVal);
            return true;
        }
        if (attrib.equals("augmentAllLevel")) {
            int iVal = ARZDecompress.parseInt(value);
            records[pos].setPlusAllSkills(iVal);
            return true;
        }
        if (attrib.equals("axe")) {
            records[pos].setSlotAxe1H(value.equals("1"));
            return true;
        }
        if (attrib.equals("axe2h")) {
            records[pos].setSlotAxe2H(value.equals("1"));
            return true;
        }
        if (attrib.equals("bitmap") || attrib.equals("artifactBitmap") || attrib.equals("artifactFormulaBitmapName") || attrib.equals("noteBitmap") || attrib.equals("relicBitmap") || attrib.equals("fullBitmap")) {
            records[pos].setBitmapID(value);
            return true;
        }
        if (attrib.equals("bonusTableName")) {
            records[pos].setBonusAffixSetID(value);
        }
        if (attrib.equals("chest")) {
            records[pos].setSlotChest(value.equals("1"));
            return true;
        }
        if (attrib.equals("completedRelicLevel")) {
            int iVal = ARZDecompress.parseInt(value);
            records[pos].setComponentPieces(iVal);
            return true;
        }
        if (attrib.equals("conversionInType")) {
            records[pos].setConvertIn(value);
            return true;
        }
        if (attrib.equals("conversionOutType")) {
            records[pos].setConvertOut(value);
            return true;
        }
        if (attrib.equals("conversionPercentage")) {
            int iVal = ARZDecompress.parseInt(value);
            records[pos].setConvertPerc(iVal);
            return true;
        }
        if (attrib.equals("dagger")) {
            records[pos].setSlotDagger1H(value.equals("1"));
            return true;
        }
        if (attrib.equals("feet")) {
            records[pos].setSlotFeet(value.equals("1"));
            return true;
        }
        if (attrib.equals("hands")) {
            records[pos].setSlotHands(value.equals("1"));
            return true;
        }
        if (attrib.equals("head")) {
            records[pos].setSlotHead(value.equals("1"));
            return true;
        }
        if (attrib.equals("hidePrefixName")) {
            records[pos].setHidePrefix(value.equals("1"));
            return true;
        }
        if (attrib.equals("hideSuffixName")) {
            records[pos].setHideSuffix(value.equals("1"));
            return true;
        }
        if (attrib.equals("itemCostName")) {
            records[pos].setCostFormulaSetID(value);
            return true;
        }
        if (attrib.equals("itemLevel")) {
            int iVal = ARZDecompress.parseInt(value);
            records[pos].setItemLevel(iVal);
            return true;
        }
        if (attrib.equals("itemNameTag") || attrib.equals("description")) {
            if (value != null && !value.equals("")) {
                records[pos].setItemNameTag(value);
            }
            return true;
        }
        if (attrib.equals("itemQualityTag")) {
            records[pos].setQualityTag(value);
            return true;
        }
        if (attrib.equals("itemSetName")) {
            records[pos].setItemSetID(value);
            return true;
        }
        if (attrib.equals("itemStyleTag")) {
            records[pos].setStyleTag(value);
            return true;
        }
        if (attrib.equals("legs")) {
            records[pos].setSlotLegs(value.equals("1"));
            return true;
        }
        if (attrib.equals("mace")) {
            records[pos].setSlotMace1H(value.equals("1"));
            return true;
        }
        if (attrib.equals("mace2h")) {
            records[pos].setSlotMace2H(value.equals("1"));
            return true;
        }
        if (attrib.equals("maxStackSize")) {
            int iVal = ARZDecompress.parseInt(value);
            records[pos].setMaxStackSize(iVal);
            return true;
        }
        if (attrib.equals("medal")) {
            records[pos].setSlotMedal(value.equals("1"));
            return true;
        }
        if (attrib.equals("offhand")) {
            records[pos].setSlotOffhand(value.equals("1"));
            return true;
        }
        if (attrib.equals("quest")) {
            records[pos].setQuestItem(value.equals("1"));
            return true;
        }
        if (attrib.equals("ranged1h")) {
            records[pos].setSlotRanged1H(value.equals("1"));
            return true;
        }
        if (attrib.equals("ranged2h")) {
            records[pos].setSlotRanged2H(value.equals("1"));
            return true;
        }
        if (attrib.equals("ring")) {
            records[pos].setSlotRing(value.equals("1"));
            return true;
        }
        if (attrib.equals("scepter")) {
            records[pos].setSlotScepter1H(value.equals("1"));
            return true;
        }
        if (attrib.equals("shardBitmap")) {
            records[pos].setShardBitmapID(value);
            return true;
        }
        if (attrib.equals("shield")) {
            records[pos].setSlotShield(value.equals("1"));
            return true;
        }
        if (attrib.equals("shoulders")) {
            records[pos].setSlotShoulders(value.equals("1"));
            return true;
        }
        if (attrib.equals("soulbound")) {
            records[pos].setSoulbound(value.equals("1"));
            return true;
        }
        if (attrib.equals("spear")) {
            records[pos].setSlotSpear2H(value.equals("1"));
            return true;
        }
        if (attrib.equals("staff")) {
            records[pos].setSlotStaff2H(value.equals("1"));
            return true;
        }
        if (attrib.equals("sword")) {
            records[pos].setSlotSword1H(value.equals("1"));
            return true;
        }
        if (attrib.equals("sword2h")) {
            records[pos].setSlotSword2H(value.equals("1"));
            return true;
        }
        if (attrib.equals("waist")) {
            records[pos].setSlotBelt(value.equals("1"));
            return true;
        }
        return false;
    }

    private static boolean fillAttribDamage(String attrib, int pos, String value) {
        boolean processed = false;
        if (attrib.startsWith("defensive")) {
            processed = ARZDecompress.fillAttribDamageDef(attrib, pos, value);
        }
        if (attrib.startsWith("offensive")) {
            processed = ARZDecompress.fillAttribDamageOff(attrib, pos, value);
        }
        if (attrib.startsWith("retaliation")) {
            processed = ARZDecompress.fillAttribDamageRet(attrib, pos, value);
        }
        return processed;
    }

    private static boolean fillAttribDamageStat(String attrib, String search, int pos, String value) {
        boolean processed = false;
        int len = search.length();
        int p = attrib.indexOf(search);
        if (p == -1) {
            if (search.equals("retaliationPercentCurrentLife")) {
                p = attrib.indexOf("retaliationPercentcurrentLife");
            }
            if (p == -1) {
                return false;
            }
        }
        String suf = attrib.substring(p + len);
        DBDamage damage2 = null;
        boolean found = false;
        for (DBDamage damage2 : ARZDecompress.records[pos].dbDamages) {
            if (!damage2.getDamageType().equals(search)) continue;
            found = true;
            break;
        }
        if (!found) {
            damage2 = new DBDamage();
            damage2.setDamageType(search);
            ARZDecompress.records[pos].dbDamages.add(damage2);
        }
        int val = ARZDecompress.parseInt(value);
        if (suf.equals("Global")) {
            damage2.setGlobal(val > 0);
            processed = true;
        }
        if (suf.equals("XOR")) {
            damage2.setXOR(val > 0);
            processed = true;
        }
        if (suf.equals("")) {
            damage2.setMinDamage(val);
            processed = true;
        }
        if (suf.equals("Min")) {
            damage2.setMinDamage(val);
            processed = true;
        }
        if (suf.equals("Max")) {
            damage2.setMaxDamage(val);
            processed = true;
        }
        if (suf.equals("Chance")) {
            damage2.setDamageChance(val);
            processed = true;
        }
        if (suf.equals("Modifier")) {
            damage2.setDamageModifier(val);
            processed = true;
        }
        if (suf.equals("ModifierChance")) {
            damage2.setDamageModifierChance(val);
            processed = true;
        }
        if (suf.equals("Duration")) {
            damage2.setMinDuration(val);
            processed = true;
        }
        if (suf.equals("DurationMin")) {
            damage2.setMinDuration(val);
            processed = true;
        }
        if (suf.equals("DurationMax")) {
            damage2.setMaxDuration(val);
            processed = true;
        }
        if (suf.equals("DurationChance")) {
            damage2.setDurationChance(val);
            processed = true;
        }
        if (suf.equals("DurationModifier")) {
            damage2.setDurationModifier(val);
            processed = true;
        }
        if (suf.equals("DurationModifierChance")) {
            damage2.setDurationModifierChance(val);
            processed = true;
        }
        if (suf.equals("MaxResist")) {
            damage2.setMaxResist(val);
            processed = true;
        }
        return processed;
    }

    private static boolean fillAttribDamageDef(String attrib, int pos, String value) {
        boolean processed = false;
        processed = ARZDecompress.fillAttribDamageStat(attrib, "defensiveAbsorption", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "defensiveAether", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "defensiveAll", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "defensiveBleeding", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "defensiveBlock", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "defensiveBlockAmount", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "defensiveBonusProtection", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "defensiveChaos", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "defensiveCold", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "defensiveConfusion", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "defensiveConvert", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "defensiveDisruption", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "defensiveElemental", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "defensiveElementalResistance", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "defensiveFear", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "defensiveFire", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "defensiveFreeze", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "defensiveKnockdown", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "defensiveLife", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "defensiveLightning", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "defensivePercentCurrentLife", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "defensiveManaBurnRatio", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "defensivePetrify", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "defensivePhysical", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "defensivePierce", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "defensivePoison", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "defensiveProtection", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "defensiveReflect", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "defensiveSleep", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "defensiveSlowLifeLeach", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "defensiveSlowManaLeach", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "defensiveStun", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "defensiveTaunt", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "defensiveTotalSpeedResistance", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "defensiveTrap", pos, value);
        if (processed) {
            return processed;
        }
        if (!processed) {
            int i = ARZDecompress.parseInt(value);
            ARZDecompress.logTag(attrib, i, records[pos]);
        }
        return processed;
    }

    private static boolean fillAttribDamageOff(String attrib, int pos, String value) {
        boolean processed = false;
        processed = ARZDecompress.fillAttribDamageStat(attrib, "offensiveAether", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "offensiveBaseAether", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "offensiveBaseChaos", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "offensiveBaseCold", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "offensiveBaseFire", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "offensiveBaseLife", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "offensiveBaseLightning", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "offensiveBasePoison", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "offensiveBonusPhysical", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "offensiveChaos", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "offensiveCold", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "offensiveConfusion", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "offensiveConvert", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "offensiveCritDamage", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "offensiveDamageMult", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "offensiveDisruption", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "offensiveElemental", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "offensiveElementalReductionPercent", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "offensiveElementalResistanceReductionAbsolute", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "offensiveFear", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "offensiveFire", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "offensiveFreeze", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "offensiveFumble", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "offensiveKnockdown", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "offensiveLife", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "offensiveLifeLeech", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "offensiveLightning", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "offensivePercentCurrentLife", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "offensiveManaBurnDamageRatio", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "offensiveManaBurnDrain", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "offensivePetrify", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "offensivePhysical", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "offensivePhysicalReductionPercent", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "offensivePhysicalResistanceReductionAbsolute", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "offensivePierce", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "offensivePierceRatio", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "offensivePoison", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "offensiveProjectileFumble", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "offensiveSleep", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "offensiveSlowAttackSpeed", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "offensiveSlowBleeding", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "offensiveSlowCold", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "offensiveSlowDefensiveAbility", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "offensiveSlowDefensiveReduction", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "offensiveSlowFire", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "offensiveSlowLife", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "offensiveSlowLifeLeach", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "offensiveSlowLightning", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "offensiveSlowManaLeach", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "offensiveSlowOffensiveAbility", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "offensiveSlowOffensiveReduction", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "offensiveSlowPhysical", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "offensiveSlowPoison", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "offensiveSlowRunSpeed", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "offensiveSlowTotalSpeed", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "offensiveStun", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "offensiveTaunt", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "offensiveTotalDamage", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "offensiveTotalDamageReductionPercent", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "offensiveTotalResistanceReductionAbsolute", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "offensiveTotalResistanceReductionPercent", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "offensiveTrap", pos, value);
        if (processed) {
            return processed;
        }
        if (!processed) {
            int i = ARZDecompress.parseInt(value);
            ARZDecompress.logTag(attrib, i, records[pos]);
        }
        return processed;
    }

    private static boolean fillAttribDamageRet(String attrib, int pos, String value) {
        boolean processed = false;
        processed = ARZDecompress.fillAttribDamageStat(attrib, "retaliationAether", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "retaliationChaos", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "retaliationCold", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "retaliationConfusion", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "retaliationConvert", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "retaliationElemental", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "retaliationFear", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "retaliationFire", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "retaliationFreeze", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "retaliationLife", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "retaliationLightning", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "retaliationPercentCurrentLife", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "retaliationPetrify", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "retaliationPhysical", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "retaliationPierce", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "retaliationPierceRatio", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "retaliationPoison", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "retaliationSleep", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "retaliationSlowAttackSpeed", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "retaliationSlowBleeding", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "retaliationSlowCold", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "retaliationSlowDefensiveAbility", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "retaliationSlowFire", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "retaliationSlowLife", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "retaliationSlowLifeLeach", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "retaliationSlowLightning", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "retaliationSlowManaLeach", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "retaliationSlowOffensiveAbility", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "retaliationSlowOffensiveReduction", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "retaliationSlowPhysical", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "retaliationSlowPoison", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "retaliationSlowRunSpeed", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "retaliationStun", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "retaliationTotalDamage", pos, value);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribDamageStat(attrib, "retaliationTrap", pos, value);
        if (processed) {
            return processed;
        }
        if (!processed) {
            int i = ARZDecompress.parseInt(value);
            ARZDecompress.logTag(attrib, i, records[pos]);
        }
        return processed;
    }

    private static boolean fillAttribCharBonus(String attrib, int pos, String value) {
        int i = 0;
        boolean error = false;
        try {
            i = ARZDecompress.parseInt(value);
        }
        catch (NumberFormatException ex) {
            i = 100;
        }
        if (attrib.equals("characterArmorStrengthReqReduction")) {
            if (error) {
                Object[] args = new Object[]{records[pos].getFileName(), attrib, value};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_TAG_INVALID_VALUE", args);
                GDMsgLogger.addError(msg);
            }
            ARZDecompress.records[pos].dbCharBonus.setReducedArmorStrPerc(i);
            return true;
        }
        if (attrib.equals("characterAttackSpeed")) {
            if (error) {
                Object[] args = new Object[]{records[pos].getFileName(), attrib, value};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_TAG_INVALID_VALUE", args);
                GDMsgLogger.addError(msg);
            }
            ARZDecompress.records[pos].dbCharBonus.setAttackSpeed(i);
            return true;
        }
        if (attrib.equals("characterAttackSpeedModifier")) {
            if (error) {
                Object[] args = new Object[]{records[pos].getFileName(), attrib, value};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_TAG_INVALID_VALUE", args);
                GDMsgLogger.addError(msg);
            }
            ARZDecompress.records[pos].dbCharBonus.setAttackSpeedPerc(i);
            return true;
        }
        if (attrib.equals("characterBaseAttackSpeed")) {
            float fVal = 0.0f;
            try {
                fVal = ARZDecompress.parseFloat(value);
            }
            catch (NumberFormatException ex) {
                fVal = 0.0f;
                Object[] args = new Object[]{records[pos].getFileName(), attrib, value};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_TAG_INVALID_VALUE", args);
                GDMsgLogger.addError(msg);
            }
            ARZDecompress.records[pos].dbCharBonus.setBaseAttackSpeed(fVal);
            return true;
        }
        if (attrib.equals("characterConstitutionModifier")) {
            if (error) {
                Object[] args = new Object[]{records[pos].getFileName(), attrib, value};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_TAG_INVALID_VALUE", args);
                GDMsgLogger.addError(msg);
            }
            ARZDecompress.records[pos].dbCharBonus.setConstitutionPerc(i);
            return true;
        }
        if (attrib.equals("characterDefensiveAbility")) {
            if (error) {
                Object[] args = new Object[]{records[pos].getFileName(), attrib, value};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_TAG_INVALID_VALUE", args);
                GDMsgLogger.addError(msg);
            }
            ARZDecompress.records[pos].dbCharBonus.setDefense(i);
            return true;
        }
        if (attrib.equals("characterDefensiveAbilityModifier")) {
            if (error) {
                Object[] args = new Object[]{records[pos].getFileName(), attrib, value};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_TAG_INVALID_VALUE", args);
                GDMsgLogger.addError(msg);
            }
            ARZDecompress.records[pos].dbCharBonus.setDefensePerc(i);
            return true;
        }
        if (attrib.equals("characterDefensiveBlockRecoveryReduction")) {
            if (error) {
                Object[] args = new Object[]{records[pos].getFileName(), attrib, value};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_TAG_INVALID_VALUE", args);
                GDMsgLogger.addError(msg);
            }
            ARZDecompress.records[pos].dbCharBonus.setShieldRecoveryRedPerc(i);
            return true;
        }
        if (attrib.equals("characterDeflectProjectile")) {
            if (error) {
                Object[] args = new Object[]{records[pos].getFileName(), attrib, value};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_TAG_INVALID_VALUE", args);
                GDMsgLogger.addError(msg);
            }
            ARZDecompress.records[pos].dbCharBonus.setAvoidProjectilesPerc(i);
            return true;
        }
        if (attrib.equals("characterDexterity")) {
            if (error) {
                Object[] args = new Object[]{records[pos].getFileName(), attrib, value};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_TAG_INVALID_VALUE", args);
                GDMsgLogger.addError(msg);
            }
            ARZDecompress.records[pos].dbCharBonus.setCunning(i);
            return true;
        }
        if (attrib.equals("characterDexterityModifier")) {
            if (error) {
                Object[] args = new Object[]{records[pos].getFileName(), attrib, value};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_TAG_INVALID_VALUE", args);
                GDMsgLogger.addError(msg);
            }
            ARZDecompress.records[pos].dbCharBonus.setCunningPerc(i);
            return true;
        }
        if (attrib.equals("characterDodgePercent")) {
            if (error) {
                Object[] args = new Object[]{records[pos].getFileName(), attrib, value};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_TAG_INVALID_VALUE", args);
                GDMsgLogger.addError(msg);
            }
            ARZDecompress.records[pos].dbCharBonus.setAvoidMeleeAttackPerc(i);
            return true;
        }
        if (attrib.equals("characterEnergyAbsorptionPercent")) {
            if (error) {
                Object[] args = new Object[]{records[pos].getFileName(), attrib, value};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_TAG_INVALID_VALUE", args);
                GDMsgLogger.addError(msg);
            }
            ARZDecompress.records[pos].dbCharBonus.setEnergyAbsorbPerc(i);
            return true;
        }
        if (attrib.equals("characterHuntingDexterityReqReduction")) {
            if (error) {
                Object[] args = new Object[]{records[pos].getFileName(), attrib, value};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_TAG_INVALID_VALUE", args);
                GDMsgLogger.addError(msg);
            }
            ARZDecompress.records[pos].dbCharBonus.setReducedRangedDexPerc(i);
            return true;
        }
        if (attrib.equals("characterGlobalReqReduction")) {
            if (error) {
                Object[] args = new Object[]{records[pos].getFileName(), attrib, value};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_TAG_INVALID_VALUE", args);
                GDMsgLogger.addError(msg);
            }
            ARZDecompress.records[pos].dbCharBonus.setRequirementRedPerc(i);
            return true;
        }
        if (attrib.equals("characterIncreasedExperience")) {
            if (error) {
                Object[] args = new Object[]{records[pos].getFileName(), attrib, value};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_TAG_INVALID_VALUE", args);
                GDMsgLogger.addError(msg);
            }
            ARZDecompress.records[pos].dbCharBonus.setExperienceIncPerc(i);
            return true;
        }
        if (attrib.equals("characterIntelligence")) {
            if (error) {
                Object[] args = new Object[]{records[pos].getFileName(), attrib, value};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_TAG_INVALID_VALUE", args);
                GDMsgLogger.addError(msg);
            }
            ARZDecompress.records[pos].dbCharBonus.setSpirit(i);
            return true;
        }
        if (attrib.equals("characterIntelligenceModifier")) {
            if (error) {
                Object[] args = new Object[]{records[pos].getFileName(), attrib, value};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_TAG_INVALID_VALUE", args);
                GDMsgLogger.addError(msg);
            }
            ARZDecompress.records[pos].dbCharBonus.setSpiritPerc(i);
            return true;
        }
        if (attrib.equals("characterLife")) {
            if (error) {
                Object[] args = new Object[]{records[pos].getFileName(), attrib, value};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_TAG_INVALID_VALUE", args);
                GDMsgLogger.addError(msg);
            }
            ARZDecompress.records[pos].dbCharBonus.setHealth(i);
            return true;
        }
        if (attrib.equals("characterLifeModifier")) {
            if (error) {
                Object[] args = new Object[]{records[pos].getFileName(), attrib, value};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_TAG_INVALID_VALUE", args);
                GDMsgLogger.addError(msg);
            }
            ARZDecompress.records[pos].dbCharBonus.setHealthPerc(i);
            return true;
        }
        if (attrib.equals("characterLifeRegen")) {
            if (error) {
                Object[] args = new Object[]{records[pos].getFileName(), attrib, value};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_TAG_INVALID_VALUE", args);
                GDMsgLogger.addError(msg);
            }
            ARZDecompress.records[pos].dbCharBonus.setHealthRegen(i);
            return true;
        }
        if (attrib.equals("characterLifeRegenModifier")) {
            if (error) {
                Object[] args = new Object[]{records[pos].getFileName(), attrib, value};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_TAG_INVALID_VALUE", args);
                GDMsgLogger.addError(msg);
            }
            ARZDecompress.records[pos].dbCharBonus.setHealthRegenPerc(i);
            return true;
        }
        if (attrib.equals("characterLightRadius")) {
            if (error) {
                Object[] args = new Object[]{records[pos].getFileName(), attrib, value};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_TAG_INVALID_VALUE", args);
                GDMsgLogger.addError(msg);
            }
            ARZDecompress.records[pos].dbCharBonus.setLightRadius(i);
            return true;
        }
        if (attrib.equals("characterMana")) {
            if (error) {
                Object[] args = new Object[]{records[pos].getFileName(), attrib, value};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_TAG_INVALID_VALUE", args);
                GDMsgLogger.addError(msg);
            }
            ARZDecompress.records[pos].dbCharBonus.setMana(i);
            return true;
        }
        if (attrib.equals("characterManaModifier")) {
            if (error) {
                Object[] args = new Object[]{records[pos].getFileName(), attrib, value};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_TAG_INVALID_VALUE", args);
                GDMsgLogger.addError(msg);
            }
            ARZDecompress.records[pos].dbCharBonus.setManaPerc(i);
            return true;
        }
        if (attrib.equals("characterManaLimitReserve")) {
            if (error) {
                Object[] args = new Object[]{records[pos].getFileName(), attrib, value};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_TAG_INVALID_VALUE", args);
                GDMsgLogger.addError(msg);
            }
            ARZDecompress.records[pos].dbCharBonus.setManaLimit(i);
            return true;
        }
        if (attrib.equals("characterManaLimitReserveModifier")) {
            if (error) {
                Object[] args = new Object[]{records[pos].getFileName(), attrib, value};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_TAG_INVALID_VALUE", args);
                GDMsgLogger.addError(msg);
            }
            ARZDecompress.records[pos].dbCharBonus.setManaLimitPerc(i);
            return true;
        }
        if (attrib.equals("characterManaLimitReserveReduction")) {
            if (error) {
                Object[] args = new Object[]{records[pos].getFileName(), attrib, value};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_TAG_INVALID_VALUE", args);
                GDMsgLogger.addError(msg);
            }
            ARZDecompress.records[pos].dbCharBonus.setManaReserve(i);
            return true;
        }
        if (attrib.equals("characterManaLimitReserveReductionModifier")) {
            if (error) {
                Object[] args = new Object[]{records[pos].getFileName(), attrib, value};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_TAG_INVALID_VALUE", args);
                GDMsgLogger.addError(msg);
            }
            ARZDecompress.records[pos].dbCharBonus.setManaReservePerc(i);
            return true;
        }
        if (attrib.equals("characterManaRegen")) {
            if (error) {
                Object[] args = new Object[]{records[pos].getFileName(), attrib, value};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_TAG_INVALID_VALUE", args);
                GDMsgLogger.addError(msg);
            }
            ARZDecompress.records[pos].dbCharBonus.setManaRegen(i);
            return true;
        }
        if (attrib.equals("characterManaRegenModifier")) {
            if (error) {
                Object[] args = new Object[]{records[pos].getFileName(), attrib, value};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_TAG_INVALID_VALUE", args);
                GDMsgLogger.addError(msg);
            }
            ARZDecompress.records[pos].dbCharBonus.setManaRegenPerc(i);
            return true;
        }
        if (attrib.equals("characterMeleeDexterityReqReduction")) {
            if (error) {
                Object[] args = new Object[]{records[pos].getFileName(), attrib, value};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_TAG_INVALID_VALUE", args);
                GDMsgLogger.addError(msg);
            }
            ARZDecompress.records[pos].dbCharBonus.setReducedMeleeDexPerc(i);
            return true;
        }
        if (attrib.equals("characterMeleeStrengthReqReduction")) {
            if (error) {
                Object[] args = new Object[]{records[pos].getFileName(), attrib, value};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_TAG_INVALID_VALUE", args);
                GDMsgLogger.addError(msg);
            }
            ARZDecompress.records[pos].dbCharBonus.setReducedMeleeStrPerc(i);
            return true;
        }
        if (attrib.equals("characterOffensiveAbility")) {
            if (error) {
                Object[] args = new Object[]{records[pos].getFileName(), attrib, value};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_TAG_INVALID_VALUE", args);
                GDMsgLogger.addError(msg);
            }
            ARZDecompress.records[pos].dbCharBonus.setOffense(i);
            return true;
        }
        if (attrib.equals("characterOffensiveAbilityModifier")) {
            if (error) {
                Object[] args = new Object[]{records[pos].getFileName(), attrib, value};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_TAG_INVALID_VALUE", args);
                GDMsgLogger.addError(msg);
            }
            ARZDecompress.records[pos].dbCharBonus.setOffensePerc(i);
            return true;
        }
        if (attrib.equals("characterRunSpeedModifier")) {
            if (error) {
                Object[] args = new Object[]{records[pos].getFileName(), attrib, value};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_TAG_INVALID_VALUE", args);
                GDMsgLogger.addError(msg);
            }
            ARZDecompress.records[pos].dbCharBonus.setRunSpeedPerc(i);
            return true;
        }
        if (attrib.equals("characterSpellCastSpeedModifier")) {
            if (error) {
                Object[] args = new Object[]{records[pos].getFileName(), attrib, value};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_TAG_INVALID_VALUE", args);
                GDMsgLogger.addError(msg);
            }
            ARZDecompress.records[pos].dbCharBonus.setCastSpeedPerc(i);
            return true;
        }
        if (attrib.equals("characterStrength")) {
            if (error) {
                Object[] args = new Object[]{records[pos].getFileName(), attrib, value};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_TAG_INVALID_VALUE", args);
                GDMsgLogger.addError(msg);
            }
            ARZDecompress.records[pos].dbCharBonus.setPhysique(i);
            return true;
        }
        if (attrib.equals("characterStrengthModifier")) {
            if (error) {
                Object[] args = new Object[]{records[pos].getFileName(), attrib, value};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_TAG_INVALID_VALUE", args);
                GDMsgLogger.addError(msg);
            }
            ARZDecompress.records[pos].dbCharBonus.setPhysiquePerc(i);
            return true;
        }
        if (attrib.equals("characterTotalSpeedModifier")) {
            if (error) {
                Object[] args = new Object[]{records[pos].getFileName(), attrib, value};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_TAG_INVALID_VALUE", args);
                GDMsgLogger.addError(msg);
            }
            ARZDecompress.records[pos].dbCharBonus.setTotalSpeedPerc(i);
            return true;
        }
        if (attrib.equals("characterWeaponStrengthReqReduction")) {
            if (error) {
                Object[] args = new Object[]{records[pos].getFileName(), attrib, value};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_TAG_INVALID_VALUE", args);
                GDMsgLogger.addError(msg);
            }
            ARZDecompress.records[pos].dbCharBonus.setReducedWeaponStrPerc(i);
            return true;
        }
        if (attrib.equals("racialBonusPercentDamage")) {
            if (error) {
                Object[] args = new Object[]{records[pos].getFileName(), attrib, value};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_TAG_INVALID_VALUE", args);
                GDMsgLogger.addError(msg);
            }
            ARZDecompress.records[pos].dbCharBonus.setRaceDamagePerc(i);
            return true;
        }
        if (attrib.equals("racialBonusRace")) {
            String tag = value;
            if (!tag.startsWith("tag")) {
                tag = "tag" + tag;
            }
            String name = GDStashFrame.arcList.getTag("tags_creatures.txt", tag);
            ARZDecompress.records[pos].dbCharBonus.addRace(value, name);
            return true;
        }
        if (attrib.equals("skillCooldownReduction")) {
            if (error) {
                Object[] args = new Object[]{records[pos].getFileName(), attrib, value};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_TAG_INVALID_VALUE", args);
                GDMsgLogger.addError(msg);
            }
            ARZDecompress.records[pos].dbCharBonus.setCooldownRed(i);
            return true;
        }
        if (attrib.equals("skillCooldownReductionModifier")) {
            if (error) {
                Object[] args = new Object[]{records[pos].getFileName(), attrib, value};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_TAG_INVALID_VALUE", args);
                GDMsgLogger.addError(msg);
            }
            ARZDecompress.records[pos].dbCharBonus.setCooldownRedPerc(i);
            return true;
        }
        if (attrib.equals("skillManaCostReduction")) {
            if (error) {
                Object[] args = new Object[]{records[pos].getFileName(), attrib, value};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_TAG_INVALID_VALUE", args);
                GDMsgLogger.addError(msg);
            }
            ARZDecompress.records[pos].dbCharBonus.setManaCostRed(i);
            return true;
        }
        if (attrib.equals("skillManaCostReductionModifier")) {
            if (error) {
                Object[] args = new Object[]{records[pos].getFileName(), attrib, value};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_TAG_INVALID_VALUE", args);
                GDMsgLogger.addError(msg);
            }
            ARZDecompress.records[pos].dbCharBonus.setManaCostRedPerc(i);
            return true;
        }
        if (attrib.startsWith("character")) {
            ARZDecompress.logTag(attrib, i, records[pos]);
        }
        return false;
    }

    private static void logTag(String attrib, int value, ARZRecord record) {
        if (value == 0) {
            return;
        }
        if (!(attrib.equals("characterBaseAttackSpeedTag") || attrib.equals("characterAttributeEquations") || attrib.equals("characterGenderProfile") || attrib.equals("characterRacialProfile") || attrib.equals("characterRunSpeed") || attrib.equals("characterRunSpeed") || attrib.equals("characterRunSpeedJitter") || attrib.equals("characterSpellCastSpeed") || attrib.equals("characterWeapon2HStrengthReqReduction"))) {
            Object[] args = new Object[]{attrib};
            String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_TAG_UNKNOWN", args);
            GDStashFrame.messageToList(msg);
        }
    }

    private static boolean fillEngineGame(String attrib, int pos, String value) {
        int i = 0;
        boolean error = false;
        try {
            i = ARZDecompress.parseInt(value);
        }
        catch (NumberFormatException ex) {
            i = 0;
            error = true;
        }
        if (attrib.equals("factionAlternateNeutralTag")) {
            records[pos].setFactionAltNeutralTag(value);
            return true;
        }
        if (attrib.startsWith("factionValue")) {
            String s = attrib.substring(12);
            int index = ARZDecompress.parseInt(s);
            records[pos].addFactionReputationValue(index, i);
            return true;
        }
        if (attrib.startsWith("factionTag")) {
            String s = attrib.substring(10);
            int index = ARZDecompress.parseInt(s);
            records[pos].addFactionReputationStateTag(index, value);
            return true;
        }
        return false;
    }

    private static boolean fillFaction(String attrib, int pos, String value) {
        if (attrib.equals("bountyEnabled")) {
            records[pos].setFactionBountyEnabled(value.equals("1"));
            return true;
        }
        if (attrib.startsWith("questEnabled")) {
            records[pos].setFactionQuestEnabled(value.equals("1"));
            return true;
        }
        if (attrib.startsWith("myFaction")) {
            records[pos].setFactionTag(value);
            return true;
        }
        return false;
    }

    private static boolean fillEnginePlayer(String attrib, int pos, String value) throws GDParseException {
        int i = 0;
        boolean error = false;
        try {
            i = ARZDecompress.parseInt(value);
        }
        catch (NumberFormatException ex) {
            i = 0;
            error = true;
        }
        if (attrib.equals("dexterityIncrement")) {
            if (error) {
                Object[] args = new Object[]{records[pos].getFileName(), attrib, value};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_TAG_INVALID_VALUE", args);
                GDMsgLogger.addError(msg);
            }
            records[pos].setPlayerIncDex(i);
            return true;
        }
        if (attrib.equals("experienceLevelEquation")) {
            records[pos].setXPFormula(value.toUpperCase(GDConstants.LOCALE_US));
            return true;
        }
        if (attrib.equals("intelligenceIncrement")) {
            if (error) {
                Object[] args = new Object[]{records[pos].getFileName(), attrib, value};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_TAG_INVALID_VALUE", args);
                GDMsgLogger.addError(msg);
            }
            records[pos].setPlayerIncInt(i);
            return true;
        }
        if (attrib.equals("lifeIncrement")) {
            if (error) {
                Object[] args = new Object[]{records[pos].getFileName(), attrib, value};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_TAG_INVALID_VALUE", args);
                GDMsgLogger.addError(msg);
            }
            records[pos].setPlayerIncLife(i);
            return true;
        }
        if (attrib.equals("manaIncrement")) {
            if (error) {
                Object[] args = new Object[]{records[pos].getFileName(), attrib, value};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_TAG_INVALID_VALUE", args);
                GDMsgLogger.addError(msg);
            }
            records[pos].setPlayerIncMana(i);
            return true;
        }
        if (attrib.equals("maxPlayerLevel")) {
            if (error) {
                Object[] args = new Object[]{records[pos].getFileName(), attrib, value};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_TAG_INVALID_VALUE", args);
                GDMsgLogger.addError(msg);
            }
            records[pos].setPlayerMaxLevel(i);
            return true;
        }
        if (attrib.equals("strengthIncrement")) {
            if (error) {
                Object[] args = new Object[]{records[pos].getFileName(), attrib, value};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_TAG_INVALID_VALUE", args);
                GDMsgLogger.addError(msg);
            }
            records[pos].setPlayerIncStr(i);
            return true;
        }
        return false;
    }

    private static boolean fillAttribSkill(String attrib, int pos, String value) {
        int i = 0;
        boolean error = false;
        try {
            i = ARZDecompress.parseInt(value);
        }
        catch (NumberFormatException ex) {
            i = 0;
            error = true;
        }
        if (attrib.equals("buffSkillName")) {
            records[pos].setSkillBuffID(value);
            return true;
        }
        if (attrib.equals("petSkillName")) {
            records[pos].setSkillPetID(value);
            return true;
        }
        if (attrib.equals("skillBaseDescription")) {
            records[pos].setSkillDescription(value);
            return true;
        }
        if (attrib.equals("skillCooldownTime")) {
            if (error) {
                Object[] args = new Object[]{records[pos].getFileName(), attrib, value};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_TAG_INVALID_VALUE", args);
                GDMsgLogger.addError(msg);
            }
            records[pos].setSkillCooldownTime(i);
            return true;
        }
        if (attrib.equals("skillDisplayName")) {
            records[pos].setSkillNameTag(value);
            return true;
        }
        if (attrib.equals("skillManaCost")) {
            if (error) {
                Object[] args = new Object[]{records[pos].getFileName(), attrib, value};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_TAG_INVALID_VALUE", args);
                GDMsgLogger.addError(msg);
            }
            records[pos].setSkillManaCost(i);
            return true;
        }
        if (attrib.equals("weaponDamagePct")) {
            if (error) {
                Object[] args = new Object[]{records[pos].getFileName(), attrib, value};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_TAG_INVALID_VALUE", args);
                GDMsgLogger.addError(msg);
            }
            records[pos].setSkillWeaponDamagePerc(i);
            return true;
        }
        return false;
    }

    private static boolean fillAttribSkillBonus(String attrib, int pos, String value) {
        if (attrib.startsWith("augmentMasteryName") || attrib.startsWith("augmentSkillName")) {
            String s = null;
            int type = 0;
            if (attrib.startsWith("augmentMasteryName")) {
                s = attrib.substring(18);
                type = 1;
            }
            if (attrib.startsWith("augmentSkillName")) {
                s = attrib.substring(16);
                type = 2;
            }
            int i = ARZDecompress.parseInt(s);
            DBSkillBonus.addEntity(ARZDecompress.records[pos].dbSkillBonuses, i, type, value);
            return true;
        }
        if (attrib.startsWith("augmentMasteryLevel") || attrib.startsWith("augmentSkillLevel")) {
            String s = null;
            int type = 0;
            if (attrib.startsWith("augmentMasteryLevel")) {
                s = attrib.substring(19);
                type = 1;
            }
            if (attrib.startsWith("augmentSkillLevel")) {
                s = attrib.substring(17);
                type = 2;
            }
            int i = ARZDecompress.parseInt(s);
            int iVal = ARZDecompress.parseInt(value);
            DBSkillBonus.addValue(ARZDecompress.records[pos].dbSkillBonuses, i, type, iVal);
            return true;
        }
        return false;
    }

    private static boolean fillAttribItemSet(String attrib, int pos, String value) {
        if (attrib.equals("setDescription")) {
            records[pos].setItemSetDescriptionTag(value);
            return true;
        }
        if (attrib.equals("setMembers")) {
            records[pos].addItemSetItemID(value);
            return true;
        }
        if (attrib.equals("setName")) {
            records[pos].setItemSetNameTag(value);
            return true;
        }
        return false;
    }

    private static boolean fillAttribLootTable(String attrib, int pos, String value) {
        if (attrib.equals("bothPrefixSuffix")) {
            records[pos].setTableNormalPrefixSuffix(ARZDecompress.parseInt(value) > 0);
            return true;
        }
        if (attrib.equals("normalPrefixRareSuffix")) {
            records[pos].setTableNormalPrefixRareSuffix(ARZDecompress.parseInt(value) > 0);
            return true;
        }
        if (attrib.equals("rarePrefixNormalSuffix")) {
            records[pos].setTableRarePrefixNormalSuffix(ARZDecompress.parseInt(value) > 0);
            return true;
        }
        if (attrib.equals("rareBothPrefixSuffix")) {
            records[pos].setTableRarePrefixSuffix(ARZDecompress.parseInt(value) > 0);
            return true;
        }
        if (attrib.startsWith("lootName")) {
            records[pos].addTableItemID(value);
            return true;
        }
        if (attrib.startsWith("prefixTableLevelMax") || attrib.startsWith("suffixTableLevelMax") || attrib.startsWith("rarePrefixTableLevelMax") || attrib.startsWith("rareSuffixTableLevelMax")) {
            String search = "TableLevelMax";
            int len = search.length();
            int p = attrib.indexOf(search);
            String pre = attrib.substring(0, p);
            String num = attrib.substring(p + len);
            int i = ARZDecompress.parseInt(num);
            int type = 0;
            if (pre.equals("prefix")) {
                type = 1;
            }
            if (pre.equals("suffix")) {
                type = 2;
            }
            if (pre.equals("rarePrefix")) {
                type = 3;
            }
            if (pre.equals("rareSuffix")) {
                type = 4;
            }
            int iVal = ARZDecompress.parseInt(value);
            records[pos].addTableMaxLevel(i, type, iVal);
            return true;
        }
        if (attrib.startsWith("prefixTableLevelMin") || attrib.startsWith("suffixTableLevelMin") || attrib.startsWith("rarePrefixTableLevelMin") || attrib.startsWith("rareSuffixTableLevelMin")) {
            String search = "TableLevelMin";
            int len = search.length();
            int p = attrib.indexOf(search);
            String pre = attrib.substring(0, p);
            String num = attrib.substring(p + len);
            int i = ARZDecompress.parseInt(num);
            int type = 0;
            if (pre.equals("prefix")) {
                type = 1;
            }
            if (pre.equals("suffix")) {
                type = 2;
            }
            if (pre.equals("rarePrefix")) {
                type = 3;
            }
            if (pre.equals("rareSuffix")) {
                type = 4;
            }
            int iVal = ARZDecompress.parseInt(value);
            records[pos].addTableMinLevel(i, type, iVal);
            return true;
        }
        if (attrib.startsWith("prefixTableName") || attrib.startsWith("suffixTableName") || attrib.startsWith("rarePrefixTableName") || attrib.startsWith("rareSuffixTableName")) {
            String search = "TableName";
            int len = search.length();
            int p = attrib.indexOf(search);
            String pre = attrib.substring(0, p);
            String num = attrib.substring(p + len);
            int i = ARZDecompress.parseInt(num);
            int type = 0;
            if (pre.equals("prefix")) {
                type = 1;
            }
            if (pre.equals("suffix")) {
                type = 2;
            }
            if (pre.equals("rarePrefix")) {
                type = 3;
            }
            if (pre.equals("rareSuffix")) {
                type = 4;
            }
            records[pos].addTableAffixSetID(i, type, value);
            return true;
        }
        return false;
    }

    private static boolean fillAttribLootTableSet(String attrib, int pos, String value) {
        if (attrib.equals("levels")) {
            int iVal = ARZDecompress.parseInt(value);
            records[pos].addTableSetMinLevel(iVal);
            return true;
        }
        if (attrib.equals("records")) {
            records[pos].addTableSetTableID(value);
            return true;
        }
        return false;
    }

    private static boolean fillAttribFormula(String attrib, int pos, String value) {
        if (attrib.equals("armorCostEquation") || attrib.equals("jewelryCostEquation") || attrib.equals("offhandCostEquation") || attrib.equals("shieldCostEquation") || attrib.equals("weaponCostEquation") || attrib.equals("weaponMelee2hCostEquation") || attrib.equals("weaponRangedCostEquation") || attrib.equals("weaponRanged2hCostEquation") || attrib.equals("daggerDexterityEquation") || attrib.equals("ranged1hDexterityEquation") || attrib.equals("ranged2hDexterityEquation") || attrib.equals("swordDexterityEquation") || attrib.equals("amuletIntelligenceEquation") || attrib.equals("chestIntelligenceEquation") || attrib.equals("daggerIntelligenceEquation") || attrib.equals("headIntelligenceEquation") || attrib.equals("offhandIntelligenceEquation") || attrib.equals("ringIntelligenceEquation") || attrib.equals("scepterIntelligenceEquation") || attrib.equals("axeStrengthEquation") || attrib.equals("chestStrengthEquation") || attrib.equals("feetStrengthEquation") || attrib.equals("handsStrengthEquation") || attrib.equals("headStrengthEquation") || attrib.equals("legsStrengthEquation") || attrib.equals("maceStrengthEquation") || attrib.equals("melee2hStrengthEquation") || attrib.equals("scepterStrengthEquation") || attrib.equals("shieldStrengthEquation") || attrib.equals("shouldersStrengthEquation") || attrib.equals("waistStrengthEquation")) {
            records[pos].addFormulaSetFormula(attrib, value.toUpperCase(GDConstants.LOCALE_US));
            return true;
        }
        return false;
    }

    public static int getGenderCode(String s) {
        int code = -1;
        if (s.equals("[ms]")) {
            code = 0;
        }
        if (s.equals("[mp]")) {
            code = 3;
        }
        if (s.equals("[fs]")) {
            code = 1;
        }
        if (s.equals("[fp]")) {
            code = 4;
        }
        if (s.equals("[ns]")) {
            code = 2;
        }
        if (s.equals("[np]")) {
            code = 5;
        }
        return code;
    }

    public static String[] getGenderTexts(String text) {
        String[] genders = new String[6];
        if (text == null) {
            return genders;
        }
        String remainder = text;
        String gender = null;
        String value = null;
        int code = -1;
        if (remainder.startsWith("|")) {
            remainder = remainder.substring(2);
        }
        if (remainder.startsWith("$")) {
            remainder = remainder.substring(1);
        }
        while (remainder != null) {
            int pos = remainder.indexOf("[");
            if (pos != -1) {
                gender = remainder.substring(pos, pos + 4);
                if ((pos = (remainder = remainder.substring(pos + 4)).indexOf("[")) != -1) {
                    value = remainder.substring(0, pos);
                    remainder = remainder.substring(pos);
                } else {
                    value = remainder;
                    remainder = null;
                }
                code = ARZDecompress.getGenderCode(gender);
                if (code == -1) {
                    code = 0;
                }
                genders[code] = value;
                continue;
            }
            value = remainder;
            remainder = null;
            genders[0] = value;
            genders[1] = value;
            genders[2] = value;
            genders[3] = value;
            genders[4] = value;
            genders[5] = value;
        }
        return genders;
    }

    private static boolean resolveSkillName(ARZRecord record) {
        String skill = null;
        if (record.getSkillPetID() != null) {
            skill = record.getSkillPetID();
        }
        if (record.getSkillBuffID() != null) {
            skill = record.getSkillBuffID();
        }
        if (skill == null) {
            return false;
        }
        for (int i = 0; i < records.length; ++i) {
            if (records[i] == null || records[i].getSkillNameTag() == null || !skill.equals(records[i].getFileName())) continue;
            record.setSkillNameTag(records[i].getSkillNameTag());
            return true;
        }
        return false;
    }

    private static void resolveGrantedSkillName(ARZRecord record) {
        block0: for (DBSkillBonus bonus : record.dbSkillBonuses) {
            if (bonus.getEntity() == null) continue;
            for (int i = 0; i < records.length; ++i) {
                if (records[i] == null || records[i].getSkillName() == null && records[i].getSkillBuffID() == null && records[i].getSkillPetID() == null || !bonus.getEntity().equals(records[i].getFileName())) continue;
                if (records[i].getSkillName() == null) continue block0;
                bonus.setEntityName(records[i].getSkillName());
                continue block0;
            }
        }
    }

    private static void resolveAttrib() {
        int i;
        for (int i2 = 0; i2 < records.length; ++i2) {
            if (records[i2] == null || records[i2].getItemSetID() == null) continue;
            records[i2].setItemSetNameTag(ARZDecompress.getAttribValue(records[i2].getItemSetID(), "itemSetName"));
        }
        boolean changed = true;
        while (changed) {
            changed = false;
            for (i = 0; i < records.length; ++i) {
                if (records[i] == null || !records[i].getFileName().startsWith("records/skills/") || records[i].getSkillNameTag() != null) continue;
                boolean b = ARZDecompress.resolveSkillName(records[i]);
                changed = changed || b;
            }
        }
        for (i = 0; i < records.length; ++i) {
            if (records[i] == null || ARZDecompress.records[i].dbSkillBonuses == null || ARZDecompress.records[i].dbSkillBonuses.isEmpty()) continue;
            ARZDecompress.resolveGrantedSkillName(records[i]);
        }
    }

    public static DBFormulaSet getFormulaSet(String formulaSetID) {
        DBFormulaSet set = null;
        for (int i = 0; i < records.length; ++i) {
            if (records[i] == null || !records[i].getFileName().equals(formulaSetID)) continue;
            set = records[i].getDBFormulaSet();
            break;
        }
        return set;
    }

    private static String getAttribValue(String filename, String attrib) {
        String value = null;
        for (int i = 0; i < records.length; ++i) {
            if (records[i] == null || !records[i].getFileName().equals(filename)) continue;
            value = records[i].getItemSetNameTag();
            break;
        }
        return value;
    }

    public static boolean insertData() {
        return GDDBData.insertData(records);
    }

    public static boolean insertModData() {
        return GDDBData.insertModData(records);
    }

    public static void extractRecords(String filename, String dir) {
        try {
            File file = new File(filename);
            if (!file.exists()) {
                Object[] args = new Object[]{filename};
                String s = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_FILE_NOT_FOUND", args);
                throw new FileNotFoundException(s);
            }
            if (!file.isFile()) {
                Object[] args = new Object[]{filename};
                String s = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_FILE_NOT_FOUND", args);
                throw new FileNotFoundException(s);
            }
            if (!file.canRead()) {
                Object[] args = new Object[]{filename};
                String s = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_FILE_CANNOT_READ", args);
                throw new IOException(s);
            }
            MappedByteBuffer buffer = null;
            try (RandomAccessFile raf = new RandomAccessFile(file, "r");){
                buffer = raf.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, raf.length());
                buffer.order(ByteOrder.LITTLE_ENDIAN);
                header = ARZDecompress.getHeader(buffer);
                strings = ARZDecompress.getStrings(buffer);
                records = ARZDecompress.getRecords(buffer);
                ARZDecompress.recordsToText(buffer, dir);
            }
            catch (IOException ex) {
                throw ex;
            }
            finally {
                buffer = null;
            }
        }
        catch (Exception ex) {
            GDMsgLogger.addError(ex);
        }
        if (GDMsgLogger.errorsInLog()) {
            GDMsgLogger.addError(GDMsgFormatter.getString(GDMsgFormatter.rbMsg, "ERR_DB_EXTRACT_FAIL"));
        }
    }

    private static void recordsToText(MappedByteBuffer buffer, String dir) throws GDParseException {
        DecimalFormat formatter = new DecimalFormat("#0.000000");
        LZ4Factory factory = LZ4Factory.fastestInstance();
        LZ4FastDecompressor decomp = factory.fastDecompressor();
        for (int i = 0; i < records.length; ++i) {
            if (records[i] == null) continue;
            records[i].setFileName(ARZDecompress.strings[ARZDecompress.records[i].strID].str);
            byte[] bComp = GDReader.getBytes(buffer, ARZDecompress.records[i].offset + 24, ARZDecompress.records[i].len_comp);
            byte[] bDecomp = new byte[ARZDecompress.records[i].len_decomp];
            decomp.decompress(bComp, bDecomp);
            String text = "";
            String value = "";
            int offset = 0;
            try {
                while (offset < bDecomp.length) {
                    int typeOffset = offset;
                    short varType = GDReader.getUShort(bDecomp, offset);
                    int count = GDReader.getUShort(bDecomp, offset += 2);
                    int strIdx = GDReader.getUInt(bDecomp, offset += 2);
                    offset += 4;
                    String line = ARZDecompress.strings[strIdx].str + ",";
                    for (int j = 0; j < count; ++j) {
                        switch (varType) {
                            case 0: {
                                int valInt = GDReader.getInt(bDecomp, offset);
                                value = String.valueOf(valInt);
                                break;
                            }
                            case 1: {
                                float valFloat = GDReader.getFloat(bDecomp, offset);
                                value = formatter.format(valFloat);
                                break;
                            }
                            case 2: {
                                int valStrIdx = GDReader.getUInt(bDecomp, offset);
                                value = ARZDecompress.strings[valStrIdx].str;
                                break;
                            }
                            case 3: {
                                boolean valBool = GDReader.getBool(bDecomp, offset);
                                if (valBool) {
                                    value = "1";
                                    break;
                                }
                                value = "0";
                                break;
                            }
                            default: {
                                Object[] args = new Object[]{records[i].getFileName(), ARZDecompress.strings[strIdx].str};
                                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_UNKNOWN_VAR_TYPE", args);
                                throw new GDParseException(msg, typeOffset);
                            }
                        }
                        offset += 4;
                        line = line + value;
                        line = j == count - 1 ? line + "," : line + ";";
                    }
                    text = text + line + GDConstants.LINE_SEPARATOR;
                }
            }
            catch (GDParseException ex) {
                GDMsgLogger.addError(ex);
                ARZDecompress.records[i].error = true;
                int pos = records[i].getFileName().lastIndexOf(".");
                if (pos != -1) {
                    records[i].setFileName(records[i].getFileName().substring(0, pos));
                }
                records[i].setFileName(records[i].getFileName() + ".err");
            }
            String osName = GDWriter.getOSFilePath(records[i].getFileName());
            String newName = dir + GDConstants.FILE_SEPARATOR + osName;
            try {
                GDWriter.write(newName, text);
                continue;
            }
            catch (Exception ex) {
                GDMsgLogger.addError(ex);
            }
        }
    }
}

